import React, { useState } from "react";
import { GoChevronRight } from "react-icons/go";

const TeamCdiic = () => {
  const [activeIndex, setActiveIndex] = useState(0); // Default show first item

  const data = [
    {
      title: "TEAM",
      img:"https://placehold.co/600x400/png"
     
    },
    {
      title: "DEFENCE",
          img:"https://placehold.co/600x400/png"
     
    },
   
    {
      title: "INCUBATION",
          img:"https://placehold.co/600x400/png"
  
    },
    {
      title: "QUALITY",
          img:"https://placehold.co/600x400/png"
 
    },
    {
      title: "ADMIN",
          img:"https://placehold.co/600x400/png"
   
    },
  ];

  const renderContent = () => {
    const item = data[activeIndex];
    return (
      <div className="data-section">
      
        {Array.isArray(item.description) ? (
          <ul className="description-list">
            {item.description.map((point, i) => (
              <li key={i}>{point}</li>
            ))}
          </ul>
        ) : typeof item === "object" ? (
          <div className="description-object">
            <img src={item.img} alt="" srcset="" />
          </div>
        ) : (
          <p className="description-text">{item.description}</p>
        )}
      </div>
    );
  };

  return (
    <div className="indigenisation-container sec-ptb">
      <div className="container">
        <div className="sec-content  text-center  mb-5">
            <h6 className="sec-sub-title">Cdiic Team</h6>
            <h2 className="teamx-title text-white ">Explore Our Team</h2>
          </div>
        <div className="row">
          <div className="col-lg-6">
            <div className="header-block-main indigenisation-container-sutom">
              <div className="nav-items">
                {data.map((item, index) => (
                  <div
                    key={index}
                    className={`nav-item-custom d-flex justify-content-between ${
                      activeIndex === index ? "active" : ""
                    }`}
                    onMouseEnter={() => setActiveIndex(index)}
                    onClick={() => setActiveIndex(index)}
                  >
                    <div>
                      <h4 className="nav-title-custom">{item.title}</h4>
                   
                    </div>
                    <div className="bg-go">
                        <GoChevronRight/>
                    </div>
                  </div>
                ))}
              </div>
            </div>
          </div>
          <div className="col-lg-6">
            <div >{renderContent()}</div>
          </div>
        </div>
      </div>
    </div>
  );
};

export default TeamCdiic;
