<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\User;
use Illuminate\Validation\ValidationException;

class AuthController extends Controller
{
    public function login(Request $request)
    {

        // Validate the request
        $request->validate([
            'useremail' => 'required|email',
            'password' => 'required',
        ]);

        // Attempt to authenticate the user
        if (Auth::attempt(['email' => $request->useremail, 'password' => $request->password])) {
            // Authentication successful
            return view('dashboard');
        }

        // Authentication failed
        return redirect()->back()
            ->withInput($request->only('useremail'))
            ->withErrors(['useremail' => 'The provided credentials are incorrect.']);
    }
    public function logout(Request $request)
    {
        Auth::guard('web')->logout();
        return redirect('/');

    }
}
