<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Banner;
use Illuminate\Support\Facades\Validator;

class BannerController extends Controller
{
    public function index()
    {
        $banner = Banner::paginate(10);
        return view('layouts.banner.index', compact('banner'));
    }


    public function create()
    {
        return view('layouts.banner.add');
    }

    // Store a new Banner
    public function store(Request $request)
    {

        // Validate the input data
        $validator = Validator::make($request->all(), [
            'is_active' => 'required|boolean',
            'image' => $request->id ? 'nullable|image|mimes:jpeg,png,jpg,gif|max:2048' : 'required|image|mimes:jpeg,png,jpg,gif|max:2048',
        ]);

        if ($validator->fails()) {
            return response()->json([
                'errors' => $validator->errors(),
            ], 422);
        }

        // Handle the image upload
        $imagePath = $request->id ? Banner::find($request->id)->image : null;

        if ($request->hasFile('image')) {
            $image = $request->file('image');
            $imageName = time() . '.' . $image->getClientOriginalExtension();

            try {
                $image->move(public_path('images'), $imageName);
                $imagePath = 'images/' . $imageName;
            } catch (\Exception $e) {
                return response()->json(['error' => 'Failed to upload image.'], 500);
            }
        }

        // Save the event data (including the image path)
        Banner::updateOrCreate(
            ['id' => $request->id],
            [
                'is_active' => $request->is_active,
                'image' => $imagePath,
            ]
        );

        return response()->json([
            'success' => true,
            'redirect_url' => route('banner.index'),
        ]);
    }
    // Update an existing Banner
    public function edit($id)
    {
        $banner = Banner::findOrFail($id);

        return view('layouts.banner.edit', compact('banner')); // Return form view
    }

    // Update an existing Banner

    // Delete a Banner
    public function destroy($id)
    {
        $banner = Banner::findOrFail($id);
        $banner->delete();
        $banner = Banner::paginate(10);

        return view('layouts.banner.index', compact('banner'));
    }


    public function banner(Request $request)
    {
        // Fetch all galleries
        $banner = Banner::where('is_active', 1)->get();

        // Check if the collection is empty
        if ($banner->isEmpty()) {
            return response()->json([
                'status' => 404,
                'message' => 'No banner image found!'
            ]);
        }

        // Return gallery data if found
        return response()->json([
            'status' => 200,
            'message' => $banner
        ]);
    }
}
