<?php

namespace App\Imports;

use App\Models\Member;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;

class MembersImport implements ToModel, WithHeadingRow
{
    public function model(array $row)
    {
        // Trim each value in the row array to remove any leading or trailing spaces
        return Member::updateOrCreate(
            ['email' => trim($row['email'])], // Unique identifier
            [
                'name' => trim($row['name']),
                'company_name' => trim($row['company_name']),
                'category' => trim($row['category']),
                'email' => trim($row['email']),
                'phone_number' => trim($row['phone_number']),
                'address' => trim($row['address']),
                'designation' => trim($row['designation']),
                'code_no' => trim($row['code_no']),
                'website_url' => trim($row['website_url']),
                'keywords' => trim($row['keywords']),
            ]
        );
    }
}
