<?php

namespace App\Mail;

use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class EnquiryReceived extends Mailable
{
    use SerializesModels;

    public $enquiry; // Make the enquiry data available to the email view

    /**
     * Create a new message instance.
     *
     * @param $enquiry
     * @return void
     */
    public function __construct($enquiry)
    {
        $this->enquiry = $enquiry;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->subject('New Enquiry Received') // Set the email subject
                    ->view('emails.enquiry_received'); // Specify the view for the email body
    }
}
