<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('members', function (Blueprint $table) {
            $table->id();
            $table->string('company_name')->nullable();  // Assuming company names are usually short, string is appropriate.
            $table->string('category');  // Assuming categories are short labels.
            $table->string('email')->unique();  // Emails are usually strings and should be unique.
            $table->string('phone_number')->unique();  // Phone numbers are also strings and should be unique.
            $table->text('address');  // Addresses can be long, so text is a better option.
            $table->string('designation')->nullable();  // Assuming designations are short, string is appropriate.
            $table->string('code_no')->nullable();  // Assuming code numbers are usually short, string is appropriate.
            $table->string('website_url');  // URLs are usually not too long, so string is appropriate.
            $table->text('keywords')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('members');
    }
};
