<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('events', function (Blueprint $table) {
            $table->id();
            $table->string('name'); // Event name
            $table->text('description')->nullable(); // Event description
            $table->date('event_date_from'); // Event start date
            $table->date('event_date_to')->nullable(); // Event end date (nullable if it's a one-day event)
            $table->time('event_time_from')->nullable(); // Event start time
            $table->time('event_time_to')->nullable(); // Event end time
            $table->string('place')->nullable(); // Event location
            $table->string('image')->nullable(); // Path to the event image
            $table->integer('capacity')->nullable(); // Maximum attendees
            $table->string('organizer')->nullable(); // Organizer name or organization
            $table->boolean('is_virtual')->default(0); // Is the event virtual or in-person
            $table->string('registration_link')->nullable();// Registration or ticket link
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('events');
    }
};
