<head>
<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/toastify-js/src/toastify.min.css">
<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/toastify-js"></script>
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.8/dist/umd/popper.min.js" integrity="sha384-QFUMHLf/U4+OCcFLLZai7Y3TlHz5zLn5p/NG6VrR6N/SJAgAzt/SlsfYdXYk8hXY" crossorigin="anonymous"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.min.js" integrity="sha384-RhEVx0ZNGhIixT/1b2+B3N16NLpVcp75/MqCZWknwEnAhYdD+gF2N1wO92+3joH9" crossorigin="anonymous"></script>

</head>

@include('partials.head-css')
@include('partials.title-meta', ['title' => 'Login page'])
<style>
    .css-xwws3d .ant-app .h-full {
        height: auto;
    }

    .card-body h4 {
        padding: 0px 0px 10px;
        color: #000;
        font-size: 30px;
    }

    .admin-info p {
        padding: 0px 0px 5px;
    }

    .admin-logo {
        border: 1px solid #e6e6e6 !important;
        border-radius: 0px 0px 50px 50px !important;
        width: 300px;
        padding: 10px;
        border-top: 0px !important;
    }

    .nav-tabs {
        border: 0px !important;

    }

    .nav-tabs .nav-link.active {
        color: #495057;
        background-color: #F44336 !important;
        color: white !important;
        border-color: #dee2e6 #dee2e6 #ffffff;


    }

    .nav-tabs .nav-link {
        color: #495057 !important;
        border-radius: 5px !important;
        margin: 5px;
        border: 1px solid #F44336 !important;

    }

    .profile-view-left {
        border: 1px solid #e6e6e6 !important;
        border-radius: 5px !important;

        padding: 0px 30px 30px 30px !important;


    }

    .form-main {
        padding: 15px !important;
    }

    .required {
        color: red !important;

    }

    .file-upload-form {
        width: fit-content;
        height: fit-content;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .file-upload-label input {
        display: none;
    }

    .file-upload-label svg {
        height: 50px;
        fill: rgb(82, 82, 82);

    }

    .file-upload-label {
        cursor: pointer;
        background-color: #dddddd40;
        padding: 30px 45px;
        border-radius: 50%;
        border: 2px dashed rgb(82, 82, 82);
    }

    .file-upload-design {
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        gap: 5px;
    }

    .browse-button {
        background-color: rgb(82, 82, 82);
        padding: 5px 15px;
        border-radius: 10px;
        color: white;
        transition: all 0.3s;
    }

    .browse-button:hover {
        background-color: rgb(14, 14, 14);
    }

    @media screen and (max-width: 768px) {
        #profileTab {
            justify-content: center;

        }

    }
</style>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha3/dist/css/bootstrap.min.css" rel="stylesheet">

<main class="dashboard-main">
    @include('partials.main')

    <div class="container-fluid p-5 mt-5">
        <div class="row">
            <!-- Profile Info Section -->
            <div class="col-md-4 profile-view-left mb-5">
                <div>
                    <div class="card-body text-center ">
                        <img src="{{$admin->profile_url}}" class=" mb-3 admin-logo" alt="Profile Image">
                        <h5>{{$admin->name}}</h5>
                        <p>{{$admin->email}}</p>
                        <hr>

                        <h4 class="text-start">Personal Info</h4>
                        <div class="admin-info">

                            <p class="text-start mb-1"><strong>Full Name:</strong> {{$admin->name}}</p>

                            <p class="text-start mb-1"><strong>Email:</strong> {{$admin->email}}</p>
                            <p class="text-start"><strong>Role:</strong> Admin</p>

                        </div>

                    </div>
                </div>
            </div>

            <!-- Edit Profile Section -->
            <div class="col-md-8">
                <div class="dashboard-card">
                    <div class="card-body">
                        <ul class="nav nav-tabs mb-3" id="profileTab" role="tablist">
                            <li class="nav-item" role="presentation">
                                <button class="nav-link active" id="edit-profile-tab" data-bs-toggle="tab" data-bs-target="#edit-profile" type="button" role="tab">Edit Profile</button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="change-password-tab" data-bs-toggle="tab" data-bs-target="#change-password" type="button" role="tab">Change Password</button>
                            </li>
                        </ul>
                        <div class="tab-content">
                            <!-- Edit Profile Tab -->
                            <div class="tab-pane fade show active" id="edit-profile" role="tabpanel">
                                <div class="mb-3 text-center">
                                    <div class="d-flex justify-content-center">
                                    <form id="updateProfile" method="POST" enctype="multipart/form-data">
                                    @csrf
                                            <label for="file" class="file-upload-label">
                                                <div class="file-upload-design">
                                                    <svg viewBox="0 0 640 512" height="1em">
                                                        <path
                                                            d="M144 480C64.5 480 0 415.5 0 336c0-62.8 40.2-116.2 96.2-135.9c-.1-2.7-.2-5.4-.2-8.1c0-88.4 71.6-160 160-160c59.3 0 111 32.2 138.7 80.2C409.9 102 428.3 96 448 96c53 0 96 43 96 96c0 12.2-2.3 23.8-6.4 34.6C596 238.4 640 290.1 640 352c0 70.7-57.3 128-128 128H144zm79-217c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l39-39V392c0 13.3 10.7 24 24 24s24-10.7 24-24V257.9l39 39c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-80-80c-9.4-9.4-24.6-9.4-33.9 0l-80 80z"></path>
                                                    </svg>

                                                    <p>or</p>
                                                    <span class="browse-button">Browse file</span>
                                                </div>
                                                <input id="file" type="file" name="image" accept=".png, .jpg, .jpeg"/>
                                            </label>
                                       
                                    </div>

                                </div>
                                
                                    <div class="row">
                                        <div class="mb-3 col-md-6">
                                            <label for="name" class="form-label ">Name <span class="required">*</span></label>
                                            <input type="text" class="form-control form-main" id="name" name="name" value="{{$admin->name}}">
                                            <span id="name-error" class="text-red-500 text-sm mt-1" style="color:red"></span>
                                        </div>
                                        <div class="mb-3 col-md-6">
                                            <label for="email" class="form-label ">Email <span class="required">*</span></label>
                                            <input type="email" class="form-control form-main" id="email" name="email" value="{{$admin->email}}">
                                            <span id="email-error" class="text-red-500 text-sm mt-1" style="color:red"></span>
                                        </div>
                                        <div class="mb-3 col-md-6">
                                            <label for="role" class="form-label in">Role <span class="required">*</span></label>
                                            <input type="text" class="form-control form-main" id="role" value="admin" readonly>
                                        </div>
                                        <div class="mb-3 mt-5 col-md-6">
                                            <button type="submit" class="btn btn-primary">Save</button>
                                            <button type="button" class="btn btn-danger">Cancel</button>
                                        </div>
                                    </div>



                                </form>
                            </div>

                            <!-- Change Password Tab -->
                            <div class="tab-pane fade" id="change-password" role="tabpanel">
                                <form id="updatePassword" method="POST" enctype="multipart/form-data">
                                @csrf
                                    
                                    <div class="mb-3">
                                        <label for="new-password" class="form-label">New Password <span class="required">*</span></label>
                                        <input type="password" class="form-control form-main" id="new-password" name="password">
                                    </div>
                                    <div class="mb-3">
                                        <label for="confirm-password" class="form-label">Confirm Password <span class="required">*</span></label>
                                        <input type="password" class="form-control form-main" id="confirm-password" name="confirm-password">
                                    </div>
                                    <button type="submit" class="btn btn-primary">Change Password</button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>



</main>

@include('partials.vendor-scripts')

<script src="{{ asset('assets/js/app.js') }}"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha3/dist/js/bootstrap.bundle.min.js"></script>
<script>
    $('#updateProfile').on('submit', function(e) {
        console.log('122');
        e.preventDefault();

        // Create a FormData object
        let formData = new FormData(this);


        // Add CSRF token to headers
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        // Send the AJAX request
        $.ajax({
            url: "{{ route('updateProfile') }}", // Adjust the route as needed
            method: 'POST',
            data: formData,
            processData: false, // Prevent jQuery from automatically transforming the data
            contentType: false, // Set content type to false for FormData
            success: function(response) {

                Toastify({
                    text: "Profile added successfully",
                    duration: 3000,
                    destination: "https://github.com/apvarun/toastify-js",
                    newWindow: true,
                    close: true,
                    position: "right",
                    gravity: "top", // `top` or `bottom`
                    positionLeft: true, // `true` or `false`
                    backgroundColor: "green",
                }).showToast();
               
                setTimeout(function() {
                    window.location.reload();
                }, 2000); // 2000 milliseconds = 2 seconds
            },
            error: function(xhr) {
                if (xhr.status === 422) { // Validation error
                    let errors = xhr.responseJSON.errors;

                    // Loop through each error and display it under the respective field
                    $.each(errors, function(field, messages) {
                        $('#' + field + '-error').text(messages[0]); // Show the first error message
                    });
                } else {
                    alert('Something went wrong. Please try again.');
                }
            }
        });
    });

    $('#updatePassword').on('submit', function(e) {

        e.preventDefault();

        // Create a FormData object
        let formData = new FormData(this);


        // Add CSRF token to headers
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        // Send the AJAX request
        $.ajax({
            url: "{{ route('updatePassword') }}", // Adjust the route as needed
            method: 'POST',
            data: formData,
            processData: false, // Prevent jQuery from automatically transforming the data
            contentType: false, // Set content type to false for FormData
            success: function(response) {

                Toastify({
                    text: "Password added successfully",
                    duration: 3000,
                    destination: "https://github.com/apvarun/toastify-js",
                    newWindow: true,
                    close: true,
                    position: "right",
                    gravity: "top", // `top` or `bottom`
                    positionLeft: true, // `true` or `false`
                    backgroundColor: "green",
                }).showToast();
                return false;
                setTimeout(function() {
                    window.location.href = "{{ route('profile') }}";
                }, 2000); // 2000 milliseconds = 2 seconds
            },
            error: function(xhr) {
                if (xhr.status === 422) { // Validation error
                    let errors = xhr.responseJSON.errors;

                    // Loop through each error and display it under the respective field
                    $.each(errors, function(field, messages) {
                        $('#' + field + '-error').text(messages[0]); // Show the first error message
                    });
                } else {
                    alert('Something went wrong. Please try again.');
                }
            }
        });
    });
</script>