<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>New Enquiry Received</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f9f9f9;
            margin: 0;
            padding: 0;
            color: #333;
        }
        .email-container {
            max-width: 600px;
            margin: 20px auto;
            background-color: #fff;
            border-radius: 8px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            overflow: hidden;
        }
        .header {
            background-color: #ED1C24;
            color: #fff;
            padding: 20px;
            text-align: center;
        }
        .header h1 {
            margin: 0;
            font-size: 24px;
        }
        .content {
            padding: 20px;
        }
        .content p {
            margin: 10px 0;
            font-size: 16px;
            line-height: 1.5;
        }
        .content p strong {
            color: #ED1C24;
        }
        .footer {
            background-color: #f1f1f1;
            text-align: center;
            padding: 10px;
            font-size: 14px;
            color: #666;
        }
    </style>
</head>
<body>
    <div class="email-container">
        <div class="header">
            <h1>New Enquiry Received</h1>
        </div>
        <div class="content">
            <p><strong>Name:</strong> {{ $enquiry['name'] }}</p>
            <p><strong>Email:</strong> {{ $enquiry['email'] }}</p>
            <p><strong>Mobile:</strong> {{ $enquiry['mobile'] }}</p>
            <p><strong>Subject:</strong> {{ $enquiry['subject'] }}</p>
            <p><strong>Message:</strong> {{ $enquiry['message'] }}</p>
            <p><strong>Address:</strong> {{ $enquiry['address'] }}</p>
        </div>
        <div class="footer">
            <p>&copy; 2024 Codissa. All rights reserved.</p>
        </div>
    </div>
</body>
</html>
