<!DOCTYPE html>
<html>

<head>
    @include('partials.main')
    @include('partials.head-css')
    @include('partials.title-meta', ['title' => 'Bulletins'])
    <link rel="stylesheet" href="{{ asset('assets/libs/twitter-bootstrap-wizard/prettify.css') }}">

    <!-- Select2 CSS -->
    <link href="{{ asset('assets/libs/select2/css/select2.min.css') }}" rel="stylesheet" type="text/css" />

    <!-- Dropzone CSS -->
    <link href="{{ asset('assets/libs/dropzone/min/dropzone.min.css') }}" rel="stylesheet" type="text/css" />

</head>
<style>
    .card-body {
        padding: 6.25rem 1.25rem !important;
    }

    .mb-2 {
        margin-top: -92px;
    }

    .user-sidebar {
        background-color: #f14e4e !important;
    }

    .page-title-box {
        background-color: #f14e4e !important;
    }
</style>

<body>

    <div id="layout-wrapper">

        @include('partials.menu')

        <!-- ============================================================== -->
        <!-- Start right Content here -->
        <!-- ============================================================== -->
        <div class="main-content">

            <div class="page-content">

                @include('partials.page-title', ['pagetitle' => 'Form', 'subtitle' => 'Codissa', 'title' => 'Add Bulletins'])


                <div class="container-fluid">

                    <div class="page-content-wrapper">

                        <div class="row">
                            <div class="col-lg-12">
                                <div class="card">
                                    <div class="card-body">

                                        <div id="addproduct-nav-pills-wizard" class="twitter-bs-wizard">

                                            <!-- ebd ul -->
                                            <div>

                                                <div>
                                                    <h4 class="header-title">Bulletins</h4>
                                                    <p class="card-title-desc">Fill all information below</p>

                                                    <form action="{{ route('bulletin.store') }}" method="POST" enctype="multipart/form-data">
                                                        @csrf

                                                        <div class="row">
                                                            <!-- Status Field -->
                                                            <!-- Name Field -->
                                                            <div class="col-sm-3">
                                                                <div class="mb-3">
                                                                    <label class="form-label" for="name">Name<span class="text-danger"></span></label>
                                                                    <input type="text" id="name" name="name" class="form-control @error('name') is-invalid @enderror" value="{{ old('name') }}" placeholder="Enter name">
                                                                    @error('name')
                                                                    <div class="invalid-feedback">
                                                                        {{ $message }}
                                                                    </div>
                                                                    @enderror
                                                                </div>
                                                            </div>
                                                            <!-- end row -->

                                                            <!-- Day Field -->
                                                            <div class="col-sm-3">
                                                                <div class="mb-3">
                                                                    <label class="form-label" for="day">Date<span class="text-danger"> *</span></label>
                                                                    <select id="day" name="date" class="form-control @error('date') is-invalid @enderror">
                                                                        <option value="">Select Date</option>
                                                                        @for ($i = 1; $i <= 31; $i++)
                                                                            <option value="{{ $i }}" {{ old('date') == $i ? 'selected' : '' }}>{{ $i }}</option>
                                                                            @endfor
                                                                    </select>
                                                                    @error('date')
                                                                    <div class="invalid-feedback">
                                                                        {{ $message }}
                                                                    </div>
                                                                    @enderror
                                                                </div>


                                                            </div>

                                                            <!-- Month Field -->
                                                            <div class="col-sm-3">
                                                                <div class="mb-3">
                                                                    <label class="form-label" for="month">Month<span class="text-danger"> *</span></label>
                                                                    <select id="month" name="month" class="form-control @error('month') is-invalid @enderror">
                                                                        <option value="">Select Month</option>
                                                                        @foreach (range(1, 12) as $month)
                                                                        <option value="{{ $month }}" {{ old('month') == $month ? 'selected' : '' }}>
                                                                            {{ date('F', mktime(0, 0, 0, $month, 1)) }}
                                                                        </option>
                                                                        @endforeach
                                                                    </select>
                                                                    @error('month')
                                                                    <div class="invalid-feedback">
                                                                        {{ $message }}
                                                                    </div>
                                                                    @enderror
                                                                </div>
                                                            </div>

                                                            <!-- Year Field -->
                                                            <div class="col-sm-3">
                                                                <div class="mb-3">
                                                                    <label class="form-label" for="year">Year<span class="text-danger"> *</span></label>
                                                                    <input type="number"
                                                                        id="year"
                                                                        name="year"
                                                                        class="form-control @error('year') is-invalid @enderror"
                                                                        value="{{ old('year') }}"
                                                                        placeholder="Enter year"
                                                                        min="1900"
                                                                        max="{{ now()->year }}">
                                                                    @error('year')
                                                                    <div class="invalid-feedback">
                                                                        {{ $message }}
                                                                    </div>
                                                                    @enderror
                                                                </div>

                                                            </div>

                                                            <!-- Image Field -->
                                                            <div class="col-sm-3">
                                                                <div class="mb-3">
                                                                    <label class="form-label" for="image">Image<span class="text-danger"> *</span></label>
                                                                    <input type="file" class="form-control @error('image') is-invalid @enderror" id="image" name="image" accept="image/*">
                                                                    @error('image')
                                                                    <div class="invalid-feedback">
                                                                        {{ $message }}
                                                                    </div>
                                                                    @enderror
                                                                </div>
                                                            </div>



                                                            <ul class="pager wizard twitter-bs-wizard-pager-link">
                                                                <li class="float-end">
                                                                    <button type="submit" class="btn btn-primary" style="background-color:red;border-color:red">
                                                                        Save Changes <i class="mdi mdi-arrow-right ms-1"></i>
                                                                    </button>
                                                                </li>
                                                            </ul>
                                                    </form>




                                                    <!-- end ul -->
                                                </div>
                                                <!-- end tabpane -->
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- end row -->

                    </div>


                </div> <!-- container-fluid -->
            </div>
            <!-- End Page-content -->



            @include('partials.footer')

        </div>
        <!-- end main content-->

    </div>
    <!-- End Page-content -->



    </div>
    @include('partials.vendor-scripts')
    @include('partials.right-sidebar')


    <script src="{{ asset('assets/libs/twitter-bootstrap-wizard/jquery.bootstrap.wizard.min.js') }}"></script>

    <!-- Prettify JS -->
    <script src="{{ asset('assets/libs/twitter-bootstrap-wizard/prettify.js') }}"></script>

    <!-- Select2 Plugin JS -->
    <script src="{{ asset('assets/libs/select2/js/select2.min.js') }}"></script>

    <!-- Dropzone Plugin JS -->
    <script src="{{ asset('assets/libs/dropzone/min/dropzone.min.js') }}"></script>

    <!-- Init JS -->
    <script src="{{ asset('assets/js/pages/ecommerce-add-product.init.js') }}"></script>

    <!-- App JS -->
    <script src="{{ asset('assets/js/app.js') }}"></script>
    <script>
        $(document).ready(function() {
            // Capture the form submit event
            $("form").on("submit", function(e) {
                e.preventDefault(); // Prevent the form from submitting normally

                var formData = new FormData(this); // Get the form data

                $.ajax({
                    url: $(this).attr("action"), // Form action (the URL to which the data is sent)
                    type: $(this).attr("method"), // POST method
                    data: formData, // Send the form data
                    processData: false, // Prevent jQuery from processing the data
                    contentType: false, // Prevent jQuery from setting the content type
                    success: function(response) {
                        window.location.href = response.redirect_url;
                    },
                    error: function(xhr, status, error) {
                        // Handle the error response
                        var errors = xhr.responseJSON.errors;

                        // Clear previous error messages
                        $(".invalid-feedback").remove();

                        // Loop through the errors and display them next to the respective form fields
                        $.each(errors, function(field, messages) {
                            // Find the input field based on the field name
                            var inputField = $("input[name='" + field + "'], textarea[name='" + field + "']");

                            // Append the error message below the input field
                            inputField.addClass('is-invalid'); // Add the error class
                            inputField.after('<div class="invalid-feedback">' + messages[0] + '</div>'); // Display the first error message
                        });
                    }
                });
            });
        });
    </script>



</body>

</html>