<!DOCTYPE html>
<html>

<head>
    @include('partials.main')
    @include('partials.head-css')
    @include('partials.title-meta', ['title' => 'Bulletins'])
    <link rel="stylesheet" href="{{ asset('assets/libs/twitter-bootstrap-wizard/prettify.css') }}">

    <!-- Select2 CSS -->
    <link href="{{ asset('assets/libs/select2/css/select2.min.css') }}" rel="stylesheet" type="text/css" />

    <!-- Dropzone CSS -->
    <link href="{{ asset('assets/libs/dropzone/min/dropzone.min.css') }}" rel="stylesheet" type="text/css" />
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>


</head>

<style>
    .card-body {
        padding: 6.25rem 1.25rem !important;
    }

    .mb-2 {
        margin-top: -92px;
    }

    .user-sidebar {
        background-color: #f14e4e !important;
    }

    .page-title-box {
        background-color: #f14e4e !important;
    }
</style>

<body>

    <div id="layout-wrapper">

        @include('partials.menu')

        <!-- ============================================================== -->
        <!-- Start right Content here -->
        <!-- ============================================================== -->
        <div class="main-content">

            <div class="page-content">

                @include('partials.page-title', ['pagetitle' => 'Form', 'subtitle' => 'Codissia', 'title' => 'Edit Bulletins'])


                <div class="container-fluid">

                    <div class="page-content-wrapper">

                        <div class="row">
                            <div class="col-lg-12">
                                <div class="card">
                                    <div class="card-body">

                                        <div id="addproduct-nav-pills-wizard" class="twitter-bs-wizard">
                                            <div>
                                                <div>
                                                    <h4 class="header-title">Edit Bulletins</h4>
                                                    <p class="card-title-desc">Modify the information below</p>

                                                    <form action="{{ route('bulletin.store') }}" method="POST" enctype="multipart/form-data">
                                                        @csrf

                                                        <!-- Hidden ID Field -->
                                                        <input type="hidden" name="id" value="{{ $bulletin->id ?? '' }}">

                                                        <div class="row">
                                                            <!-- Name Field -->
                                                            <div class="col-sm-3">
                                                                <div class="mb-3">
                                                                    <label class="form-label" for="name">Name<span class="text-danger"></span></label>
                                                                    <input type="text" id="name" name="name" class="form-control @error('name') is-invalid @enderror"
                                                                        value="{{ old('name', $bulletin->name ?? '') }}" placeholder="Enter name">
                                                                    @error('name')
                                                                    <div class="invalid-feedback">
                                                                        {{ $message }}
                                                                    </div>
                                                                    @enderror
                                                                </div>
                                                            </div>

                                                            <!-- Day Field -->
                                                            <div class="col-sm-3">
                                                                <div class="mb-3">
                                                                    <label class="form-label" for="day">Day<span class="text-danger"> *</span></label>
                                                                    <input type="number" id="date" name="date" class="form-control @error('date') is-invalid @enderror"
                                                                        value="{{ old('date', $bulletin->date ?? '') }}" placeholder="Enter the date" min="1" max="31">
                                                                    @error('date')
                                                                    <div class="invalid-feedback">
                                                                        {{ $message }}
                                                                    </div>
                                                                    @enderror
                                                                </div>
                                                            </div>

                                                            <!-- Month Field -->
                                                            <div class="col-sm-3">
                                                                <div class="mb-3">
                                                                    <label class="form-label" for="month">Month<span class="text-danger"> *</span></label>
                                                                    <select id="month" name="month" class="form-control @error('month') is-invalid @enderror">
                                                                        @foreach(range(1, 12) as $m)
                                                                        <option value="{{ $m }}" {{ old('month', $bulletin->month ?? '') == $m ? 'selected' : '' }}>
                                                                            {{ date('F', mktime(0, 0, 0, $m, 10)) }}
                                                                        </option>
                                                                        @endforeach
                                                                    </select>
                                                                    @error('month')
                                                                    <div class="invalid-feedback">
                                                                        {{ $message }}
                                                                    </div>
                                                                    @enderror
                                                                </div>
                                                            </div>

                                                            <!-- Year Field -->
                                                            <div class="col-sm-3">
                                                                <div class="mb-3">
                                                                    <label class="form-label" for="year">Year<span class="text-danger"> *</span></label>
                                                                    <input type="number" id="year" name="year" class="form-control @error('year') is-invalid @enderror"
                                                                        value="{{ old('year', $bulletin->year ?? date('Y')) }}" placeholder="Enter year" min="1900" max="{{ date('Y') }}">
                                                                    @error('year')
                                                                    <div class="invalid-feedback">
                                                                        {{ $message }}
                                                                    </div>
                                                                    @enderror
                                                                </div>
                                                            </div>



                                                            <!-- Image Field -->
                                                            <div class="col-sm-3">
                                                                <div class="mb-3">
                                                                    <label class="form-label" for="image">Image<span class="text-danger"> *</span></label>
                                                                    <input type="file" class="form-control" id="image" name="image" accept="image/*">
                                                                    @if(isset($bulletin->image))
                                                                    <p>Current Image: <img src="{{ asset($bulletin->image) }}" alt="Banner Image" height="50"></p>
                                                                    @endif
                                                                    @error('image')
                                                                    <div class="invalid-feedback">
                                                                        {{ $message }}
                                                                    </div>
                                                                    @enderror
                                                                </div>
                                                            </div>
                                                        </div>

                                                        <!-- Submit Button -->
                                                        <ul class="pager wizard twitter-bs-wizard-pager-link">
                                                            <li class="float-end">
                                                                <button type="submit" class="btn btn-primary" style="background-color: red; border-color: red;">
                                                                    Save Changes <i class="mdi mdi-arrow-right ms-1"></i>
                                                                </button>
                                                            </li>
                                                        </ul>
                                                    </form>



                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- end row -->

                    </div>


                </div> <!-- container-fluid -->
            </div>
            <!-- End Page-content -->



            @include('partials.footer')

        </div>
        <!-- end main content-->

    </div>
    <!-- End Page-content -->



    </div>
    @include('partials.vendor-scripts')
    @include('partials.right-sidebar')
    <script>
        $("form").on("submit", function(e) {
            e.preventDefault();

            var formData = new FormData(this);

            // Clear previous error messages
            $("form .invalid-feedback").remove();
            $("form .is-invalid").removeClass("is-invalid");

            $.ajax({
                url: $(this).attr('action'),
                type: 'POST',
                data: formData,
                processData: false,
                contentType: false,
                success: function(response) {
                    console.log(response);
                    if (response.redirect_url) {
                        window.location.href = response.redirect_url;
                    } else {
                        alert('Form submitted successfully!');
                    }
                },
                error: function(xhr) {
                    if (xhr.status === 422) {
                        // Parse validation errors
                        var errors = xhr.responseJSON.errors;
                        for (var field in errors) {
                            var input = $(`[name="${field}"]`);
                            var errorMessage = `<div class="invalid-feedback">${errors[field][0]}</div>`;
                            input.addClass("is-invalid");
                            input.after(errorMessage);
                        }
                    } else {
                        console.error('Error:', xhr.responseText);
                        alert('An unexpected error occurred.');
                    }
                }
            });
        });

        $(".save-button").click(function() {
            $("form").submit();
        });
    </script>



    <script src="{{ asset('assets/libs/twitter-bootstrap-wizard/jquery.bootstrap.wizard.min.js') }}"></script>

    <!-- Prettify JS -->
    <script src="{{ asset('assets/libs/twitter-bootstrap-wizard/prettify.js') }}"></script>

    <!-- Select2 Plugin JS -->
    <script src="{{ asset('assets/libs/select2/js/select2.min.js') }}"></script>

    <!-- Dropzone Plugin JS -->
    <script src="{{ asset('assets/libs/dropzone/min/dropzone.min.js') }}"></script>

    <!-- Init JS -->
    <script src="{{ asset('assets/js/pages/ecommerce-add-product.init.js') }}"></script>

    <!-- App JS -->
    <script src="{{ asset('assets/js/app.js') }}"></script>

</body>

</html>