<!DOCTYPE html>
<html>

<head>
    @include('partials.main')
    @include('partials.head-css')
    @include('partials.title-meta', ['title' => 'Event'])
    <link rel="stylesheet" href="{{ asset('assets/libs/twitter-bootstrap-wizard/prettify.css') }}">

    <!-- Select2 CSS -->
    <link href="{{ asset('assets/libs/select2/css/select2.min.css') }}" rel="stylesheet" type="text/css" />

    <!-- Dropzone CSS -->
    <link href="{{ asset('assets/libs/dropzone/min/dropzone.min.css') }}" rel="stylesheet" type="text/css" />

</head>
<style>
    .card-body {
        padding: 6.25rem 1.25rem !important;
    }

    .mb-2 {
        margin-top: -92px;
    }

    .user-sidebar {
        background-color: #f14e4e !important;
    }

    .page-title-box {
        background-color: #f14e4e !important;
    }
</style>

<body>

    <div id="layout-wrapper">

        @include('partials.menu')

        <!-- ============================================================== -->
        <!-- Start right Content here -->
        <!-- ============================================================== -->
        <div class="main-content">

            <div class="page-content">

                @include('partials.page-title', ['pagetitle' => 'Form', 'subtitle' => 'Codissa', 'title' => 'Add Event'])


                <div class="container-fluid">

                    <div class="page-content-wrapper">

                        <div class="row">
                            <div class="col-lg-12">
                                <div class="card">
                                    <div class="card-body">

                                        <div id="addproduct-nav-pills-wizard" class="twitter-bs-wizard">

                                            <!-- ebd ul -->
                                            <div>

                                                <div>
                                                    <h4 class="header-title">Event</h4>
                                                    <p class="card-title-desc">Fill all information below</p>

                                                    <form action="{{ route('event.store') }}" method="POST">
                                                        @csrf

                                                        <div class="row">
                                                            <div class="col-sm-3">
                                                                <div class="mb-3">
                                                                    <label class="form-label" for="name">Name<span class="text-danger"> *</span></label>
                                                                    <input id="name" name="name" type="text" class="form-control @error('name') is-invalid @enderror" placeholder="Enter name" value="{{ old('name') }}">
                                                                    @error('name')
                                                                    <div class="invalid-feedback">
                                                                        {{ $message }}
                                                                    </div>
                                                                    @enderror
                                                                </div>
                                                            </div><!-- end col -->
                                                            <div class="col-sm-3">
                                                                <div class="mb-3">
                                                                    <label class="form-label" for="event_date_from">Event Date From <span class="text-danger"> *</span></label>
                                                                    <input id="event_date_from" name="event_date_from" type="date" class="form-control @error('event_date_from') is-invalid @enderror" placeholder="Enter event start date" value="{{ old('event_date_from') }}">
                                                                    @error('event_date_from')
                                                                    <div class="invalid-feedback">
                                                                        {{ $message }}
                                                                    </div>
                                                                    @enderror
                                                                </div>
                                                            </div>

                                                            <div class="col-sm-3">
                                                                <div class="mb-3">
                                                                    <label class="form-label" for="event_date_to">Event Date To <span class="text-danger"> *</span></label>
                                                                    <input id="event_date_to" name="event_date_to" type="date" class="form-control @error('event_date_to') is-invalid @enderror" placeholder="Enter event end date" value="{{ old('event_date_to') }}">
                                                                    @error('event_date_to')
                                                                    <div class="invalid-feedback">
                                                                        {{ $message }}
                                                                    </div>
                                                                    @enderror
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="row">
                                                            <div class="col-sm-3">
                                                                <div class="mb-3">
                                                                    <label class="form-label" for="name">Event time from<span class="text-danger"> *</span></label>
                                                                    <input type="time" id="event_time_from" name="event_time_from" class="form-control @error('event_time_from') is-invalid @enderror" placeholder="Enter event time from">
                                                                    @error('event_time_from')
                                                                    <div class="invalid-feedback">
                                                                        {{ $message }}
                                                                    </div>
                                                                    @enderror
                                                                </div>
                                                            </div><!-- end col -->
                                                            <div class="col-sm-3">
                                                                <div class="mb-3">
                                                                    <label class="form-label" for="name">Event time to<span class="text-danger"> *</span></label>
                                                                    <input type="time" id="event_time_to" name="event_time_to" class="form-control @error('event_time_to') is-invalid @enderror" placeholder="Enter event time to">
                                                                    @error('event_time_to')
                                                                    <div class="invalid-feedback">
                                                                        {{ $message }}
                                                                    </div>
                                                                    @enderror
                                                                </div>
                                                            </div><!-- end col -->
                                                            <div class="col-sm-3">
                                                                <div class="mb-3">
                                                                    <label class="form-label" for="name">place</label>
                                                                    <input id="place" name="place" type="text" class="form-control @error('place') is-invalid @enderror" placeholder="Enter the place" value="{{ old('place') }}">
                                                                    @error('place')
                                                                    <div class="invalid-feedback">
                                                                        {{ $message }}
                                                                    </div>
                                                                    @enderror
                                                                </div>
                                                            </div><!-- end col -->


                                                        </div>
                                                        <div class="row">
                                                            <div class="col-sm-3">
                                                                <div class="mb-3">
                                                                    <label class="form-label" for="name">capacity</label>
                                                                    <input id="capacity" name="capacity" type="text" class="form-control @error('capacity') is-invalid @enderror" placeholder="Enter the capacity" value="{{ old('capacity') }}">
                                                                    @error('capacity')
                                                                    <div class="invalid-feedback">
                                                                        {{ $message }}
                                                                    </div>
                                                                    @enderror
                                                                </div>
                                                            </div><!-- end col -->
                                                            <div class="col-sm-3">
                                                                <div class="mb-3">
                                                                    <label class="form-label" for="name">Organizer</label>
                                                                    <input id="organizer" name="organizer" type="text" class="form-control" placeholder="Enter the organizer" value="{{ old('organizer') }}">
                                                                    @error('organizer')
                                                                    <div class="invalid-feedback">
                                                                        {{ $message }}
                                                                    </div>
                                                                    @enderror
                                                                </div>
                                                            </div><!-- end col -->
                                                            <div class="col-sm-3">
                                                                <div class="mb-3">
                                                                    <label class="form-label" for="name">Registration link</label>
                                                                    <input id="registration_link" name="registration_link" type="text" class="form-control @error('registration_link') is-invalid @enderror" placeholder="Enter the registration link" value="{{ old('registration_link') }}">
                                                                    @error('registration_link')
                                                                    <div class="invalid-feedback">
                                                                        {{ $message }}
                                                                    </div>
                                                                    @enderror
                                                                </div>
                                                            </div><!-- end col -->


                                                        </div>
                                                        <!-- end row -->
                                                        <div class="col-sm-3">
                                                        <div class="mb-3">
                                                      
                                                            <label class="form-label" for="image">Image</label>
                                                            <input type="file" class="form-control" id="image" name="image" accept="image/*" />
                                                        </div>
                                                        </div>


                                                        <ul class="pager wizard twitter-bs-wizard-pager-link">
                                                            <li class="float-end">
                                                                <button type="submit" class="btn btn-primary" style="background-color:red;border-color:red">Save Changes <i class="mdi mdi-arrow-right ms-1"></i></button>
                                                            </li>
                                                        </ul>
                                                    </form>


                                                    <!-- end ul -->
                                                </div>
                                                <!-- end tabpane -->
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- end row -->

                    </div>


                </div> <!-- container-fluid -->
            </div>
            <!-- End Page-content -->



            @include('partials.footer')

        </div>
        <!-- end main content-->

    </div>
    <!-- End Page-content -->



    </div>
    @include('partials.vendor-scripts')
    @include('partials.right-sidebar')


    <script src="{{ asset('assets/libs/twitter-bootstrap-wizard/jquery.bootstrap.wizard.min.js') }}"></script>

    <!-- Prettify JS -->
    <script src="{{ asset('assets/libs/twitter-bootstrap-wizard/prettify.js') }}"></script>

    <!-- Select2 Plugin JS -->
    <script src="{{ asset('assets/libs/select2/js/select2.min.js') }}"></script>

    <!-- Dropzone Plugin JS -->
    <script src="{{ asset('assets/libs/dropzone/min/dropzone.min.js') }}"></script>

    <!-- Init JS -->
    <script src="{{ asset('assets/js/pages/ecommerce-add-product.init.js') }}"></script>

    <!-- App JS -->
    <script src="{{ asset('assets/js/app.js') }}"></script>
    <script>
        $(document).ready(function() {
            // Capture the form submit event
            $("form").on("submit", function(e) {
                e.preventDefault(); // Prevent the form from submitting normally

                var formData = new FormData(this); // Get the form data

                $.ajax({
                    url: $(this).attr("action"), // Form action (the URL to which the data is sent)
                    type: $(this).attr("method"), // POST method
                    data: formData, // Send the form data
                    processData: false, // Prevent jQuery from processing the data
                    contentType: false, // Prevent jQuery from setting the content type
                    success: function(response) {
                        window.location.href = response.redirect_url;
                    },
                    error: function(xhr, status, error) {
                        // Handle the error response
                        var errors = xhr.responseJSON.errors;

                        // Clear previous error messages
                        $(".invalid-feedback").remove();

                        // Loop through the errors and display them next to the respective form fields
                        $.each(errors, function(field, messages) {
                            // Find the input field based on the field name
                            var inputField = $("input[name='" + field + "'], textarea[name='" + field + "']");

                            // Append the error message below the input field
                            inputField.addClass('is-invalid'); // Add the error class
                            inputField.after('<div class="invalid-feedback">' + messages[0] + '</div>'); // Display the first error message
                        });
                    }
                });
            });
        });
    </script>



</body>

</html>