<!DOCTYPE html>
<html>

<head>
    @include('partials.main')
    @include('partials.head-css')
    @include('partials.title-meta', ['title' => 'Members'])
    <link rel="stylesheet" href="{{ asset('assets/libs/twitter-bootstrap-wizard/prettify.css') }}">

    <!-- Select2 CSS -->
    <link href="{{ asset('assets/libs/select2/css/select2.min.css') }}" rel="stylesheet" type="text/css" />

    <!-- Dropzone CSS -->
    <link href="{{ asset('assets/libs/dropzone/min/dropzone.min.css') }}" rel="stylesheet" type="text/css" />
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>


</head>

<style>
    .card-body {
        padding: 6.25rem 1.25rem !important;
    }

    .mb-2 {
        margin-top: -92px;
    }

    .user-sidebar {
        background-color: #f14e4e !important;
    }

    .page-title-box {
        background-color: #f14e4e !important;
    }
</style>

<body>

    <div id="layout-wrapper">

        @include('partials.menu')

        <!-- ============================================================== -->
        <!-- Start right Content here -->
        <!-- ============================================================== -->
        <div class="main-content">

            <div class="page-content">

                @include('partials.page-title', ['pagetitle' => 'Form', 'subtitle' => 'Codissia', 'title' => 'Edit Event'])


                <div class="container-fluid">

                    <div class="page-content-wrapper">

                        <div class="row">
                            <div class="col-lg-12">
                                <div class="card">
                                    <div class="card-body">

                                        <div id="addproduct-nav-pills-wizard" class="twitter-bs-wizard">
                                            <div>
                                                <div>
                                                    <h4 class="header-title">Edit Member</h4>
                                                    <p class="card-title-desc">Modify the information below</p>

                                                    <form action="{{ route('event.store') }}" method="POST">
                                                        @csrf


                                                        <div class="row">
                                                            <div class="col-sm-3">
                                                                <div class="mb-3">
                                                                    <input type="hidden" name="id" value="{{ $event->id ?? '' }}">

                                                                    <label class="form-label" for="name">Name<span class="text-danger"> *</span></label>
                                                                    <input id="name" name="name" type="text" class="form-control @error('name') is-invalid @enderror" placeholder="Enter name" value="{{ old('name', $event->name) }}">
                                                                    @error('name')
                                                                    <div class="invalid-feedback">
                                                                        {{ $message }}
                                                                    </div>
                                                                    @enderror
                                                                </div>
                                                            </div><!-- end col -->
                                                            <div class="col-sm-3">
                                                                <div class="mb-3">
                                                                    <label class="form-label" for="event_date_from">Event Date From <span class="text-danger"> *</span></label>
                                                                    <input id="event_date_from" name="event_date_from" type="date" class="form-control @error('event_date_from') is-invalid @enderror" value="{{ old('event_date_from', $event->event_date_from) }}">
                                                                    @error('event_date_from')
                                                                    <div class="invalid-feedback">
                                                                        {{ $message }}
                                                                    </div>
                                                                    @enderror
                                                                </div>
                                                            </div><!-- end col -->

                                                            <div class="col-sm-3">
                                                                <div class="mb-3">
                                                                    <label class="form-label" for="event_date_to">Event Date To <span class="text-danger"> *</span></label>
                                                                    <input id="event_date_to" name="event_date_to" type="date" class="form-control @error('event_date_to') is-invalid @enderror" value="{{ old('event_date_to', $event->event_date_to) }}">
                                                                    @error('event_date_to')
                                                                    <div class="invalid-feedback">
                                                                        {{ $message }}
                                                                    </div>
                                                                    @enderror
                                                                </div>
                                                            </div><!-- end col -->
                                                        </div>

                                                        <div class="row">
                                                            <div class="col-sm-3">
                                                                <div class="mb-3">
                                                                    <label class="form-label" for="event_time_from">Event time from<span class="text-danger"> *</span></label>
                                                                    <input type="time" id="event_time_from" name="event_time_from" class="form-control @error('event_time_from') is-invalid @enderror" value="{{ old('event_time_from', $event->event_time_from) }}">
                                                                    @error('event_time_from')
                                                                    <div class="invalid-feedback">
                                                                        {{ $message }}
                                                                    </div>
                                                                    @enderror
                                                                </div>
                                                            </div><!-- end col -->
                                                            <div class="col-sm-3">
                                                                <div class="mb-3">
                                                                    <label class="form-label" for="event_time_to">Event time to<span class="text-danger"> *</span></label>
                                                                    <input type="time" id="event_time_to" name="event_time_to" class="form-control @error('event_time_to') is-invalid @enderror" value="{{ old('event_time_to', $event->event_time_to) }}">
                                                                    @error('event_time_to')
                                                                    <div class="invalid-feedback">
                                                                        {{ $message }}
                                                                    </div>
                                                                    @enderror
                                                                </div>
                                                            </div><!-- end col -->
                                                            <div class="col-sm-3">
                                                                <div class="mb-3">
                                                                    <label class="form-label" for="place">Place</label>
                                                                    <input id="place" name="place" type="text" class="form-control @error('place') is-invalid @enderror" value="{{ old('place', $event->place) }}">
                                                                    @error('place')
                                                                    <div class="invalid-feedback">
                                                                        {{ $message }}
                                                                    </div>
                                                                    @enderror
                                                                </div>
                                                            </div><!-- end col -->
                                                        </div>

                                                        <div class="row">
                                                            <div class="col-sm-3">
                                                                <div class="mb-3">
                                                                    <label class="form-label" for="capacity">Capacity</label>
                                                                    <input id="capacity" name="capacity" type="text" class="form-control @error('capacity') is-invalid @enderror" value="{{ old('capacity', $event->capacity) }}">
                                                                    @error('capacity')
                                                                    <div class="invalid-feedback">
                                                                        {{ $message }}
                                                                    </div>
                                                                    @enderror
                                                                </div>
                                                            </div><!-- end col -->
                                                            <div class="col-sm-3">
                                                                <div class="mb-3">
                                                                    <label class="form-label" for="organizer">Organizer</label>
                                                                    <input id="organizer" name="organizer" type="text" class="form-control" value="{{ old('organizer', $event->organizer) }}">
                                                                    @error('organizer')
                                                                    <div class="invalid-feedback">
                                                                        {{ $message }}
                                                                    </div>
                                                                    @enderror
                                                                </div>
                                                            </div><!-- end col -->
                                                            <div class="col-sm-3">
                                                                <div class="mb-3">
                                                                    <label class="form-label" for="registration_link">Registration Link</label>
                                                                    <input id="registration_link" name="registration_link" type="text" class="form-control @error('registration_link') is-invalid @enderror" value="{{ old('registration_link', $event->registration_link) }}">
                                                                    @error('registration_link')
                                                                    <div class="invalid-feedback">
                                                                        {{ $message }}
                                                                    </div>
                                                                    @enderror
                                                                </div>
                                                            </div><!-- end col -->
                                                        </div>

                                                        <!-- Image upload -->
                                                        <div class="col-sm-3">
                                                            <div class="mb-3">
                                                                <label class="form-label" for="image">Image</label>
                                                                <input type="file" class="form-control" id="image" name="image" accept="image/*" />
                                                                @if($event->image)
                                                                <p>Current Image: <img src="{{ asset($event->image) }}" alt="Event Image" height="50"></p>
                                                                @endif
                                                            </div>
                                                        </div>

                                                        <!-- Submit button -->
                                                        <ul class="pager wizard twitter-bs-wizard-pager-link">
                                                            <li class="float-end">
                                                                <button type="button" class="btn btn-primary save-button" style="background-color:red;border-color:red">Save Changes <i class="mdi mdi-arrow-right ms-1"></i></button>

                                                            </li>
                                                        </ul>
                                                    </form>


                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- end row -->

                    </div>


                </div> <!-- container-fluid -->
            </div>
            <!-- End Page-content -->



            @include('partials.footer')

        </div>
        <!-- end main content-->

    </div>
    <!-- End Page-content -->



    </div>
    @include('partials.vendor-scripts')
    @include('partials.right-sidebar')
    <script>
        $("form").on("submit", function(e) {
            e.preventDefault();

            var formData = new FormData(this);

            // Clear previous error messages
            $("form .invalid-feedback").remove();
            $("form .is-invalid").removeClass("is-invalid");

            $.ajax({
                url: $(this).attr('action'),
                type: 'POST',
                data: formData,
                processData: false,
                contentType: false,
                success: function(response) {
                    console.log(response);
                    if (response.redirect_url) {
                        window.location.href = response.redirect_url;
                    } else {
                        alert('Form submitted successfully!');
                    }
                },
                error: function(xhr) {
                    if (xhr.status === 422) {
                        // Parse validation errors
                        var errors = xhr.responseJSON.errors;
                        for (var field in errors) {
                            var input = $(`[name="${field}"]`);
                            var errorMessage = `<div class="invalid-feedback">${errors[field][0]}</div>`;
                            input.addClass("is-invalid");
                            input.after(errorMessage);
                        }
                    } else {
                        console.error('Error:', xhr.responseText);
                        alert('An unexpected error occurred.');
                    }
                }
            });
        });

        $(".save-button").click(function() {
            $("form").submit();
        });
    </script>



    <script src="{{ asset('assets/libs/twitter-bootstrap-wizard/jquery.bootstrap.wizard.min.js') }}"></script>

    <!-- Prettify JS -->
    <script src="{{ asset('assets/libs/twitter-bootstrap-wizard/prettify.js') }}"></script>

    <!-- Select2 Plugin JS -->
    <script src="{{ asset('assets/libs/select2/js/select2.min.js') }}"></script>

    <!-- Dropzone Plugin JS -->
    <script src="{{ asset('assets/libs/dropzone/min/dropzone.min.js') }}"></script>

    <!-- Init JS -->
    <script src="{{ asset('assets/js/pages/ecommerce-add-product.init.js') }}"></script>

    <!-- App JS -->
    <script src="{{ asset('assets/js/app.js') }}"></script>

</body>

</html>