<!DOCTYPE html>
<html>

<head>
    @include('partials.main')
    @include('partials.head-css')
    @include('partials.title-meta', ['title' => 'Exhibitors'])
    <link href="{{ asset('assets/libs/admin-resources/jquery.vectormap/jquery-jvectormap-1.2.2.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ asset('assets/libs/flatpickr/flatpickr.min.css') }}" rel="stylesheet">

    <!-- gridjs css -->
    <link href="{{ asset('assets/libs/gridjs/theme/mermaid.min.css') }}" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastify-js/1.12.0/toastify.min.css">

    <meta name="csrf-token" content="{{ csrf_token() }}">
    <style>
        .shadow-sm {
            display: flex;
            justify-content: center;
            align-items: center;
        }

        .text-sm {
            text-align: center;
        }

        .navigation {
            line-height: 40px !important;
        }
    </style>
</head>

<style>
    .card-body {
        padding: 30px !important;
    }



    .user-sidebar {
        background-color: #f14e4e !important;
    }

    .page-title-box {
        background-color: #f14e4e !important;
    }
</style>

<body>

    <div id="layout-wrapper">
        @include('partials.menu')

        <div class="main-content">
            <div class="page-content">
                @include('partials.page-title', ['pagetitle' => 'Form', 'subtitle' => 'Codissa', 'title' => 'Exhibitors'])
                <div class="container-fluid">
                    <div class="page-content-wrapper">
                        <div class="row">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-body">
                                        <!-- Add Import Form -->

                                        <form class="mb-4">
                                            @csrf
                                            <div class="d-flex mb-4">
                                                <!-- Add Member -->
                                                <div>
                                                    <a href="{{ route('exhibitors') }}" class="btn btn-success">
                                                        <i class="mdi mdi-plus me-2"></i> Add Exhibitors
                                                    </a>
                                                </div>
                                                <!--Form Submit -->

                                            </div>



                                        </form>
                                        <h4 class="card-title">Exhibitors List</h4>
                                        <div class="table-responsive">
                                            <table class="table table-centered table-nowrap">
                                                <thead>
                                                    <tr>
                                                        <th>#</th>
                                                        <th>Name</th>
                                                        <th>Image</th>
                                                        <th>Link</th>
                                                        <th>Created at</th>
                                                        <th>Updated at</th>
                                                        <th style="width: 120px;">Action</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @if($exhibitors->count() > 0)
                                                    @foreach($exhibitors as $event)
                                                    <tr>
                                                        <td>{{ $loop->iteration + ($exhibitors->currentPage() - 1) * $exhibitors->perPage() }}</td>
                                                        <td>{{ $event->name }}</td>
                                                        <td>
                                                            @if($event->image)
                                                            <img src="{{ asset($event->image) }}" alt="{{ $event->name }}" style="width: 100px; height: auto;">
                                                            @else
                                                            No Image
                                                            @endif
                                                        </td>
                                                        <td>{{ $event->link }}</td>
                                                        <td>{{ $event->created_at }}</td>
                                                        <td>{{ $event->updated_at }}</td>
                                                        <td id="tooltip-container0">
                                                            <form action="{{ route('exhibitors.edit', $event->id) }}" method="GET" style="display: inline;">
                                                                <button type="submit" class="btn btn-danger" data-bs-container="#tooltip-container0" data-bs-toggle="tooltip" data-bs-placement="top" title="Edit">
                                                                    Edit
                                                                </button>
                                                            </form>
                                                            <button type="button" class="btn btn-danger delete-customer btn-btn danger" data-member-id="{{ $event->id }}">Delete</button>
                                                        </td>
                                                    </tr>
                                                    @endforeach
                                                    @else
                                                    <tr>
                                                        <td colspan="8" class="text-center">No exhibitors found.</td>
                                                    </tr>
                                                    @endif
                                                </tbody>
                                            </table>

                                            <div class="d-flex justify-content-center">
                                                {{ $exhibitors->links() }}
                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div> <!-- end page-content-wrapper -->
                </div>
                <!-- end container-fluid -->
            </div> <!-- end page-content -->
        </div> <!-- end main-content -->
    </div>
    @include('partials.vendor-scripts')
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/sweetalert/2.1.2/sweetalert.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastify-js/1.12.0/toastify.min.js"></script>

    <script>
        $(document).ready(function() {
            // Attach a click event handler to the delete button
            $('.delete-customer').click(function() {
                // Store a reference to the current button
                var button = $(this);
                var memberId = button.data('member-id');

                // Display SweetAlert confirmation dialog
                swal({
                    title: "Are you sure?",
                    text: "Once deleted, you will not be able to recover this member!",
                    icon: "warning",
                    buttons: true,
                    dangerMode: true,
                }).then((willDelete) => {
                    if (willDelete) {
                        // Fetch the CSRF token
                        var csrfToken = $('meta[name="csrf-token"]').attr('content');

                        // Make the AJAX request
                        $.ajax({
                            url: '/exhibitors/' + memberId, // URL to your Laravel route
                            method: 'DELETE', // Correct HTTP method for deletion
                            data: {
                                _token: csrfToken // Include CSRF token for Laravel
                            },

                            success: function(response) {
                                Toastify({
                                    text: "Exhibitors deleted successfully!",
                                    duration: 3000, // Duration in milliseconds
                                    close: true, // Show close button
                                    gravity: "top", // Position (top or bottom)
                                    position: "right", // Position (left, center, right)
                                    backgroundColor: "linear-gradient(to right, #00b09b, #96c93d)" // Custom background color
                                }).showToast();
                                setTimeout(function() {
                                    window.location.reload();
                                }, 1000);

                            },
                            error: function(xhr, status, error) {
                                console.error('Error deleting member:', error);
                                Swal.fire(
                                    'Error!',
                                    'Failed to delete event.',
                                    'error'
                                );
                            }
                        });
                    } else {
                        // If user cancels deletion, do nothing
                        swal("event deletion cancelled!");
                    }
                });
            });
        });
    </script>


</body>

</html>