<!DOCTYPE html>
<html>

<head>
    @include('partials.main')
    @include('partials.head-css')
    @include('partials.title-meta', ['title' => 'Members'])
    <link rel="stylesheet" href="{{ asset('assets/libs/twitter-bootstrap-wizard/prettify.css') }}">

    <!-- Select2 CSS -->
    <link href="{{ asset('assets/libs/select2/css/select2.min.css') }}" rel="stylesheet" type="text/css" />

    <!-- Dropzone CSS -->
    <link href="{{ asset('assets/libs/dropzone/min/dropzone.min.css') }}" rel="stylesheet" type="text/css" />

</head>
<style>
    .card-body {
        padding: 6.25rem 1.25rem !important;
    }

    .mb-2 {
        margin-top: -92px;
    }

    .user-sidebar {
        background-color: #f14e4e !important;
    }

    .page-title-box {
        background-color: #f14e4e !important;
    }
</style>

<body>

    <div id="layout-wrapper">

        @include('partials.menu')

        <!-- ============================================================== -->
        <!-- Start right Content here -->
        <!-- ============================================================== -->
        <div class="main-content">

            <div class="page-content">

                @include('partials.page-title', ['pagetitle' => 'Form', 'subtitle' => 'Codissa', 'title' => 'Add Member'])


                <div class="container-fluid">

                    <div class="page-content-wrapper">

                        <div class="row">
                            <div class="col-lg-12">
                                <div class="card">
                                    <div class="card-body">

                                        <div id="addproduct-nav-pills-wizard" class="twitter-bs-wizard">

                                            <!-- ebd ul -->
                                            <div>

                                                <div>
                                                    <h4 class="header-title">Members</h4>
                                                    <p class="card-title-desc">Fill all information below</p>

                                                    <form action="{{ route('members.store') }}" method="POST">
                                                        @csrf

                                                        <div class="row">
                                                            <div class="col-sm-3">
                                                                <div class="mb-3">
                                                                    <label class="form-label" for="name">Name<span class="text-danger"> *</span></label>
                                                                    <input id="name" name="name" type="text" class="form-control @error('name') is-invalid @enderror" placeholder="Enter name" value="{{ old('name') }}">
                                                                    @error('name')
                                                                    <div class="invalid-feedback">
                                                                        {{ $message }}
                                                                    </div>
                                                                    @enderror
                                                                </div>
                                                            </div><!-- end col -->
                                                            <div class="col-sm-3">
                                                                <div class="mb-3">
                                                                    <label class="form-label" for="name">Company name<span class="text-danger"> *</span></label>
                                                                    <input id="company_name" name="company_name" type="text" class="form-control @error('company_name') is-invalid @enderror" placeholder="Enter company name" value="{{ old('name') }}">
                                                                    @error('company_name')
                                                                    <div class="invalid-feedback">
                                                                        {{ $message }}
                                                                    </div>
                                                                    @enderror
                                                                </div>
                                                            </div><!-- end col -->
                                                            <div class="col-sm-3">
                                                                <div class="mb-3">
                                                                  
                                                                    <label class="form-label" for="name">Category<span class="text-danger"> *</span></label>
                                                                    <input id="category" name="category" type="text" class="form-control @error('category') is-invalid @enderror" placeholder="Enter the category" value="{{ old('category') }}">
                                                                    @error('category')
                                                                    <div class="invalid-feedback">
                                                                        {{ $message }}
                                                                    </div>
                                                                    @enderror
                                                                </div>
                                                            </div><!-- end col -->
                                                        </div>
                                                        <div class="row">
                                                            <div class="col-sm-3">
                                                                <div class="mb-3">
                                                                    <label class="form-label" for="name">Email<span class="text-danger"> *</span></label>
                                                                    <input type="email" id="email" name="email" class="form-control @error('email') is-invalid @enderror" placeholder="Enter email">
                                                                    @error('email')
                                                                    <div class="invalid-feedback">
                                                                        {{ $message }}
                                                                    </div>
                                                                    @enderror
                                                                </div>
                                                            </div><!-- end col -->
                                                            <div class="col-sm-3">
                                                                <div class="mb-3">
                                                                    <label class="form-label" for="name">Phone Number<span class="text-danger"> *</span></label>
                                                                    <input id="phone_number" name="phone_number" type="text" class="form-control @error('phone_number') is-invalid @enderror" placeholder="Enter phone number" value="{{ old('phone_number') }}">
                                                                    @error('phone_number')
                                                                    <div class="invalid-feedback">
                                                                        {{ $message }}
                                                                    </div>
                                                                    @enderror
                                                                </div>
                                                            </div><!-- end col -->
                                                            <div class="col-sm-3">
                                                                <div class="mb-3">
                                                                    <label class="form-label" for="name">Address</label>
                                                                    <input id="address" name="address" type="text" class="form-control @error('address') is-invalid @enderror" placeholder="Enter the address" value="{{ old('address') }}">
                                                                    @error('address')
                                                                    <div class="invalid-feedback">
                                                                        {{ $message }}
                                                                    </div>
                                                                    @enderror
                                                                </div>
                                                            </div><!-- end col -->


                                                        </div>
                                                        <div class="row">
                                                            <div class="col-sm-3">
                                                                <div class="mb-3">
                                                                    <label class="form-label" for="name">Desigination</label>
                                                                    <input id="designation" name="designation" type="text" class="form-control @error('desigination') is-invalid @enderror" placeholder="Enter the desigination" value="{{ old('designation') }}">
                                                                    @error('designation')
                                                                    <div class="invalid-feedback">
                                                                        {{ $message }}
                                                                    </div>
                                                                    @enderror
                                                                </div>
                                                            </div><!-- end col -->
                                                            <div class="col-sm-3">
                                                                <div class="mb-3">
                                                                    <label class="form-label" for="name">Code number</label>
                                                                    <input id="code_no" name="code_no" type="text" class="form-control" placeholder="Enter the code number" value="{{ old('code_no') }}">
                                                                    @error('code_no')
                                                                    <div class="invalid-feedback">
                                                                        {{ $message }}
                                                                    </div>
                                                                    @enderror
                                                                </div>
                                                            </div><!-- end col -->
                                                            <div class="col-sm-3">
                                                                <div class="mb-3">
                                                                    <label class="form-label" for="name">Website URL</label>
                                                                    <input id="website_url" name="website_url" type="text" class="form-control @error('website_url') is-invalid @enderror" placeholder="Enter the website url" value="{{ old('website_url') }}">
                                                                    @error('website_url')
                                                                    <div class="invalid-feedback">
                                                                        {{ $message }}
                                                                    </div>
                                                                    @enderror
                                                                </div>
                                                            </div><!-- end col -->


                                                        </div>
                                                        <!-- end row -->
                                                        <div class="mb-3">
                                                            <label class="form-label" for="metadescription">Keywords</label>
                                                            <textarea class="form-control" id="keywords" name="keywords" rows="5" placeholder="Enter Description">{{ old('keyword') }}</textarea>
                                                        </div>

                                                        <ul class="pager wizard twitter-bs-wizard-pager-link">
                                                            <li class="float-end">
                                                                <button type="submit" class="btn btn-primary" style="background-color:red;border-color:red">Save Changes <i class="mdi mdi-arrow-right ms-1"></i></button>
                                                            </li>
                                                        </ul>
                                                    </form>


                                                    <!-- end ul -->
                                                </div>
                                                <!-- end tabpane -->
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- end row -->

                    </div>


                </div> <!-- container-fluid -->
            </div>
            <!-- End Page-content -->



            @include('partials.footer')

        </div>
        <!-- end main content-->

    </div>
    <!-- End Page-content -->



    </div>
    @include('partials.vendor-scripts')
    @include('partials.right-sidebar')


    <script src="{{ asset('assets/libs/twitter-bootstrap-wizard/jquery.bootstrap.wizard.min.js') }}"></script>

    <!-- Prettify JS -->
    <script src="{{ asset('assets/libs/twitter-bootstrap-wizard/prettify.js') }}"></script>

    <!-- Select2 Plugin JS -->
    <script src="{{ asset('assets/libs/select2/js/select2.min.js') }}"></script>

    <!-- Dropzone Plugin JS -->
    <script src="{{ asset('assets/libs/dropzone/min/dropzone.min.js') }}"></script>

    <!-- Init JS -->
    <script src="{{ asset('assets/js/pages/ecommerce-add-product.init.js') }}"></script>

    <!-- App JS -->
    <script src="{{ asset('assets/js/app.js') }}"></script>
    <script>
        $(document).ready(function() {
            // Capture the form submit event
            $("form").on("submit", function(e) {
                e.preventDefault(); // Prevent the form from submitting normally

                var formData = new FormData(this); // Get the form data

                $.ajax({
                    url: $(this).attr("action"), // Form action (the URL to which the data is sent)
                    type: $(this).attr("method"), // POST method
                    data: formData, // Send the form data
                    processData: false, // Prevent jQuery from processing the data
                    contentType: false, // Prevent jQuery from setting the content type
                    success: function(response) {
                        window.location.href = response.redirect_url;
                    },
                    error: function(xhr, status, error) {
                        // Handle the error response
                        var errors = xhr.responseJSON.errors;

                        // Clear previous error messages
                        $(".invalid-feedback").remove();

                        // Loop through the errors and display them next to the respective form fields
                        $.each(errors, function(field, messages) {
                            // Find the input field based on the field name
                            var inputField = $("input[name='" + field + "'], textarea[name='" + field + "']");

                            // Append the error message below the input field
                            inputField.addClass('is-invalid'); // Add the error class
                            inputField.after('<div class="invalid-feedback">' + messages[0] + '</div>'); // Display the first error message
                        });
                    }
                });
            });
        });
    </script>



</body>

</html>