<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\MemberController;
use App\Http\Controllers\ApiController;
use App\Http\Controllers\EventController;
use App\Http\Controllers\GalleryController;
use App\Http\Controllers\NotificationController;
use App\Http\Controllers\ExhibitorController;
use App\Http\Controllers\BannerController;
use App\Http\Controllers\BulletinController;


/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});


Route::middleware('check.static.token')->group(function () {
    Route::get('/members', [MemberController::class, 'member_view']);
    Route::get('/allmembers', [MemberController::class, 'allmembers']);
    Route::get('/searchmembers', [MemberController::class, 'search_members']);
    Route::get('/searchalphabet', [MemberController::class, 'alphabet']);
    Route::post('/enquiry', [ApiController::class, 'enquiry']);
    Route::get('/member/edit/{id}', [ApiController::class, 'editMember']);
    Route::get('/getevents', [EventController::class, 'getEvents']);
    Route::get('/getgallery', [GalleryController::class, 'gallery']);
    Route::get('/getnotification', [NotificationController::class, 'notification']);
    Route::get('/getexhibitors', [ExhibitorController::class, 'exhibitors']);
    Route::get('/getbanner', [BannerController::class, 'banner']);
    Route::get('/getAllYearsWithEvents', [BulletinController::class, 'getAllYearsWithEvents']);
    Route::get('/getEventsByDate', [BulletinController::class, 'getEventsByDate']);
    
    
});

Route::get('/profile', [ApiController::class, 'profile'])->name('profile');
Route::post('/updateProfile', [ApiController::class, 'updateProfile'])->name('updateProfile');
Route::post('/updatePassword', [ApiController::class, 'changepassword'])->name('updatePassword');
