<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\ApiController;
use App\Http\Controllers\MemberController;
use App\Http\Controllers\EventController;
use App\Http\Controllers\GalleryController;
use App\Http\Controllers\NotificationController;
use App\Http\Controllers\ExhibitorController;
use App\Http\Controllers\BannerController;
use App\Http\Controllers\BulletinController;

Route::get('/', function () {
    return view('auth/auth-login');
});

//authentication
Route::post('/login', [AuthController::class, 'login'])->name('login');
Route::get('/logout', [AuthController::class, 'logout'])
    ->middleware('auth:sanctum')
    ->name('logout');
//authentication


Route::middleware('auth:sanctum')->group(function () {

    Route::get('/dashboard', function () {
        return view('dashboard');
    })->name('dashboard');
    //members
    Route::get('/members', [MemberController::class, 'index'])->name('members.index');
    Route::get('/member', [MemberController::class, 'create'])->name('members');
    Route::post('/member/store', [MemberController::class, 'store'])->name('members.store');
    Route::get('/member/{id}/edit', [MemberController::class, 'edit'])->name('members.edit');
    Route::delete('/member/{id}', [MemberController::class, 'destroy'])->name('members.destroy');
    Route::post('/import', [MemberController::class, 'import'])->name('user.import');
    //members

    //events
    Route::get('/events', [EventController::class, 'index'])->name('event.index');
    Route::get('/add-event', [EventController::class, 'create'])->name('event');
    Route::post('/event/store', [EventController::class, 'store'])->name('event.store');
    Route::get('/event/{id}/edit', [EventController::class, 'edit'])->name('event.edit');
    Route::delete('/event/{id}', [EventController::class, 'destroy'])->name('event.destroy');
    //events

    //gallery
    Route::get('/gallery', [GalleryController::class, 'index'])->name('gallery.index');
    Route::get('/add-gallery', [GalleryController::class, 'create'])->name('gallery');
    Route::post('/gallery/store', [GalleryController::class, 'store'])->name('gallery.store');
    Route::get('/gallery/{id}/edit', [GalleryController::class, 'edit'])->name('gallery.edit');
    Route::delete('/gallery/{id}', [GalleryController::class, 'destroy'])->name('gallery.destroy');
    //gallery


    //notification
    Route::get('/notification', [NotificationController::class, 'index'])->name('notification.index');
    Route::get('/add-notification', [NotificationController::class, 'create'])->name('notification');
    Route::post('/notification/store', [NotificationController::class, 'store'])->name('notification.store');
    Route::get('/notification/{id}/edit', [NotificationController::class, 'edit'])->name('notification.edit');
    Route::delete('/notification/{id}', [NotificationController::class, 'destroy'])->name('notification.destroy');
    //notification

    //exhibitors
    Route::get('/exhibitors', [ExhibitorController::class, 'index'])->name('exhibitors.index');
    Route::get('/add-exhibitors', [ExhibitorController::class, 'create'])->name('exhibitors');
    Route::post('/exhibitors/store', [ExhibitorController::class, 'store'])->name('exhibitors.store');
    Route::get('/exhibitors/{id}/edit', [ExhibitorController::class, 'edit'])->name('exhibitors.edit');
    Route::delete('/exhibitors/{id}', [ExhibitorController::class, 'destroy'])->name('exhibitors.destroy');
    //exhibitors

    //banner
    Route::get('/banner', [BannerController::class, 'index'])->name('banner.index');
    Route::get('/add-banner', [BannerController::class, 'create'])->name('banner');
    Route::post('/banner/store', [BannerController::class, 'store'])->name('banner.store');
    Route::get('/banner/{id}/edit', [BannerController::class, 'edit'])->name('banner.edit');
    Route::delete('/banner/{id}', [BannerController::class, 'destroy'])->name('banner.destroy');
    //banner

    //bulletin
    Route::get('/bulletin', [BulletinController::class, 'index'])->name('bulletin.index');
    Route::get('/add-bulletin', [BulletinController::class, 'create'])->name('bulletin');
    Route::post('/bulletin/store', [BulletinController::class, 'store'])->name('bulletin.store');
    Route::get('/bulletin/{id}/edit', [BulletinController::class, 'edit'])->name('bulletin.edit');
    Route::delete('/bulletin/{id}', [BulletinController::class, 'destroy'])->name('bulletin.destroy');
    //bulletin
});


//profile
Route::get('/profile', [ApiController::class, 'profile'])->name('profile');
Route::post('/updateProfile', [ApiController::class, 'updateProfile'])->name('updateProfile');
Route::post('/updatePassword', [ApiController::class, 'changepassword'])->name('updatePassword');
//profile
