<!DOCTYPE html>
<html>

<head>
    <?php echo $__env->make('partials.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('partials.head-css', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('partials.title-meta', ['title' => 'Notification'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <link href="<?php echo e(asset('assets/libs/admin-resources/jquery.vectormap/jquery-jvectormap-1.2.2.css')); ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo e(asset('assets/libs/flatpickr/flatpickr.min.css')); ?>" rel="stylesheet">

    <!-- gridjs css -->
    <link href="<?php echo e(asset('assets/libs/gridjs/theme/mermaid.min.css')); ?>" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastify-js/1.12.0/toastify.min.css">

    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <style>
        .shadow-sm {
            display: flex;
            justify-content: center;
            align-items: center;
        }

        .text-sm {
            text-align: center;
        }

        .navigation {
            line-height: 40px !important;
        }
    </style>
</head>

<style>
    .card-body {
        padding: 30px !important;
    }



    .user-sidebar {
        background-color: #f14e4e !important;
    }

    .page-title-box {
        background-color: #f14e4e !important;
    }
</style>

<body>

    <div id="layout-wrapper">
        <?php echo $__env->make('partials.menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <div class="main-content">
            <div class="page-content">
                <?php echo $__env->make('partials.page-title', ['pagetitle' => 'Form', 'subtitle' => 'Codissa', 'title' => 'Notification'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <div class="container-fluid">
                    <div class="page-content-wrapper">
                        <div class="row">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-body">
                                        <!-- Add Import Form -->

                                        <form class="mb-4">
                                            <?php echo csrf_field(); ?>
                                            <div class="d-flex mb-4">
                                                <!-- Add Member -->
                                                <div>
                                                    <a href="<?php echo e(route('notification')); ?>" class="btn btn-success">
                                                        <i class="mdi mdi-plus me-2"></i> Add Notification
                                                    </a>
                                                </div>
                                                <!--Form Submit -->

                                            </div>



                                        </form>
                                        <h4 class="card-title">Notification List</h4>
                                        <div class="table-responsive">
                                            <table class="table table-centered table-nowrap">
                                                <thead>
                                                    <tr>
                                                        <th>#</th>
                                                        <th>Name</th>
                                                        <th>Image</th>
                                                        <th>Date</th>
                                                        <th>Created at</th>
                                                        <th>Updated at</th>
                                                        <th style="width: 120px;">Action</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php if($notification->count() > 0): ?>
                                                    <?php $__currentLoopData = $notification; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $event): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <tr>
                                                        <td><?php echo e($loop->iteration + ($notification->currentPage() - 1) * $notification->perPage()); ?></td>
                                                        <td><?php echo e($event->name); ?></td>
                                                        <td>
                                                            <?php if($event->image): ?>
                                                            <img src="<?php echo e(asset($event->image)); ?>" alt="<?php echo e($event->name); ?>" style="width: 100px; height: auto;">
                                                            <?php else: ?>
                                                            No Image
                                                            <?php endif; ?>
                                                        </td>
                                                        <td><?php echo e($event->date); ?></td>
                                                        <td><?php echo e($event->created_at); ?></td>
                                                        <td><?php echo e($event->updated_at); ?></td>
                                                        <td id="tooltip-container0">
                                                            <form action="<?php echo e(route('notification.edit', $event->id)); ?>" method="GET" style="display: inline;">
                                                                <button type="submit" class="btn btn-danger" data-bs-container="#tooltip-container0" data-bs-toggle="tooltip" data-bs-placement="top" title="Edit">
                                                                    Edit
                                                                </button>
                                                            </form>
                                                            <button type="button" class="btn btn-danger delete-customer btn-btn danger" data-member-id="<?php echo e($event->id); ?>">Delete</button>
                                                        </td>
                                                    </tr>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    <?php else: ?>
                                                    <tr>
                                                        <td colspan="8" class="text-center">No notification found.</td>
                                                    </tr>
                                                    <?php endif; ?>
                                                </tbody>
                                            </table>

                                            <div class="d-flex justify-content-center">
                                                <?php echo e($notification->links()); ?>

                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div> <!-- end page-content-wrapper -->
                </div>
                <!-- end container-fluid -->
            </div> <!-- end page-content -->
        </div> <!-- end main-content -->
    </div>
    <?php echo $__env->make('partials.vendor-scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/sweetalert/2.1.2/sweetalert.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastify-js/1.12.0/toastify.min.js"></script>

    <script>
        $(document).ready(function() {
            // Attach a click event handler to the delete button
            $('.delete-customer').click(function() {
                // Store a reference to the current button
                var button = $(this);
                var memberId = button.data('member-id');

                // Display SweetAlert confirmation dialog
                swal({
                    title: "Are you sure?",
                    text: "Once deleted, you will not be able to recover this member!",
                    icon: "warning",
                    buttons: true,
                    dangerMode: true,
                }).then((willDelete) => {
                    if (willDelete) {
                        // Fetch the CSRF token
                        var csrfToken = $('meta[name="csrf-token"]').attr('content');

                        // Make the AJAX request
                        $.ajax({
                            url: '/notification/' + memberId, // URL to your Laravel route
                            method: 'DELETE', // Correct HTTP method for deletion
                            data: {
                                _token: csrfToken // Include CSRF token for Laravel
                            },

                            success: function(response) {
                                Toastify({
                                    text: "Notification deleted successfully!",
                                    duration: 3000, // Duration in milliseconds
                                    close: true, // Show close button
                                    gravity: "top", // Position (top or bottom)
                                    position: "right", // Position (left, center, right)
                                    backgroundColor: "linear-gradient(to right, #00b09b, #96c93d)" // Custom background color
                                }).showToast();
                                setTimeout(function() {
                                    window.location.reload();
                                }, 1000);

                            },
                            error: function(xhr, status, error) {
                                console.error('Error deleting member:', error);
                                Swal.fire(
                                    'Error!',
                                    'Failed to delete event.',
                                    'error'
                                );
                            }
                        });
                    } else {
                        // If user cancels deletion, do nothing
                        swal("event deletion cancelled!");
                    }
                });
            });
        });
    </script>


</body>

</html><?php /**PATH C:\xampp\htdocs\codissa\resources\views/layouts/notification/index.blade.php ENDPATH**/ ?>