<?php
 
/*
 * DataTables example server-side processing script.
 *
 * Please note that this script is intentionally extremely simply to show how
 * server-side processing can be implemented, and probably shouldn't be used as
 * the basis for a large complex system. It is suitable for simple use cases as
 * for learning.
 *
 * See http://datatables.net/usage/server-side for full details on the server-
 * side processing requirements of DataTables.
 *
 * @license MIT - http://datatables.net/license_mit
 */
 
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
 
// DB table to use
$table = 'order_item';
 
// Table's primary key
$primaryKey = 'id';
 
// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case simple
// indexes
$columns = array(
    array( 'db' => 'id', 'dt' => 0 ),
     array( 'db' => 'product_name', 'dt' => 1 ),
     array( 'db' => 'vendor_type',  'dt' => 2 ),
    array( 'db' => 'gift_option',  'dt' => 3 ),
    array( 'db' => 'order_item_status',  'dt' => 4 ),
    array( 'db' => 'created_at','dt' => 5,
        'formatter' => function( $d, $row ) {
            return date( 'd-m-Y', strtotime($d));
        }
    ),
    array( 'db' => 'id', 'dt' => 6 ,
        'formatter' => function( $d, $row ) {
             return '<a href="orderItemView.php?editid='.$d.'" class="btn btn-success btn-sm mr-2">Edit</a>';
    }),
    array( 'db' => 'order_id', 'dt' => 7 ,
        'formatter' => function( $d, $row ) {
             return '<a href="orderView.php?editid='.$d.'" class="btn btn-warning btn-sm mr-2">View</a>';
    })
   
);
 
// SQL server connection information
$sql_details = array(
   'user' => 'countryish_clouddreams',
    'pass' => 'Cloud@2021',
    'db'   => 'countryish_database',
    'host' => 'localhost'
);
 
 
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
 
include 'ssp.class.php';

$where = "orderitem_payment_status ='success'";
 
echo json_encode(
    SSP::complex( $_GET, $sql_details, $table, $primaryKey, $columns, $where)
);
die();