<!DOCTYPE html>
<html lang="zxx">
<?php include 'includes/head.php'; ?>
<meta http-equiv="content-type" content="text/html;charset=UTF-8" />

<body>
    <?php include 'includes/header.php'; ?>
    <!--====== Start Hero Section ======-->

    <!--====== Start Breadcrumb Section ======-->
    <section class="page-banner overlay pt-100 pb-100 bg_cover" style="background-image: url(assets/images/bg/page-bg.jpg);">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-10">
                    <!--=== Page Banner Content ===-->
                    <div class="page-banner-content text-center text-white">
                        <h1 class="page-title">About Company</h1>
                        <ul class="breadcrumb-link text-white">
                            <li><a href="index.php">Home</a></li>
                            <li class="active">About Company</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </section><!--====== End Breadcrumb Section ======--> <!--====== Start About Section ======-->
    <section class="about-section pt-120 pb-25">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="section-title mb-55 wow fadeInUp">
                        <span class="sub-title">About KAAPAN Financial Services</span>
                        <h2>Simplifying Insurance for a Secure Future with 25+ Years of Experience</h2>
                    </div>
                </div>
            </div>
            <div class="row align-items-center">
                <div class="col-xl-4">
                    <div class="fancy-icon-box-three mb-40 wow fadeInUp" data-wow-delay="0.1s">
                        <div class="icon">
                            <img src="assets/images/icon/icon-18.png" alt="Company Mission Icon">
                        </div>
                        <div class="content">
                            <h4>Our Mission</h4>
                            <p>To make insurance simple, transparent, and accessible for individuals and families across India.</p>
                        </div>
                    </div>
                    <div class="fancy-icon-box-three mb-40 wow fadeInUp" data-wow-delay="0.3s">
                        <div class="icon">
                            <img src="assets/images/icon/icon-19.png" alt="Vision & Goal Icon">
                        </div>
                        <div class="content">
                            <h4>Our Vision & Goals</h4>
                            <p>To be the trusted partner in securing your financial future through reliable and affordable insurance solutions.</p>
                        </div>
                    </div>
                    <div class="fancy-icon-box-three mb-40 wow fadeInUp" data-wow-delay="0.5s">
                        <div class="icon">
                            <img src="assets/images/icon/icon-20.png" alt="Dedicated Teams Icon">
                        </div>
                        <div class="content">
                            <h4>Dedicated & Experienced Teams</h4>
                            <p>Our IRDAI-certified professionals are committed to helping you find the right coverage with personalized service.</p>
                        </div>
                    </div>
                </div>
                <div class="col-xl-8">
                    <div class="about-image mb-45 wow fadeInRight">
                        <img src="assets/images/about/about-3.jpg" alt="About KAAPAN Financial Services">
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-12">
                    <p class="wow fadeInUp" data-wow-delay="0.7s">At **KAAPAN Financial Services**, we believe everyone deserves access to clear, reliable, and affordable insurance solutions. Established as an **IRDAI-certified company**, our mission is to make insurance simple, transparent, and accessible for individuals and families across India.</p>
                    <p class="wow fadeInUp" data-wow-delay="0.9s">With **years of experience** in the insurance industry, we have built our reputation on **trust, integrity, and personalized service**. Our team of dedicated professionals is committed to helping you find the right coverage—whether you’re seeking protection for your family, your business, or planning for the future.</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Features -->

  <section class="about-section pt-70 pb-25">
          <div class="container">
 <div class="row g-4">
    
  <!-- Card 1 -->
  <div class="col-lg-4 col-md-6">
    <div class="xinsurance-card position-relative text-white p-4 rounded-4">
      <div class="xcard-icon-top d-flex justify-content-between align-items-start">
         <div class="glass-text px-3 py-1 rounded">
          <i class="fas fa-shield-alt fs-4"></i> <span>Kaapan Financial Services</span>
        </div>
      
      </div>
      <h4 class="fw-700 mt-3 mb-2">Are You Really Covered When It Matters?</h4>
      <p>Discover true peace of mind with KAAPAN’s comprehensive coverage options.</p>
    </div>
  </div>

  <!-- Card 2 -->
  <div class="col-lg-4 col-md-6">
    <div class="xinsurance-card position-relative text-white p-4 rounded-4">
      <div class="xcard-icon-top d-flex justify-content-between align-items-start">
       <div class="glass-text px-3 py-1 rounded">
          <i class="fas fa-notes-medical fs-4"></i> <span>Kaapan Financial Services</span>
        </div>
       
      </div>
      <h4 class="fw-700 mt-3 mb-2">Is Insurance Easier Than You Think?</h4>
      <p>Experience simplicity with clear, hassle-free insurance plans.</p>
    </div>
  </div>

  <!-- Card 3 -->
  <div class="col-lg-4 col-md-6">
    <div class="xinsurance-card position-relative text-white p-4 rounded-4">
     <div class="xcard-icon-top d-flex justify-content-between align-items-start">
  <div class="glass-text px-3 py-1 rounded">
    <i class="fas fa-car-crash fs-4 me-2"></i> 
    <span>Kaapan Financial Services</span>
  </div>
</div>

      <h4 class="fw-700 mt-3 mb-2">Why Pay More for Less?</h4>
      <p>Affordable plans, tailored for your needs and budget.</p>
    </div>
  </div>

</div>

</div>

    </section>



    <!-- Countup -->
 <section class="xrating-section">
  <div class="container">
    <div class="row align-items-center gy-5">
      <!-- Left Content -->
      <div class="col-lg-7">
        <h2>Highest rated insurance company</h2>
        <div class="xrating-stars">
          ★ ★ ★ ★ ★
          <div class="text-muted small mt-2">Rated by over 5000 customer <a href="#" class="xreview-link">View all Review</a></div>
        </div>
        <div class="xtrust-score mt-2">Trust Score rated 4.3/5</div>

        <!-- Info Cards -->
        <div class="row xrating-cards mt-4">
          <div class="col-md-6 mb-3 mb-md-0">
            <div class="xrating-card-box text-center">
            <h3><span id="insuranceCount">0</span><br><span class="fs-5 fw-normal">Insurance</span></h3>
              <p>We’ll explain all your coverage options and explore</p>
            </div>
          </div>
          <div class="col-md-6">
            <div class="xrating-card-box text-center">
             <h3><span id="teamCount">0</span><br><span class="fs-5 fw-normal">Team</span></h3>
              <p>We’ll explain all your coverage options and explore</p>
            </div>
          </div>
        </div>
      </div>

      <!-- Right Image -->
      <div class="col-lg-5 text-center">
        <img cl src="assets/images/about/business-merger.png" alt="Happy Customer" class="xrating-image img-fluid" />
      </div>
    </div>
  </div>
</section>



    </div><!-- /.page-wrapper -->



    <!--====== Search From ======--><!--====== Back To Top  ======-->
    <?php include 'includes/footer.php'; ?>
    <?php include 'includes/script.php'; ?>
</body>

<script>
     document.addEventListener("DOMContentLoaded", function () {
    const insuranceCount = new countUp.CountUp("insuranceCount", 30, {
      duration: 2,
      suffix: "+"
    });

    const teamCount = new countUp.CountUp("teamCount", 40, {
      duration: 2,
      suffix: "+"
    });

    // Only start animation if the elements are visible
    function isInViewport(el) {
      const rect = el.getBoundingClientRect();
      return (
        rect.top >= 0 &&
        rect.left >= 0 &&
        rect.bottom <= (window.innerHeight || document.documentElement.clientHeight) &&
        rect.right <= (window.innerWidth || document.documentElement.clientWidth)
      );
    }

    function runCountUpIfVisible() {
      if (isInViewport(document.getElementById("insuranceCount"))) {
        insuranceCount.start();
        teamCount.start();
        window.removeEventListener("scroll", runCountUpIfVisible);
      }
    }

    window.addEventListener("scroll", runCountUpIfVisible);
    runCountUpIfVisible(); // Check on load too
  });
</script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/countup.js/2.6.2/countUp.umd.js"></script>

</html>