const faqData = {
    lifeInsurance: [
      {
        question: "Why prefer Kaapan?",
        answer: "Kaapan Financial Services Company stands out for its commitment to providing customer-focused life insurance solutions..."
      },
      {
        question: "Why Choose Kaapan?",
        answer: "Kaapan Financial Services is committed to making life insurance simple, efficient, and trustworthy..."
      },
      {
        question: "What is Life Insurance?",
        answer: "Life insurance with Kaapan is a financial agreement where you pay regular premiums..."
      },
      {
        question: "Who Should Buy Life Insurance?",
        answer: "Kaapan recommends life insurance for anyone who wants to protect their family’s financial future..."
      },
      {
        question: "What Are the Factors Influencing Life Insurance Premiums?",
        answer: "At Kaapan, your premium depends on several factors, such as your age, health status, lifestyle habits..."
      },
      {
        question: "What Are the Benefits of Life Insurance?",
        answer: "Choosing Kaapan life insurance provides financial security, tax benefits, and peace of mind..."
      }
    ],
    motorInsurance: [
      {
        question: "Why prefer Kaapan for Motor Insurance?",
        answer: "Kaapan offers motor insurance with quick claims, extensive garage networks, and 24x7 assistance..."
      },
      {
        question: "What is Covered in Motor Insurance?",
        answer: "Covers accidents, theft, natural disasters, third-party liabilities and more depending on your policy type."
      }
    ],
    premiumInsurance: [
      {
        question: "How is Premium Calculated?",
        answer: "Premium depends on sum assured, policy term, age, health, and selected riders."
      },
      {
        question: "Can I Change My Premium Plan Later?",
        answer: "Yes, Kaapan offers flexibility to upgrade or modify plans as per your evolving needs."
      }
    ]
  };

  const tabItems = document.querySelectorAll(".tab-item");
  const faqContainer = document.getElementById("faqContent");

  function renderFAQs(type) {
    const faqs = faqData[type];
    if (!faqs) return;

    let html = '<div class="accordion" id="accordionFaq">';
    faqs.forEach((faq, index) => {
      html += `
        <div class="accordion-card mb-25">
          <div class="accordion-header">
            <h6 class="accordion-title ${index !== 0 ? 'collapsed' : ''}" 
                data-bs-toggle="collapse" 
                data-bs-target="#collapse${type}${index}" 
                aria-expanded="${index === 0}">
              <span class="number">${index + 1}.</span> ${faq.question}
            </h6>
          </div>
          <div id="collapse${type}${index}" 
               class="accordion-collapse collapse ${index === 0 ? 'show' : ''}" 
               data-bs-parent="#accordionFaq">
            <div class="accordion-body">
              <p>${faq.answer}</p>
            </div>
          </div>
        </div>`;
    });
    html += '</div>';
    faqContainer.innerHTML = html;
  }

  tabItems.forEach(tab => {
    tab.addEventListener("click", () => {
      // Remove active class
      tabItems.forEach(item => item.classList.remove("active"));
      tab.classList.add("active");

      // Get target
      const target = tab.getAttribute("data-target");
      renderFAQs(target);
    });
  });

  // Initialize default
  renderFAQs("lifeInsurance");