/*-----------------------------------------------------------------------------------
    
    Template Name: Surancy - Insurance Agency Figma Template
    Template URI: site.com
    Description: Surancy is a creative & unique HTML template specifically created for insurance, car insurance, health insurance, life insurance and all insurance company related any business website.
    Author: WebTend 
    Author URI: https://webtend.net/
    Version: 1.0

    Note: This is Main Js file
-----------------------------------------------------------------------------------
    Js INDEX
    ===================
    ## Main Menu
    ## Document Ready
    ## Nav Overlay
    ## Preloader
    ## Sticky
    ## Back to top
    ## Counter
    ## Magnific-popup js
    ## Nice select
    ## Slick Slider
    ## WOW Js
    
-----------------------------------------------------------------------------------*/

(function ($) {
  "use strict";

  //===== Main Menu
  function mainMenu() {
    // Variables
    var var_window = $(window),
      navContainer = $(".header-navigation"),
      navbarToggler = $(".navbar-toggler"),
      navMenu = $(".nav-menu"),
      navMenuLi = $(".nav-menu ul li ul li"),
      closeIcon = $(".navbar-close");

    // navbar toggler
    navbarToggler.on("click", function () {
      navbarToggler.toggleClass("active");
      navMenu.toggleClass("menu-on");
    });

    // close icon
    closeIcon.on("click", function () {
      navMenu.removeClass("menu-on");
      navbarToggler.removeClass("active");
    });

    // adds toggle button to li items that have children
    navMenu.find("li a").each(function () {
      if ($(this).children(".dd-trigger").length < 1) {
        if ($(this).next().length > 0) {
          $(this).append(
            '<span class="dd-trigger"><i class="far fa-angle-down"></i></span>'
          );
        }
      }
    });

    // expands the dropdown menu on each click
    navMenu.find(".dd-trigger").on("click", function (e) {
      e.preventDefault();
      $(this).parent().parent().siblings().children("ul.sub-menu").slideUp();
      $(this).parent().next("ul.sub-menu").stop(!0, !0).slideToggle(350);
      $(this).toggleClass("sub-menu-open");
    });

    // check browser width in real-time
    function breakpointCheck() {
      var windowWidth = window.innerWidth;
      if (windowWidth <= 991) {
        navContainer.addClass("breakpoint-on");
      } else {
        navContainer.removeClass("breakpoint-on");
      }
    }
    breakpointCheck();
    var_window.on("resize", function () {
      breakpointCheck();
    });
  }

  // Document Ready
  $(document).ready(function () {
    mainMenu();
  });
  document.addEventListener("DOMContentLoaded", () => {
    const sliderTrack = document.querySelector(".slider-track");
    if (!sliderTrack) return;

    // Duplicate images for infinite loop effect if not already duplicated in HTML
    // (If you've manually duplicated in HTML, this block can be removed or modified)
    const images = Array.from(sliderTrack.children);
    images.forEach((img) => {
      const clone = img.cloneNode(true);
      sliderTrack.appendChild(clone);
    });

    // Calculate the total width of the original set of images
    let totalWidth = 0;
    for (let i = 0; i < images.length; i++) {
      totalWidth += images[i].offsetWidth;
    }

    // Set a CSS variable for the animation to use
    // This allows you to dynamically adjust the animation based on content
    sliderTrack.style.setProperty("--slider-width", `-${totalWidth}px`);

    // The animation keyframes in CSS would then use this variable:
    /*
    @keyframes smoothLoopSlider {
        0% { transform: translateX(0); }
        100% { transform: var(--slider-width); }
    }
    */
    // For the current setup with 50% translation, this JS is not strictly necessary for the animation,
    // but it's useful for making sure the image duplication is handled correctly and sizes are accurate.
  });

  const tabItems = document.querySelectorAll(".tab-item");
  const contentBoxes = document.querySelectorAll(".faq-content-box");

  tabItems.forEach((tab) => {
    tab.addEventListener("click", () => {
      // Remove active class
      tabItems.forEach((t) => t.classList.remove("active"));
      contentBoxes.forEach((c) => c.classList.add("d-none"));

      // Activate selected tab and content
      tab.classList.add("active");
      document
        .getElementById(tab.dataset.target + "Box")
        .classList.remove("d-none");
    });
  });

  // Nav Overlay On

  $(".navbar-toggler, .navbar-close,.nav-overlay").on("click", function (e) {
    $(".nav-overlay").toggleClass("active");
  });
  $(".nav-overlay").on("click", function (e) {
    $(".navbar-toggler").removeClass("active");
    $(".nav-menu").removeClass("menu-on");
  });

  // Panel Widget

  var panelIcon = $(".bar-item"),
    panelClose = $(".panel-close,.panel-overlay"),
    panelWrap = $(".offcanvas-panel");
  panelIcon.on("click", function (e) {
    panelWrap.toggleClass("panel-on");
    e.preventDefault();
  });
  panelClose.on("click", function (e) {
    panelWrap.removeClass("panel-on");
    e.preventDefault();
  });

  //===== Preloader

  $(window).on("load", function (event) {
    $(".preloader").delay(500).fadeOut("500");
  });

  //===== Sticky

  $(window).on("scroll", function (event) {
    var scroll = $(window).scrollTop();
    if (scroll < 100) {
      $(".header-navigation").removeClass("sticky");
    } else {
      $(".header-navigation").addClass("sticky");
    }
  });

  //===== Back to top

  $(window).on("scroll", function (event) {
    if ($(this).scrollTop() > 600) {
      $(".back-to-top").fadeIn(200);
    } else {
      $(".back-to-top").fadeOut(200);
    }
  });
  $(".back-to-top").on("click", function (event) {
    event.preventDefault();
    $("html, body").animate(
      {
        scrollTop: 0,
      },
      1500
    );
  });

  //===== Counter js

  if ($(".count").length) {
    $(".count").counterUp({
      delay: 100,
      time: 4000,
    });
  }

  //===== Magnific-popup js

  if ($(".video-popup").length) {
    $(".video-popup").magnificPopup({
      type: "iframe",
      removalDelay: 300,
      mainClass: "mfp-fade",
    });
  }

  if ($(".img-popup").length) {
    $(".img-popup").magnificPopup({
      type: "image",
      gallery: {
        enabled: true,
      },
    });
  }

  //===== Nice select js

  if ($("select").length) {
    $("select").niceSelect();
  }

  //===== Slick slider js

  $(".hero-slider-one").on("init", function (e, slick) {
    var $firstAnimatingElements = $("div.single-slider:first-child").find(
      "[data-animation]"
    );
    doAnimations($firstAnimatingElements);
  });
  $(".hero-slider-one").on(
    "beforeChange",
    function (e, slick, currentSlide, nextSlide) {
      var $animatingElements = $(
        'div.single-slider[data-slick-index="' + nextSlide + '"]'
      ).find("[data-animation]");
      doAnimations($animatingElements);
    }
  );
  function doAnimations(elements) {
    var animationEndEvents =
      "webkitAnimationEnd mozAnimationEnd MSAnimationEnd oanimationend animationend";
    elements.each(function () {
      var $this = $(this);
      var $animationDelay = $this.data("delay");
      var $animationType = "animated " + $this.data("animation");
      $this.css({
        "animation-delay": $animationDelay,
        "-webkit-animation-delay": $animationDelay,
      });
      $this.addClass($animationType).one(animationEndEvents, function () {
        $this.removeClass($animationType);
      });
    });
  }
  if ($(".hero-slider-one").length) {
    $(".hero-slider-one").slick({
      dots: false,
      arrows: false,
      infinite: true,
      speed: 800,
      fade: true,
      cssEase: "cubic-bezier(0.7, 0, 0.3, 1)",
      autoplay: true,
      slidesToShow: 1,
      slidesToScroll: 1,
      prevArrow: '<div class="prev"><i class="far fa-arrow-left"></i></div>',
      nextArrow: '<div class="next"><i class="far fa-arrow-right"></i></div>',
      responsive: [
        {
          breakpoint: 1024,
          settings: {
            arrows: false,
          },
        },
      ],
    });
  }
  if ($(".slider-active-4-item").length) {
    $(".slider-active-4-item").slick({
      dots: false,
      arrows: false,
      infinite: true,
      speed: 800,
      autoplay: true,
      slidesToShow: 4,
      slidesToScroll: 1,
      prevArrow: '<div class="prev"><i class="far fa-angle-left"></i></div>',
      nextArrow: '<div class="next"><i class="far fa-angle-right"></i></div>',
      responsive: [
        {
          breakpoint: 1400,
          settings: {
            slidesToShow: 3,
          },
        },
        {
          breakpoint: 1200,
          settings: {
            slidesToShow: 2,
          },
        },
        {
          breakpoint: 575,
          settings: {
            slidesToShow: 1,
          },
        },
      ],
    });
  }
  if ($(".slider-active-5-item").length) {
    $(".slider-active-5-item").slick({
      dots: false,
      arrows: false,
      infinite: true,
      speed: 800,
      autoplay: true,
      slidesToShow: 5,
      slidesToScroll: 1,
      prevArrow: '<div class="prev"><i class="far fa-arrow-left"></i></div>',
      nextArrow: '<div class="next"><i class="far fa-arrow-right"></i></div>',
      responsive: [
        {
          breakpoint: 1400,
          settings: {
            slidesToShow: 4,
          },
        },
        {
          breakpoint: 1199,
          settings: {
            slidesToShow: 3,
          },
        },
        {
          breakpoint: 991,
          settings: {
            slidesToShow: 2,
          },
        },
        {
          breakpoint: 575,
          settings: {
            slidesToShow: 1,
          },
        },
      ],
    });
  }
  if ($(".testimonial-slider-one").length) {
    $(".testimonial-slider-one").slick({
      dots: true,
      arrows: false,
      infinite: true,
      speed: 800,
      autoplay: false,
      slidesToShow: 2,
      slidesToScroll: 1,
      prevArrow: '<div class="prev"><i class="far fa-arrow-left"></i></div>',
      nextArrow: '<div class="next"><i class="far fa-arrow-right"></i></div>',
      responsive: [
        {
          breakpoint: 1200,
          settings: {
            slidesToShow: 1,
          },
        },
      ],
    });
  }
  if ($(".testimonial-slider-two").length) {
    $(".testimonial-slider-two").slick({
      dots: false,
      arrows: false,
      infinite: true,
      speed: 800,
      autoplay: false,
      slidesToShow: 1,
      slidesToScroll: 1,
      prevArrow: '<div class="prev"><i class="far fa-arrow-left"></i></div>',
      nextArrow: '<div class="next"><i class="far fa-arrow-right"></i></div>',
    });
  }
  if ($(".testimonial-slider-three").length) {
    var sliderArrows = $(".testimonial-arrows");
    $(".testimonial-slider-three").slick({
      dots: false,
      arrows: true,
      infinite: true,
      speed: 800,
      appendArrows: sliderArrows,
      autoplay: false,
      slidesToShow: 1,
      slidesToScroll: 1,
      nextArrow: '<div class="next"><i class="far fa-arrow-right"></i></div>',
      prevArrow: '<div class="prev"><i class="far fa-arrow-left"></i></div>',
    });
  }
  if ($(".partner-slider-one").length) {
    $(".partner-slider-one").slick({
      dots: false,
      arrows: false,
      infinite: true,
      speed: 800,
      autoplay: true,
      slidesToShow: 5,
      slidesToScroll: 1,
      prevArrow: '<div class="prev"><i class="far fa-angle-left"></i></div>',
      nextArrow: '<div class="next"><i class="far fa-angle-right"></i></div>',
      responsive: [
        {
          breakpoint: 1400,
          settings: {
            slidesToShow: 4,
          },
        },
        {
          breakpoint: 991,
          settings: {
            slidesToShow: 3,
          },
        },
        {
          breakpoint: 800,
          settings: {
            slidesToShow: 3,
          },
        },
        {
          breakpoint: 575,
          settings: {
            slidesToShow: 1,
          },
        },
      ],
    });
  }

  // Support Logos Slider

  const supportLogos = [
    "icici.png",
    "max-life-insurance-logo.png",
    "HDFC_Life_Logo.svg.png",
    "Life_Insurance_Corporation_of_India_(logo).svg.png",
    "sbi_life_insurance-logo_brandlogos.net_st8mb.png",
    "tata-a-i-a-life-insurance-logo-lm6ng8yut7lwyacg-lm6ng8yut7lwyacg.png",
    "HDFC-Ergo-logo.png",
    "Star_Health_and_Allied_Insurance.svg.png",
    "Niva.png",
    "Liberty_Insurance.png",
    "ICICIPrudentialLifeInsurancejp-1542860734947.png",
    "reliance-general-insurance3594.logowik.com.png",
    "TATA_AIG_logo.png",
    "shriram.png",
    "Aditya-birla.png",
    "bharti-axa_owler_20200630_223719_original.png",
    "United_India_Insurance.svg.png",
    "National-Insurance-Process-in-Kolkata.png",
    "Iffco-tokio.png",
    "digit.png",
    "sbi.png",
    "nialogo-org.png",
    "oriental-insurance.png",
    "policybaazar.svg",
  ];

  const sliderTrack = document.getElementById("supportSlider");

  // Loop twice for infinite effect
  for (let i = 0; i < 2; i++) {
    supportLogos.forEach((filename) => {
      const img = document.createElement("img");
      img.src = `./assets/images/support_logo/${filename}`;
      img.alt = "Support 1";
      sliderTrack.appendChild(img);
    });
  }

    // Support Logos Slider

    // Support Logos

    const supportLogoinsurance = [
    "icici.png",
    "max-life-insurance-logo.png",
    "HDFC_Life_Logo.svg.png",
    "Life_Insurance_Corporation_of_India_(logo).svg.png",
    "sbi_life_insurance-logo_brandlogos.net_st8mb.png",
    "tata-a-i-a-life-insurance-logo-lm6ng8yut7lwyacg-lm6ng8yut7lwyacg.png",
    "HDFC-Ergo-logo.png",
    "Star_Health_and_Allied_Insurance.svg.png",
    "Niva.png",
    "Liberty_Insurance.png",
    "ICICIPrudentialLifeInsurancejp-1542860734947.png",
    "reliance-general-insurance3594.logowik.com.png",
    "TATA_AIG_logo.png",
    "shriram.png",
    "Aditya-birla.png",
    "bharti-axa_owler_20200630_223719_original.png",
    "United_India_Insurance.svg.png",
    "National-Insurance-Process-in-Kolkata.png",
    "Iffco-tokio.png",
    "digit.png",
    "sbi.png",
    "nialogo-org.png",
    "oriental-insurance.png",
        "policybaazar.svg",
  ];

  const supportGrid = document.getElementById("supportGrid");

  supportLogoinsurance.forEach(filename => {
    const div = document.createElement("div");
    div.className = "support-item";
    div.innerHTML = `<img src="./assets/images/support_logo/${filename}" alt="Support 1">`;
    supportGrid.appendChild(div);
  });


    // Insurance Slider

     const insuranceItems = [
    {
      icon: "lifeinsurance.png",
      label: "Life Insurance"
    },
    {
      icon: "healthinsurance.png",
      label: "Health Insurance"
    },
    {
      icon: "carinsurance.png",
      label: "Car Insurance"
    },
    {
      icon: "emplyeegroup.png",
      label: "Employee Group Health Insurance"
    },
    {
      icon: "travelinsurance.png",
      label: "Travel Insurance"
    },
    {
      icon: "officeinsurance.png",
      label: "Office / Home Insurance"
    }
  ];

  const insuranceGrid = document.getElementById("insuranceGrid");

  insuranceItems.forEach(item => {
    const div = document.createElement("div");
    div.className = "insurance-item";
    div.innerHTML = `
      <div class="icon-circle">
        <img src="./assets/images/vector/${item.icon}" alt="${item.label}" />
      </div>
      <div class="label">
        <h6>${item.label}</h6>
      </div>
    `;
    insuranceGrid.appendChild(div);
  });

//   Insurance Slider





  // Testimonails
  document.addEventListener("DOMContentLoaded", function () {
    const testimonialSwiper = new Swiper(".testimonial-swiper-main", {
      // Optional parameters
      direction: "horizontal",
      loop: true, // Enable infinite looping

      // Autoplay (optional, adjust as needed)
      autoplay: {
        delay: 4500, // Time between slides in ms
        disableOnInteraction: false, // Continue autoplay after user interaction
        pauseOnMouseEnter: true, // Pause autoplay on hover
      },

      // Space between slides
      spaceBetween: 30, // Default space

      // Number of slides per view
      slidesPerView: 1, // Always show 1 slide for testimonials

      // Navigation arrows
      navigation: {
        nextEl: ".testimonial-swiper-button-next",
        prevEl: ".testimonial-swiper-button-prev",
      },

      // Lazy loading for images
      lazy: {
        loadOnTransitionStart: true,
        loadPrevNext: true, // Load images of next/prev slides
        loadPrevNextAmount: 1, // How many slides to load in advance
      },

      // Responsive breakpoints are not strictly necessary for slidesPerView: 1
      // but included for completeness if you decide to change it later.
      breakpoints: {
        // When window width is >= 768px, keep 1 slide, but adjust spacing if needed
        768: {
          spaceBetween: 40,
        },
        // When window width is >= 992px, still 1 slide, maybe more space
        992: {
          spaceBetween: 50,
        },
      },

      // Optional: Pagination (dots)
      // pagination: {
      //     el: '.testimonial-swiper-pagination',
      //     clickable: true,
      // },
    });
  });
  // Popular Insurance Swiper
  document.addEventListener("DOMContentLoaded", function () {
    const popularInsuranceSwiper = new Swiper(
      ".popular-insurance-swiper-main",
      {
        // Optional parameters
        direction: "horizontal",
        loop: true, // Enable infinite looping

        // Autoplay
        autoplay: {
          delay: 3500, // Time between slides in ms
          disableOnInteraction: false, // Continue autoplay after user interaction
          pauseOnMouseEnter: true, // Pause autoplay on hover
        },

        // Space between slides
        spaceBetween: 30, // Default space between slides

        // Number of slides per view
        slidesPerView: 1, // Default for mobile

        // Responsive breakpoints
        breakpoints: {
          // when window width is >= 640px
          640: {
            slidesPerView: 2,
            spaceBetween: 20,
          },
          // when window width is >= 768px
          768: {
            slidesPerView: 2,
            spaceBetween: 30,
          },
          // when window width is >= 1024px
          1024: {
            slidesPerView: 3,
            spaceBetween: 30,
          },
          // when window width is >= 1200px (or your max-width)
          1200: {
            slidesPerView: 3,
            spaceBetween: 40, // More space for larger screens
          },
        },

        // Navigation arrows
        navigation: {
          nextEl: ".popular-insurance-swiper-button-next",
          prevEl: ".popular-insurance-swiper-button-prev",
        },

        // Lazy loading for images
        lazy: {
          loadOnTransitionStart: true,
          loadPrevNext: true, // Load images of next/prev slides
          loadPrevNextAmount: 2, // How many slides to load in advance
        },

        // Optional: Pagination (dots)
        // pagination: {
        //     el: '.popular-insurance-swiper-pagination',
        //     clickable: true,
        // },

        // Optional: Scrollbar
        // scrollbar: {
        //     el: '.popular-insurance-swiper-scrollbar',
        //     hide: true,
        // },
      }
    );
  });

  //====== Isotope js

  if ($(".portfolio-active").length) {
    $(".portfolio-active").imagesLoaded(function () {
      $(".filter-btn li").on("click", function () {
        $(this).siblings(".active").removeClass("active");
        $(this).addClass("active");
        var filterValue = $(this).attr("data-filter");
        $grid.isotope({
          filter: filterValue,
        });
      });
      var $grid = $(".portfolio-active").isotope({
        itemSelector: ".item",
        layoutMode: "fitRows",
      });
    });
  }

  //===== Wow js

  new WOW().init();
})(window.jQuery);
