<!DOCTYPE html>
<html lang="zxx">
<meta http-equiv="content-type" content="text/html;charset=UTF-8" />
<?php include 'includes/head.php'; ?>

<body>
  <?php include 'includes/header.php'; ?>
  <section class="hero-section">
    <div class="hero-bg">
      <img src="./assets/images/hero/hero-bg.png" alt="" srcset="">
    </div>
    <!--=== Hero Wrapper ===-->
    <div class="hero-wrapper-one">
      <div class="container">
        <div class="row align-items-center">
          <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12">
            <!--=== Hero Image ===-->
            <div class="hero-one-image wow fadeInRight" data-wow-delay=".8s">
              <img src="assets/images/hero/hero-one_img-1.png" alt="Hero Image">
            </div>
          </div>
          <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12">
            <div class="hero-content text-end">
              <span class="tag-line wow fadeInDown" data-wow-delay=".3s">GET INSURANCE</span>
              <h1 class="wow fadeInUp" data-wow-delay=".5s">FOR YOUR BETTER FUTURE</h1>

              <div class="award-box wow fadeInUp text-end" data-wow-delay=".8s">
                <p>an arrangement with a company in which you pay them regular amounts of money and they agree to pay the costs if, for example, you die or are ill, or if you lose or damage something.
                </p>
                <div class="hero-button mb-40 wow fadeInDown" data-wow-delay=".7s">


                </div>
                <div>
                  <a href="services.html" class="btn-readmore">READ MORE</a>
                </div>
              </div>
            </div>
          </div>

        </div>
      </div>
    </div>
  </section><!--====== End Hero Section  ======--><!--====== Start About Section  ======-->
  <!-- LOGOS -->
  <section class="wow fadeInDown" data-wow-delay=".7s">
    <div class="smooth-slider-wrapper">
      <div class="slider-track" id="supportSlider"></div>
    </div>
  </section>
  <!-- LOGOS -->
  <section class="services-section pt-120 ">
    <div class="container">
      <div class="row justify-content-center">
        <div class="col-lg-8">
          <!--=== Section Title ===-->
          <div class="section-title text-center mb-80 wow fadeInDown">

            <h2>Kaapan Insurance Products</h2>
            <p>Select a product below to browse or get a quote online.</p>
          </div>
        </div>
      </div>
      <div class="row">
        <div class="insurance-grid wow fadeInDown" id="insuranceGrid">

        </div>

        <!-- See Products -->
        <div class="text-center mt-5 wow fadeInDown">

          <a class="btn-readmore" href="http://">See all our products</a>
        </div>

      </div>
    </div>

  </section><!--====== End Services Section  ======--><!--=== Start Animate Headline ===-->


  <!-- Features -->
  <section class="features-section pt-120 wow fadeInDown ">
    <div class="illustration-left">
      <img src="./assets/images/cta/left-icons.png" class="img-fluid" alt="" srcset="">
    </div>
    <div class="illustration-right">
      <img src="./assets/images/cta/right-icons.png" class="img-fluid" alt="" srcset="">
    </div>
    <div class="container">
      <div class="row align-items-center">
        <!-- Left Section -->
        <div class="col-lg-6 text-center text-lg-start mb-5 mb-lg-0">
          <img src="assets/images/cta/illustration.png" alt="Agents" class="img-fluid mb-4 agent-illustration">
          <h2 class="fw-bold">Become An Agent</h2>
          <h5 class="text-secondary mb-3">IC38 Passed? We’ve Got The Perfect Job For You.</h5>
          <p class="agent-description">
            At KAAPAN, we open doors for IRDAI IC38-certified individuals to earn, grow, and succeed as professional insurance agents. No office. No investment. Just opportunities.
          </p>
        </div>

        <!-- Right Section -->
        <div class="col-lg-6">
          <div class="row g-4">
            <!-- Left Column with 2 cards -->
            <div class="col-lg-6 wow fadeInDown">
              <div class="d-flex flex-column gap-4">
                <!-- Card 1 -->
                <div class="agent-card p-4 border rounded shadow-sm bg-white">
                  <div class="mb-2">
                    <img src="assets/images/cta/Symbol.png" alt="Check" class="me-2" width="24">
                  </div>
                  <h5 class="fw-bold  mb-2">Full Sales Training</h5>
                  <p class="text-muted mb-0">
                    Learn everything you need to succeed — from product knowledge to customer handling, even if you're just starting out.
                  </p>
                </div>

                <!-- Card 2 -->
                <div class="agent-card p-4 border rounded shadow-sm bg-white wow fadeInDown">
                  <div class="mb-2">
                    <img src="assets/images/cta/Symbol.png" alt="Check" class="me-2" width="24">
                  </div>
                  <h5 class="fw-bold  mb-2">Work–from–anywhere Flexibility</h5>
                  <p class="text-muted mb-0">
                    Be your own boss. No office needed. Build your career from home or on the go.
                  </p>
                </div>
              </div>
            </div>

            <!-- Right Column with 1 card -->
            <div class="col-lg-6 d-flex justify-content-center align-items-center justify-content-lg-start mt-4 mt-lg-0 wow fadeInDown">
              <div class="agent-card p-4 border rounded shadow-sm bg-white">
                <div class="mb-2">
                  <img src="assets/images/cta/Symbol.png" alt="Check" class="me-2" width="24">
                </div>
                <h5 class="fw-bold  mb-2">Digital Tools & CRM Access</h5>
                <p class="text-muted mb-0">
                  Get access to our mobile app and web portal to manage leads, track progress, and issue policies from anywhere.
                </p>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </section><!--====== End Features Section ======--><!--=== Start Animate Headline ===-->
  <!-- Why Choose Us -->
  <section class="who-kaapan-section pt-120">
    <div class="container">
      <div class="text-center mb-5">
        <h2 class="who-kaapan-title">Who We Are</h2>
        <p class="who-kaapan-subtitle">Redefining Insurance, Empowering Lives.</p>
        <p class="who-kaapan-description mx-auto">
          At KAAPAN Financial Services, we’re more than just a name — we’re an IRDAI-certified company committed
          to offering simple, transparent, and accessible insurance solutions for every individual. Whether you’re
          insuring your future or starting your career with us, KAAPAN is here to back you with trust and clarity.
        </p>
      </div>

      <div class="row g-4 text-center d-flex justify-content-center">
        <div class="col-6 col-md-4 wow fadeInDown">
          <div class="who-kaapan-card h-100 p-4 rounded-3 border">
            <h5 class="who-kaapan-feature">100% Paperless<br>Onboarding</h5>
            <img src="./assets/images/about/whoweare/paperlessclaim.png" alt="Paperless Onboarding" class="img-fluid mb-3">

          </div>
        </div>

        <div class="col-6 col-md-4 wow fadeInDown">
          <div class="who-kaapan-card h-100 p-4 rounded-3 border">
            <h5 class="who-kaapan-feature">100% Claim<br>Settlement Support</h5>
            <img src="./assets/images/about/whoweare/claimsettlement.png" alt="Claim Support" class="img-fluid mb-3">

          </div>
        </div>

        <div class="col-6 col-md-4 wow fadeInDown">
          <div class="who-kaapan-card h-100 p-4 rounded-3 border">
            <h5 class="who-kaapan-feature">Personalized Plan<br>Guidance</h5>
            <img src="./assets/images/about/whoweare/planguidance.png" alt="Plan Guidance" class="img-fluid mb-3">

          </div>
        </div>
      </div>
    </div>
  </section>
  <!-- Become Agent -->
  <section class="support-section-main-agent pt-120 ">
    <div class="support-bg-agent">
      <img src="assets/images/cta/group.png" alt="Support Background" class="img-fluid">
    </div>

    <div class="support-section-agent ">
      <div class="container">
        <div class="row align-items-center justify-content-between">
          <!-- Right Image Placeholder (optional) -->
          <div class="col-md-6 support-image text-center mt-4 mt-md-0">
            <!-- If you want additional images/content -->
          </div>
          <!-- Left Content -->
          <div class="col-md-6 support-text wow fadeInDown  ">
            <div class="text-end">
              <h4>Become an KAAPAN Agent</h4>
              <p>
                Earning for your efforts to pay off? Become your own boss !
              </p>
              <div class="support-buttons">

                <a href="#" class="btn-readmore"> Apply Now</a>
              </div>
            </div>

          </div>


        </div>
      </div>
    </div>
  </section>


  <!-- Popular -->
  <section class="popular-insurance-section-container pt-120 pb-100">
    <div class="popular-insurance-header-wrapper">

      <div class="section-title text-center mb-20 wow fadeInDown">

        <h2>Popular Insurance</h2>
        <p>Select a product below to browse or get a quote online.</p>
      </div>
      <div class="popular-insurance-header-nav">
        <div class="popular-insurance-nav-arrow popular-insurance-swiper-button-prev">
          <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M15 18L9 12L15 6" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
          </svg>
        </div>
        <div class="popular-insurance-nav-arrow popular-insurance-swiper-button-next">
          <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M9 18L15 12L9 6" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
          </svg>
        </div>
        <a href="#" class="popular-insurance-view-all-link">View All</a>
      </div>
    </div>

    <div class="swiper popular-insurance-swiper-main wow fadeInDown">
      <div class="swiper-wrapper popular-insurance-swiper-wrapper">
        <div class="swiper-slide popular-insurance-card-slide">
          <div class="popular-insurance-card-image-wrapper">
            <img src="/assets/images/popular/healthinsurance.png" alt="Health Insurance" class="popular-insurance-card-image" loading="lazy">
          </div>
          <h3 class="popular-insurance-card-title">Health Coverage</h3>
          <p class="popular-insurance-card-description">An Arrangement With A Company In Which You Pay Them Regular Amounts Of Money And They Agree To Pay The Costs If, For Example, You Die Or Are Ill, Or If You Lose Or Damage Something.</p>
          <a href="#" class="btn-readmore">More</a>
        </div>


        <div class="swiper-slide popular-insurance-card-slide">
          <div class="popular-insurance-card-image-wrapper">
            <img src="/assets/images/popular/carinsurance.png" alt="Car Insurance" class="popular-insurance-card-image" loading="lazy">
          </div>
          <h3 class="popular-insurance-card-title">Vehicle Insurance</h3>
          <p class="popular-insurance-card-description">An Arrangement With A Company In Which You Pay Them Regular Amounts Of Money And They Agree To Pay The Costs If, For Example, You Die Or Are Ill, Or If You Lose Or Damage Something.</p>
          <a href="#" class="btn-readmore">More</a>
        </div>

        <div class="swiper-slide popular-insurance-card-slide">
          <div class="popular-insurance-card-image-wrapper">
            <img src="./assets/images/popular/employeegroup.png" alt="Family Insurance" class="popular-insurance-card-image" loading="lazy">
          </div>
          <h3 class="popular-insurance-card-title">Family Protection</h3>
          <p class="popular-insurance-card-description">An Arrangement With A Company In Which You Pay Them Regular Amounts Of Money And They Agree To Pay The Costs If, For Example, You Die Or Are Ill, Or If You Lose Or Damage Something.</p>
          <a href="#" class="btn-readmore">More</a>
        </div>
        <div class="swiper-slide popular-insurance-card-slide">
          <div class="popular-insurance-card-image-wrapper">
            <img src="/assets/images/popular/healthinsurance.png" alt="Health Insurance" class="popular-insurance-card-image" loading="lazy">
          </div>
          <h3 class="popular-insurance-card-title">Health Coverage</h3>
          <p class="popular-insurance-card-description">An Arrangement With A Company In Which You Pay Them Regular Amounts Of Money And They Agree To Pay The Costs If, For Example, You Die Or Are Ill, Or If You Lose Or Damage Something.</p>
          <a href="#" class="btn-readmore">More</a>
        </div>


        <div class="swiper-slide popular-insurance-card-slide">
          <div class="popular-insurance-card-image-wrapper">
            <img src="/assets/images/popular/carinsurance.png" alt="Car Insurance" class="popular-insurance-card-image" loading="lazy">
          </div>
          <h3 class="popular-insurance-card-title">Vehicle Insurance</h3>
          <p class="popular-insurance-card-description">An Arrangement With A Company In Which You Pay Them Regular Amounts Of Money And They Agree To Pay The Costs If, For Example, You Die Or Are Ill, Or If You Lose Or Damage Something.</p>
          <a href="#" class="btn-readmore">More</a>
        </div>

        <div class="swiper-slide popular-insurance-card-slide">
          <div class="popular-insurance-card-image-wrapper">
            <img src="./assets/images/popular/employeegroup.png" alt="Family Insurance" class="popular-insurance-card-image" loading="lazy">
          </div>
          <h3 class="popular-insurance-card-title">Family Protection</h3>
          <p class="popular-insurance-card-description">An Arrangement With A Company In Which You Pay Them Regular Amounts Of Money And They Agree To Pay The Costs If, For Example, You Die Or Are Ill, Or If You Lose Or Damage Something.</p>
          <a href="#" class="btn-readmore">More</a>
        </div>





      </div>
    </div>
  </section>

  <!-- Testimonail -->
  <section class="testimonial-section-container pt-60 pb-100">
    <div class="container">
      <div class="section-title text-center mb-20 wow fadeInDown">

        <h2>Testimonails</h2>
        <p>Discover what our valued clients have to say about our service and support.</p>
      </div>

      <div class="row align-items-center justify-content-center">
        <div class="col-12 col-lg-4 d-flex flex-column align-items-lg-start align-items-center text-center text-lg-start mb-4 mb-lg-0 wow fadeInDown">
          <div class="d-none d-lg-block">
            <h3 class="testimonial-secondary-heading mb-3">Don't Believe Me</h3>
            <p class="testimonial-sub-text mb-4">Check What Client Think Of Us</p>
          </div>

          <div class="testimonial-nav-controls d-flex gap-3">
            <div class="testimonial-swiper-button-prev testimonial-nav-arrow">
              <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M15 18L9 12L15 6" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
              </svg>
            </div>
            <div class="testimonial-swiper-button-next testimonial-nav-arrow">
              <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M9 18L15 12L9 6" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
              </svg>
            </div>
          </div>
        </div>

        <div class="col-12 col-lg-8 wow fadeInDown">
          <div class="swiper testimonial-swiper-main">
            <div class="swiper-wrapper testimonial-swiper-wrapper">

              <div class="swiper-slide testimonial-card-slide">
                <div class="row align-items-center">
                  <div class="col-12 col-md-5 testimonial-client-info text-center text-md-start">
                    <div>
                      <img src="./assets/images/testimonial/testimonial-1.png" alt="Client 3" class=" img-fluid " loading="lazy">
                    </div>
                  </div>
                  <div class="col-12 col-md-7 testimonial-text-content mt-4 mt-md-0">
                    <blockquote class="testimonial-quote">
                      <span class="testimonial-quote-icon">&ldquo;</span>
                      <p class="testimonial-quote-text">An Arrangement With A Company In Which You Pay Them Regular Amounts Of Money And They Agree To Pay The Costs If, For Example, You Die Or Are Ill, Or If You Lose Or Damage Something.</p>
                    </blockquote>
                  </div>
                </div>
              </div>

              <div class="swiper-slide testimonial-card-slide">
                <div class="row align-items-center">
                  <div class="col-12 col-md-5 testimonial-client-info text-center text-md-start">
                    <div>
                      <img src="./assets/images/testimonial/testimonial-1.png" alt="Client 3" class=" img-fluid " loading="lazy">
                    </div>
                  </div>
                  <div class="col-12 col-md-7 testimonial-text-content mt-4 mt-md-0">
                    <blockquote class="testimonial-quote">
                      <span class="testimonial-quote-icon">&ldquo;</span>
                      <p class="testimonial-quote-text">This insurance service provided excellent support when I needed it most. Their team was responsive and the process was seamless, making a difficult situation much easier to handle.</p>
                    </blockquote>
                  </div>
                </div>
              </div>

              <div class="swiper-slide testimonial-card-slide">
                <div class="row align-items-center">
                  <div class="col-12 col-md-5 testimonial-client-info text-center text-md-start">
                    <div>
                      <img src="./assets/images/testimonial/testimonial-1.png" alt="Client 3" class=" img-fluid " loading="lazy">
                    </div>
                  </div>
                  <div class="col-12 col-md-7 testimonial-text-content mt-4 mt-md-0">
                    <blockquote class="testimonial-quote">
                      <span class="testimonial-quote-icon">&ldquo;</span>
                      <p class="testimonial-quote-text">Highly recommend! The policy options were clear, and the customer service was exceptional. They really prioritize their clients' needs.</p>
                    </blockquote>
                  </div>
                </div>
              </div>

            </div>
          </div>
        </div>
      </div>
    </div>
  </section>

  <!-- Our Supports -->
  <section class=" pt-120 ">
    <div class="container">
      <div class="row justify-content-center">
        <div class="col-lg-8">
          <!--=== Section Title ===-->
          <div class="section-title text-center mb-50 wow fadeInDown">

            <h2>Our Supports</h2>
            <p>Select a product below to browse or get a quote online.</p>
          </div>
        </div>
      </div>
      <div class="support-grid wow fadeInDown" id="supportGrid"></div>

    </div>
  </section>
  <!-- FAQ -->
  <section class="faq-section  pt-120 ">
    <div class="container">
      <div class="row ">
        <div class="col-lg-4 mb-5">
          <div class="section-title mb-40 wow fadeInDown">
            <h2>Insurance FAQs</h2>
          </div>
          <div class="faq-tabs wow fadeInDown">
            <div class="tab-item active" data-target="lifeInsurance">Life Insurance</div>
            <div class="tab-item" data-target="motorInsurance">Motor Insurance</div>
            <div class="tab-item" data-target="premiumInsurance">Premium</div>

          </div>
        </div>

        <div class="col-lg-8 ">
          <!-- Life isurance -->
          <div class="faq-content-box pr-lg-70 mb-20 wow fadeInLeft " id="lifeInsuranceBox">
            <!--=== Section Title ===-->

            <!--=== Accordion ===-->
            <div class="accordion" id="accordionOne">
              <div class="accordion-card mb-25">
                <div class="accordion-header">
                  <h6 class="accordion-title" data-bs-toggle="collapse" data-bs-target="#collapse0" aria-expanded="true">
                    <span class="number"></span>Why prefer Kaapan?
                  </h6>
                </div>
                <div id="collapse0" class="accordion-collapse collapse show" data-bs-parent="#accordionOne">
                  <div class="accordion-body">
                    <p>Kaapan Financial Services Company stands out for its commitment to providing customer-focused life insurance solutions that address the varied needs and aspirations of every individual. As one of India’s fastest-growing private life insurers, Kaapan blends innovative technology into its services, making the process of purchasing and managing life insurance simple, transparent, and efficient.</p>
                  </div>
                </div>
              </div>
              <div class="accordion-card mb-25">
                <div class="accordion-header">
                  <h6 class="accordion-title" data-bs-toggle="collapse" data-bs-target="#collapse6" aria-expanded="false">
                    <span class="number"></span>Why Choose Kaapan?
                  </h6>
                </div>
                <div id="collapse6" class="accordion-collapse collapse" data-bs-parent="#accordionOne">
                  <div class="accordion-body">
                    <p>Kaapan Financial Services is committed to making life insurance simple, efficient, and trustworthy. Leveraging innovative technology, flexible policy options, strong financial backing from leading institutions, and responsive customer service, Kaapan strives to be your reliable partner in safeguarding your financial future.</p>
                  </div>
                </div>
              </div>
              <div class="accordion-card mb-25">
                <div class="accordion-header">
                  <h6 class="accordion-title collapsed" data-bs-toggle="collapse" data-bs-target="#collapse1" aria-expanded="false">
                    <span class="number"></span>What is Life Insurance?
                  </h6>
                </div>
                <div id="collapse1" class="accordion-collapse collapse" data-bs-parent="#accordionOne">
                  <div class="accordion-body">
                    <p>Life insurance with Kaapan is a financial agreement where you pay regular premiums, and in return, Kaapan promises to provide a lump sum payout to your beneficiaries upon your death or, in some cases, after a specified period. This payout ensures your loved ones have financial security during difficult times.</p>
                  </div>
                </div>
              </div>
              <div class="accordion-card mb-25">
                <div class="accordion-header">
                  <h6 class="accordion-title collapsed" data-bs-toggle="collapse" data-bs-target="#collapse2" aria-expanded="false">
                    <span class="number"></span>Who Should Buy Life Insurance?
                  </h6>
                </div>
                <div id="collapse2" class="accordion-collapse collapse" data-bs-parent="#accordionOne">
                  <div class="accordion-body">
                    <p>Kaapan recommends life insurance for anyone who wants to protect their family’s financial future — including working individuals supporting dependents, parents planning for their children's education, those with debts, business owners safeguarding their ventures, and anyone looking for a long-term financial planning tool.</p>
                  </div>
                </div>
              </div>
              <div class="accordion-card mb-25">
                <div class="accordion-header">
                  <h6 class="accordion-title" data-bs-toggle="collapse" data-bs-target="#collapse3" aria-expanded="false">
                    <span class="number"></span>What Are the Factors Influencing Life Insurance Premiums?
                  </h6>
                </div>
                <div id="collapse3" class="accordion-collapse collapse" data-bs-parent="#accordionOne">
                  <div class="accordion-body">
                    <p>QAt Kaapan, your premium depends on several factors, such as your age, health status, lifestyle habits (e.g., smoking), the coverage amount you choose, policy duration, your occupation, and gender. These help us assess risk to offer the most suitable premium.</p>
                  </div>
                </div>
              </div>
              <div class="accordion-card mb-25">
                <div class="accordion-header">
                  <h6 class="accordion-title" data-bs-toggle="collapse" data-bs-target="#collapse4" aria-expanded="false">
                    <span class="number"></span>What Are the Benefits of Life Insurance?
                  </h6>
                </div>
                <div id="collapse4" class="accordion-collapse collapse" data-bs-parent="#accordionOne">
                  <div class="accordion-body">
                    <p>Choosing Kaapan life insurance provides you with financial security for your family, ensures debt repayment without burdening loved ones, aids in wealth creation through savings and investment-linked plans, offers tax benefits under Indian laws, and delivers peace of mind knowing your loved ones are protected.</p>
                  </div>
                </div>
              </div>



            </div>
          </div>
          <!-- Motor isurance -->
          <div class="faq-content-box pr-lg-70 mb-20 wow fadeInLeft d-none" id="motorInsuranceBox">
            <!--=== Section Title ===-->

            <!--=== Accordion ===-->
            <div class="accordion" id="accordionOne">
              <div class="accordion-card mb-25">
                <div class="accordion-header">
                  <h6 class="accordion-title" data-bs-toggle="collapse" data-bs-target="#collapse0" aria-expanded="true">
                    <span class="number"></span>Why prefer Kaapan?
                  </h6>
                </div>
                <div id="collapse0" class="accordion-collapse collapse show" data-bs-parent="#accordionOne">
                  <div class="accordion-body">
                    <p>Kaapan Financial Services Company stands out for its commitment to providing customer-focused life insurance solutions that address the varied needs and aspirations of every individual. As one of India’s fastest-growing private life insurers, Kaapan blends innovative technology into its services, making the process of purchasing and managing life insurance simple, transparent, and efficient.</p>
                  </div>
                </div>
              </div>
              <div class="accordion-card mb-25">
                <div class="accordion-header">
                  <h6 class="accordion-title" data-bs-toggle="collapse" data-bs-target="#collapse6" aria-expanded="false">
                    <span class="number"></span>Why Choose Kaapan?
                  </h6>
                </div>
                <div id="collapse6" class="accordion-collapse collapse" data-bs-parent="#accordionOne">
                  <div class="accordion-body">
                    <p>Kaapan Financial Services is committed to making life insurance simple, efficient, and trustworthy. Leveraging innovative technology, flexible policy options, strong financial backing from leading institutions, and responsive customer service, Kaapan strives to be your reliable partner in safeguarding your financial future.</p>
                  </div>
                </div>
              </div>
              <div class="accordion-card mb-25">
                <div class="accordion-header">
                  <h6 class="accordion-title collapsed" data-bs-toggle="collapse" data-bs-target="#collapse1" aria-expanded="false">
                    <span class="number"></span>What is Life Insurance?
                  </h6>
                </div>
                <div id="collapse1" class="accordion-collapse collapse" data-bs-parent="#accordionOne">
                  <div class="accordion-body">
                    <p>Life insurance with Kaapan is a financial agreement where you pay regular premiums, and in return, Kaapan promises to provide a lump sum payout to your beneficiaries upon your death or, in some cases, after a specified period. This payout ensures your loved ones have financial security during difficult times.</p>
                  </div>
                </div>
              </div>
              <div class="accordion-card mb-25">
                <div class="accordion-header">
                  <h6 class="accordion-title collapsed" data-bs-toggle="collapse" data-bs-target="#collapse2" aria-expanded="false">
                    <span class="number"></span>Who Should Buy Life Insurance?
                  </h6>
                </div>
                <div id="collapse2" class="accordion-collapse collapse" data-bs-parent="#accordionOne">
                  <div class="accordion-body">
                    <p>Kaapan recommends life insurance for anyone who wants to protect their family’s financial future — including working individuals supporting dependents, parents planning for their children's education, those with debts, business owners safeguarding their ventures, and anyone looking for a long-term financial planning tool.</p>
                  </div>
                </div>
              </div>
              <div class="accordion-card mb-25">
                <div class="accordion-header">
                  <h6 class="accordion-title" data-bs-toggle="collapse" data-bs-target="#collapse3" aria-expanded="false">
                    <span class="number"></span>What Are the Factors Influencing Life Insurance Premiums?
                  </h6>
                </div>
                <div id="collapse3" class="accordion-collapse collapse" data-bs-parent="#accordionOne">
                  <div class="accordion-body">
                    <p>QAt Kaapan, your premium depends on several factors, such as your age, health status, lifestyle habits (e.g., smoking), the coverage amount you choose, policy duration, your occupation, and gender. These help us assess risk to offer the most suitable premium.</p>
                  </div>
                </div>
              </div>
              <div class="accordion-card mb-25">
                <div class="accordion-header">
                  <h6 class="accordion-title" data-bs-toggle="collapse" data-bs-target="#collapse4" aria-expanded="false">
                    <span class="number"></span>What Are the Benefits of Life Insurance?
                  </h6>
                </div>
                <div id="collapse4" class="accordion-collapse collapse" data-bs-parent="#accordionOne">
                  <div class="accordion-body">
                    <p>Choosing Kaapan life insurance provides you with financial security for your family, ensures debt repayment without burdening loved ones, aids in wealth creation through savings and investment-linked plans, offers tax benefits under Indian laws, and delivers peace of mind knowing your loved ones are protected.</p>
                  </div>
                </div>
              </div>



            </div>
          </div>
          <!-- Premium isurance -->
          <div class="faq-content-box pr-lg-70 mb-20 wow fadeInLeft d-none" id="premiumInsuranceBox">
            <!--=== Section Title ===-->

            <!--=== Accordion ===-->
            <div class="accordion" id="accordionOne">
              <div class="accordion-card mb-25">
                <div class="accordion-header">
                  <h6 class="accordion-title" data-bs-toggle="collapse" data-bs-target="#collapse0" aria-expanded="true">
                    <span class="number"></span>Why prefer Kaapan?
                  </h6>
                </div>
                <div id="collapse0" class="accordion-collapse collapse show" data-bs-parent="#accordionOne">
                  <div class="accordion-body">
                    <p>Kaapan Financial Services Company stands out for its commitment to providing customer-focused life insurance solutions that address the varied needs and aspirations of every individual. As one of India’s fastest-growing private life insurers, Kaapan blends innovative technology into its services, making the process of purchasing and managing life insurance simple, transparent, and efficient.</p>
                  </div>
                </div>
              </div>
              <div class="accordion-card mb-25">
                <div class="accordion-header">
                  <h6 class="accordion-title" data-bs-toggle="collapse" data-bs-target="#collapse6" aria-expanded="false">
                    <span class="number"></span>Why Choose Kaapan?
                  </h6>
                </div>
                <div id="collapse6" class="accordion-collapse collapse" data-bs-parent="#accordionOne">
                  <div class="accordion-body">
                    <p>Kaapan Financial Services is committed to making life insurance simple, efficient, and trustworthy. Leveraging innovative technology, flexible policy options, strong financial backing from leading institutions, and responsive customer service, Kaapan strives to be your reliable partner in safeguarding your financial future.</p>
                  </div>
                </div>
              </div>
              <div class="accordion-card mb-25">
                <div class="accordion-header">
                  <h6 class="accordion-title collapsed" data-bs-toggle="collapse" data-bs-target="#collapse1" aria-expanded="false">
                    <span class="number"></span>What is Life Insurance?
                  </h6>
                </div>
                <div id="collapse1" class="accordion-collapse collapse" data-bs-parent="#accordionOne">
                  <div class="accordion-body">
                    <p>Life insurance with Kaapan is a financial agreement where you pay regular premiums, and in return, Kaapan promises to provide a lump sum payout to your beneficiaries upon your death or, in some cases, after a specified period. This payout ensures your loved ones have financial security during difficult times.</p>
                  </div>
                </div>
              </div>
              <div class="accordion-card mb-25">
                <div class="accordion-header">
                  <h6 class="accordion-title collapsed" data-bs-toggle="collapse" data-bs-target="#collapse2" aria-expanded="false">
                    <span class="number"></span>Who Should Buy Life Insurance?
                  </h6>
                </div>
                <div id="collapse2" class="accordion-collapse collapse" data-bs-parent="#accordionOne">
                  <div class="accordion-body">
                    <p>Kaapan recommends life insurance for anyone who wants to protect their family’s financial future — including working individuals supporting dependents, parents planning for their children's education, those with debts, business owners safeguarding their ventures, and anyone looking for a long-term financial planning tool.</p>
                  </div>
                </div>
              </div>
              <div class="accordion-card mb-25">
                <div class="accordion-header">
                  <h6 class="accordion-title" data-bs-toggle="collapse" data-bs-target="#collapse3" aria-expanded="false">
                    <span class="number"></span>What Are the Factors Influencing Life Insurance Premiums?
                  </h6>
                </div>
                <div id="collapse3" class="accordion-collapse collapse" data-bs-parent="#accordionOne">
                  <div class="accordion-body">
                    <p>QAt Kaapan, your premium depends on several factors, such as your age, health status, lifestyle habits (e.g., smoking), the coverage amount you choose, policy duration, your occupation, and gender. These help us assess risk to offer the most suitable premium.</p>
                  </div>
                </div>
              </div>
              <div class="accordion-card mb-25">
                <div class="accordion-header">
                  <h6 class="accordion-title" data-bs-toggle="collapse" data-bs-target="#collapse4" aria-expanded="false">
                    <span class="number"></span>What Are the Benefits of Life Insurance?
                  </h6>
                </div>
                <div id="collapse4" class="accordion-collapse collapse" data-bs-parent="#accordionOne">
                  <div class="accordion-body">
                    <p>Choosing Kaapan life insurance provides you with financial security for your family, ensures debt repayment without burdening loved ones, aids in wealth creation through savings and investment-linked plans, offers tax benefits under Indian laws, and delivers peace of mind knowing your loved ones are protected.</p>
                  </div>
                </div>
              </div>



            </div>
          </div>

        </div>

      </div>

    </div>
    </div>
  </section><!--====== End Faq Section ======--><!--=== Start Animate Headline ===-->
  <!-- CTA -->
  <section class="support-section-main  pt-120 ">
    <div class="support-bg">
      <img src="assets/images/cta/People.png" alt="Support Background" class="img-fluid">
    </div>

    <div class="support-section">
      <div class="container">
        <div class="row align-items-center justify-content-between">
          <!-- Left Content -->
          <div class="col-md-6  text-center text-md-start">
            <h4 class="mb-3">Have A Question?<br>Here To Help.</h4>
            <p class="mb-3">
              Our friendly customer support team is your extended family. Speak your heart out.
              They listen with undivided attention to resolve your concerns. Give us a call,
              request a callback or drop us an email, we're here to help.
            </p>
            <div class="support-buttons mb-3">
              <a href="#" class="btn-readmore"><i class="fas fa-phone"></i> Call Us</a>
              <a href="#" class="btn-readmore"><i class="fas fa-envelope"></i> Mail Us</a>
            </div>
          </div>

          <!-- Right Image Placeholder (optional) -->
          <div class="col-md-6 support-image text-center mt-4 mt-md-0">
            <!-- If you want additional images/content -->
          </div>
        </div>
      </div>
    </div>
  </section>
  <!-- CTA -->
  <section class="custom-support-section  pt-120 ">
    <div class="container">
      <div class="row gy-4 justify-content-center text-center">
        <div class="col-sm-6 col-md-4 wow fadeInDown">
          <div class="custom-support-box p-3 d-flex  align-items-center">
            <div>
              <i class="fas fa-phone-alt custom-icon"></i>
            </div>
            <div class="ms-3 text-start">
              <p class="mb-1">Call us now</p>
              <h5>1800 209 8700</h5>
            </div>
          </div>
        </div>

        <div class="col-sm-6 col-md-4 wow fadeInDown">
          <div class="custom-support-box p-3 d-flex  align-items-center">
            <div>
              <i class="fab fa-whatsapp custom-icon"></i>
            </div>
            <div class="ms-3 text-start">
              <p class="mb-1">Chat with us on WhatsApp</p>
              <h5>8828840199</h5>
            </div>
          </div>
        </div>

        <div class="col-sm-6 col-md-4 wow fadeInDown">
          <div class="custom-support-box p-3 d-flex  align-items-center">
            <div>
              <i class="fas fa-headset custom-icon"></i>
            </div>
            <div class="ms-3 text-start">
              <p class="mb-1">Kaapan is here to help!</p>
              <h5>+91 22 6274 9898</h5>
            </div>
          </div>
        </div>
      </div>

      <div class="container mt-5">
        <div class="row  text-center text-md-start footer-area-info">
          <div class="col-12 col-lg-6 wow fadeInDown mb-4 mb-md-0 text-center text-md-start">
            <p>
              <strong>BEWARE OF SPURIOUS PHONE CALLS AND FICTITIOUS/FRAUDULENT OFFERS</strong><br>
              IRDAI or its officials do not involve in activities like selling insurance policies,
              announcing bonus or investment of premiums. Public receiving such phone calls are requested to lodge a police complaint.
            </p>

          </div>

          <!-- Divider for desktop only -->


          <div class="col-12 col-lg-5 text-center ">
            <p class="mb-3 fw-700 text-grey">Follow Us</p>
            <div class="d-flex justify-content-center  gap-5 fs-5">
              <a href="#"><i class="fab fa-facebook-f"></i></a>

              <a href="#"><i class="fab fa-youtube"></i></a>
              <a href="#"><i class="fab fa-linkedin-in"></i></a>
              <a href="#"><i class="fab fa-instagram"></i></a>
            </div>
          </div>
        </div>
      </div>

    </div>
  </section>


  <?php include 'includes/footer.php'; ?>
  <?php include 'includes/script.php'; ?>
  <script>
    gsap.registerPlugin(ScrollTrigger);

    gsap.from(".insurance-item", {
      scrollTrigger: {
        trigger: ".services-section",
        start: "top 80%", // when section is 80% into viewport
      },
      y: 100,
      scale: 0,
      opacity: 0,
      ease: "bounce.out",
      duration: 1,
      stagger: 0.2
    });
  </script>

</html>