var price_regex = /^(\d*\.)?\d+$/;
var numbers_regex = /^\d+$/;

function CalProductAmount(obj) {
    var all_errors_check = 1;

    var selected_quantity = "";
    selected_quantity = jQuery(obj).val();
    selected_quantity = selected_quantity.replace(/ /g,'');
    selected_quantity = selected_quantity.trim();
    if(selected_quantity.charAt(0) == 0) {
        selected_quantity = selected_quantity.slice(1);
        selected_quantity = selected_quantity.trim();
    }
    
    if (typeof selected_quantity != "undefined" && selected_quantity != "" && selected_quantity != 0) {
        if(numbers_regex.test(selected_quantity) == false) {
            all_errors_check = 0;
        }
        else {
            if(parseInt(selected_quantity) >= 10000) {
                selected_quantity = 1;
            }
            jQuery(obj).val(selected_quantity);
        }
    }
    else {
        all_errors_check = 0;
    }
    
    var selected_rate = "";
    if(jQuery(obj).closest('tr').find('.price').length > 0) {
        selected_rate = jQuery(obj).closest('tr').find('.price').html();
        selected_rate = selected_rate.replace(/ /g,'');
        selected_rate = selected_rate.replace(/,/g,'');
        selected_rate = selected_rate.trim();
        if (typeof selected_rate != "undefined" && selected_rate != "" && selected_rate != 0) {
            if(price_regex.test(selected_rate) == false) {
                all_errors_check = 0;
            }
            else {
                selected_rate = CheckDecimal(selected_rate);
            }
        }
    }
    
    if(all_errors_check == 1) {
        if((parseInt(selected_quantity) > 0 && numbers_regex.test(selected_quantity) == true) && price_regex.test(selected_rate) == true) {
            var selected_amount = parseInt(selected_quantity) * parseFloat(selected_rate);
            selected_amount = CheckDecimal(selected_amount);
            if(jQuery(obj).closest('tr').find('.product_name').length > 0) {
                var product_id = "";
                product_id = jQuery(obj).closest('tr').find('.product_name').attr('id');
                if(typeof product_id != "undefined" && product_id != "") {
                    if(jQuery('.amount_'+product_id).length > 0) {
                        jQuery('.amount_'+product_id).find('input[type="text"]').val(selected_amount);
                    }
                    if(jQuery('.quantity_'+product_id).length > 0) {
                        jQuery('.quantity_'+product_id).val(selected_quantity);
                    }
                    if(jQuery('form[name="order_form"]').find('.product'+product_id).length > 0) {
                        jQuery('form[name="order_form"]').find('.product'+product_id).val(product_id+'/'+selected_quantity+'/'+selected_amount);
                    }
                    else {
                        jQuery('form[name="order_form"]').append('<input type="hidden" name="product_quantity[]" class="product'+product_id+'" value="'+product_id+'/'+selected_quantity+'/'+selected_amount+'">');  
                    }                        
                }
            }
        }
        else {
            if(jQuery(obj).closest('tr').find('.product_name').length > 0) {
                var product_id = "";
                product_id = jQuery(obj).closest('tr').find('.product_name').attr('id');
                if(typeof product_id != "undefined" && product_id != "") {
                    if(jQuery('.amount_'+product_id).length > 0) {
                        jQuery('.amount_'+product_id).find('input[type="text"]').val('');
                    }
                    if(jQuery('.quantity_'+product_id).length > 0) {
                        jQuery('.quantity_'+product_id).html('');
                    }
                    if(jQuery('form[name="order_form"]').find('.product'+product_id).length > 0) {
                        jQuery('form[name="order_form"]').find('.product'+product_id).remove();
                    }
                }
            }    
        }
    }
    else {
        if(jQuery(obj).closest('tr').find('.product_name').length > 0) {
            var product_id = "";
            product_id = jQuery(obj).closest('tr').find('.product_name').attr('id');
            if(typeof product_id != "undefined" && product_id != "") {
                if(jQuery('.amount_'+product_id).length > 0) {
                    jQuery('.amount_'+product_id).find('input[type="text"]').val('');
                }
                if(jQuery('.quantity_'+product_id).length > 0) {
                    jQuery('.quantity_'+product_id).html('');
                }
                if(jQuery('form[name="order_form"]').find('.product'+product_id).length > 0) {
                    jQuery('form[name="order_form"]').find('.product'+product_id).remove();
                }
            }
        }
    }   
    
    calOverallTotal();
}

function calOverallTotal() {
    var sub_total = 0; var packing_charges = 0; var net_total=0; var packing_charges_value = 0; var overall_total = 0; var product_count = 0;
    if(jQuery('.sub_total').length > 0) {
        jQuery('.sub_total').html('');
    }

    if(jQuery('.net_total').length > 0) {
        jQuery('.net_total').html('');
    }
    if(jQuery('.discount_total').length > 0) {
        jQuery('.discount_total').html('');
    }
    if(jQuery('.packing_charges_value').length > 0) {
        jQuery('.packing_charges_value').html('');
    }
    if(jQuery('.round_off').length > 0) {
        jQuery('.round_off').html('');
    }
    if(jQuery('.overall_total').length > 0) {
        jQuery('.overall_total').html('');
    }
    if(jQuery('.product_count').length > 0) {
        jQuery('.product_count').html('');
    }

    if(jQuery('.promotion_code_discount_value').length > 0) {
        jQuery('.promotion_code_discount_value').html('');
    }
    if(jQuery('.final_value').length > 0) {
        jQuery('.final_value').html('');
    }
    if(jQuery('.promotion_code_error').length > 0) {
        jQuery('.promotion_code_error').html('');
    }

    if(jQuery('.pricelist_products').find('.product_row').length > 0) {
        jQuery('.pricelist_products').find('.product_row').each(function(){
            var actual_price = "";
            if(jQuery(this).find('.actual_price').length > 0) {
                actual_price = jQuery(this).find('.actual_price').html();
                actual_price = actual_price.replace(/ /g,'');
                actual_price = actual_price.replace(/,/g,'');
                actual_price = actual_price.trim();
                if(price_regex.test(actual_price) != false) {
                    actual_price = actual_price;
                }
            }

            var qty = "";
            if(jQuery(this).find('.qty_box').length > 0) {
                qty = jQuery(this).find('.qty_box ').val();
                qty = qty.replace(/ /g,'');
                qty = qty.replace(/,/g,'');
                qty = qty.trim();
                if(price_regex.test(qty) != false) {
                      net_amount = parseFloat(actual_price) * parseFloat(qty);
                      net_total = parseFloat(net_total) + parseFloat(net_amount);
                }
            }
        });
        if(jQuery('.net_total').length > 0) {
            net_total = CheckDecimal(net_total);
            jQuery('.net_total').val(net_total);
        }       
    }        

    if(jQuery('.pricelist_products').find('.product_row').length > 0) {
        jQuery('.pricelist_products').find('.product_row').each(function(){
            var amount = jQuery(this).find('.amount').find('input[type="text"]').val();
            if(typeof amount != "undefined" && amount != "") {
                amount = amount.replace(/ /g,'');
                amount = amount.trim();
                if(price_regex.test(amount) != false) {
                    amount = CheckDecimal(amount);
                    sub_total = parseFloat(sub_total) + parseFloat(amount); 
                    product_count = parseInt(product_count) + 1;
                }
            }
        });
        if(typeof product_count != "undefined" && product_count != "" && product_count != 0) {
            if(jQuery('.product_count').length > 0) {
                jQuery('.product_count').html(product_count);
            }
        }
        if(typeof sub_total != "undefined" && sub_total != "" && sub_total != 0) {
            sub_total = CheckDecimal(sub_total);
            overall_total = sub_total;

            if(price_regex.test(net_total) != false && price_regex.test(sub_total) != false) {
                var discounted_total= parseFloat(net_total) - parseFloat(sub_total);
                discounted_total = CheckDecimal(discounted_total); 
                jQuery('.discount_total').html(discounted_total);
            }
            
            if(jQuery('.sub_total').length > 0) {
                jQuery('.sub_total').html(sub_total);
            }
        }

        if(jQuery('.packing_charges').length > 0) {
            packing_charges = jQuery('.packing_charges').html();
            packing_charges = packing_charges.replace(/ /g,'');
            packing_charges = packing_charges.trim();
            if(typeof packing_charges != "undefined" && packing_charges != "" && packing_charges != 0) {
                if(packing_charges.indexOf('%') != -1) {
                    packing_charges = packing_charges.replace("%", "");
                    packing_charges = packing_charges.trim();
                    if(numbers_regex.test(packing_charges) != false) {
                        packing_charges_value = (parseFloat(sub_total) * parseFloat(packing_charges)) / 100;
                        packing_charges_value = CheckDecimal(packing_charges_value);
                    }
                }
                else {
                    if(numbers_regex.test(packing_charges) != false) {
                        packing_charges_value = parseFloat(packing_charges);
                        packing_charges_value = CheckDecimal(packing_charges_value);
                    }
                }

                if(typeof packing_charges_value != "undefined" && packing_charges_value != "" && packing_charges_value != 0) {
                    overall_total = parseFloat(overall_total) + parseFloat(packing_charges_value);
                    if(jQuery('.packing_charges_value').length > 0) {
                        jQuery('.packing_charges_value').html('Rs.'+packing_charges_value);
                    }
                }
            }
        }

        if(typeof overall_total != "undefined" && overall_total != "" && overall_total != 0) {
            overall_total = CheckDecimal(overall_total);
            if(jQuery('.overall_total').length > 0) {
                var decimal = ""; var round_off = '';
                var numbers = overall_total.toString().split('.');                          
                if( typeof numbers[1] != 'undefined') {
                    decimal = numbers[1];
                }
                if(decimal != "" && decimal != 00) {
                    if(decimal.length == 1) {
                        decimal = decimal+'0';
                    }
                    var round_off = "";
                    if(parseFloat(decimal) >= 50) {
                        round_off = 100 - parseFloat(decimal);
                        round_off = "0."+round_off;
                        overall_total = parseFloat(overall_total) + parseFloat(round_off);
                        if( typeof round_off != 'undefined' && round_off != '') {
                            jQuery('.round_off').html(round_off);
                        }
                    }
                    else {
                        round_off = decimal;
                        round_off = "0."+round_off;
                        overall_total = parseFloat(overall_total) - parseFloat(round_off);
                        if( typeof round_off != 'undefined' && round_off != '') {
                            jQuery('.round_off').html(" - "+round_off);
                        }
                    }   
                }
                jQuery('.overall_total').html('Rs.'+overall_total);

                var promotion_code = "";
                if(jQuery('input[name="promotion_code"]').length > 0) {
                    promotion_code = jQuery('input[name="promotion_code"]').val();
                    promotion_code = jQuery.trim(promotion_code);

                    if(typeof promotion_code != "undefined" && promotion_code != null && promotion_code != "") {

                        var overall_total = "";
                        if(jQuery('.overall_total').length > 0) {
                            overall_total = jQuery('.overall_total').html();
                            overall_total = overall_total.replace("Rs.", "");
                            overall_total = jQuery.trim(overall_total);
                            if(typeof overall_total != "undefined" && overall_total != null && overall_total != "") {
                                if(price_regex.test(overall_total) == true) {

                                    var post_url = "pricelist_changes.php?check_promotion_code="+promotion_code+"&overall_total="+overall_total;
                                    jQuery.ajax({url: post_url, success: function(result){
                                        var price_regex = /^(\d*\.)?\d+$/;
                                        if(price_regex.test(result) == true) {
                                            promotion_code_discount_value = result;
                                            if(jQuery('.promotion_code_discount_value').length > 0) {
                                                jQuery('.promotion_code_discount_value').html(promotion_code_discount_value);
                                            }
                                            overall_total = parseFloat(overall_total) - parseFloat(promotion_code_discount_value);
                                            if(jQuery('.final_value_cover').length > 0) {
                                                if(jQuery('.final_value_cover').hasClass('d-none') == true) {
                                                    jQuery('.final_value_cover').removeClass('d-none');
                                                }
                                            }
                                            if(jQuery('.final_value').length > 0) {
                                                jQuery('.final_value').html(overall_total);
                                            }
                                        }
                                        else {
                                            if(jQuery('.promotion_code_error').length > 0) {
                                                jQuery('.promotion_code_error').html(result);
                                            }
                                        }
                                    }});

                                }
                            }
                        }
                        
                    }
                }

            }
        }
    }
}

function ShowCart() {
    if(jQuery('.card_products_table').find('tr.product_row').length > 0) {
        jQuery('.card_products_table').find('tr.product_row').each(function() { jQuery(this).remove(); } );
    }

    if(jQuery('table.pricelist_products').find('.product_row').length > 0) {
        jQuery('table.pricelist_products').find('.product_row').each(function(){
            var amount = jQuery(this).find('.amount').find('input[type="text"]').val();
            if(typeof amount != "undefined" && amount != "") {
                var product_id = ""; var quantity = "";
                product_id = jQuery(this).find('.product_name').attr('id');
                if(typeof product_id != "undefined" && product_id != "") {
                    var quantity = jQuery('.quantity_'+product_id).val();
                    quantity = quantity.replace(/ /g,'');
                    quantity = quantity.trim();
                    if(quantity.charAt(0) == 0) {
                        quantity = quantity.slice(1);
                        quantity = quantity.trim();
                    }
                }                
                if(typeof quantity != "undefined" && quantity != "" && quantity != 0) {
                    var product_row_content = "";
                    product_row_content = jQuery(this).html();
                    if(product_row_content != "undefined" && product_row_content != "") {
                        if(jQuery('.card_products_table').length > 0) {
                            product_row_content = product_row_content + '<td class="text-center"><a href="Javascript:DeleteCartProduct('+"'"+product_id+"'"+');"><i class="bi bi-x-circle-fill"></i></a></td>';
                            jQuery('.card_products_table').find('tbody').append('<tr class="product_row cart_product_'+product_id+'">'+product_row_content+'</tr>');
                        }
                        if(jQuery('.card_products_table').find('.quantity_'+product_id).length > 0) {
                            jQuery('.card_products_table').find('.quantity_'+product_id).val(quantity);
                        }
                        if(jQuery('.card_products_table').find('.amount_'+product_id).length > 0) {
                            jQuery('.card_products_table').find('.amount_'+product_id).find('input[type="text"]').val(amount);
                        }
                        jQuery('.card_products_table').find('tr.product_row').each(function(){
                            if(jQuery(this).find('td.product_image').length > 0) {
                                jQuery(this).find('td.product_image').remove();
                            }
                            if(jQuery(this).find('td.product_code').length > 0) {
                                jQuery(this).find('td.product_code').remove();
                            }
                            if(jQuery(this).find('span.xsmall_visible').length > 0) {
                                jQuery(this).find('span.xsmall_visible').remove();
                            }
                            if(jQuery(this).find('td.product_content').length > 0) {
                                jQuery(this).find('td.product_content').remove();
                            }
                        });
                    }
                }    
            }
        });
    }            

    if(jQuery('.cart_modal_button').length > 0) {
        jQuery('.cart_modal_button').trigger("click");
    }
}

function DeleteCartProduct(product_id) {
    if(typeof product_id != "undefined" && product_id != "") {
        if(jQuery('table.pricelist_products').find('.quantity_'+product_id).length > 0) {
            jQuery('table.pricelist_products').find('.quantity_'+product_id).val('');
        }
        if(jQuery('table.pricelist_products').find('.amount_'+product_id).length > 0) {
            jQuery('table.pricelist_products').find('.amount_'+product_id).find('input[type="text"]').val('');
        }
        if(jQuery('table.card_products_table').find('.quantity_'+product_id).length > 0) {
            jQuery('table.card_products_table').find('.quantity_'+product_id).parent().parent().remove();
        }
        if(jQuery('.product'+product_id).length > 0) {
            jQuery('.product'+product_id).remove();
        }
        calOverallTotal();
    }
}

function GoToSubmit() {
    if(jQuery('.close_cart').length > 0) {
        jQuery('.close_cart').trigger("click");
    }    
    // if(jQuery('.submit_button').length > 0) {
    //     jQuery('.submit_button').trigger("click");
    // }

    var top = parseFloat(jQuery('form[name="order_form"]').offset().top) - 100;

    jQuery('html, body').animate({
        scrollTop: (top)
    }, 500);
}