<?php
ob_start();
session_start();
if(isset($_SESSION['userid'])){
    $user = $_SESSION['userid'];
}

if($user){
include('header.php'); 
include ('sidebar.php');
include ('db.php');

if($conn){
$categorysql = mysqli_query($conn,"SELECT * FROM category ORDER BY id DESC");
$parentcategory = mysqli_query($conn,"SELECT * FROM sub_category ORDER BY id DESC");
$unit = mysqli_query($conn,"SELECT * FROM unit ORDER BY id DESC");
$brand = mysqli_query($conn,"SELECT * FROM brand ORDER BY id DESC");


}


if(isset($_GET['msg'])) {
    $msg = "(Note:".$_GET['msg'].")";
} else {
    $msg = "";
}

if(isset($_GET['pmsg'])) {
    $pmsg = "(Note:".$_GET['pmsg'].")";
} else {
    $pmsg = "";
}

?>
<div class="content-body">
    <!-- row -->
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-body">
                        <h4 class="card-title">Create Products</h4>
                        <div class="table-responsive">
                            <form method="post" enctype="multipart/form-data" action="saveProduct.php">
                                <div class="row">
                                    <div class="col-4">
                                        <div class="form-group">
                                            <label><b>Category</b></label>
                                            <select onchange="getCatg()" name="parent_cat_id" id="parent_cat_id" class="form-control" required>
                                                <option value="">Select Category</option>
                                                <?php foreach ($categorysql as $key => $value) { ?>
                                                    <option value="<?= $value['code'] ?>"><?= $value['title'] ?></option>
                                               <?php } ?>
                                               
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-4">
                                        <div class="form-group">
                                            <label><b>Product Name</b></label>
                                            <input type="text" class="form-control" name="p_name" value="" required>
                                        </div>
                                    </div>
                                    <div class="col-4">
                                        <div class="form-group ">
                                            <label class=""><b>Product Code</b></label>
                                            <input type="text" id="link_code" class="form-control" name="p_code" value="" required>
                                        </div>
                                    </div>
                                    <div class="col-4">
                                        <div class="form-group ">
                                            <label class=""><b>Product Content </b></label>
                                            <input type="text" class="form-control" name="p_content" value="" required>
                                        </div>
                                    </div>
                                    <div class="col-4">
                                        <div class="form-group ">
                                            <label class=""><b>MRP Price</b></label>
                                            <input type="number" class="form-control" name="mrp_price" value="" required>
                                        </div>
                                    </div>
                                    <div class="col-4">
                                        <div class="form-group">
                                            <label><b>Quantity</b></label>
                                            <input type="number" name="qty" class="form-control" value="" required>                          
                                        </div>
                                    </div>
                                </div>

                                 <div class="row">
                                    <div class="col-6">
                                        <div class="form-group">
                                            <label><b>Product Image</b></label>
                                            <input type="file" class="form-control" name="single_image">
                                        </div>

                                    </div>
                                    <!--<div class="col-6">
                                        <div class="form-group">
                                            <label>Add More Images</label>
                                            <input type="file" class="form-control" name="files[]" required multiple>
                                        </div>

                                    </div>-->

                                </div>

                                <div class="card-footer text-right">
                                    <button type="submit" class="btn btn-info mr-3">Save</button>

                                    <a href="productList.php" class="btn btn-danger">Cancel</a>
                                </div>

                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- #/ container -->
</div>
<?php include ('footer.php'); } else {
    header('location:login.php');
} ?>
<script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
<script src="//cdn.ckeditor.com/4.11.1/standard/ckeditor.js"></script>
<script type="text/javascript">

// Initialize CKEditor
CKEDITOR.inline( 'short_desc' );

CKEDITOR.replace('long_description',{

  width: "500px",
  height: "200px"

}); 
CKEDITOR.replace('product_details',{

  width: "500px",
  height: "200px"

});

</script>
<script type="text/javascript">
$('#adminuser').submit(function(e) {
        $('#loader-wrapper').fadeOut('slow', function() {
            $(this).show();
        });
        e.preventDefault();
        console.log('ajax called');
        var long_description = CKEDITOR.instances['long_description'].getData();
        var product_details = CKEDITOR.instances['product_details'].getData();

        $.ajax({
            url: "saveProduct.php",
            type: "POST",
            data: new FormData(this)+"&long_description="+long_description+"&product_details="+product_details,
            contentType: false,
            cache: false,
            processData: false,
            success: function(res) {
                var data = res;
                console.log(data);
                if (data == '1') {
                    swal("Success !!", "New Product Created Successfully !!", "success");
                    setTimeout(function() {
                        window.location.href = "productList.php";
                    }, 1500);
                } else if (data == '2') {
                    swal("Oops...", "SKU Already exists !!", "error");
                } else if (data == '3') {
                    swal("Oops...", "SQL Error", "error");
                } else {
                    swal("Oops...", "Please Try Again !!", "error");
                }
            }
        });
    });

    function getCatg() {
        console.log('category');
        var id = $('#parent_cat_id').val();
        $('#sub_category_id').val('');
        $(".catgsec").hide();
        $(".sector_" + id).show();
    }


</script>