<?php 
// Load the database configuration file 
include_once 'db.php'; 
 
$filename = "Orders_" . date('Y-m-d') . ".csv"; 
$delimiter = ","; 
 
// Create a file pointer 
$f = fopen('php://memory', 'w'); 
 
// Set column headers 
$fields = array('Id', 'Order Id', 'Shipname', 'shipmobile', 'shipaddress', 'shipcity', 'shipstate','shippincode','Grand Total', 'Total Amount', 'Tax', 'Order Status', 'Shipping Cost', 'Product Name', 'Product Brand', 'Weight', 'Quantity','Created'); 
fputcsv($f, $fields, $delimiter); 
 
// Get records from the database 
$result = mysqli_query($conn,"SELECT * FROM orders as o INNER JOIN order_item as oi ON o.user_id = oi.user_id"); 
$getOrder = mysqli_fetch_array($result);
//     $shipping = json_decode($getOrder['shipping_address'], true);
    $billing = json_decode($getOrder['billing_address'], true);
if($result->num_rows > 0){ 
             // print_r($result);exit;
    while($row = $result->fetch_assoc()){ 
        $lineData = array($row['id'], $row['kurinji_user_id'], $billing['billname'], $billing['billmobile'], $billing['billaddr1'], $billing['billcity'], $billing['billcity'], $billing['billpincode'], $row['grand_total'], $row['total_amount'], $row['tax'], $row['order_status'], $row['shipping_cost'], $row['product_name'],$row['product_brand'], $row['product_weight'], $row['product_qty'],$row['created_at']); 

        fputcsv($f, $lineData, $delimiter); 
    } 
} 

// Move back to beginning of file 
fseek($f, 0); 
 
// Set headers to download file rather than displayed 
header('Content-Type: text/csv'); 
header('Content-Disposition: attachment; filename="' . $filename . '";'); 
 
// Output all remaining data on a file pointer 
fpassthru($f); 
 
// Exit from file 
exit();