<?php 
ob_start();
session_start();
if(isset($_SESSION['userid'])){
    $user = $_SESSION['userid'];
}

if($user){
include ('header.php');
include ('sidebar.php');
include ('db.php');
?>

<div class="content-body">
            <!-- MAIN CONTENT -->
            <div class="main-content">
                <div class="container-fluid">
                    <?php if(isset($_GET['msg'])){ ?> 
                        <div class="alert alert-info">
                        <strong>Info!</strong> <?=$_GET['msg'];?></div>
                    <?php } ?>
                    <div class="row">
                        <!-- coupon List -->
                        <div class="col-md-12">
                            <h4 class="card-title">Import Stock</h4>
                            <div class="panel-body">
                                <form action="importProduct.php" method="POST" enctype="multipart/form-data">    
                                    <div class="row">                               
                                        <div class="col-6">
                                            <div class="form-group">
                                                <input type="file" name="bulkpro" class="form-control" required="" accept=".xlsx, .xls, .csv"/>
                                            </div>
                                        </div> 
                                     </div>
                                        <div class="card-footer text-right">
                                            <button type="submit" class="btn btn-info mr-3" name="Import">Update</button>
                                            <a href="index.php" class="btn btn-danger">Cancel</a>
                                        </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <!-- coupon List -->
                        <div class="col-md-12">
                            <!-- BASIC TABLE -->
                            <div class="panel">
                                <div class="panel-heading">
                                    <h3 class="panel-title">Stock List</h3>
                                </div>
                                <div class="panel-body">
                                    <table id="order-listing" class="table table-striped table-bordered">
                                        <thead>
                                            <tr role="row">
                                            <th>S.no</th>
                                            <th>Product Id</th>
                                            <th>Product Name</th>
                                            <th>SKU</th>
                                            <th>Quantity</th>
                                            <th>New Qty</th>
                                        </thead>
                                        <tbody>
                                            <?php $userview = mysqli_query($conn,"select * from products order by id");
                                            $i=1;
                                            while($ro = mysqli_fetch_array($userview)){?> 
                                            <tr role="row" class="odd">
                                                <td><?php  echo $i++; ?> </td>
                                                <td><?php echo $ro['id']; ?></td>
                                                <td><?php echo $ro['p_name']; ?></td>
                                                <td><?php echo $ro['sku']; ?></td>
                                                <td><?php echo $ro['qty']; ?></td>
                                                <td><?php echo $ro['add_qty']; ?></td>
                                            </tr> 
                                            <?php } ?> 
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

<?php include ('footer.php'); } else {
    header('location:login.php');
} ?>
<script type="text/javascript" src="https://unpkg.com/pdfmake@0.2.2/build/pdfmake.js"></script>
  <script type="text/javascript" src="https://cdn.datatables.net/r/dt/jq-2.1.4,jszip-2.5.0,pdfmake-0.1.18,dt-1.10.9,af-2.0.0,b-1.0.3,b-colvis-1.0.3,b-html5-1.0.3,b-print-1.0.3,se-1.0.1/datatables.min.js"></script>
<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.66/vfs_fonts.js"></script>

<script>
$(document).ready(function() {
    $('#order-listing').DataTable({
        // "scrollX": true,
        "pagingType": "numbers",
        "processing": true,
        // "serverSide": true,
        // "ajax": "orderServerList.php",
        "dom": 'lBfrtip',
        "buttons": [
    'excel', 'csv'
   ],
   "lengthMenu": [ [10, 25, 50, -1], [10, 25, 50, "All"] ]
    } );
} );
</script>