<?php
// Assume you have an array of products with their categories
$products = [
    ['name' => 'Product 1', 'categories' => ['category1', 'category2']],
    ['name' => 'Product 2', 'categories' => ['category2']],
    ['name' => 'Product 3', 'categories' => ['category3']],
    // Add more products here
];

// Define the coupons for each category
$coupons = [
    'category1' => 'COUPON1',
    'category2' => 'COUPON2',
    // Add more categories and coupons here
];

$getalter = mysqli_query($conn, "SELECT * FROM product as p ")
// Iterate over each product
foreach ($products as $product) {
    $categories = $product['categories'];
    $appliedCoupons = [];

    // Check each category of the product
    foreach ($categories as $category) {
        // Check if the category has a corresponding coupon
        if (isset($coupons[$category])) {
            // Apply the coupon to the product
            $appliedCoupons[] = $coupons[$category];
        }
    }

    // Print the product name and applied coupons
    echo 'Product: ' . $product['name'] . '<br>';
    echo 'Applied Coupons: ' . implode(', ', $appliedCoupons) . '<br><br>';
}
?>