<?php
ob_start();
session_start();
if(isset($_SESSION['userid'])){
    $user = $_SESSION['userid'];
}

if($user){
include('header.php'); 
include ('sidebar.php');
include ('db.php');

if($conn){
$categorysql = mysqli_query($conn,"SELECT * FROM category ORDER BY id DESC");
$parentcategory = mysqli_query($conn,"SELECT * FROM sub_category ORDER BY id DESC");
$unit = mysqli_query($conn,"SELECT * FROM unit ORDER BY id DESC");
$brand = mysqli_query($conn,"SELECT * FROM brand ORDER BY id DESC");


}


if(isset($_GET['msg'])) {
    $msg = "(Note:".$_GET['msg'].")";
} else {
    $msg = "";
}

?>
<div class="content-body">
    <!-- row -->
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-body">
                        <h4 class="card-title">Create Products</h4>
                        <div class="table-responsive">
                            <form method="post" enctype="multipart/form-data" action="saveProduct.php">
                                <div class="row">
                                    <div class="col-4">
                                        <div class="form-group">
                                            <label>Category</label>
                                            <select onchange="getCatg()" name="parent_cat_id" id="parent_cat_id" class="form-control" required>
                                                <option value="">Select Category</option>
                                                <?php foreach ($categorysql as $key => $value) { ?>
                                                    <option value="<?= $value['code'] ?>"><?= $value['title'] ?></option>
                                               <?php } ?>
                                               
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-4">
                                        <div class="form-group">
                                            <label>Sub Category</label>
                                            <select name="sub_category_id" id="sub_category_id" class="form-control" required>
                                                <option value="">Select SubCategory</option>
                                                <?php foreach($parentcategory as $val){ ?>
                                                <option class="catgsec sector_<?=$val['cat_code']?>" value="<?=$val['sub_code']?>"><?=$val['sub_title']?></option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-4">
                                        <div class="form-group">
                                            <label>Brand</label>
                                            <select  name="brand" id="brand" class="form-control" required>
                                                <option value="">Select Brand</option>
                                                <?php foreach ($brand as $key => $value) { ?>
                                                    <option value="<?= $value['name'] ?>"><?= $value['name'] ?></option>
                                               <?php } ?>
                                               
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-4">
                                        <div class="form-group">
                                            <label>Name</label>
                                            <input type="text" class="form-control" name="p_name" value="" required>
                                        </div>
                                    </div>
                                    <div class="col-4">
                                        <div class="form-group ">
                                            <label class="">Item Code: <?= $msg; ?></label>
                                            <input type="text" id="link_code" class="form-control" name="sku" value="" required>
                                        </div>
                                    </div>
                                    <div class="col-4">
                                        <div class="form-group ">
                                            <label class="">Item weight (ex: 200)</label>
                                            <input type="number" class="form-control" name="p_weight" value="" required>
                                        </div>
                                    </div>
                                    <div class="col-4">
                                        <div class="form-group">
                                            <label>Unit</label>
                                            <select name="unit" id="unit" class="form-control" required>
                                                <option value="">Select Unit</option>
                                                <?php foreach($unit as $val){ ?>
                                                <option  value="<?=$val['name']?>"><?=$val['name']?></option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-4">
                                        <div class="form-group ">
                                            <label class="">MRP Price</label>
                                            <input type="number" class="form-control" name="mrp_price" value="" required>
                                        </div>
                                    </div>
                                    <div class="col-4">
                                        <div class="form-group ">
                                            <label class="">Our Price</label>
                                            <input type="number" class="form-control" name="our_price" value="" required>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-12">
                                        <div class="form-group ">
                                            <label class="">Short Description</label>
                                            <textarea class="form-control summernote" name="short_description" required></textarea>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <div class="form-group ">
                                            <label class="">Long Description</label>
                                            <textarea class="form-control summernote ckeditor" name="long_description" required></textarea>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <div class="form-group ">
                                            <label class="">Product Details</label>
                                            <textarea class="form-control summernote ckeditor" name="product_details" required></textarea>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-3">
                                        <div class="form-group">
                                            <label>Status</label>
                                            <select name="is_active" class="form-control" required>
                                                <option value="1">Active</option>
                                                <option value="0">Inactive</option>
                                            </select>
                                        </div>

                                    </div>
                                    <div class="col-3">
                                        <div class="form-group">
                                            <label>Type of product</label>
                                            <select name="product_type" class="form-control">
                                                <option value="">SELECT</option>
                                                <option value="featured">Featured</option>
                                                <option value="upsell">Upsell</option>
                                                <option value="trending">Trending</option>

                                            </select>
                                        </div>

                                    </div>
                                    <div class="col-3">
                                        <div class="form-group">
                                            <label>Quantity</label>
                                            <input type="number" name="qty" class="form-control" value="" required>                          
                                        </div>
                                    </div>
                                </div>

                                 <div class="row">
                                    <div class="col-6">
                                        <div class="form-group">
                                            <label>Images</label>
                                            <input type="file" class="form-control" name="single_image" required>
                                        </div>

                                    </div>
                                     <div class="col-6">
                                        <div class="form-group">
                                            <label>Add More Images</label>
                                            <input type="file" class="form-control" name="files[]" required multiple>
                                        </div>

                                    </div>

                                </div>

                                <div class="card-footer text-right">
                                    <button type="submit" class="btn btn-info mr-3">Save</button>

                                    <a href="productList.php" class="btn btn-danger">Cancel</a>
                                </div>

                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- #/ container -->
</div>
<?php include ('footer.php'); } else {
    header('location:login.php');
} ?>
<script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
<script src="//cdn.ckeditor.com/4.11.1/standard/ckeditor.js"></script>
<script type="text/javascript">

// Initialize CKEditor
CKEDITOR.inline( 'short_desc' );

CKEDITOR.replace('long_description',{

  width: "500px",
  height: "200px"

}); 
CKEDITOR.replace('product_details',{

  width: "500px",
  height: "200px"

});

</script>
<script type="text/javascript">
$('#adminuser').submit(function(e) {
        $('#loader-wrapper').fadeOut('slow', function() {
            $(this).show();
        });
        e.preventDefault();
        console.log('ajax called');
        var long_description = CKEDITOR.instances['long_description'].getData();
        var product_details = CKEDITOR.instances['product_details'].getData();

        $.ajax({
            url: "saveProduct.php",
            type: "POST",
            data: new FormData(this)+"&long_description="+long_description+"&product_details="+product_details,
            contentType: false,
            cache: false,
            processData: false,
            success: function(res) {
                var data = res;
                console.log(data);
                if (data == '1') {
                    swal("Success !!", "New Product Created Successfully !!", "success");
                    setTimeout(function() {
                        window.location.href = "productList.php";
                    }, 1500);
                } else if (data == '2') {
                    swal("Oops...", "SKU Already exists !!", "error");
                } else if (data == '3') {
                    swal("Oops...", "SQL Error", "error");
                } else {
                    swal("Oops...", "Please Try Again !!", "error");
                }
            }
        });
    });

    function getCatg() {
        console.log('category');
        var id = $('#parent_cat_id').val();
        $('#sub_category_id').val('');
        $(".catgsec").hide();
        $(".sector_" + id).show();
    }


</script>