<?php
 
/*
 * DataTables example server-side processing script.
 *
 * Please note that this script is intentionally extremely simply to show how
 * server-side processing can be implemented, and probably shouldn't be used as
 * the basis for a large complex system. It is suitable for simple use cases as
 * for learning.
 *
 * See http://datatables.net/usage/server-side for full details on the server-
 * side processing requirements of DataTables.
 *
 * @license MIT - http://datatables.net/license_mit
 */
 
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
 
// DB table to use
$table = 'products';
 
include 'db.php';

// Table's primary key
$primaryKey = 'id';
 
// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case simple
// indexes
$columns = array(
    array( 'db' => 'id', 'dt' => 0 ),
     array( 'db' => 'p_name', 'dt' => 1 ),
     array( 'db' => 'sku', 'dt' => 2 ),
    array( 'db' => 'product_url',  'dt' => 3 ),
    array( 'db' => 'single_image', 'dt' => 4,
        'formatter' => function( $d, $row ) {
             return '<img style="width:100px;" src="'.$d.'">';
    }),
    array( 'db' => 'created_at','dt' => 5,
        'formatter' => function( $d, $row ) {
            return date( 'd-m-Y', strtotime($d));
        }
    ),
    array( 'db' => 'id', 'dt' => 6,
        'formatter' => function( $d, $row ) {
             return '<a href="productEdit.php?editid='.$d.'" class="btn btn-success btn-sm mr-2">Edit</a><a href="productEdit.php?deleteid='.$d.'" class="btn btn-danger btn-sm mr-2">Del</a>';
    })
   
);
 
// SQL server connection information
$sql_details = array(
    'user' => $db1,
    'pass' => $db2,
    'db'   => $db3,
    'host' => $db4
);
 
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
 
include 'ssp.class.php';
 
echo json_encode(
    SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns )
);