<?php error_reporting(E_ALL);
ini_set('display_errors', 1);
include 'db.php';
// DB table to use
$table = 'review';

// Table's primary key
$primaryKey = 'id';

// indexestestiname, testiimagepath, testicontent
$columns = array(
    array( 'db' => 'id', 'dt' => 0),
    array( 'db' => 'product_id', 'dt' => 1 ),
    array( 'db' => 'user_name', 'dt' => 2),
    array( 'db' => 'user_rating', 'dt' => 3),
    array( 'db' => 'user_review', 'dt' => 4),
    array( 'db' => 'status', 'dt' => 5,
    'formatter' => function( $d, $row ) {
             
            return ''. ($d == '1'? 'approved ': '') .''. ($d == '0'? 'pending ': '') .'';
       
        }),
    array( 'db' => 'created_at', 'dt' => 6,
    'formatter' => function( $d, $row ) {
            return date( 'd-m-Y', strtotime($d));
        }),
     array( 'db' => 'id', 'dt' => 7 ,
        'formatter' => function( $d, $row ) {
             return '<a href="reviewedit.php?editid='.$d.'" class="btn btn-success btn-sm mr-2">Edit</a>';
    })
    
);

// SQL server connection information
$sql_details = array(
    'user' => $user,
    'pass' => $password,
    'db'   => $db,
    'host' => $host
);



require('ssp.class.php'); 

echo json_encode(
    SSP::complex( $_GET, $sql_details, $table, $primaryKey, $columns)
);

