@extends('layout')

@section('title')
    <?= get_label('create_customers', 'Create Customers') ?>
@endsection

@section('content')
    <div class="container-fluid">
        <div class="d-flex justify-content-between mt-4">
            <div>
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb breadcrumb-style1">
                        <li class="breadcrumb-item">
                            <a href="{{ route('superadmin.panel') }}"><?= get_label('home', 'Home') ?></a>
                        </li>
                        <li class="breadcrumb-item active">
                            <?= get_label('create_customers', 'Create Customers') ?>
                        </li>
                    </ol>
                </nav>
            </div>
            <div>
                <a href="{{ route('customers.index') }}">
                    <button type="button" class="btn btn-sm btn-primary" data-bs-toggle="tooltip" data-bs-placement="left"
                        data-bs-original-title="<?= get_label('customers', 'Customers') ?>">
                        <i class='bx bx-list-ul'></i>
                    </button>
                </a>
            </div>
        </div>

        <div class="card">
            <div class="card-body">
                <form id="registerCustomerForm" method="POST" action="{{ route('customers.store') }}">
                    @csrf
                    <h2 class="mb-4">{{ get_label('create_customer', 'Create Customer') }}</h2>
                    <div class="row mt-3">
                        <div class="col-lg-6 mb-3">
                            <label for="first_name" class="form-label"><?= get_label('first_name', 'First Name') ?>:</label>
                            <input type="text" class="form-control" id="first_name" name="first_name"
                                value="{{ old('first_name') }}" required>
                        </div>
                        <div class="col-lg-6 mb-3">
                            <label for="last_name" class="form-label"><?= get_label('last_name', 'Last Name') ?>:</label>
                            <input type="text" class="form-control" id="last_name" name="last_name"
                                value="{{ old('last_name') }}" required>
                        </div>
                    </div>
                    <div class="row mt-3">
                        <div class="col-lg-6 mb-3">
                            <label for="email" class="form-label"><?= get_label('email', 'Email') ?>:</label>
                            <input type="email" class="form-control" id="email" name="email"
                                value="{{ old('email') }}" required>
                        </div>
                        <div class="col-lg-6 mb-3">
                            <label for="phone"
                                class="form-label"><?= get_label('phone_number', 'Phone Number') ?>:</label>
                            <input type="text" class="form-control" id="phone_number" name="phone"
                                value="{{ old('phone') }}" required>
                        </div>
                    </div>
                    <div class="row mt-3">
                        <div class="col-lg-6 mb-3 ">
                            <label for="password" class="form-label"><?= get_label('password', 'Password') ?>:</label>
                           <div class="input-group">
                            <input type="password" class="form-control" id="password" name="password" required>
                            <span class="input-group-text cursor-pointer" id="show_password" >
                                <i id="eyeicon"   class="bx bx-hide" ></i>
                            </span>
                        </div>
                        </div>
                        <div class="col-lg-6 mb-3 ">
                            <label for="password_confirmation"
                                class="form-label"><?= get_label('confirm_password', 'Confirm Password') ?>:</label>
                            <div class="input-group">
                                <input type="password" class="form-control" id="password_confirmation" 
                                    name="password_confirmation" required> 
                                    <span class=" input-group-text cursor-pointer" id="show_confirm_password">
                                    <i id="eyeicon" class='bx bx-hide'></i>
                                </span>
                            </div>
                        </div>
                    </div>
                    <button type="submit" id="registerCustomer"
                        class="btn btn-primary"><?= get_label('register_customer', 'Register Customer') ?></button>
                </form>
            </div>
        </div>
    </div>
     @php
        $routePrefix = Route::getCurrentRoute()->getPrefix();
    @endphp
    <script>
 var routePrefix = '/'+'{{ $routePrefix }}';
    </script>
    <script src="{{ asset('assets/js/pages/customers.js') }}"></script>
@endsection
