@extends('layout')

@section('title')
    <?= get_label('update_client_profile', 'Update client profile') ?>
@endsection

@section('content')
    <div class="container-fluid">

        <div class="d-flex justify-content-between mt-4">
            <div>
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb breadcrumb-style1">
                        <li class="breadcrumb-item">
                            <a href="{{ route('home.index') }}"><?= get_label('home', 'Home') ?></a>
                        </li>
                        <li class="breadcrumb-item">
                            <a href="{{ route('clients.index') }}"><?= get_label('clients', 'Clients') ?></a>
                        </li>
                        <li class="breadcrumb-item">
                            <a
                                href="{{ route('clients.profile', ['id' => $client->id]) }}">{{ $client->first_name . ' ' . $client->last_name }}</a>
                        </li>
                        <li class="breadcrumb-item active">
                            <?= get_label('update', 'Update') ?>
                        </li>
                    </ol>
                </nav>
            </div>
        </div>

        <div class="card">
            <div class="card-body">
                <form action="{{ route('clients.update', ['id' => $client->id]) }}" method="POST" class="form-submit-event"
                    enctype="multipart/form-data">
                    <input type="hidden" name="redirect_url" value="{{ route('clients.index') }}">
                    @csrf
                    @method('PUT')
                    <div class="row">
                        <div class="mb-3 col-md-6">
                            <label for="firstName" class="form-label"><?= get_label('first_name', 'First name') ?> <span
                                    class="asterisk">*</span></label>
                            <input class="form-control" type="text" id="first_name" name="first_name"
                                placeholder="Enter First name" value="{{ $client->first_name }}">

                            @error('first_name')
                                <p class="text-danger text-xs mt-1">{{ $message }}</p>
                            @enderror


                        </div>
                        <div class="mb-3 col-md-6">
                            <label for="lastName" class="form-label"><?= get_label('last_name', 'Last name') ?> <span
                                    class="asterisk">*</span></label>
                            <input class="form-control" type="text" name="last_name" placeholder="Enter Last name"
                                id="last_name" value="{{ $client->last_name }}">

                            @error('last_name')
                                <p class="text-danger text-xs mt-1">{{ $message }}</p>
                            @enderror


                        </div>

                        <div class="mb-3 col-md-6">
                            <label for="email" class="form-label"><?= get_label('email', 'E-mail') ?> <span
                                    class="asterisk">*</span></label>
                            <input class="form-control" type="text" id="email" name="email"
                                placeholder="Enter E-mail" value="{{ $client->email }}">

                            @error('email')
                                <p class="text-danger text-xs mt-1">{{ $message }}</p>
                            @enderror
                        </div>

                         <div class="mb-3 col-md-6">
                        <label class="form-label"><?= get_label('country_code_and_phone_number', 'Country code and phone number') ?> <span class="asterisk">*</span></label>
                        <div class="input-group">
                            <!-- Country Code Input -->
                            <input type="text" name="country_code" class="form-control country-code-input" placeholder="+1" value="{{ $client->country_code }}">

                            <!-- Mobile Number Input -->
                            <input type="text" name="phone" class="form-control" placeholder="1234567890" value="{{ $client->phone }}">
                        </div>
                    </div>

                        <div class="mb-3 col-md-6">
                            <label for="company" class="form-label"><?= get_label('company', 'Company') ?> <span
                                    class="asterisk">*</span></label>
                            <input class="form-control" type="text" id="company" name="company"
                                placeholder="Enter Company name" value="{{ $client->company }}">

                            @error('company')
                                <p class="text-danger text-xs mt-1">{{ $message }}</p>
                            @enderror


                        </div>

                        <div class="mb-3 col-md-6">
                            <label for="address" class="form-label"><?= get_label('address', 'Address') ?> <span
                                    class="asterisk">*</span></label>
                            <input class="form-control" type="text" id="address" name="address"
                                placeholder="Enter Address" value="{{ $client->address }}">

                            @error('address')
                                <p class="text-danger text-xs mt-1">{{ $message }}</p>
                            @enderror


                        </div>

                        <div class="mb-3 col-md-6">
                            <label for="city" class="form-label"><?= get_label('city', 'City') ?> <span
                                    class="asterisk">*</span></label>
                            <input class="form-control" type="text" id="city" name="city"
                                placeholder="Enter City" value="{{ $client->city }}">

                            @error('city')
                                <p class="text-danger text-xs mt-1">{{ $message }}</p>
                            @enderror


                        </div>

                        <div class="mb-3 col-md-6">
                            <label for="state" class="form-label"><?= get_label('state', 'State') ?> <span
                                    class="asterisk">*</span></label>
                            <input class="form-control" type="text" id="state" name="state"
                                placeholder="Enter State" value="{{ $client->state }}">

                            @error('state')
                                <p class="text-danger text-xs mt-1">{{ $message }}</p>
                            @enderror


                        </div>

                        <div class="mb-3 col-md-6">
                            <label for="country" class="form-label"><?= get_label('country', 'Country') ?> <span
                                    class="asterisk">*</span></label>
                            <input class="form-control" type="text" id="country" name="country"
                                placeholder="Enter Country" value="{{ $client->country }}">

                            @error('country')
                                <p class="text-danger text-xs mt-1">{{ $message }}</p>
                            @enderror


                        </div>

                        <div class="mb-3 col-md-6">
                            <label for="zip" class="form-label"><?= get_label('zip_code', 'Zip code') ?> <span
                                    class="asterisk">*</span></label>
                            <input class="form-control" type="text" id="zip" name="zip"
                                placeholder="Enter Zip Code" value="{{ $client->zip }}">

                            @error('zip')
                                <p class="text-danger text-xs mt-1">{{ $message }}</p>
                            @enderror
                        </div>

                        <div class="mb-3 col-md-6">
                            <label for="dob" class="form-label"><?= get_label('date_of_birth', 'Date of birth') ?>
                                <span class="asterisk">*</span></label>
                            <input class="form-control" type="text" id="dob" name="dob"
                                value="{{ format_date($client->dob) }}"
                                placeholder="<?= get_label('please_select', 'Please select') ?>" autocomplete="off">

                            @error('dob')
                                <p class="text-danger text-xs mt-1">{{ $message }}</p>
                            @enderror
                        </div>
                        <div class="mb-3 col-md-6">
                            <label for="doj" class="form-label"><?= get_label('date_of_join', 'Date of joining') ?>
                                <span class="asterisk">*</span></label>
                            <input class="form-control" type="text" id="doj" name="doj"
                                value="{{ format_date($client->doj) }}"
                                placeholder="<?= get_label('please_select', 'Please select') ?>" autocomplete="off">

                            @error('doj')
                                <p class="text-danger text-xs mt-1">{{ $message }}</p>
                            @enderror
                        </div>

                        <div class="mb-3 col-md-12">
                            <label for="photo"
                                class="form-label"><?= get_label('profile_picture', 'Profile picture') ?></label>
                            <div class="d-flex align-items-start align-items-sm-center gap-4 my-3">
                                <img src="{{ $client->photo ? asset('storage/' . $client->photo) : asset('storage/photos/no-image.jpg') }}"
                                    alt="user-avatar" class="d-block rounded" height="100" width="100"
                                    id="uploadedAvatar" />
                                <div class="button-wrapper">
                                    <div class="input-group d-flex">
                                        <input type="file" class="form-control" id="inputGroupFile02" name="upload">
                                    </div>

                                    @error('upload')
                                        <p class="text-danger text-xs mt-1">{{ $message }}</p>
                                    @enderror

                                    <p class="text-muted mt-2"><?= get_label('allowed_jpg_png', 'Allowed JPG or PNG.') ?>
                                    </p>
                                </div>

                            </div>
                        </div>

                        @if (isAdminOrHasAllDataAccess())
                            <div class="mb-3 col-md-6">
                                <label class="form-label" for=""><?= get_label('status', 'Status') ?> (<small
                                        class="text-muted mt-2">If deactivated, the client won't be able to log in to their
                                        account.</small>)</label>
                                <div class="">
                                    <div class="btn-group btn-group d-flex justify-content-center" role="group"
                                        aria-label="Basic radio toggle button group">

                                        <input type="radio" class="btn-check" id="client_active" name="status"
                                            value="1" <?= $client->status == 1 ? 'checked' : '' ?>>
                                        <label class="btn btn-outline-primary"
                                            for="client_active"><?= get_label('active', 'Active') ?></label>

                                        <input type="radio" class="btn-check" id="client_deactive" name="status"
                                            value="0" <?= $client->status == 0 ? 'checked' : '' ?>>
                                        <label class="btn btn-outline-primary"
                                            for="client_deactive"><?= get_label('deactive', 'Deactive') ?></label>

                                    </div>
                                </div>
                            </div>
                        @endif

                        <div class="mt-2">
                            <button type="submit" class="btn btn-primary me-2"
                                id="submit_btn"><?= get_label('update', 'Update') ?></button>
                            <button type="reset"
                                class="btn btn-outline-secondary"><?= get_label('cancel', 'Cancel') ?></button>
                        </div>

                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection
