@extends('layout')

@section('title')
    <?= get_label('update_user_profile', 'Update user profile') ?>
@endsection

@section('content')
    <div class="container-fluid">
        <div class="d-flex justify-content-between mt-4">
            <div>
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb breadcrumb-style1">
                        <li class="breadcrumb-item">
                            <a href="{{ route('home.index') }}"><?= get_label('home', 'Home') ?></a>
                        </li>
                        <li class="breadcrumb-item">
                            <a href="{{ route('users.index') }}"><?= get_label('users', 'Users') ?></a>
                        </li>
                        <li class="breadcrumb-item">
                            <a
                                href="{{ route('users.show', [$user->id]) }}">{{ $user->first_name . ' ' . $user->last_name }}</a>

                        </li>
                        <li class="breadcrumb-item active">
                            <?= get_label('update', 'Update') ?>
                        </li>
                    </ol>
                </nav>
            </div>
        </div>

        <div class="card">
            <div class="card-body">
                <form action="{{ route('users.update_user', [$user->id]) }}" class="form-submit-event" method="POST"
                    enctype="multipart/form-data">
                    <input type="hidden" name="redirect_url" value="{{ route('users.index') }}">
                    @csrf
                    @method('PUT')
                    <div class="row">
                        <div class="mb-3 col-md-6">
                            <label for="firstName" class="form-label"><?= get_label('first_name', 'First name') ?> <span
                                    class="asterisk">*</span></label>
                            <input class="form-control" type="text" id="first_name" name="first_name"
                                placeholder="Enter first name" value="{{ $user->first_name }}">

                            @error('first_name')
                                <p class="text-danger text-xs mt-1">{{ $message }}</p>
                            @enderror


                        </div>
                        <div class="mb-3 col-md-6">
                            <label for="lastName" class="form-label"><?= get_label('last_name', 'Last name') ?> <span
                                    class="asterisk">*</span></label>
                            <input class="form-control" type="text" name="last_name" placeholder="Enter last name"
                                id="last_name" value="{{ $user->last_name }}">

                            @error('last_name')
                                <p class="text-danger text-xs mt-1">{{ $message }}</p>
                            @enderror

                        </div>

                        <div class="mb-3 col-md-6">
                            <label class="form-label" for="role"><?= get_label('role', 'Role') ?> <span
                                    class="asterisk">*</span></label>
                            <div class="input-group">
                                <select class="form-select text-capitalize" id="role" name="role">
                                   @foreach ($roles->filter(fn($role) => $role->name !== 'superadmin') as $role)
                                              <option value="{{ $role->id }}" {{ $user->getRoleNames()->first() == $role->name ? 'selected' : '' }}>
                                                  {{ $role->name }}
                                              </option>
                                              @endforeach
                                </select>
                            </div>

                            @error('role')
                                <p class="text-danger text-xs mt-1">{{ $message }}</p>
                            @enderror

                        </div>

                        <div class="mb-3 col-md-6">
                            <label for="email" class="form-label"><?= get_label('email', 'E-mail') ?> <span
                                    class="asterisk">*</span></label>
                            <input class="form-control" type="text" id="email" name="email"
                                placeholder="Enter email" value="{{ $user->email }}">

                            @error('email')
                                <p class="text-danger text-xs mt-1">{{ $message }}</p>
                            @enderror
                        </div>

                       <div class="mb-3 col-md-6">
                        <label class="form-label"><?= get_label('country_code_and_phone_number', 'Country code and phone number') ?> <span class="asterisk">*</span></label>
                        <div class="input-group">
                            <!-- Country Code Input -->
                            <input type="text" name="country_code" class="form-control country-code-input" placeholder="+1" value="{{ $user->country_code }}">

                            <!-- Mobile Number Input -->
                            <input type="text" name="phone" class="form-control" placeholder="1234567890" value="{{ $user->phone }}">
                        </div>
                    </div>



                        <div class="mb-3 col-md-6">
                            <label for="address" class="form-label"><?= get_label('address', 'Address') ?> <span
                                    class="asterisk">*</span></label>
                            <input class="form-control" type="text" id="address" name="address"
                                placeholder="Enter address" value="{{ $user->address }}">
                            @error('address')
                                <p class="text-danger text-xs mt-1">{{ $message }}</p>
                            @enderror

                        </div>

                        <div class="mb-3 col-md-6">
                            <label for="city" class="form-label"><?= get_label('city', 'City') ?> <span
                                    class="asterisk">*</span></label>
                            <input class="form-control" type="text" id="city" name="city"
                                placeholder="Enter city" value="{{ $user->city }}">

                            @error('city')
                                <p class="text-danger text-xs mt-1">{{ $message }}</p>
                            @enderror


                        </div>

                        <div class="mb-3 col-md-6">
                            <label for="state" class="form-label"><?= get_label('state', 'State') ?> <span
                                    class="asterisk">*</span></label>
                            <input class="form-control" type="text" id="state" name="state"
                                placeholder="Enter state" value="{{ $user->state }}">

                            @error('state')
                                <p class="text-danger text-xs mt-1">{{ $message }}</p>
                            @enderror


                        </div>

                        <div class="mb-3 col-md-6">
                            <label for="country" class="form-label"><?= get_label('country', 'Country') ?> <span
                                    class="asterisk">*</span></label>
                            <input class="form-control" type="text" id="country" name="country"
                                placeholder="Enter country" value="{{ $user->country }}">

                            @error('country')
                                <p class="text-danger text-xs mt-1">{{ $message }}</p>
                            @enderror


                        </div>

                        <div class="mb-3 col-md-6">
                            <label for="zip" class="form-label"><?= get_label('zip_code', 'ZIP code') ?> <span
                                    class="asterisk">*</span></label>
                            <input class="form-control" type="text" id="zip" name="zip"
                                placeholder="Enter ZIP code" value="{{ $user->zip }}">

                            @error('zip')
                                <p class="text-danger text-xs mt-1">{{ $message }}</p>
                            @enderror


                        </div>

                        <div class="mb-3 col-md-6">
                            <label for="dob" class="form-label"><?= get_label('date_of_birth', 'Date of birth') ?>
                                <span class="asterisk">*</span></label>
                            <input class="form-control" type="text" id="dob" name="dob"
                                value="{{ $user->dob ? format_date($user->dob) : '' }}"
                                placeholder="<?= get_label('please_select', 'Please select') ?>" autocomplete="off">

                            @error('dob')
                                <p class="text-danger text-xs mt-1">{{ $message }}</p>
                            @enderror
                        </div>
                        <div class="mb-3 col-md-6">
                            <label for="doj" class="form-label"><?= get_label('date_of_join', 'Date of joining') ?>
                                <span class="asterisk">*</span></label>
                            <input class="form-control" type="text" id="doj" name="doj"
                                value="{{ $user->doj ? format_date($user->doj) : '' }}"
                                placeholder="<?= get_label('please_select', 'Please select') ?>" autocomplete="off">

                            @error('doj')
                                <p class="text-danger text-xs mt-1">{{ $message }}</p>
                            @enderror
                        </div>

                        <div class="mb-3 col-md-12">
                            <label for="photo"
                                class="form-label"><?= get_label('profile_picture', 'Profile picture') ?></label>
                            <div class="d-flex align-items-start align-items-sm-center gap-4 my-3">
                                <img src="{{ $user->photo ? asset('storage/' . $user->photo) : asset('storage/photos/no-image.jpg') }}"
                                    alt="user-avatar" class="d-block rounded" height="100" width="100"
                                    id="uploadedAvatar" />
                                <div class="button-wrapper">
                                    <div class="input-group d-flex">

                                        <input type="file" class="form-control" id="inputGroupFile02" name="upload">
                                    </div>

                                    @error('upload')
                                        <p class="text-danger text-xs mt-1">{{ $message }}</p>
                                    @enderror

                                    <p class="text-muted mt-2"><?= get_label('allowed_jpg_png', 'Allowed JPG or PNG.') ?>
                                    </p>
                                </div>

                            </div>
                        </div>

                        @if (isAdminOrHasAllDataAccess())
                            <div class="mb-3 col-md-6">
                                <label class="form-label" for=""><?= get_label('status', 'Status') ?> (<small
                                        class="text-muted mt-2">If deactivated, the user won't be able to log in to their
                                        account.</small>)</label>
                                <div class="">
                                    <div class="btn-group btn-group d-flex justify-content-center" role="group"
                                        aria-label="Basic radio toggle button group">

                                        <input type="radio" class="btn-check" id="user_active" name="status"
                                            value="1" <?= $user->status == 1 ? 'checked' : '' ?>>
                                        <label class="btn btn-outline-primary"
                                            for="user_active"><?= get_label('active', 'Active') ?></label>

                                        <input type="radio" class="btn-check" id="user_deactive" name="status"
                                            value="0" <?= $user->status == 0 ? 'checked' : '' ?>>
                                        <label class="btn btn-outline-primary"
                                            for="user_deactive"><?= get_label('deactive', 'Deactive') ?></label>

                                    </div>
                                </div>
                            </div>
                        @endif

                        <div class="mt-4">
                            <button type="submit" id="submit_btn"
                                class="btn btn-primary me-2"><?= get_label('update', 'Update') ?></button>
                            <button type="reset"
                                class="btn btn-outline-secondary"><?= get_label('cancel', 'Cancel') ?></button>
                        </div>

                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection
