<?php

namespace App\Http;

use Illuminate\Foundation\Http\Kernel as HttpKernel;

class Kernel extends HttpKernel
{
    /**
     * The application's global HTTP middleware stack.
     *
     * These middleware are run during every request to your application.
     *
     * @var array<int, class-string|string>
     */
    protected $middleware = [
        // \App\Http\Middleware\TrustHosts::class,
        \App\Http\Middleware\TrustProxies::class,
        \Illuminate\Http\Middleware\HandleCors::class,
        \App\Http\Middleware\PreventRequestsDuringMaintenance::class,
        \Illuminate\Foundation\Http\Middleware\ValidatePostSize::class,
        \App\Http\Middleware\TrimStrings::class,
        \Illuminate\Foundation\Http\Middleware\ConvertEmptyStringsToNull::class,

    ];

    /**
     * The application's route middleware groups.
     *
     * @var array<string, array<int, class-string|string>>
     */
    protected $middlewareGroups = [
        'web' => [
            \App\Http\Middleware\EncryptCookies::class,
            \Illuminate\Cookie\Middleware\AddQueuedCookiesToResponse::class,
            \Illuminate\Session\Middleware\StartSession::class,
            \Illuminate\View\Middleware\ShareErrorsFromSession::class,
            \App\Http\Middleware\VerifyCsrfToken::class,
            \Illuminate\Routing\Middleware\SubstituteBindings::class,
            \App\Http\Middleware\Language::class,
        ],

        'api' => [
            // \Laravel\Sanctum\Http\Middleware\EnsureFrontendRequestsAreStateful::class,
            'throttle:api',
            \Illuminate\Routing\Middleware\SubstituteBindings::class,
        ],
    ];

    /**
     * The application's route middleware.
     *
     * These middleware may be assigned to groups or used individually.
     *
     * @var array<string, class-string|string>
     */
    protected $routeMiddleware = [
        'auth' => \App\Http\Middleware\Authenticate::class,
        'auth.basic' => \Illuminate\Auth\Middleware\AuthenticateWithBasicAuth::class,
        'auth.session' => \Illuminate\Session\Middleware\AuthenticateSession::class,
        'cache.headers' => \Illuminate\Http\Middleware\SetCacheHeaders::class,
        'can' => \Illuminate\Auth\Middleware\Authorize::class,
        'guest' => \App\Http\Middleware\RedirectIfAuthenticated::class,
        'password.confirm' => \Illuminate\Auth\Middleware\RequirePassword::class,
        'signed' => \App\Http\Middleware\ValidateSignature::class,
        'throttle' => \Illuminate\Routing\Middleware\ThrottleRequests::class,
        'verified' => \Illuminate\Auth\Middleware\EnsureEmailIsVerified::class,
        'has_workspace' => \App\Http\Middleware\HasWorkspace::class,
        'demo_restriction' => \App\Http\Middleware\DemoRestriction::class,
        'multiguard' => \App\Http\Middleware\MultiGuardMiddleware::class,
        'custom-verified' => \App\Http\Middleware\CustomVerifiedMiddleware::class,
        'customcan' => \App\Http\Middleware\CustomCanMiddleware::class,
        'customRole' => \App\Http\Middleware\CustomRoleMiddleware::class,
        'admin_or_leave_editor' => \App\Http\Middleware\CheckAdminOrLeaveEditor::class,
        'admin_or_user' => \App\Http\Middleware\CheckAdminOrUser::class,
        'checkAccess' => \App\Http\Middleware\CheckAccess::class,
        'CheckInstallation' => \App\Http\Middleware\CheckInstallation::class,
        'log.activity' => \App\Http\Middleware\LogActivity::class,
        'checkRole' => \App\Http\Middleware\CheckRole::class,
        'checkSuperadmin' => \App\Http\Middleware\CheckSuperAdmin::class,
        'check.subscription' => \App\Http\Middleware\CheckSubscription::class,
        'subscription.modules' => \App\Http\Middleware\CheckSubscriptionModules::class,
        'check.maxCreate' => \App\Http\Middleware\CheckMaxCreate::class,
    ];
}
