<head>
  <!-- jQuery (Must come first) -->
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

  <!-- Owl Carousel CSS -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.carousel.min.css" />
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.theme.default.min.css" />

  <!-- Owl Carousel JS -->
  <script src="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/owl.carousel.min.js"></script>
  <!-- AOS CSS -->
  <link href="https://cdn.jsdelivr.net/npm/aos@2.3.4/dist/aos.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>

<body>
  <!-- header -->
  <?php include('header.php'); ?>

  <main>

    <!-- home carousel -->
    <section>
      <div class="carousel-section">
        <div class="container-fluid">
          <div class="owl-carousel owl-theme custom-owl">
            <div class="item">
              <img src="assets/image/banner/banner-9.webp" alt="Slide 1">
            </div>
          </div>
        </div>
      </div>
    </section>


    <section>
      <div class="inner-product-home">
        <div class="container-fluid">

          <div class="product-home-header text-center">
            <h2 class="text-black Choose-content">Our <span class="text-success succ1">Rice Collection</span></h2>
            <p class="lead-text">
              Explore a premium selection of rice varieties, carefully processed and packaged to retain their natural aroma and freshness.
            </p>
          </div>

          <div class="product-inner-home">

            <!-- Desktop Tab Buttons -->
            <ul class="nav nav-pills tab-buttons d-none d-sm-flex" id="productTabs" role="tablist">
              <li class="category-title">Category :</li>
              <li class="nav-item" role="presentation">
                <button class="nav-link active" id="tab1" data-bs-toggle="tab" data-bs-target="#category1" type="button"
                  role="tab" aria-controls="category1" aria-selected="true">
                  <img src="./assets/image/icons/icon-1.png" alt="Cat 1" />
                  Premium Rice
                </button>
              </li>
              <li class="nav-item" role="presentation">
                <button class="nav-link" id="tab2" data-bs-toggle="tab" data-bs-target="#category2" type="button" role="tab"
                  aria-controls="category2" aria-selected="false">
                  <img src="./assets/image/icons/icon-2.png" alt="Cat 2" />
                  Broken Rice
                </button>
              </li>
              <li class="nav-item" role="presentation">
                <button class="nav-link" id="tab3" data-bs-toggle="tab" data-bs-target="#category3" type="button" role="tab"
                  aria-controls="category3" aria-selected="false">
                  <img src="./assets/image/icons/icon-3.png" alt="Cat 3" />
                  Other Collections
                </button>
              </li>
            </ul>

            <!-- Custom Mobile Dropdown -->
            <div class="custom-dropdown d-block d-sm-none mb-3">
              <button class="dropdown-btn w-100">
                Select Category
                <span class="arrow">&#9662;</span>
              </button>
              <div class="dropdown-list">
                <div class="dropdown-item" data-target="#category1"> <img src="./assets/image/icons/icon-1.png" alt="Cat 1" /> Premium Rice</div>
                <div class="dropdown-item" data-target="#category2"> <img src="./assets/image/icons/icon-2.png" alt="Cat 2" /> Broken Rice</div>
                <div class="dropdown-item" data-target="#category3"> <img src="./assets/image/icons/icon-3.png" alt="Cat 3" /> Other Collections</div>
              </div>
            </div>

            <!-- Tab Content -->
            <div class="tab-content container" id="productTabsContent">

              <!-- premium product -->
              <div class="tab-pane fade show active" id="category1" role="tabpanel" aria-labelledby="tab1">

                <div class="product-carousel-wrapper">

                  <div class="owl-carousel owl-theme">


                    <div class="product-card-home">
                      <div class="product-warp">

                        <div class="product-img">
                          <img src="./assets/image/product/revathi-premium.png" class="img-fluid" alt="">
                        </div>

                        <div class="product-content2">
                          <h2>Revathi Premium</h2>
                        </div>

                      </div>
                    </div>

                    <div class="product-card-home">
                      <div class="product-warp">
                        <a href="products.php">
                          <div class="product-img">
                            <img src="./assets/image/product/revathi-khichadi.png" class="img-fluid" alt="">
                          </div>

                          <div class="product-content2">
                            <h2>Revathi Khichadi</h2>
                          </div>
                        </a>
                      </div>
                    </div>


                    <div class="product-card-home">
                      <div class="product-warp">
                        <a href="products.php">
                          <div class="product-img">
                            <img src="./assets/image/product/revathi-malligai.png" class="img-fluid" alt="">
                          </div>

                          <div class="product-content2">
                            <h2>Revathi Malligai</h2>
                          </div>
                        </a>
                      </div>
                    </div>

                    <div class="product-card-home">
                      <div class="product-warp">
                        <a href="products.php">
                          <div class="product-img">
                            <img src="./assets/image/product/shri-kumuthavalli.png" class="img-fluid" alt="">
                          </div>

                          <div class="product-content2">
                            <h2>Shri Kumuthavalli</h2>
                          </div>
                        </a>
                      </div>
                    </div>

                    <div class="product-card-home">
                      <div class="product-warp">
                        <a href="products.php">
                          <div class="product-img">
                            <img src="./assets/image/product/shri-amuthavalli.png" class="img-fluid" alt="">
                          </div>

                          <div class="product-content2">
                            <h2>
                              Shri Aamuthavalli</h2>
                          </div>
                        </a>
                      </div>
                    </div>



                  </div>
                </div>


              </div>

              <div class="tab-pane fade" id="category2" role="tabpanel" aria-labelledby="tab2">
                <h3>Broken Rice Products</h3>
                <p>This is the product list for Broken Rice.</p>
              </div>

              <div class="tab-pane fade" id="category3" role="tabpanel" aria-labelledby="tab3">
                <h3>Other Collections</h3>
                <p>This is the product list for Other Collections.</p>
              </div>

            </div>

          </div>


        </div>
        <!-- <div class="product-home-overlay">
          <img src="./assets/image/icons/vector-1.png" class="img-fluid" alt="">
        </div> -->
      </div>

    </section>





    <!-- scrole section -->
    <div class="scrolling-ticker-wrapper">
      <div class="scrolling-ticker">
        <div class="ticker-track">
          <!-- First Set -->
          <div class="ticker-item">
            <div class="ticker-icon"><i class="bi bi-clock-fill"></i></div>
            <span class="ticker-text">24/7 Service Way Bridge</span>
          </div>
          <div class="ticker-item">
            <div class="ticker-icon"><i class="bi bi-shop"></i></div>
            <span class="ticker-text">24/7 Retail Services</span>
          </div>
          <div class="ticker-item">
            <div class="ticker-icon"><i class="bi bi-award-fill"></i></div>
            <span class="ticker-text">High Quality Products</span>
          </div>
          <div class="ticker-item">
            <div class="ticker-icon"><i class="bi bi-people-fill"></i></div>
            <span class="ticker-text">Customer Satisfaction Guaranteed</span>
          </div>
          <div class="ticker-item">
            <div class="ticker-icon"><i class="bi bi-truck"></i></div>
            <span class="ticker-text">Fast Nationwide Delivery</span>
          </div>

          <!-- Duplicate Set -->
          <div class="ticker-item">
            <div class="ticker-icon"><i class="bi bi-clock-fill"></i></div>
            <span class="ticker-text">24/7 Service Way Bridge</span>
          </div>
          <div class="ticker-item">
            <div class="ticker-icon"><i class="bi bi-shop"></i></div>
            <span class="ticker-text">24/7 Retail Services</span>
          </div>
          <div class="ticker-item">
            <div class="ticker-icon"><i class="bi bi-award-fill"></i></div>
            <span class="ticker-text">High Quality Products</span>
          </div>
          <div class="ticker-item">
            <div class="ticker-icon"><i class="bi bi-people-fill"></i></div>
            <span class="ticker-text">Customer Satisfaction Guaranteed</span>
          </div>
          <div class="ticker-item">
            <div class="ticker-icon"><i class="bi bi-truck"></i></div>
            <span class="ticker-text">Fast Nationwide Delivery</span>
          </div>
        </div>
      </div>

      <!-- Gradient overlays -->
      <div class="ticker-overlay left"></div>
      <div class="ticker-overlay right"></div>
    </div>

    <!-- package section -->
    <section class="rice-section">
      <div class="container">

        <div class="row align-items-center">

          <div class="col-xl-6 col-lg-6 col-md-12">
            <div class="product-info">
              <h2 class="text-black Choose-content">Our <span class="text-success succ1">Packages</span></h2>

              <p class="lead-text">
                <i class="bi bi-arrow-right-short"></i> Custom packaging options designed to preserve freshness and meet your branding needs.
              </p>

              <div class="dynamic-content" id="dynamicContent">
                <div class="content-item active" data-packaging="jute">
                  <p><i class="bi bi-caret-right-fill"></i> Eco-friendly <strong>Jute Bags</strong> made from natural fibers, perfect for sustainable branding. Available in 5kg, 10kg, and 25kg sizes with premium stitching.</p>
                  <div class="product-features">
                    <div class="feature-item">
                      <div class="feature-icon">♻️</div>
                      <span>Biodegradable & reusable</span>
                    </div>
                    <div class="feature-item">
                      <div class="feature-icon">🌿</div>
                      <span>Natural moisture control</span>
                    </div>
                  </div>
                </div>

                <div class="content-item" data-packaging="bopp">
                  <p><i class="bi bi-caret-right-fill"></i> Premium <strong>BOPP Bags</strong> with high-barrier protection against moisture and pests. Ideal for long-term storage and transport.</p>
                  <div class="product-features">
                    <div class="feature-item">
                      <div class="feature-icon">🛡️</div>
                      <span>100% airtight seal</span>
                    </div>
                    <div class="feature-item">
                      <div class="feature-icon">🖨️</div>
                      <span>Vibrant printing options</span>
                    </div>
                  </div>
                </div>

                <div class="content-item" data-packaging="nonwoven">
                  <p><i class="bi bi-caret-right-fill"></i> Durable <strong>Non-Woven Bags</strong> combining strength and lightweight convenience. Custom branding with woven handles for retail appeal.</p>
                  <div class="product-features">
                    <div class="feature-item">
                      <div class="feature-icon">💪</div>
                      <span>Reinforced stress points</span>
                    </div>
                    <div class="feature-item">
                      <div class="feature-icon">👜</div>
                      <span>Retail-ready handles</span>
                    </div>
                  </div>
                </div>
              </div>

              <div class="thumbnail-nav">
                <div class="thumbnail-item active"
                  data-packaging="jute"
                  data-image="./assets/image/packages/stage-1.png "
                  onclick="changePackage(this)">
                  <img src="./assets/image/packages/mockup-1.png" alt="Jute Bag">
                  <span>Jute Bags</span>
                </div>

                <div class="thumbnail-item"
                  data-packaging="bopp"
                  data-image="./assets/image/packages/stage-2.png"
                  onclick="changePackage(this)">
                  <img src="./assets/image/packages/mockup-2.png" alt="BOPP Bag">
                  <span>BOPP Bags</span>
                </div>

                <div class="thumbnail-item"
                  data-packaging="nonwoven"
                  data-image="./assets/image/packages/stage-3.png"
                  onclick="changePackage(this)">
                  <img src="./assets/image/packages/mockup-3.png" alt="Non-Woven Bag">
                  <span>Non-Woven</span>
                </div>
              </div>
            </div>
          </div>

          <div class="col-xl-6 col-lg-6 col-md-12 mt-3">
            <div class="product-gallery">
              <img src="./assets/image/packages/mockup-1.png"
                alt="Jute Bag Packaging"
                class="main-image active"
                id="mainImage">
            </div>
          </div>
        </div>

      </div>

      <div class="rice-overlay">
        <img src="./assets/image/icons/Vector.png" class="img-fluid" alt="">
      </div>
    </section>

    <!-- rice section -->
    <!-- <section>
      <div class="inner-rice" id="rice-category">
        <div class="container">

          <div class="head-rice">
            <div class="rice-head">
              <h2 class="about-content">Our <span class="text-success succ1">Rice Categories</span></h2>
              <p>Handpicked varieties to match every recipe, taste, and tradition.</p>
            </div>
            <div class="rice-thumbnail-controls  mb-3">
              <button id="prevBtn" class="btn btn-outline-success me-2"><i class="bi bi-arrow-left-short"></i></button>
              <button id="nextBtn" class="btn btn-outline-success"><i class="bi bi-arrow-right-short"></i></button>
            </div>
          </div>


          <div class="timeline-carousel">

            <div class="rice-thumbnail-nav">



              <div class="rice-thumbnail active" data-tooltip="Basmati Rice" data-year="rice1">
                <img src="./assets/image/rice/rice-1.png" alt="Basmati Rice">
                <div class="rice-tooltip">Revathi Premium</div>

              </div>
              <div class="rice-thumbnail" data-tooltip="Sona Masoori" data-year="rice2">
                <img src="./assets/image/rice/rice-2.png" alt="Sona Masoori">
                <div class="rice-tooltip">Broken Rice</div>

              </div>
              <div class="rice-thumbnail active" data-tooltip="Basmati Rice" data-year="rice3">
                <img src="./assets/image/rice/rice-3.png" alt="Basmati Rice">
                <div class="rice-tooltip">Revathi Malligai</div>

              </div>
              <div class="rice-thumbnail" data-tooltip="Sona Masoori" data-year="rice4">
                <img src="./assets/image/rice/rice-4.png" alt="Sona Masoori">
                <div class="rice-tooltip">Rajabhogam Ponni Rice</div>

              </div>



            </div>

            <div class="rice-gallery">

              <div class="rice-card" data-type="rice1">
                <div class="rice-inner">
                  <div class="row align-items-center">
                    <div class="col-lg-6">
                      <div class="rice-left">
                        <h2 class="rice-title">Revathi Premium</h2>
                        <p class="rice-desc">
                          Experience the richness of tradition and taste with <strong>Revathi Premium Rice</strong>. Carefully selected and expertly milled, this rice offers unmatched purity, aroma, and texture — perfect for daily meals or festive feasts.
                        </p>

                        <ul class="rice-features">
                          <li>Long, slender grains with a natural shine</li>
                          <li>Naturally aged for enhanced aroma and fluffiness</li>
                          <li>Ideal for biryanis, pulao, and traditional South Indian dishes</li>
                        </ul>

                        <div class="mt-4">
                          <a href="Products.php" class="read-btn">Explore Now <i class="bi bi-arrow-right-short"></i></a>
                        </div>
                      </div>

                    </div>
                    <div class="col-lg-6 text-center">
                      <div class="rice-right">
                        <img src="./assets/image/rice/img-1.png" class="img-fluid rounded" alt="White Ponni Kurunai">
                      </div>
                    </div>
                  </div>
                </div>
              </div>


              <div class="rice-card" data-type="rice2">
                <div class="rice-inner">
                  <div class="row align-items-center">
                    <div class="col-lg-6">
                      <div class="rice-left">
                        <h2 class="rice-title">Rajabogam Khichdi Ponni</h2>
                        <p class="rice-desc">
                          Specially curated for traditional Indian dishes, <strong>Rajabogam Khichdi Ponni Rice</strong> offers a soft texture, quick cooking time, and rich nutritional value — making it the perfect choice for khichdi, pongal, and everyday meals.
                        </p>

                        <ul class="rice-features">
                          <li>Medium-grain rice ideal for soft, creamy preparations</li>
                          <li>Cooks quickly and evenly for hassle-free cooking</li>
                          <li>Retains shape and absorbs flavors beautifully</li>
                          <li>Naturally processed with no added chemicals</li>
                        </ul>

                        <div class="mt-4">
                          <a href="Products.php" class="read-btn">Explore Now <i class="bi bi-arrow-right-short"></i></a>
                        </div>
                      </div>

                    </div>
                    <div class="col-lg-6 text-center">
                      <div class="rice-right">
                        <img src="./assets/image/rice/img-2.png" class="img-fluid rounded" alt="Rajabogam Khichdi Ponni">
                      </div>
                    </div>
                  </div>
                </div>
              </div>

              <div class="rice-card" data-type="rice3">
                <div class="rice-inner">
                  <div class="row align-items-center">
                    <div class="col-lg-6">
                      <div class="rice-left">
                        <h2 class="rice-title">Revathi Malligai</h2>
                        <p class="rice-desc">
                          Known for its delicate aroma and fluffy texture, <strong>Revathi Malligai Rice</strong> is the perfect choice for everyday meals. This short-grain variety cooks quickly and blends beautifully with South Indian dishes, delivering taste and comfort in every bite.
                        </p>

                        <ul class="rice-features">
                          <li>Soft and fluffy texture — ideal for daily cooking</li>
                          <li>Mild, jasmine-like aroma for a pleasant dining experience</li>
                          <li>Cooks evenly and absorbs flavors perfectly</li>
                        </ul>

                        <div class="mt-4">
                          <a href="Products.php" class="read-btn">Explore Now <i class="bi bi-arrow-right-short"></i></a>
                        </div>
                      </div>

                    </div>
                    <div class="col-lg-6 text-center">
                      <div class="rice-right">
                        <img src="./assets/image/rice/img-3.png" class="img-fluid rounded" alt="Malligai Ponni Kurunai">
                      </div>
                    </div>
                  </div>
                </div>
              </div>


              <div class="rice-card" data-type="rice4">
                <div class="rice-inner">
                  <div class="row align-items-center">
                    <div class="col-lg-6">
                      <div class="rice-left">
                        <h2 class="rice-title">Revathi Khichdi Kurunai</h2>
                        <p class="rice-desc">
                          Crafted for wholesome comfort, <strong>Revathi Khichdi Kurunai</strong> is a coarsely broken rice variety ideal for preparing soft, nourishing dishes. Its texture and quick cooking nature make it a favorite for pongal, khichdi, and baby food.
                        </p>

                        <ul class="rice-features">
                          <li>Coarse-grain rice perfect for soft-textured meals</li>
                          <li>Cooks quickly and easily — no soaking required</li>
                          <li>Rich in nutrients and easily digestible</li>
                          <li>Ideal for traditional South Indian dishes and light diets</li>
                        </ul>

                        <div class="mt-4">
                          <a href="Products.php" class="read-btn">Explore Now <i class="bi bi-arrow-right-short"></i></a>
                        </div>
                      </div>

                    </div>
                    <div class="col-lg-6 text-center">
                      <div class="rice-right">
                        <img src="./assets/image/rice/img-4.png" class="img-fluid rounded" alt="Revathi Khichdi Kurunai">
                      </div>
                    </div>
                  </div>
                </div>
              </div>

            </div>
          </div>
        </div>


        <div class="rive-overlay">
          <img src="./assets/image/icons/vector-2.png" class="img-fluid" alt="">
        </div>

        <div class="rive-overlay1">
          <img src="./assets/image/home/why-overlay.png" class="img-fluid" alt="">
        </div>
      </div>
    </section> -->

    <!-- weighbridge bridge -->
    <section class="way-bridge-section">
      <div class="container">

        <div class="section-header">
          <div class="title-wrapper">
          </div>
        </div>

        <div class="row">
          <div class="col-lg-6 col-md-12 mt-4">
            <div class="left-bridge">
              <h2 class="about-content">The <span class="text-success succ1">Weighbridge</span></h2>
              <p>
                <i class="bi bi-arrow-right-short"></i>
                At <strong>Revathi Modern Rice Mill LLP</strong>, the <strong>Weighbridge</strong> is more than just infrastructure — it represents our round-the-clock commitment to precision, transparency, and efficiency in every grain. With a fully operational <strong>24/7 digital weighbridge</strong>, we ensure accurate measurements, real-time data tracking, and smooth logistics from farm to facility.
              </p>

              <ul class="bridge-points mt-3">
                <li>
                  <i class="bi bi-clock-history point-icon"></i>
                  <div class="point-text">24/7 fully automated weighbridge access</div>
                </li>
                <li>
                  <i class="bi bi-award point-icon"></i>
                  <div class="point-text">Consistent quality with zero compromise</div>
                </li>
                <li>
                  <i class="bi bi-cpu-fill point-icon"></i>
                  <div class="point-text">Advanced digital tracking & integration</div>
                </li>
                <li>
                  <i class="bi bi-shield-check point-icon"></i>
                  <div class="point-text">Comprehensive quality checks & standards</div>
                </li>
                <li>
                  <i class="bi bi-building-gear point-icon"></i>
                  <div class="point-text">Modern rice milling backed by smart logistics</div>
                </li>
              </ul>

            </div>

          </div>
          <div class="col-lg-6  col-md-12 mt-4">

            <div id="way-bridge" class="owl-carousel custom-dots">
              <div class="item active"><img src="./assets/image/home/img-1.png" alt="Slide 1"></div>
              <div class="item"><img src="./assets/image/home/img-1.png" alt="Slide 2"></div>
              <div class="item"><img src="./assets/image/home/img-1.png" alt="Slide 3"></div>
            </div>

          </div>
        </div>
      </div>

    </section>

    <!-- why choose section -->
    <section>
      <div class="inner-why-choose">

        <div class="container">
          <div class="row">
            <div class="col-lg-5 col-sm-12 order-sm-2 d-flex justify-content-center align-items-center">
              <img src="./assets/img/Group 85.png" class="img-fluid choose-img" alt="" style="max-width: 100%; height: auto;">
            </div>

            <div class="col-lg-7 col-sm-12 cc1 sm-order-1 md-order-2">
              <div class="why-choose-content">
                <h2 class="text-black Choose-content">Why <span class="text-success succ1">Choose us</span></h2>

                <div class="features-grid mt-4">

                  <div class="feature-card">

                    <div class="feature-text">
                      <h4> <i class="bi bi-award-fill"></i> Legacy of Quality & Trust</h4>
                      <p>Decades of experience in traditional rice processing with modern excellence.</p>
                    </div>
                  </div>

                  <div class="feature-card">

                    <div class="feature-text">
                      <h4> <i class="bi bi-cpu-fill"></i> Tradition Meets Technology</h4>
                      <p>Buhler Sortex German Technology preserves natural aroma and nutrition.</p>
                    </div>
                  </div>

                  <div class="feature-card">

                    <div class="feature-text">
                      <h4> <i class="bi bi-box2-heart"></i> Premium Raw Materials</h4>
                      <p>Finest paddy processed in hygienic environments for unmatched quality.</p>
                    </div>
                  </div>

                  <div class="feature-card">

                    <div class="feature-text">
                      <h4> <i class="bi bi-fire"></i> Easy Cooking, Rich Flavor</h4>
                      <p>Perfect for modern lifestyles without compromising traditional taste.</p>
                    </div>
                  </div>

                </div>

                <div class="mt-4">
                  <a href="about.php" class="read-btn">Know More <i class="bi bi-arrow-right-short"></i></a>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>


    </section>

    <!-- Gallery Section -->
    <section class="gallery-section">
      <div class="inner-gallery">

        <div class="container">

          <h2 class="text-black about-content">
            Revathi Mills <span class="text-success succ1" data-aos="fade-up" data-aos-delay="100">Gallery</span>
          </h2>

          <div class="row">
            <div class="col-12">

              <div class="filter-group d-flex flex-wrap gap-2 justify-content-center my-3">

                <a class="filter-btn read-btn active" onclick="filterGallery('all', event)">
                  <i class="bi bi-grid-fill me-1"></i> All
                </a>

                <a class="filter-btn read-btn" onclick="filterGallery('paddy-field', event)">
                  Paddy Field
                </a>

                <a class="filter-btn read-btn" onclick="filterGallery('rice', event)">
                  Rice
                </a>

                <a class="filter-btn read-btn" onclick="filterGallery('paddy', event)">
                  Paddy
                </a>

              </div>

            </div>

            <!-- <div class="col-lg-3 col-md-6 col-sm-12 mt-3 gallery-item paddy-field">
              <div class="gallery-card cursor-pointer" onclick="openModal(); currentSlide(1)">
                <img src="./assets/image/gallery/img-1.png" class="img-fluid" alt="" />
                <div class="gallery-overlay">

                </div>
              </div>
            </div> -->
            <div class="col-lg-3 col-md-6 col-sm-12 mt-3 gallery-item rice">
              <div class="gallery-card cursor-pointer" onclick="openModal(); currentSlide(5)">
                <img src="./assets/image/gallery/img-5.png" class="img-fluid" alt="Millets" />
                <div class="gallery-overlay">

                </div>
              </div>
            </div>


            <div class="col-lg-3 col-md-6 col-sm-12 mt-3 gallery-item paddy">
              <div class="gallery-card cursor-pointer" onclick="openModal(); currentSlide(3)">
                <img src="./assets/image/gallery/img-3.png" class="img-fluid" alt="Rice" />
                <div class="gallery-overlay">

                </div>
              </div>
            </div>

            <div class="col-lg-3 col-md-6 col-sm-12 mt-3 gallery-item paddy">
              <div class="gallery-card cursor-pointer" onclick="openModal(); currentSlide(4)">
                <img src="./assets/image/gallery/img-4.png" class="img-fluid" alt="Millets" />
                <div class="gallery-overlay">
                </div>
              </div>
            </div>

            <div class="col-lg-3 col-md-6 col-sm-12 mt-3 gallery-item rice">
              <div class="gallery-card cursor-pointer" onclick="openModal(); currentSlide(6)">
                <img src="./assets/image/gallery/img-6.png" class="img-fluid" alt="Millets" />
                <div class="gallery-overlay">

                </div>
              </div>
            </div>

            <div class="col-lg-3 col-md-6 col-sm-12 mt-3 gallery-item paddy-field">
              <div class="gallery-card cursor-pointer" onclick="openModal(); currentSlide(7)">
                <img src="./assets/image/gallery/img-7.png" class="img-fluid" alt="Millets" />
                <div class="gallery-overlay">
                </div>
              </div>
            </div>

            <div class="col-lg-3 col-md-6 col-sm-12 mt-3 gallery-item paddy-field">
              <div class="gallery-card cursor-pointer" onclick="openModal(); currentSlide(8)">
                <img src="./assets/image/gallery/img-8.png" class="img-fluid" alt="Millets" />
                <div class="gallery-overlay">

                </div>
              </div>
            </div>
            <div class="col-lg-3 col-md-6 col-sm-12 mt-3 gallery-item paddy">
              <div class="gallery-card cursor-pointer" onclick="openModal(); currentSlide(2)">
                <img src="./assets/image/gallery/img-2.png" class="img-fluid" alt="Rice" />
                <div class="gallery-overlay">

                </div>
              </div>
            </div>

            <div class="col-lg-3 col-md-6 col-sm-12 mt-3 gallery-item rice">
              <div class="gallery-card cursor-pointer" onclick="openModal(); currentSlide(9)">
                <img src="./assets/image/gallery/img-9.png" class="img-fluid" alt="Millets" />
                <div class="gallery-overlay">

                </div>
              </div>
            </div>

            <div class="col-lg-3 col-md-6 col-sm-12 mt-3 gallery-item paddy-field">
              <div class="gallery-card cursor-pointer" onclick="openModal(); currentSlide(10)">
                <img src="./assets/image/gallery/img-10.png" class="img-fluid" alt="Millets" />
                <div class="gallery-overlay">

                </div>
              </div>
            </div>

            <div class="col-lg-3 col-md-6 col-sm-12 mt-3 gallery-item rice">
              <div class="gallery-card cursor-pointer" onclick="openModal(); currentSlide(11)">
                <img src="./assets/image/gallery/img-11.png" class="img-fluid" alt="Millets" />
                <div class="gallery-overlay">

                </div>
              </div>
            </div>
            <div class="col-lg-3 col-md-6 col-sm-12 mt-3 gallery-item paddy-field">
              <div class="gallery-card cursor-pointer" onclick="openModal(); currentSlide(12)">
                <img src="./assets/image/gallery/img-12.png" class="img-fluid" alt="Millets" />
                <div class="gallery-overlay">

                </div>
              </div>
            </div>
            <div class="col-lg-3 col-md-6 col-sm-12 mt-3 gallery-item paddy">
              <div class="gallery-card cursor-pointer" onclick="openModal(); currentSlide(12)">
                <img src="./assets/image/gallery/img-18.png" class="img-fluid" alt="Millets" />
                <div class="gallery-overlay">

                </div>
              </div>
            </div>

          </div>
        </div>
      </div>
    </section>




  </main>


  <!-- footer secction -->
  <?php include('footer.php'); ?>

  <!-- banner carousel -->
  <script>
    $(document).ready(function() {
      var totalSlides = $('.custom-owl .item').length;

      var owl = $(".custom-owl");
      owl.owlCarousel({
        items: 1,
        loop: true,
        autoplay: true,
        autoplayTimeout: 3000,
        autoplayHoverPause: true,
        dots: true,
        nav: false
      });

      owl.on('changed.owl.carousel', function(event) {
        var currentIndex = event.item.index - event.relatedTarget._clones.length / 2;
        if (currentIndex >= totalSlides) currentIndex = 0;
        if (currentIndex < 0) currentIndex = totalSlides - 1;

        $("#customPage").text((currentIndex + 1) + "/" + totalSlides);
      });

      // Initial set
      $("#customPage").text("1/" + totalSlides);
    });
  </script>

  <!-- waybridge-section -->
  <script>
    $(document).ready(function() {
      $("#way-bridge").owlCarousel({
        items: 1,
        loop: true,
        dots: true,
        nav: false,
        autoplay: true,
        autoplayTimeout: 10000,
        autoplayHoverPause: true
      });
    });
  </script>

  <!-- gallery -->
  <script>
    function filterGallery(category, event) {
      const items = document.querySelectorAll('.gallery-item');

      items.forEach(item => {
        if (category === 'all' || item.classList.contains(category)) {
          item.style.display = 'block';
        } else {
          item.style.display = 'none';
        }
      });

      // Update active state on filter buttons
      document.querySelectorAll('.filter-btn').forEach(btn => btn.classList.remove('active'));
      if (event) {
        event.currentTarget.classList.add('active');
      }
    }
  </script>

  <!-- package carosle -->
  <script>
    let currentIndex = 0;
    let autoSlideInterval;

    const thumbnails = document.querySelectorAll('.thumbnail-item');
    const mainImage = document.getElementById('mainImage');
    const contents = document.querySelectorAll('.content-item');

    function changePackage(thumbnail) {
      const packagingType = thumbnail.getAttribute('data-packaging');
      const newImageSrc = thumbnail.getAttribute('data-image');


      thumbnails.forEach(item => item.classList.remove('active'));
      thumbnail.classList.add('active');

      contents.forEach(content => {
        content.classList.remove('active');
        if (content.getAttribute('data-packaging') === packagingType) {
          setTimeout(() => content.classList.add('active'), 10);
        }
      });

      mainImage.classList.remove('active');
      setTimeout(() => {
        mainImage.src = newImageSrc;
        mainImage.alt = thumbnail.querySelector('img').alt;
        mainImage.classList.add('active');
      }, 120);
    }

    function startAutoSlide() {
      autoSlideInterval = setInterval(() => {
        currentIndex = (currentIndex + 1) % thumbnails.length;
        changePackage(thumbnails[currentIndex]);
      }, 5000);
    }

    function stopAutoSlide() {
      clearInterval(autoSlideInterval);
    }

    thumbnails.forEach((thumb, index) => {
      thumb.addEventListener('click', () => {
        currentIndex = index;
        changePackage(thumb);
        stopAutoSlide();
        startAutoSlide();
      });
    });

    // Start auto slide on page load
    document.addEventListener('DOMContentLoaded', () => {
      changePackage(thumbnails[currentIndex]);
      startAutoSlide();
    });
  </script>

  <!-- product carousle -->
  <script>
    $(document).ready(function() {
      $('.product-carousel-wrapper .owl-carousel').owlCarousel({
        loop: true,
        margin: 30,
        nav: true,
        dots: true,
        navText: [
          '<i class="fas fa-chevron-left"></i>',
          '<i class="fas fa-chevron-right"></i>'
        ],
        responsive: {
          0: {
            items: 1,
            nav: false
          },
          768: {
            items: 2,
            nav: false
          },
          992: {
            items: 3,
            nav: true
          }
        }
      });
    });
  </script>

  <script>
    const dropdownBtn = document.querySelector('.dropdown-btn');
    const dropdownList = document.querySelector('.dropdown-list');
    dropdownBtn.addEventListener('click', () => {
      dropdownList.style.display = dropdownList.style.display === 'block' ? 'none' : 'block';
    });

    document.querySelectorAll('.dropdown-item').forEach(item => {
      item.addEventListener('click', function() {
        dropdownBtn.innerHTML = this.innerText + ' <span class="arrow">&#9662;</span>';
        dropdownList.style.display = 'none';

        const target = this.getAttribute('data-target');
        document.querySelectorAll('.tab-pane').forEach(pane => {
          pane.classList.remove('show', 'active');
        });
        document.querySelector(target).classList.add('show', 'active');
      });
    });
  </script>


</body>