<?php
$jsonData = file_get_contents('./jsons/product.json');
$data = json_decode($jsonData, true);

$premiumProducts = [];
foreach ($data['category'] as $category) {
  if ($category['name'] === 'Premium Rice') {
    $premiumProducts = $category['products'];
    break;
  }
}
?>

<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">

  <title>Revathi Mills</title>

  <style>
    .inner-product {
      background-image: none !important;
    }

    .about-content {
      color: #000 !important;
    }

    .product-head p {
      color: #000 !important;
    }
  </style>
  <!-- Bootstrap 5 JS Bundle (includes Popper.js) -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
  <!-- Bootstrap 5 CSS -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

</head>

<body>

  <!-- header -->
  <?php include('header.php'); ?>


  <main id="main">

    <section class="hero-banner">
      <div class="banner-container">
        <div class="banner-image">
          <img src="./assets/image/banner/sub-banner-4.png" alt="About Us" class="banner-img">
          <div class="gradient-overlay"></div>
        </div>

        <div class="banner-content">
          <h1 class="banner-title">Our Product</h1>
          <div class="animated-line"></div>
        </div>

        <div class="particle particle-1"></div>
        <div class="particle particle-2"></div>
        <div class="particle particle-3"></div>
      </div>
    </section>


    <section id="title-sec01" class="title-sec01">
      <div class="container" data-aos="fade-up">
        <div class="row gx-0">
          <div class="col-lg-12 d-flex flex-column justify-content-center" data-aos="fade-up" data-aos-delay="200">
            <div class="content">
               <h1 class="main-title01">Discover Our <span class="text-success">Products</span></h1>
            </div>
          </div>
        </div>
      </div>
    </section>


    <!-- product section -->
    <section>
      <div class="product-detail-inner">
        <div class="container-fluid">


          <!-- Dropdown for mobile -->
          <div class="dropdown d-block d-md-none mb-3">
            <button class="btn btn-light border dropdown-toggle w-100 text-start" type="button" id="categoryDropdown" data-bs-toggle="dropdown" aria-expanded="false">
              <img src="./assets/image/icons/rice.png" class="img-fluid me-2" alt=""> Categories
            </button>
            <ul class="dropdown-menu w-100 shadow-sm" aria-labelledby="categoryDropdown">
              <li>
                <a class="dropdown-item" href="#v-pills-premium" role="tab" data-bs-toggle="pill">
                  <img src="./assets/image/icons/rice.png" class="img-fluid me-2" alt=""> Premium Rice
                </a>
              </li>
              <li>
                <a class="dropdown-item" href="#v-pills-broken" role="tab" data-bs-toggle="pill">
                  <img src="./assets/image/icons/rice.png" class="img-fluid me-2" alt=""> Broken Rice
                </a>
              </li>
              <li>
                <a class="dropdown-item" href="#v-pills-other" role="tab" data-bs-toggle="pill">
                  <img src="./assets/image/icons/rice.png" class="img-fluid me-2" alt=""> Other Collections
                </a>
              </li>
            </ul>
          </div>









          <div class="row align-items-start position-relative">
            <!-- Sidebar -->
            <div class="col-lg-3 col-md-4 mb-4 position-sticky" style="top: 20px;">
              <div class="sidebar">
                <h5 class="mb-3">Categories</h5>

                <!-- Dropdown for mobile -->


                <!-- Vertical nav for desktop -->
                <nav class="nav flex-column nav-pills me-3 d-none d-md-flex" id="v-pills-tab" role="tablist" aria-orientation="vertical">
                  <button class="nav-link active" data-bs-toggle="pill" data-bs-target="#v-pills-premium" type="button" role="tab" aria-controls="v-pills-premium" aria-selected="true">
                    <img src="./assets/image/icons/rice.png" class="img-fluid me-2" alt=""> Premium Rice
                  </button>
                  <button class="nav-link" data-bs-toggle="pill" data-bs-target="#v-pills-broken" type="button" role="tab" aria-controls="v-pills-broken" aria-selected="false">
                    <img src="./assets/image/icons/rice.png" class="img-fluid me-2" alt=""> Broken Rice
                  </button>
                  <button class="nav-link" data-bs-toggle="pill" data-bs-target="#v-pills-other" type="button" role="tab" aria-controls="v-pills-other" aria-selected="false">
                    <img src="./assets/image/icons/rice.png" class="img-fluid me-2" alt=""> Other Collections
                  </button>
                </nav>




                <div class="quick-links">
                  <h5 class="quick-links-title">Navigate</h5>
                  <ul class="quick-links-menu">
                    <li>
                      <a href="#" class="quick-link">
                        <span class="quick-link-icon"><i class="bi bi-house-door"></i></span>
                        <span class="quick-link-text">Home</span>
                        <span class="quick-link-arrow"><i class="bi bi-chevron-right"></i></span>
                      </a>
                    </li>
                    <li>
                      <a href="#" class="quick-link">
                        <span class="quick-link-icon"><i class="bi bi-info-circle"></i></span>
                        <span class="quick-link-text">About Us</span>
                        <span class="quick-link-arrow"><i class="bi bi-chevron-right"></i></span>
                      </a>
                    </li>
                    <li>
                      <a href="#" class="quick-link">
                        <span class="quick-link-icon"><i class="bi bi-award"></i></span>
                        <span class="quick-link-text">Certifications</span>
                        <span class="quick-link-arrow"><i class="bi bi-chevron-right"></i></span>
                      </a>
                    </li>
                    <li>
                      <a href="#" class="quick-link">
                        <span class="quick-link-icon"><i class="bi bi-egg-fried"></i></span>
                        <span class="quick-link-text">Rice Recipes</span>
                        <span class="quick-link-arrow"><i class="bi bi-chevron-right"></i></span>
                      </a>
                    </li>
                    <li>
                      <a href="#" class="quick-link">
                        <span class="quick-link-icon"><i class="bi bi-telephone"></i></span>
                        <span class="quick-link-text">Contact Us</span>
                        <span class="quick-link-arrow"><i class="bi bi-chevron-right"></i></span>
                      </a>
                    </li>
                  </ul>
                </div>

                <div class="promo-card">
                  <div class="promo-badge"><i class="bi bi-lightning-charge"></i> Hot Deal</div>
                  <div class="promo-content">
                    <h4><i class="bi bi-megaphone"></i> Today's Special</h4>
                    <div class="promo-message">
                      <p>Discover our premium rice varieties at exclusive prices</p>
                      <button class="promo-button">
                        <i class="bi bi-arrow-right"></i> Explore Now
                      </button>
                    </div>
                  </div>
                  <div class="promo-illustration">
                    <i class="bi bi-basket"></i>
                  </div>
                </div>
              </div>
            </div>


            <!-- Right Content Area -->
            <div class="col-lg-9 col-md-8">

              <div class="tab-content" id="v-pills-tabContent">
                <div class="tab-pane fade show active" id="v-pills-premium" role="tabpanel" aria-labelledby="v-pills-premium-tab">

                  <div class="product-controls-container">
                    <div class="product-controls">
                      <div class="category-header">
                        <h5 id="categoryTitle">
                          <span class="category-icon"><i class="bi bi-stars"></i></span>
                          <span class="category-name">Premium Rice</span>
                          <span class="product-count">(5 products)</span>
                        </h5>
                      </div>

                      <div class="controls-right">
                        <!-- Search Bar -->
                        <div class="search-container">
                          <i class="bi bi-search search-icon"></i>
                          <input type="text" class="search-input" placeholder="Search by name, type...">
                          <button class="search-clear"><i class="bi bi-x-lg"></i></button>
                        </div>

                        <!-- View Toggle -->
                        <div class="view-toggle-container">
                          <span class="view-label">View:</span>
                          <div class="view-toggle">
                            <button class="view-btn active" onclick="switchView('grid')">
                              <i class="bi bi-grid-3x3-gap"></i>
                            </button>
                            <!-- <button class="view-btn" onclick="switchView('list')">
                              <i class="bi bi-list-task"></i>
                            </button> -->
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>

                  <!-- Grid View -->
                  <div class="row mt-4" id="gridView">

                    <?php foreach ($premiumProducts as $index => $product) { ?>
                      <div class="col-lg-4 col-md-6 col-sm-6 col-sx-6 d-flex justify-content-center mb-4 premium d-flex">
                        <div class="product-cards p-3 rounded shadow-sm flex-full border w-100">
                          <div class="product-card-img mb-2" >
                            <img src="<?php echo htmlspecialchars($product['image']); ?>" class="img-fluid" alt="<?php echo htmlspecialchars($product['name']); ?>">
                          </div>
                          <h6><?php echo htmlspecialchars($product['name']); ?></h6>
                          <p><?php echo htmlspecialchars($product['rice']); ?></p>
                          <div class="d-flex justify-content-end align-items-end">
                            <a class="read-btn btn btn-sm btn-outline-primary view-details-btn"
                              data-bs-toggle="modal"
                              data-bs-target="#productModal"
                              data-product-index="<?php echo $index; ?>">
                              <i class="bi bi-arrow-right-short"></i> View Details
                            </a>
                          </div>
                          <?php if (!empty($product['badge'])): ?>
                            <div class="card-overlay">
                              <p><?php echo htmlspecialchars($product['badge']); ?></p>
                            </div>
                          <?php endif; ?>

                        </div>
                      </div>
                    <?php } ?>

                  </div>

                </div>
                <!-- List View -->
                <!-- <div class="d-none" id="listView">
                  <div class="product-card-list mt-4 d-flex gap-3  mb-4 p-3">
                    <img src="./assets/image/product/img-6.png" class="img-fluid mb-2 product-list-img" alt="Golden Premium Rice">

                    <div class="list-card">
                      <h6>Revathi Premium Rice</h6>
                      <p>Lorem ipsum, dolor sit amet consectetur adipisicing elit. Voluptatum vel facilis sunt tempora aspernatur
                        sit dignissimos, quis repellat maiores quasi doloribus voluptates laboriosam dolore assumenda qui asperiores fuga ducimus tenetur?</p>
                      <ul>
                        <li>Lorem ipsum dolor sit.</li>
                        <li>Lorem ipsum dolor sit.</li>
                        <li>Lorem ipsum dolor sit.</li>
                        <li>Lorem ipsum dolor sit.</li>
                      </ul>

                      <h4><span>4.5</span></h4>

                      <div class="d-flex list-btn justify-content-end align-items-end">
                        <a class="read-btn" data-bs-toggle="modal" data-bs-target="#productModal1"> <i class="bi bi-arrow-right-short"></i> View Details</a>
                      </div>

                    </div>


                  </div>

                </div> -->


              </div>

              <!-- broken rice -->
              <div class="tab-pane fade" id="v-pills-broken" role="tabpanel" aria-labelledby="v-pills-broken-tab">
                <h5>Broken Rice</h5>
                <p>Content for Broken Rice goes here...</p>
              </div>

              <!-- other coloection -->
              <div class="tab-pane fade" id="v-pills-other" role="tabpanel" aria-labelledby="v-pills-other-tab">
                <h5>Other Collections</h5>
                <p>Content for Other Collections goes here...</p>
              </div>
            </div>

          </div>
        </div>

      </div>

      </div>
    </section>


    <!-- Product Modal -->
    <div class="modal fade" id="productModal" tabindex="-1" aria-labelledby="productModalLabel" aria-hidden="true">
      <div class="modal-dialog modal-dialog-centered modal-xl custom-modal">
        <div class="modal-content border-0 shadow-lg">

          <!-- Modal Close Button -->
          <div class="modal-header border-0 position-absolute top-0 end-0 z-1">
            <button type="button" class="btn-close bg-white p-2 rounded-circle shadow-sm" data-bs-dismiss="modal" aria-label="Close"></button>
          </div>

          <!-- Modal Body -->
          <div class="modal-body p-4 p-lg-5">
            <div class="row g-4">

              <!-- Product Image -->
              <div class="col-lg-6 col-md-12 ">
                <div class="zoom-container d-flex justify-content-center">
                  <img id="modalProductImage" src="" alt="Product Image" class="zoom-img img-fluid">
                </div>
              </div>


              <!-- Product Details -->
              <div class="col-lg-6 col-md-12">
                <div class="product-details">

                  <!-- Name & Category -->
                  <div class="d-flex justify-content-between align-items-start mb-2">
                    <h2 id="modalProductName" class="fw-bold"></h2>
                    <span class="badge bg-success bg-opacity-10 text-success fs-6" id="modalProductCategory"></span>
                  </div>

                  <!-- Rating -->
                  <div class="rating mb-2">
                    <div id="modalProductRating" class="stars d-inline-block me-2 fs-5 text-warning"></div>
                    <span class="text-muted" id="modalProductRatingText"></span>
                  </div>

                  <!-- Price & Stock -->
                  <div class="price-container mb-3">
                    <span class="price h3 fw-bold text-dark" id="modalProductPrice"></span>
                    <span class="badge bg-success bg-opacity-10 text-success ms-2" id="modalProductStock"></span>
                  </div>

                  <!-- Description -->
                  <p class="product-description mb-4" id="modalProductDescription"></p>

                  <!-- Specs Grid -->
                  <div class="specs-grid mb-4" id="modalProductSpecs">
                    <!-- Specs will be inserted dynamically -->
                  </div>

                  <!-- Highlights -->
                  <div class="highlights mb-4">
                    <h5 class="fw-semibold mb-3">Product Highlights</h5>
                    <ul class="list-unstyled ps-3" id="modalProductHighlights">
                      <!-- Highlights will be inserted dynamically -->
                    </ul>
                  </div>

                  <!-- Enquiry Button -->
                  <div class="d-flex justify-content-end">
                    <a href="tel:+919876543210" class="read-btn btn btn-primary">
                      <i class="bi bi-telephone-fill me-1"></i> Get Enquiry
                    </a>
                  </div>

                </div>
              </div>

            </div>
          </div>

        </div>
      </div>
    </div>



  </main>

  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

  <!-- footer -->
  <?php include('footer.php') ?>


  <!-- change the json to js -->
  <script>
    const productsData = <?php echo json_encode($premiumProducts); ?>;
  </script>

  <!-- popup modal code  -->
  <script>
    document.addEventListener("DOMContentLoaded", function() {
      const viewButtons = document.querySelectorAll(".view-details-btn");

      viewButtons.forEach(button => {
        button.addEventListener("click", function() {
          const index = this.getAttribute("data-product-index");
          const product = productsData[index];

          if (product) {
            document.getElementById("modalProductImage").src = product.image;
            document.getElementById("modalProductImage").alt = product.name;

            document.getElementById("modalProductName").textContent = product.name;
            document.getElementById("modalProductCategory").textContent = product.title;

            const ratingContainer = document.getElementById("modalProductRating");
            const fullStars = Math.floor(product.rating);
            const halfStar = product.rating % 1 >= 0.5 ? 1 : 0;
            const emptyStars = 5 - fullStars - halfStar;
            ratingContainer.innerHTML =
              "★".repeat(fullStars) +
              (halfStar ? "½" : "") +
              "☆".repeat(emptyStars);

            document.getElementById("modalProductRatingText").textContent = `${product.rating} / 5`;

            document.getElementById("modalProductPrice").textContent = product.price;
            document.getElementById("modalProductStock").textContent = product.stock;

            document.getElementById("modalProductDescription").textContent = product.description;

            const specsContainer = document.getElementById("modalProductSpecs");
            specsContainer.innerHTML = "";
            product.specs.forEach(spec => {
              specsContainer.innerHTML += `
                  <div class="spec-item">
                    <p class="spec-header">
                      <strong><i class="bi ${spec.icon} me-1"></i> ${spec.label}</strong>
                    </p>
                    <p class="spec-value mb-0">${spec.value}</p>
                  </div>`;

            });

            const highlightsContainer = document.getElementById("modalProductHighlights");
            highlightsContainer.innerHTML = "";
            product.highlights.forEach(highlight => {
              highlightsContainer.innerHTML += `
             <li class="highlight-item">
               <strong>${highlight.label}:</strong> ${highlight.value}
             </li>`;
            });

          }
        });
      });
    });
  </script>

  <!-- image zoom -->
  <script>
    const zoomContainer = document.querySelector('.zoom-container');
    const zoomImg = document.querySelector('.zoom-img');

    zoomContainer.addEventListener('mousemove', function(e) {
      const {
        left,
        top,
        width,
        height
      } = zoomContainer.getBoundingClientRect();
      const x = ((e.clientX - left) / width) * 100;
      const y = ((e.clientY - top) / height) * 100;

      zoomImg.style.transformOrigin = `${x}% ${y}%`;
      zoomImg.style.transform = 'scale(1.5)';
    });

    zoomContainer.addEventListener('mouseleave', function() {
      zoomImg.style.transformOrigin = 'center center';
      zoomImg.style.transform = 'scale(1)';
    });
  </script>


</body>