<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">

  <title>About Us – Revathi Modern Rice Mill LLP</title>
  <link href="assets/img/footer-logo.png" rel="icon" />

</head>

<body>

  <!-- header -->
  <?php include('header.php'); ?>

  <main id="main">


    <section class="hero-banner">
      <div class="banner-container">
        <div class="banner-image">
          <img src="./assets/image/banner/sub-banner-1.jpg" alt="About Us" class="banner-img">
          <div class="gradient-overlay"></div>
        </div>
        <div class="banner-content">
          <h1 class="banner-title">About Our Company</h1>
          <div class="animated-line"></div>
        </div>

        <div class="particle particle-1"></div>
        <div class="particle particle-2"></div>
        <div class="particle particle-3"></div>
      </div>
    </section>


    <!-- about  us section -->
    <section id="title-sec01" class="title-sec01">
      <div class="container" data-aos="fade-up">
        <div class="row gx-0">
          <div class="col-lg-12 d-flex flex-column justify-content-center" data-aos="fade-up" data-aos-delay="200">
            <div class="content">
              <h1 class="main-title01">about us</h1>
            </div>

            <div class="row">
              <div class="col-lg-4 col-md-12 col-sm-12 d-flex justify-content-center align-items-center">
                <div>
                  <img src="./assets/img/about/about.png" class="img-fluid" alt="Revathi Modern Rice Mill">
                </div>
              </div>

              <div class="col-lg-8 col-md-12 col-sm-12 mt-5">
                <div class="about-right">
                  <h2><span>Revathi Modern Rice Mill LLP</span> <br>Empowering Agriculture, Enriching Kitchens Since 1997</h2>

                  <p><i class="bi bi-caret-right"></i> The success of our brand lies in the innovation of manufacturing procedures, as there were no definite types of machinery in the past for the production of quality rice. With growing experience, suitable improvements were made to meet requirements, leading to a transformation in the way paddy is processed into rice while retaining traditional aroma and flavor.</p>

                  <p><i class="bi bi-caret-right"></i> <strong>“Tradition and Technology perfectly blended”</strong> is the shibboleth of the REVATHI brand. With all humility, we proudly declare that <strong>REVATHI PREMIUM, REVATHI KICHADI & REVATHI MALLIGAI</strong> are qualitatively superior products, as they are made from the finest raw materials and processed and packed with the highest standards of hygiene.</p>

                  <p><i class="bi bi-caret-right"></i> <strong>Modern technology powers our processes.</strong> Our plant uses <strong>Bühler Sortex (German Technology)</strong>, one of the finest in Asia, to separate broken rice while preserving its natural quality, flavor, and aroma.</p>

                  <p><i class="bi bi-caret-right"></i> Ms. Revathi Modern Rice Mill, Salem, was transformed into a Limited Liability Partnership (LLP) named after its brand "REVATHI" in 1997. Today, <strong>Revathi Mill manufactures over 10+ varieties of rice</strong>, adding value to agricultural products, supporting farmers in marketing their produce, and creating employment opportunities for agricultural laborers and rural communities.</p>

                  <p><i class="bi bi-caret-right"></i> <strong>Our customers include housewives, restaurants, hostels, hotels, and canteens</strong>—anyone who values easy and quick cooking solutions with authentic flavor.</p>

                  <!-- <div class="mt-4">
                  <a href="products.php" class="read-btn">Discover More <i class="bi bi-caret-right-fill"></i></a>
                  </div> -->
                </div>
              </div>
            </div>

          </div>
        </div>
      </div>
    </section>


    <!-- reason for choseing us -->
    <section class="benefits-section" data-aos="fade-up" data-aos-delay="200">
      <div class="container">
        <div class="row">

          <!-- Image Column -->
          <div class="col-lg-6 col-md-12 col-sm-12 d-flex justify-content-center align-items-center mb-3">
            <img src="./assets/img/about/benefits.webp" class="img-fluid benefits-img" alt="Benefits of Revathi Mills">
          </div>

          <!-- Text Column -->
          <div class="col-lg-6 col-md-12 col-sm-12 d-flex justify-content-center align-items-center">
            <div class="benefits-right">
              <h2 class="text-black about-content">Benefits of<span class="text-success succ1"> Choosing Us</span></h2>

              <!-- Card 1 -->
              <div class="benefits-card">
                <!-- <div> <img src="./assets/img/icons/control-system.png" class="img-fluid" alt="Quality Control"> </div> -->
                <div>
                  <h3>Sourcing and Quality Control</h3>
                  <p><i class="bi bi-arrow-right-short"></i> At Revathi Mills, we meticulously source premium rice varieties from trusted farmers and suppliers. Our rigorous quality control measures ensure that only the highest-grade rice reaches our customers, guaranteeing freshness, purity, and superior taste in every grain.</p>
                </div>
              </div>

              <!-- Card 2 -->
              <div class="benefits-card">
                <!-- <div> <img src="./assets/img/icons/coffee-bag.png" class="img-fluid" alt="Packaging"> </div> -->
                <div>
                  <h3>Packaging Perfection</h3>
                  <p><i class="bi bi-arrow-right-short"></i> We utilize advanced packaging techniques that preserve the natural aroma and texture of our rice. Our packaging meets international quality and safety standards while offering convenience and visual appeal for a delightful customer experience.</p>
                </div>
              </div>
            </div>
          </div>

          <!-- Card 3 -->
          <div class="col-lg-6">
            <div class="benefits-card">
              <!-- <div> <img src="./assets/img/icons/customer-centricity.png" class="img-fluid" alt="Customer Service"> </div> -->
              <div>
                <h3>Customer-Centric Approach</h3>
                <p><i class="bi bi-arrow-right-short"></i> Our customers are at the heart of everything we do at Revathi Mills. We aim to deliver exceptional support and personalized solutions tailored to your needs. Our dedicated team ensures every interaction is smooth and satisfactory.</p>
              </div>
            </div>
          </div>

          <!-- Card 4 -->
          <div class="col-lg-6">
            <div class="benefits-card">
              <!-- <div> <img src="./assets/img/icons/identities.png" class="img-fluid" alt="Sustainability"> </div> -->
              <div>
                <h3>Innovation & Sustainability</h3>
                <p><i class="bi bi-arrow-right-short"></i> We are committed to continuously improving our processes through innovation and sustainable practices. By adopting eco-friendly methods and modern technologies, we minimize our environmental impact while maintaining premium quality.</p>
              </div>
            </div>
          </div>

        </div>
      </div>
    </section>

    <!-- Vision and Mission Section -->
    <section class="vission-section">
      <div class="container">
        <div class="row">

          <!-- Mission -->
          <div class="col-lg-6 col-md-12 d-flex mt-3" data-aos="flip-right" data-aos-delay="200">
            <div class="vission-left">
              <div class="vission-head d-flex align-items-center mb-3">
                <div>
                  <img src="./assets/img/about/mission.png" class="img-fluid me-3" alt="Mission Icon">
                </div>
                <div>
                  <h4>OUR MISSION</h4>
                </div>
              </div>
              <p><i class="bi bi-caret-right-fill"></i> To consistently provide premium-quality rice products by sourcing the finest grains and using advanced milling techniques to ensure customer satisfaction and trust.</p>
              <p><i class="bi bi-caret-right-fill"></i> To support the agricultural community by empowering farmers and encouraging sustainable farming practices that benefit both people and the planet.</p>
              <p><i class="bi bi-caret-right-fill"></i> To deliver fresh, hygienic, and affordable rice varieties that enhance the daily lives of our consumers.</p>
            </div>
          </div>

          <!-- Vision -->
          <div class="col-lg-6 col-md-12 d-flex mt-3" data-aos="flip-left" data-aos-delay="200">
            <div class="vission-left">
              <div class="vission-head d-flex align-items-center mb-3">
                <div>
                  <img src="./assets/img/about/vission.png" class="img-fluid me-3" alt="Vision Icon">
                </div>
                <div>
                  <h4>OUR VISION</h4>
                </div>
              </div>
              <p><i class="bi bi-caret-right-fill"></i> To become the most trusted and recognized rice mill in the region, known for superior quality, innovation, and commitment to sustainability.</p>
              <p><i class="bi bi-caret-right-fill"></i> To expand our product range while maintaining high standards of excellence, catering to a diverse customer base locally and internationally.</p>
              <p><i class="bi bi-caret-right-fill"></i> To drive growth in the agricultural sector by creating opportunities, uplifting farming communities, and contributing to rural development.</p>
            </div>
          </div>

        </div>
      </div>
    </section>






  </main>




  <!-- footer -->
  <?php include('footer.php'); ?>

</body>

</html>