<?php
$currentPage = basename($_SERVER['PHP_SELF']);
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta content="width=device-width, initial-scale=1.0" name="viewport">
    <title>Revathi Mills</title>

    <!-- Favicons -->
    <link href="assets/img/favicon.png" rel="icon">
    <link href="assets/img/apple-touch-icon.png" rel="apple-touch-icon">

    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,400,600,700|Roboto:300,400,500,700|Poppins:300,400,500,600,700" rel="stylesheet">

    <!-- Vendor CSS -->
    <link href="assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
    <link href="assets/vendor/bootstrap-icons/bootstrap-icons.css" rel="stylesheet">
    <link href="assets/vendor/aos/aos.css" rel="stylesheet">
    <link href="assets/vendor/animate.css/animate.min.css" rel="stylesheet">

    <!-- Main CSS -->
    <link href="assets/css/style.css" rel="stylesheet">
    <link href="assets/css/responsive limit with px.css" rel="stylesheet">


    <!-- jQuery (Must come first) -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <!-- Owl Carousel CSS -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.carousel.min.css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.theme.default.min.css" />

    <!-- Owl Carousel JS -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/owl.carousel.min.js"></script>
    <!-- AOS CSS -->
    <link href="https://cdn.jsdelivr.net/npm/aos@2.3.4/dist/aos.css" rel="stylesheet">
    <!-- Font Awesome CDN -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">



</head>

<body>

    <!-- Cursor elements -->
    <div class="cursor-dot"></div>
    <div class="cursor-circle"></div>

    <style>

    </style>






    <!-- Preloader -->
    <!-- <div class="custom-preloader">
        <div class="custom-dots">
            <div class="custom-dot"></div>
            <div class="custom-dot"></div>
            <div class="custom-dot"></div>
            <div class="custom-dot"></div>
            <div class="custom-dot"></div>
        </div>
    </div> -->

    <!-- click to top btn -->
    <button id="scrollTopBtn" class="btn btn-success scroll-top-btn">
        <i class="bi bi-arrow-up-short"></i>
    </button>




    <!-- Top Bar -->
    <div class="container">

        <div class="top-bar py-2">
            <div class="container d-flex justify-content-center justify-content-lg-between align-items-center flex-wrap  text-center">

                <div class="top-welcome">
                    <p class="mb-0">Welcome to Revathi Modern Rice Mill LLP</p>
                </div>

                <div class="d-flex align-items-center top-message flex-wrap gap-2">
                    <p class="mb-0"><i class="bi bi-clock me-1"></i> Open 24/7 – Monday to Sunday</p>
                    <span class="top-line">|</span>
                    <span><i class="bi bi-telephone me-1"></i> 24/7 Call Support</span>
                </div>

            </div>
        </div>

    </div>

    <!-- Main Header -->
    <header class="main-header container-fluid shadow-sm">
        <div class="container">
            <nav class="navbar navbar-expand-lg navbar-light">

                <a class="navbar-brand" href="index.php">
                    <img src="assets/image/revathi-rice-mill.png" class="img-fluid" alt="Logo">
                </a>

                <button class="navbar-toggler" type="button" data-bs-toggle="offcanvas" data-bs-target="#offcanvasMenu">
                    <i class="bi bi-list fs-2"></i>
                </button>

                <div class="collapse navbar-collapse justify-content-center">
                    <ul class="navbar-nav mb-2 mb-lg-0">
                        <li class="nav-item">
                            <a class="nav-link <?= ($currentPage == 'index.php') ? 'active' : '' ?>" href="index.php">Home</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?= ($currentPage == 'about.php') ? 'active' : '' ?>" href="about.php">About</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?= ($currentPage == 'certificate.php') ? 'active' : '' ?>" href="certificate.php">Certificate</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?= ($currentPage == 'products.php') ? 'active' : '' ?>" href="products.php">Products</a>
                        </li>

                        <li class="nav-item">
                            <a class="nav-link <?= ($currentPage == 'recipes.php') ? 'active' : '' ?>" href="recipes.php">Recipes</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?= ($currentPage == 'contact.php') ? 'active' : '' ?>" href="contact.php">Contact</a>
                        </li>
                    </ul>
                </div>

                <div class="d-none d-lg-flex align-items-center">
                    <div class="vr mx-3"></div>
                    <div class="call-info d-flex align-items-center">
                        <a href="tel:+919944173377"><i class="bi bi-telephone-forward-fill"></i> Call Anytime: +91-99441 73377</a>
                    </div>
                </div>
            </nav>
        </div>
    </header>


    <!-- Offcanvas Mobile Menu -->
    <div class="offcanvas offcanvas-start" tabindex="-1" id="offcanvasMenu">
        <div class="offcanvas-header">
            <a href="index.php"> <img src="./assets/image/revathi-rice-mill.png" class="img-fluid" alt=""></a>
            <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas"></button>

        </div>
        <div class="offcanvas-body">
            <ul class="navbar-nav">
                <li class="nav-item">
                    <a class="nav-link <?= ($currentPage == 'index.php') ? 'active' : '' ?>" href="index.php">
                        <i class="bi bi-house-door-fill me-1"></i> Home
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?= ($currentPage == 'about.php') ? 'active' : '' ?>" href="about.php">
                        <i class="bi bi-person-lines-fill me-1"></i> About
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?= ($currentPage == 'certificate.php') ? 'active' : '' ?>" href="certificate.php">
                        <i class="bi bi-award-fill me-1"></i> Certificate
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?= ($currentPage == 'products.php') ? 'active' : '' ?>" href="products.php">
                        <i class="bi bi-box-seam me-1"></i> Products
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?= ($currentPage == 'recipes.php') ? 'active' : '' ?>" href="recipes.php">
                        <i class="bi bi-egg-fried me-1"></i> Recipes
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?= ($currentPage == 'contact.php') ? 'active' : '' ?>" href="contact.php">
                        <i class="bi bi-telephone-fill me-1"></i> Contact
                    </a>
                </li>
            </ul>

            <hr>
            <div class="offcanvas-contact mt-auto pt-3 ">
                <p class="mb-1 "> <a href="tel:+919944173377"> <i class="bi bi-telephone-fill me-1"> </i> +91 99441 73377 </a></p>
                <p class="mb-1 "> <a href="mailto:revathiricemill@gmail.com​"><i class="bi bi-envelope-fill me-2"></i> </i> revathiricemill@gmail.com​ </a></p>
                <p class="mb-2 "> <a href="#"><i class="bi bi-geo-alt-fill me-1"></i>
                        34-A/2 Revathi Modern Rice Mill Attur Main Road​ Ayothiapattinam ​Salem - 636103
                    </a> </p>

                <div class="d-flex justify-content-start gap-3 mt-4">
                    <a href="#" class="text-dark"><i class="bi bi-facebook fs-5"></i></a>
                    <a href="#" class="text-dark"><i class="bi bi-instagram fs-5"></i></a>
                    <a href="#" class="text-dark"><i class="bi bi-twitter-x fs-5"></i></a>
                    <a href="#" class="text-dark"><i class="bi bi-whatsapp fs-5"></i></a>
                </div>
            </div>
        </div>
    </div>


    <!-- Scripts -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/aos@2.3.4/dist/aos.js"></script>

    <script>
        AOS.init({
            duration: 1000,
            offset: 100,
            once: true
        });

        window.addEventListener('scroll', function() {
            const header = document.querySelector('.main-header');
            if (window.scrollY > 20) {
                header.classList.add('scrolled');
            } else {
                header.classList.remove('scrolled');
            }
        });
    </script>

    <!-- perloader -->
    <script>
        window.addEventListener('load', function() {
            setTimeout(() => {
                const preloader = document.querySelector('.custom-preloader');
                if (preloader) {
                    preloader.style.opacity = '0';
                    preloader.style.transition = 'opacity 0.5s ease';
                    setTimeout(() => preloader.style.display = 'none', 500);
                }
            }, 1200);
        });
    </script>

    <!-- click to top btn -->
    <script>
        // Show button when page is scrolled
        window.addEventListener('scroll', function() {
            const btn = document.getElementById('scrollTopBtn');
            if (window.scrollY > window.innerHeight) {
                btn.style.display = 'block';
            } else {
                btn.style.display = 'none';
            }
        });

        // Scroll to top on click
        document.getElementById('scrollTopBtn').addEventListener('click', function() {
            window.scrollTo({
                top: 0,
                behavior: 'smooth'
            });
        });
    </script>

    <!-- pointer -->
    <script>
        document.addEventListener('DOMContentLoaded', () => {
            const cursorDot = document.querySelector('.cursor-dot');
            const cursorCircle = document.querySelector('.cursor-circle');


            document.addEventListener('mousemove', (e) => {

                cursorDot.style.left = `${e.clientX}px`;
                cursorDot.style.top = `${e.clientY}px`;


                setTimeout(() => {
                    cursorCircle.style.left = `${e.clientX}px`;
                    cursorCircle.style.top = `${e.clientY}px`;
                }, 100);
            });


            document.addEventListener('click', () => {
                cursorCircle.style.transform = 'translate(-50%, -50%) scale(0.8)';
                setTimeout(() => {
                    cursorCircle.style.transform = 'translate(-50%, -50%) scale(1)';
                }, 100);
            });


            const interactiveElements = document.querySelectorAll('a, button, .interactive');
            interactiveElements.forEach(el => {
                el.addEventListener('mouseenter', () => {
                    cursorCircle.style.width = '25px';
                    cursorCircle.style.height = '25px';
                    cursorCircle.style.borderColor = 'rgba(25, 135, 84, 0.4)';
                });
                el.addEventListener('mouseleave', () => {
                    cursorCircle.style.width = '20px';
                    cursorCircle.style.height = '20px';
                    cursorCircle.style.borderColor = 'rgba(25, 135, 84, 0.4)';
                });
            });
        });
    </script>


</body>
