<?php
$jsonData = file_get_contents('./jsons/product.json');
$data = json_decode($jsonData, true);

// Initialize arrays
$premiumProducts = [];
$BrokenProducts = [];
$OtherProducts = [];

// Loop through all categories once
foreach ($data['category'] as $category) {
  switch ($category['name']) {
    case 'Premium Rice':
      $premiumProducts = $category['products'];
      break;
    case 'Broken Rice':
      $BrokenProducts = $category['products'];
      break;
    case 'Other':
      $OtherProducts = $category['products'];
      break;
  }
}

// Get product counts
$premiumCount = count($premiumProducts);
$BrokenCount = count($BrokenProducts);
$OtherCount = count($OtherProducts);
?>

<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">

  <title>Revathi Mills</title>

  <style>
    .inner-product {
      background-image: none !important;
    }

    .about-content {
      color: #000 !important;
    }

    .product-head p {
      color: #000 !important;
    }
  </style>
  <!-- Bootstrap 5 JS Bundle (includes Popper.js) -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
  <!-- Bootstrap 5 CSS -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

</head>

<body>

  <!-- header -->
  <?php include('header.php'); ?>


  <main id="main">

    <section class="hero-banner">
      <div class="banner-container">
        <div class="banner-image">
          <img src="./assets/image/banner/sub-banner-4.png" alt="About Us" class="banner-img">
          <div class="gradient-overlay"></div>
        </div>

        <div class="banner-content">
          <h1 class="banner-title">Our Product</h1>
          <div class="animated-line"></div>
        </div>

        <div class="particle particle-1"></div>
        <div class="particle particle-2"></div>
        <div class="particle particle-3"></div>
      </div>
    </section>


    <section id="title-sec01" class="title-sec01">
      <div class="container" data-aos="fade-up">
        <div class="row gx-0">
          <div class="col-lg-12 d-flex flex-column justify-content-center" data-aos="fade-up" data-aos-delay="200">
            <div class="content">
              <h1 class="main-title01">Discover Our <span class="text-success">Products</span></h1>
            </div>
          </div>
        </div>
      </div>
    </section>


    <!-- product section -->
    <section>
      <div class="product-detail-inner">
        <div class="container-fluid">


          <div class="row align-items-start position-relative">
            <!-- Mobile Dropdown OUTSIDE sidebar -->
            <div class="dropdown mb-3 d-block d-md-none">
              <button
                class="btn btn-light border dropdown-toggle w-100 text-start"
                type="button"
                id="categoryDropdown"
                data-bs-toggle="dropdown"
                aria-expanded="false">
                <img src="./assets/image/icons/rice.png" class="img-fluid me-2" alt="">
                <span id="dropdownLabel">Premium Rice</span>
              </button>
              <ul class="dropdown-menu w-100 shadow-sm" aria-labelledby="categoryDropdown">
                <li>
                  <a class="dropdown-item tab-link" href="#" data-target="#tab-premium" data-name="Premium Rice">
                    <img src="./assets/image/icons/rice.png" class="img-fluid me-2" alt="">
                    Premium Rice
                  </a>
                </li>
                <li>
                  <a class="dropdown-item tab-link" href="#" data-target="#tab-broken" data-name="Broken Rice">
                    <img src="./assets/image/icons/rice.png" class="img-fluid me-2" alt="">
                    Broken Rice
                  </a>
                </li>
                <li>
                  <a class="dropdown-item tab-link" href="#" data-target="#tab-other" data-name="Other Collections">
                    <img src="./assets/image/icons/rice.png" class="img-fluid me-2" alt="">
                    Other Collections
                  </a>
                </li>
              </ul>
            </div>

            <!-- Sidebar -->
            <div class="col-lg-3 col-md-4 mb-4 position-sticky" style="top: 20px;">
              <div class="sidebar">
                <h5 class="mb-3">Categories</h5>

                <!-- Vertical nav for desktop -->
                <nav class="nav flex-column nav-pills me-3 d-none d-md-flex">
                  <button class="nav-link tab-link active" type="button" data-target="#tab-premium">
                    <img src="./assets/image/icons/rice.png" class="img-fluid me-2" alt="">
                    Premium Rice
                  </button>
                  <button class="nav-link tab-link" type="button" data-target="#tab-broken">
                    <img src="./assets/image/icons/rice.png" class="img-fluid me-2" alt="">
                    Broken Rice
                  </button>
                  <button class="nav-link tab-link" type="button" data-target="#tab-other">
                    <img src="./assets/image/icons/rice.png" class="img-fluid me-2" alt="">
                    Other Collections
                  </button>
                </nav>


              </div>
            </div>

            <!-- Right Content Area -->
            <div class="col-lg-9 col-md-8">
              <div class="tab-content">

                <!-- Premium Rice -->
                <div id="tab-premium" class="tab-pane show active">
                  <div class="product-controls-container">
                    <div class="product-controls">
                      <div class="category-header">
                        <h5 id="categoryTitle">
                          <span class="category-icon"><i class="bi bi-stars"></i></span>
                          <span class="category-name">Premium Rice</span>
                          <span class="product-count">(<?php echo $premiumCount; ?> product<?php echo $premiumCount > 1 ? 's' : ''; ?>)</span>
                        </h5>
                      </div>
                      <div class="controls-right">
                        <!-- Search Bar -->
                        <div class="search-container">
                          <i class="bi bi-search search-icon"></i>
                          <input type="text" class="search-input" placeholder="Search by name, type...">
                          <button class="search-clear"><i class="bi bi-x-lg"></i></button>
                        </div>
                      </div>
                    </div>
                  </div>

                  <!-- Grid View -->
                  <div class="row mt-4">
                    <?php foreach ($premiumProducts as $index => $product) { ?>
                      <div class="col-lg-4 col-md-6 col-sm-6 col-sx-6 d-flex justify-content-center mb-4 premium d-flex">
                        <div class="product-cards p-3 rounded shadow-sm flex-full border w-100">
                          <div class="product-card-img mb-2">
                            <img src="<?php echo htmlspecialchars($product['image']); ?>" class="img-fluid" alt="<?php echo htmlspecialchars($product['name']); ?>">
                          </div>
                          <h6><?php echo htmlspecialchars($product['name']); ?></h6>
                          <p><?php echo htmlspecialchars($product['rice']); ?></p>
                          <div class="d-flex justify-content-end align-items-end">
                            <a class="read-btn btn btn-sm btn-outline-primary view-details-btn"
                              data-bs-toggle="modal"
                              data-bs-target="#productModal"
                              data-product-index="<?php echo $index; ?>"
                              data-dataset="premium">
                              <i class="bi bi-arrow-right-short"></i> View Details
                            </a>

                          </div>
                          <?php if (!empty($product['badge'])): ?>
                            <div class="card-overlay">
                              <p><?php echo htmlspecialchars($product['badge']); ?></p>
                            </div>
                          <?php endif; ?>
                        </div>
                      </div>
                    <?php } ?>
                  </div>
                </div>

                <!-- Broken Rice -->
                <div id="tab-broken" class="tab-pane">
                  <div class="product-controls-container">
                    <div class="product-controls">
                      <div class="category-header">
                        <h5 id="categoryTitle">
                          <span class="category-icon"><i class="bi bi-stars"></i></span>
                          <span class="category-name">Broken Rice</span>
                          <span class="product-count">(<?php echo $BrokenCount; ?> product<?php echo $BrokenCount > 1 ? 's' : ''; ?>)</span>
                        </h5>
                      </div>
                      <div class="controls-right">
                        <!-- Search Bar -->
                        <div class="search-container">
                          <i class="bi bi-search search-icon"></i>
                          <input type="text" class="search-input" placeholder="Search by name, type...">
                          <button class="search-clear"><i class="bi bi-x-lg"></i></button>
                        </div>
                      </div>
                    </div>
                  </div>

                  <!-- Grid View -->
                  <div class="row mt-4">
                    <?php foreach ($BrokenProducts as $index => $product) { ?>
                      <div class="col-lg-4 col-md-6 col-sm-6 col-sx-6 d-flex justify-content-center mb-4 premium d-flex">
                        <div class="product-cards p-3 rounded shadow-sm flex-full border w-100">
                          <div class="product-card-img mb-2">
                            <img src="<?php echo htmlspecialchars($product['image']); ?>" class="img-fluid" alt="<?php echo htmlspecialchars($product['name']); ?>">
                          </div>
                          <h6><?php echo htmlspecialchars($product['name']); ?></h6>
                          <!-- <p><?php echo htmlspecialchars($product['rice']); ?></p> -->
                          <div class="d-flex justify-content-end align-items-end">
                            <a class="read-btn btn btn-sm btn-outline-primary view-details-btn"
                              data-bs-toggle="modal"
                              data-bs-target="#productModal"
                              data-product-index="<?php echo $index; ?>"
                              data-dataset="broken">
                              <i class="bi bi-arrow-right-short"></i> View Details
                            </a>

                          </div>
                          <?php if (!empty($product['badge'])): ?>
                            <div class="card-overlay">
                              <p><?php echo htmlspecialchars($product['badge']); ?></p>
                            </div>
                          <?php endif; ?>
                        </div>
                      </div>
                    <?php } ?>
                  </div>
                </div>

                <!-- Other Collections -->
                <div id="tab-other" class="tab-pane">
                  <div class="product-controls-container">
                    <div class="product-controls">
                      <div class="category-header">
                        <h5 id="categoryTitle">
                          <span class="category-icon"><i class="bi bi-stars"></i></span>
                          <span class="category-name">Other Collections</span>
                          <span class="product-count">(<?php echo $OtherCount; ?> product<?php echo $BrokenCount > 1 ? 's' : ''; ?>)</span>
                        </h5>
                      </div>
                      <div class="controls-right">
                        <!-- Search Bar -->
                        <div class="search-container">
                          <i class="bi bi-search search-icon"></i>
                          <input type="text" class="search-input" placeholder="Search by name, type...">
                          <button class="search-clear"><i class="bi bi-x-lg"></i></button>
                        </div>
                      </div>
                    </div>
                  </div>

                  <!-- Grid View -->
                  <div class="row mt-4">
                    <?php foreach ($OtherProducts as $index => $product) { ?>
                      <div class="col-lg-4 col-md-6 col-sm-6 col-sx-6 d-flex justify-content-center mb-4 premium d-flex">
                        <div class="product-cards p-3 rounded shadow-sm flex-full border w-100">
                          <div class="product-card-img mb-2">
                            <img src="<?php echo htmlspecialchars($product['image']); ?>" class="img-fluid" alt="<?php echo htmlspecialchars($product['name']); ?>">
                          </div>
                          <h6><?php echo htmlspecialchars($product['name']); ?></h6>
                          <!-- <p><?php echo htmlspecialchars($product['rice']); ?></p> -->
                          <div class="d-flex justify-content-end align-items-end">
                            <a class="read-btn btn btn-sm btn-outline-primary view-details-btn"
                              data-bs-toggle="modal"
                              data-bs-target="#productModal"
                              data-product-index="<?php echo $index; ?>"
                              data-dataset="other">
                              <i class="bi bi-arrow-right-short"></i> View Details
                            </a>

                          </div>
                          <?php if (!empty($product['badge'])): ?>
                            <div class="card-overlay">
                              <p><?php echo htmlspecialchars($product['badge']); ?></p>
                            </div>
                          <?php endif; ?>
                        </div>
                      </div>
                    <?php } ?>
                  </div>
                </div>

              </div>
            </div>
          </div>


        </div>
      </div>
      </div>
    </section>


    <!-- Product Modal -->
    <div class="modal fade" id="productModal" tabindex="-1" aria-labelledby="productModalLabel" aria-hidden="true">
      <div class="modal-dialog modal-dialog-centered modal-xl custom-modal">
        <div class="modal-content border-0 shadow-lg">

          <!-- Modal Close Button -->
          <div class="modal-header border-0 position-absolute top-0 end-0 z-1">
            <button type="button" class="btn-close bg-white p-2 rounded-circle shadow-sm" data-bs-dismiss="modal" aria-label="Close"></button>
          </div>

          <!-- Modal Body -->
          <div class="modal-body p-4 p-lg-5">
            <div class="row g-4">

              <!-- Product Image -->
              <div class="col-lg-6 col-md-12 ">
                <div class="zoom-container d-flex justify-content-center">
                  <img id="modalProductImage" src="" alt="Product Image" class="zoom-img img-fluid">
                </div>
              </div>


              <!-- Product Details -->
              <div class="col-lg-6 col-md-12">
                <div class="product-details">

                  <!-- Name & Category -->
                  <div class="d-flex justify-content-between align-items-start mb-2">
                    <h2 id="modalProductName" class="fw-bold"></h2>
                    <span class="badge bg-success bg-opacity-10 text-success fs-6" id="modalProductCategory"></span>
                  </div>

                  <!-- Rating -->
                  <div class="rating mb-2">
                    <div id="modalProductRating" class="stars d-inline-block me-2 fs-5 text-warning"></div>
                    <span class="text-muted" id="modalProductRatingText"></span>
                  </div>

                  <!-- Price & Stock -->
                  <div class="price-container mb-3">
                    <span class="price h3 fw-bold text-dark" id="modalProductPrice"></span>
                    <span class="badge bg-success bg-opacity-10 text-success ms-2" id="modalProductStock"></span>
                  </div>

                  <!-- Description -->
                  <p class="product-description mb-4" id="modalProductDescription"></p>

                  <!-- Specs Grid -->
                  <div class="specs-grid mb-4" id="modalProductSpecs">
                    <!-- Specs will be inserted dynamically -->
                  </div>

                  <!-- Highlights -->
                  <div class="highlights mb-4">
                    <h5 class="fw-semibold mb-3">Product Highlights</h5>
                    <ul class="list-unstyled ps-3" id="modalProductHighlights">
                      <!-- Highlights will be inserted dynamically -->
                    </ul>
                  </div>

                  <!-- Enquiry Button -->
                  <div class="d-flex justify-content-end">
                    <a href="tel:+919876543210" class="read-btn btn btn-primary">
                      <i class="bi bi-telephone-fill me-1"></i> Get Enquiry
                    </a>
                  </div>

                </div>
              </div>

            </div>
          </div>

        </div>
      </div>
    </div>



  </main>

  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

  <!-- footer -->
  <?php include('footer.php') ?>


  <!-- image zoom -->
  <script>
    const zoomContainer = document.querySelector('.zoom-container');
    const zoomImg = document.querySelector('.zoom-img');

    zoomContainer.addEventListener('mousemove', function(e) {
      const {
        left,
        top,
        width,
        height
      } = zoomContainer.getBoundingClientRect();
      const x = ((e.clientX - left) / width) * 100;
      const y = ((e.clientY - top) / height) * 100;

      zoomImg.style.transformOrigin = `${x}% ${y}%`;
      zoomImg.style.transform = 'scale(1.5)';
    });

    zoomContainer.addEventListener('mouseleave', function() {
      zoomImg.style.transformOrigin = 'center center';
      zoomImg.style.transform = 'scale(1)';
    });
  </script>

  <!-- product tab link -->
  <script>
    document.addEventListener('DOMContentLoaded', function() {
      const tabLinks = document.querySelectorAll('.tab-link');
      const tabPanes = document.querySelectorAll('.tab-pane');
      const dropdownLabel = document.querySelector('#dropdownLabel');

      tabLinks.forEach(link => {
        link.addEventListener('click', function(e) {
          e.preventDefault();

          tabLinks.forEach(l => l.classList.remove('active'));
          this.classList.add('active');

          tabPanes.forEach(pane => pane.classList.remove('show', 'active'));

          const targetId = this.getAttribute('data-target');
          const targetPane = document.querySelector(targetId);
          if (targetPane) {
            targetPane.classList.add('show', 'active');
          }

          if (this.getAttribute('data-name')) {
            dropdownLabel.textContent = this.getAttribute('data-name');
          }

          const dropdownToggle = document.getElementById('categoryDropdown');
          if (dropdownToggle.classList.contains('show')) {
            dropdownToggle.click();
          }
        });
      });
    });
  </script>

  <!-- popup modal -->
  <script>
    const productsData = <?php echo json_encode($premiumProducts); ?>;
    const productsData1 = <?php echo json_encode($BrokenProducts); ?>;
    const productsData2 = <?php echo json_encode($OtherProducts); ?>;

    document.addEventListener("DOMContentLoaded", function() {
      const viewButtons = document.querySelectorAll(".view-details-btn");

      viewButtons.forEach(button => {
        button.addEventListener("click", function() {
          const index = parseInt(this.getAttribute("data-product-index"), 10);
          const dataset = this.getAttribute("data-dataset"); // premium, broken, or other

          let product = null;

          if (dataset === "premium" && productsData[index]) {
            product = productsData[index];
          } else if (dataset === "broken" && productsData1[index]) {
            product = productsData1[index];
          } else if (dataset === "other" && productsData2[index]) {
            product = productsData2[index];
          }

          if (product) {
            // Update Modal Content
            document.getElementById("modalProductImage").src = product.image || "";
            document.getElementById("modalProductImage").alt = product.name || "";

            document.getElementById("modalProductName").textContent = product.name || "N/A";
            document.getElementById("modalProductCategory").textContent = product.title || "Category";

            const ratingContainer = document.getElementById("modalProductRating");
            const fullStars = Math.floor(product.rating || 0);
            const halfStar = (product.rating % 1) >= 0.5 ? 1 : 0;
            const emptyStars = 5 - fullStars - halfStar;

            ratingContainer.innerHTML =
              "★".repeat(fullStars) +
              (halfStar ? "½" : "") +
              "☆".repeat(emptyStars);

            document.getElementById("modalProductRatingText").textContent = `${product.rating || 0} / 5`;
            document.getElementById("modalProductPrice").textContent = product.price || "Price not available";
            document.getElementById("modalProductStock").textContent = product.stock || "Stock info unavailable";
            document.getElementById("modalProductDescription").textContent = product.description || "";

            // Specs
            const specsContainer = document.getElementById("modalProductSpecs");
            specsContainer.innerHTML = "";
            if (product.specs && Array.isArray(product.specs)) {
              product.specs.forEach(spec => {
                specsContainer.innerHTML += `
                <div class="spec-item">
                  <p class="spec-header">
                    <strong><i class="bi ${spec.icon || ""} me-1"></i> ${spec.label}</strong>
                  </p>
                  <p class="spec-value mb-0">${spec.value}</p>
                </div>`;
              });
            }

            // Highlights
            const highlightsContainer = document.getElementById("modalProductHighlights");
            highlightsContainer.innerHTML = "";
            if (product.highlights && Array.isArray(product.highlights)) {
              product.highlights.forEach(highlight => {
                highlightsContainer.innerHTML += `
                <li class="highlight-item">
                  <strong>${highlight.label}:</strong> ${highlight.value}
                </li>`;
              });
            }
          } else {
            console.warn("Product not found for dataset:", dataset, "index:", index);
          }
        });
      });
    });
  </script>



</body>