<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">

  <title>Revathi Mills</title>
  <meta content="" name="description">
  <meta content="" name="keywords">

  <link href="assets/img/footer-logo.png" rel="icon" />


  <!-- Google Fonts -->
  <link
    href="https://fonts.googleapis.com/css?family=Open+Sans:300,300i,400,400i,600,600i,700,700i|Roboto:300,300i,400,400i,500,500i,600,600i,700,700i|Poppins:300,300i,400,400i,500,500i,600,600i,700,700i"
    rel="stylesheet">

  <!-- Vendor CSS Files -->
  <link href="assets/vendor/fontawesome-free/css/all.min.css" rel="stylesheet">
  <link href="assets/vendor/animate.css/animate.min.css" rel="stylesheet">
  <link href="assets/vendor/aos/aos.css" rel="stylesheet">
  <link href="assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
  <link href="assets/vendor/bootstrap-icons/bootstrap-icons.css" rel="stylesheet">
  <link href="assets/vendor/boxicons/css/boxicons.min.css" rel="stylesheet">
  <link href="assets/vendor/glightbox/css/glightbox.min.css" rel="stylesheet">
  <link href="assets/vendor/swiper/swiper-bundle.min.css" rel="stylesheet">

  <link rel="stylesheet" href="assets/slider/animate.min.css">
  <link rel="stylesheet" href="assets/slider/owl.carousel.min.css">
  <link rel="stylesheet" href="assets/slider/owl.theme.default.css">
  <link rel="stylesheet" href="assets/slider/slider.css">
  <link rel="stylesheet" href="assets/slider/lightbox.min.css">

  <!--  Main CSS File -->
  <link href="assets/css/style.css" rel="stylesheet">
  <link href="assets/css/responsive limit with px.css" rel="stylesheet">


</head>

<body>

  <!-- header -->
  <?php include('header.php'); ?>

  <main id="main">

    
    <section class="hero-banner">
      <div class="banner-container">
        <div class="banner-image">
          <img src="./assets/image/banner/sub-banner-1.jpg" alt="About Us" class="banner-img">
          <div class="gradient-overlay"></div>
        </div>

        <div class="banner-content">
          <h1 class="banner-title">About Our Company</h1>
          <div class="animated-line"></div>
        </div>

        <div class="particle particle-1"></div>
        <div class="particle particle-2"></div>
        <div class="particle particle-3"></div>
      </div>
    </section>


    <!-- about  us section -->
    <section id="title-sec01" class="title-sec01">
      <div class="container" data-aos="fade-up">
        <div class="row gx-0">
          <div class="col-lg-12 d-flex flex-column justify-content-center" data-aos="fade-up" data-aos-delay="200">
            <div class="content">
              <h1 class="main-title01">about us</h1>
            </div>

            <div class="row">
              <div class=" col-lg-4 col-md-6 col-sm-12 d-flex justify-content-center align-items-center">
                <div class="">
                  <img src="./assets/img/about/about.png" class="img-fluid" alt="">
                </div>

              </div>
              <div class="col-lg-8 col-md-6 col-sm-12 mt-5">
                <div class="about-right">
                  <h2><span>Revathi Mills </span> <br>Empowering Agriculture, Enriching Kitchens Since 1997 </h2>

                  <p> <i class="bi bi-caret-right"></i> Ms Revathi Modern Rice Mill, Salem has transformed into Limited Liability Partnership named after
                    its brand name "REVATHI" in 1997. Now Revathi Mill manufactures over 10+ varieties of Rice.
                    Revathi Brand gives value addition to the agricultural products which helps and encourages the
                    farming community to market their produces. Furthermore, they generate a lot of employment
                    opportunities to the agricultural labours and rural people.</p>

                  <p><i class="bi bi-caret-right"></i> The customers of Revathi Brand are the house wives and those who need easy and quick cooking solutions.
                    Restaurants, hostels, hotels, canteens are the other prominent consumers. ​</p>

                  <div class="mt-4">
                    <a href="products.php" class="read-btn">Discover More <i class="bi bi-caret-right-fill"></i></a>
                  </div>
                </div>

              </div>
            </div>
          </div>
        </div>
      </div>
    </section>


    <!-- reason for choseing us -->
    <section class="benefits-section" data-aos="fade-up" data-aos-delay="200">
      <div class="container">
        <div class="row">
          <div class=" col-lg-6 col-md-12 col-sm-12 d-flex justify-content-center align-items-center">

            <img src="./assets/img/about/benefits.webp" class="img-fluid benefits-img" alt="">
          </div>

          <div class="col-lg-6 col-md-12 col-sm-12 d-flex justify-content-center align-items-center">
            <div class="benefits-right ">
              <h2 class="text-black about-content">Benefits of choosing <span class="text-success succ1"> Revathi Mills</span></h2>

              <div class="benefits-card">
                <div>
                  <img src="./assets/img/icons/control-system.png" class="img-fluid" alt="">
                </div>
                <div>
                  <h3>Sourcing and Quality Control</h3>
                  <p><i class="bi bi-arrow-right-short"></i> At Revathi Mills, we meticulously source premium rice varieties from trusted farmers and suppliers. Our rigorous quality control measures ensure that only the highest grade rice reaches our customers, guaranteeing freshness, purity, and superior taste with every grain.</p>
                </div>
              </div>

              <div class="benefits-card">
                <div>
                  <img src="./assets/img/icons/coffee-bag.png" class="img-fluid" alt="">
                </div>
                <div>
                  <h3>Packaging Perfection</h3>
                  <p> <i class="bi bi-arrow-right-short"></i> We utilize advanced packaging techniques designed to preserve the natural aroma and texture of our rice. Our packaging not only meets international quality and safety standards but also offers convenience and aesthetic appeal to ensure a delightful customer experience.</p>
                </div>
              </div>

            </div>
          </div>

          <div class="col-lg-6">
            <div class="benefits-card">
              <div>
                <img src="./assets/img/icons/customer-centricity.png" class="img-fluid" alt="">
              </div>
              <div>
                <h3>Customer-Centric Approach</h3>
                <p><i class="bi bi-arrow-right-short"></i> At Revathi Mills, our customers are at the heart of everything we do. We strive to provide exceptional support and personalized solutions tailored to your specific requirements. Our dedicated team works closely with you to understand your needs, ensuring that every interaction is smooth and satisfactory.</p>
              </div>
            </div>
          </div>
          <div class="col-lg-6">
            <div class="benefits-card">
              <div>
                <img src="./assets/img/icons/identities.png" class="img-fluid" alt="">
              </div>
              <div>
                <h3>Sourcing and Quality Control</h3>
                <p><i class="bi bi-arrow-right-short"></i> We are committed to continuously improving our processes through innovation and the adoption of sustainable practices. By embracing eco-friendly methods and cutting-edge technologies, we aim to minimize our environmental impact while maintaining the highest quality standards.</p>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>


    <!-- vission and mission -->
    <section class="vission-section">
      <div class="container">
        <div class="row">
          <div class="col-lg-6 col-md-12 d-flex mt-3" data-aos="flip-right" data-aos-delay="200">
            <div class="vission-left">
              <div class="vission-head d-flex align-items-center mb-3">
                <div><img src="./assets/img/about/mission.png" class="img-fluid me-3" alt="Mission Icon"></div>
                <div>
                  <h4>OUR MISSION</h4>
                </div>
              </div>
              <p><i class="bi bi-caret-right-fill"></i> To consistently provide premium quality rice products by sourcing the best grains and employing advanced milling techniques, ensuring customer satisfaction and trust.</p>
              <p><i class="bi bi-caret-right-fill"></i> To support the agricultural community by empowering farmers and promoting sustainable farming practices that benefit both people and the environment.</p>
              <p><i class="bi bi-caret-right-fill"></i> To deliver fresh, hygienic, and affordable rice varieties that enrich the lives of our consumers.</p>
            </div>
          </div>

          <div class="col-lg-6 col-md-12 d-flex mt-3" data-aos="flip-left" data-aos-delay="200">
            <div class="vission-left">
              <div class="vission-head d-flex align-items-center mb-3">
                <div><img src="./assets/img/about/vission.png" class="img-fluid me-3" alt="Vision Icon"></div>
                <div>
                  <h4>OUR VISION</h4>
                </div>
              </div>
              <p><i class="bi bi-caret-right-fill"></i> To become the most trusted and recognized rice mill in the region, known for superior quality and commitment to innovation and sustainability.</p>
              <p><i class="bi bi-caret-right-fill"></i> To expand our product range while maintaining high standards of excellence, catering to diverse customer needs locally and globally.</p>
              <p><i class="bi bi-caret-right-fill"></i> To foster growth and prosperity in the agricultural sector by creating opportunities and uplifting farming communities.</p>
            </div>
          </div>
        </div>
      </div>
    </section>





  </main>




  <!-- footer -->
  <?php include('footer.php'); ?>

</body>

</html>