<head>
  <!-- jQuery (Must come first) -->
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

  <!-- Owl Carousel CSS -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.carousel.min.css" />
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.theme.default.min.css" />

  <!-- Owl Carousel JS -->
  <script src="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/owl.carousel.min.js"></script>
  <!-- AOS CSS -->
  <link href="https://cdn.jsdelivr.net/npm/aos@2.3.4/dist/aos.css" rel="stylesheet">

</head>

<body>
  <!-- header -->
  <?php include('header.php'); ?>

  <main>


    <!-- home carousel -->
    <section>
      <div class="carousel-section">
        <div class="container-fluid">
          <div class="owl-carousel owl-theme custom-owl">

            <!-- Slide 2 -->
            <div class="item">
              <img src="assets/image/banner/banner-8.webp" alt="Slide 1">
            </div>

            <!-- Slide 3 -->
            <div class="item">
              <img src="assets/image/banner/banner-7.webp" alt="Slide 1">
            </div>
    
            <!-- <div class="item">
              <img src="assets/image/banner/banner-5.webp" alt="Slide 1">
            </div>
            <div class="item">
              <img src="assets/image/banner/banner-6.webp" alt="Slide 1">
            </div> -->

          </div>

          <div class="custom-pagination">
            <span id="customPage"><strong>1</strong>/2</span>
          </div>
        </div>
      </div>

    </section>

    <!-- product section -->
    <section>
      <div class="inner-home-product">
        <div class="container">

          <div class="product-section">

            <div class="row">

              <div class="col-lg-4 d-flex">

                <div class="product-head d-flex flex-column justify-content-center align-items-start">
                  <h2 class="about-content">Our<span class="text-success succ1"> Product </span></h2>
                  <p>Finest Quality Rice, Straight From Our Mill</p>
                </div>

              </div>

              <div class="col-lg-8">

                <div class="product-menu">

                  <div class="tab-link active" data-target="tab1">
                    <img src="./assets/image/icons/icon-3.png" alt="Egg And Cucumber">
                    <p>Premium Rice</p>
                  </div>

                  <div class="tab-link" data-target="tab2">
                    <img src="./assets/image/icons/icon-2.png" alt="Chicken Fried Rice">
                    <p>Broken Rice</p>
                  </div>

                  <div class="tab-link" data-target="tab3">
                    <img src="./assets/image/icons/icon-1.png" alt="Chicken Leg Piece">
                    <p>Other Collections</p>
                  </div>

                </div>
              </div>
            </div>


            <div class="product-content active" id="tab1">

              <div class="container position-relative">

                <div id="primium-product" class="primium-product owl-carousel owl-theme">

                  <div class="item">
                    <div class="product-card">
                      <div class="d-flex justify-content-center position-relative">
                        <img src="assets/image/product/img-5.png" class="img-fluid" alt="Product 1">
                        <div class="product-img-overlay">
                          <h3>Top Seller</h3>
                        </div>
                      </div>
                      <h5>Revathi Khichadi</h5>
                      <p>Soft, broken rice ideal for khichadi and light meals. Cooks quickly and tastes delicious.</p>

                      <a href="products.php">View Details <i class="bi bi-arrow-right-short"></i></a>
                    </div>
                  </div>

                  <div class="item">
                    <div class="product-card">
                      <div class="d-flex justify-content-center position-relative">
                        <img src="assets/image/product/img-6.png" class="img-fluid" alt="Product 1">
                        <div class="product-img-overlay">
                          <h3>Best Quality</h3>
                        </div>
                      </div>
                      <h5>Revathi Premium</h5>
                      <p>High-quality, long-grain rice perfect for daily use with excellent taste and aroma.</p>
                      <a href="products.php">View Details <i class="bi bi-arrow-right-short"></i></a>

                    </div>
                  </div>

                  <div class="item">
                    <div class="product-card">
                      <div class="d-flex justify-content-center">
                        <img src="assets/image/product/img-7.png" class="img-fluid" alt="Product 1">
                      </div>
                      <h5>Revathi Malligai</h5>
                      <p>Jasmine-scented rice with soft texture, ideal for traditional South Indian meals.</p>
                      <a href="products.php">View Details <i class="bi bi-arrow-right-short"></i></a>

                    </div>
                  </div>

                  <div class="item">
                    <div class="product-card">
                      <div class="d-flex justify-content-center">
                        <img src="assets/image/product/img-8.png" class="img-fluid" alt="Product 1">
                      </div>
                      <h5>Rajabhogam Ponni Rice</h5>
                      <p>Rich-textured Ponni rice, perfect for steaming and authentic South Indian dishes.</p>
                      <a href="products.php">View Details <i class="bi bi-arrow-right-short"></i></a>

                    </div>
                  </div>

                </div>



                <button class="primium-btn prev-btn position-absolute top-50 start-0 translate-middle-y">
                  <i class="bi bi-arrow-left-short"></i>
                </button>
                <button class="primium-btn next-btn position-absolute top-50 end-0 translate-middle-y">
                  <i class="bi bi-arrow-right-short"></i>
                </button>

              </div>

            </div>

            <div class="product-content" id="tab2">

              <div class="container position-relative">

                <div id="primium-product" class="primium-product owl-carousel owl-theme">

                  <div class="item">
                    <div class="product-card">
                      <div class="d-flex justify-content-center position-relative">
                        <img src="assets/image/product/img-1.webp" class="img-fluid" alt="Product 1">
                        <div class="product-img-overlay">
                          <h3>Top Seller</h3>
                        </div>
                      </div>
                      <h5>White Ponni Kurunai</h5>
                      <p>Finely broken white Ponni rice, ideal for porridge, tiffin items, and quick, soft meals.</p>
                      <a href="products.php">View Details <i class="bi bi-arrow-right-short"></i></a>

                    </div>
                  </div>

                  <div class="item">
                    <div class="product-card">
                      <div class="d-flex justify-content-center">
                        <img src="assets/image/product/img-2.webp" class="img-fluid" alt="Product 1">
                      </div>
                      <h5>Rajabogam Khicadi Ponni</h5>
                      <p>A premium-quality broken rice, perfect for soft khichadi and nutritious, easily digestible meals.</p>
                      <a href="products.php">View Details <i class="bi bi-arrow-right-short"></i></a>

                    </div>
                  </div>

                  <div class="item">
                    <div class="product-card">
                      <div class="d-flex justify-content-center position-relative">
                        <img src="assets/image/product/img-3.webp" class="img-fluid" alt="Product 1">
                        <div class="product-img-overlay">
                          <h3>Best Product</h3>
                        </div>
                      </div>
                      <h5>Malligai Ponni Kurunai</h5>
                      <p>Fragrant broken rice with a soft texture, great for light South Indian dishes and porridge.</p>
                      <a href="products.php">View Details <i class="bi bi-arrow-right-short"></i></a>

                    </div>
                  </div>

                  <div class="item">
                    <div class="product-card">
                      <div class="d-flex justify-content-center position-relative">
                        <img src="assets/image/product/img-4.webp" class="img-fluid" alt="Product 1">
                      </div>
                      <h5>Revathi Khichadi Kurunai</h5>
                      <p>Specially milled rice for khichadi, offering consistent softness and flavor in every meal.</p>
                      <a href="products.php">View Details <i class="bi bi-arrow-right-short"></i></a>

                    </div>
                  </div>

                </div>

                <!-- Navigation Buttons -->
                <button class="primium-btn prev-btn position-absolute top-50 start-0 translate-middle-y">
                  <i class="bi bi-arrow-left-short"></i>
                </button>
                <button class="primium-btn next-btn position-absolute top-50 end-0 translate-middle-y">
                  <i class="bi bi-arrow-right-short"></i>
                </button>

              </div>


            </div>

            <div class="product-content" id="tab3">

              <div class="container position-relative">

                <div id="primium-product" class="primium-product owl-carousel owl-theme">

                  <div class="item">
                    <div class="product-card">
                      <div class="d-flex justify-content-center">
                        <img src="assets/image/product/img-1.webp" class="img-fluid" alt="Rice Bran">
                      </div>
                      <h5>Rice Bran (தவுடி)</h5>
                      <p>Used for oil extraction and cattle feed, rich in nutrients.</p>
                      <a href="products.php">View Details <i class="bi bi-arrow-right-short"></i></a>

                    </div>
                  </div>

                  <div class="item">
                    <div class="product-card">
                      <div class="d-flex justify-content-center">
                        <img src="assets/image/product/img-2.webp" class="img-fluid" alt="Black Rice">
                      </div>
                      <h5>Black Rice (கருப்பு கவுனி)</h5>
                      <p>Healthy, fiber-rich rice known for its natural black color.</p>
                      <a href="products.php">View Details <i class="bi bi-arrow-right-short"></i></a>

                    </div>
                  </div>

                  <div class="item">
                    <div class="product-card">
                      <div class="d-flex justify-content-center">
                        <img src="assets/image/product/img-3.webp" class="img-fluid" alt="Broken Rice Seeds">
                      </div>
                      <h5>Broken Rice Seed (உடைந்த விதை)</h5>
                      <p>Ideal for poultry feed and flour making.</p>
                      <a href="products.php">View Details <i class="bi bi-arrow-right-short"></i></a>

                    </div>
                  </div>

                  <div class="item">
                    <div class="product-card">
                      <div class="d-flex justify-content-center">
                        <img src="assets/image/product/img-2.webp" class="img-fluid" alt="Immature Paddy">
                      </div>
                      <h5>Immature Paddy (கருக்காய்)</h5>
                      <p>Used in animal feed and rice flour processing.</p>
                      <a href="products.php">View Details <i class="bi bi-arrow-right-short"></i></a>

                    </div>
                  </div>

                  <div class="item">
                    <div class="product-card">
                      <div class="d-flex justify-content-center">
                        <img src="assets/image/product/img-3.webp" class="img-fluid" alt="Bran Broken Rice">
                      </div>
                      <h5>Bran Broken Rice (தவுடு குறுநை)</h5>
                      <p>Commonly used for cattle feed and industrial needs.</p>
                      <a href="products.php">View Details <i class="bi bi-arrow-right-short"></i></a>

                    </div>
                  </div>

                </div>


                <button class="primium-btn prev-btn position-absolute top-50 start-0 translate-middle-y">
                  <i class="bi bi-arrow-left-short"></i>
                </button>
                <button class="primium-btn next-btn position-absolute top-50 end-0 translate-middle-y">
                  <i class="bi bi-arrow-right-short"></i>
                </button>

              </div>


            </div>

          </div>

        </div>

        <div class="product-vector-overlay">
          <img src="./assets/image/icons/vector-1.png" class="img-fluid" alt="">
        </div>
      </div>
    </section>

    <!-- scrole section -->
    <div class="scrolling-ticker-wrapper">
      <div class="scrolling-ticker">
        <div class="ticker-track">
          <!-- First Set -->
          <div class="ticker-item">
            <div class="ticker-icon"><i class="bi bi-clock-fill"></i></div>
            <span class="ticker-text">24/7 Service Way Bridge</span>
          </div>
          <div class="ticker-item">
            <div class="ticker-icon"><i class="bi bi-shop"></i></div>
            <span class="ticker-text">24/7 Retail Services</span>
          </div>
          <div class="ticker-item">
            <div class="ticker-icon"><i class="bi bi-award-fill"></i></div>
            <span class="ticker-text">High Quality Products</span>
          </div>
          <div class="ticker-item">
            <div class="ticker-icon"><i class="bi bi-people-fill"></i></div>
            <span class="ticker-text">Customer Satisfaction Guaranteed</span>
          </div>
          <div class="ticker-item">
            <div class="ticker-icon"><i class="bi bi-truck"></i></div>
            <span class="ticker-text">Fast Nationwide Delivery</span>
          </div>

          <!-- Duplicate Set -->
          <div class="ticker-item">
            <div class="ticker-icon"><i class="bi bi-clock-fill"></i></div>
            <span class="ticker-text">24/7 Service Way Bridge</span>
          </div>
          <div class="ticker-item">
            <div class="ticker-icon"><i class="bi bi-shop"></i></div>
            <span class="ticker-text">24/7 Retail Services</span>
          </div>
          <div class="ticker-item">
            <div class="ticker-icon"><i class="bi bi-award-fill"></i></div>
            <span class="ticker-text">High Quality Products</span>
          </div>
          <div class="ticker-item">
            <div class="ticker-icon"><i class="bi bi-people-fill"></i></div>
            <span class="ticker-text">Customer Satisfaction Guaranteed</span>
          </div>
          <div class="ticker-item">
            <div class="ticker-icon"><i class="bi bi-truck"></i></div>
            <span class="ticker-text">Fast Nationwide Delivery</span>
          </div>
        </div>
      </div>

      <!-- Gradient overlays -->
      <div class="ticker-overlay left"></div>
      <div class="ticker-overlay right"></div>
    </div>

    <!-- package section -->
    <section class="rice-section">
      <div class="container">

        <div class="row align-items-center">

          <div class="col-xl-6 col-lg-6 col-md-12">
            <div class="product-info">
              <h2 class="text-black Choose-content">Our <span class="text-success succ1">Packages</span></h2>

              <p class="lead-text">
                <i class="bi bi-arrow-right-short"></i> Custom packaging options designed to preserve freshness and meet your branding needs.
              </p>

              <div class="dynamic-content" id="dynamicContent">
                <div class="content-item active" data-packaging="jute">
                  <p><i class="bi bi-caret-right-fill"></i> Eco-friendly <strong>Jute Bags</strong> made from natural fibers, perfect for sustainable branding. Available in 5kg, 10kg, and 25kg sizes with premium stitching.</p>
                  <div class="product-features">
                    <div class="feature-item">
                      <div class="feature-icon">♻️</div>
                      <span>Biodegradable & reusable</span>
                    </div>
                    <div class="feature-item">
                      <div class="feature-icon">🌿</div>
                      <span>Natural moisture control</span>
                    </div>
                  </div>
                </div>

                <div class="content-item" data-packaging="bopp">
                  <p><i class="bi bi-caret-right-fill"></i> Premium <strong>BOPP Bags</strong> with high-barrier protection against moisture and pests. Ideal for long-term storage and transport.</p>
                  <div class="product-features">
                    <div class="feature-item">
                      <div class="feature-icon">🛡️</div>
                      <span>100% airtight seal</span>
                    </div>
                    <div class="feature-item">
                      <div class="feature-icon">🖨️</div>
                      <span>Vibrant printing options</span>
                    </div>
                  </div>
                </div>

                <div class="content-item" data-packaging="nonwoven">
                  <p><i class="bi bi-caret-right-fill"></i> Durable <strong>Non-Woven Bags</strong> combining strength and lightweight convenience. Custom branding with woven handles for retail appeal.</p>
                  <div class="product-features">
                    <div class="feature-item">
                      <div class="feature-icon">💪</div>
                      <span>Reinforced stress points</span>
                    </div>
                    <div class="feature-item">
                      <div class="feature-icon">👜</div>
                      <span>Retail-ready handles</span>
                    </div>
                  </div>
                </div>
              </div>

              <div class="thumbnail-nav">
                <div class="thumbnail-item active"
                  data-packaging="jute"
                  data-image="./assets/image/packages/stage-1.png "
                  onclick="changePackage(this)">
                  <img src="./assets/image/packages/mockup-1.png" alt="Jute Bag">
                  <span>Jute Bags</span>
                </div>

                <div class="thumbnail-item"
                  data-packaging="bopp"
                  data-image="./assets/image/packages/stage-2.png"
                  onclick="changePackage(this)">
                  <img src="./assets/image/packages/mockup-2.png" alt="BOPP Bag">
                  <span>BOPP Bags</span>
                </div>

                <div class="thumbnail-item"
                  data-packaging="nonwoven"
                  data-image="./assets/image/packages/stage-3.png"
                  onclick="changePackage(this)">
                  <img src="./assets/image/packages/mockup-3.png" alt="Non-Woven Bag">
                  <span>Non-Woven</span>
                </div>
              </div>
            </div>
          </div>

          <div class="col-xl-6 col-lg-6 col-md-12 mt-3">
            <div class="product-gallery">
              <img src="./assets/image/packages/mockup-1.png"
                alt="Jute Bag Packaging"
                class="main-image active"
                id="mainImage">
            </div>
          </div>
        </div>

      </div>

      <div class="rice-overlay">
        <img src="./assets/image/icons/Vector.png" class="imf-fluid" alt="">
      </div>
    </section>

    <!-- rice section -->
    <section>
      <div class="inner-rice" id="rice-category">
        <div class="container">

          <div class="head-rice">
            <div class="rice-head">
              <h2 class="about-content">Our <span class="text-success succ1">Rice Categories</span></h2>
              <p>Handpicked varieties to match every recipe, taste, and tradition.</p>
            </div>
            <div class="rice-thumbnail-controls  mb-3">
              <button id="prevBtn" class="btn btn-outline-success me-2"><i class="bi bi-arrow-left-short"></i></button>
              <button id="nextBtn" class="btn btn-outline-success"><i class="bi bi-arrow-right-short"></i></button>
            </div>
          </div>


          <div class="timeline-carousel">

            <div class="rice-thumbnail-nav">



              <div class="rice-thumbnail active" data-tooltip="Basmati Rice" data-year="rice1">
                <img src="./assets/image/rice/rice-1.png" alt="Basmati Rice">
                <div class="rice-tooltip">Revathi Premium</div>

              </div>
              <div class="rice-thumbnail" data-tooltip="Sona Masoori" data-year="rice2">
                <img src="./assets/image/rice/rice-2.png" alt="Sona Masoori">
                <div class="rice-tooltip">Broken Rice</div>

              </div>
              <div class="rice-thumbnail active" data-tooltip="Basmati Rice" data-year="rice3">
                <img src="./assets/image/rice/rice-3.png" alt="Basmati Rice">
                <div class="rice-tooltip">Revathi Malligai</div>

              </div>
              <div class="rice-thumbnail" data-tooltip="Sona Masoori" data-year="rice4">
                <img src="./assets/image/rice/rice-4.png" alt="Sona Masoori">
                <div class="rice-tooltip">Rajabhogam Ponni Rice</div>

              </div>



            </div>

            <div class="rice-gallery">

              <div class="rice-card" data-type="rice1">
                <div class="rice-inner">
                  <div class="row align-items-center">
                    <div class="col-lg-6">
                      <div class="rice-left">
                        <h2 class="rice-title">Revathi Premium</h2>
                        <p class="rice-desc">
                          Experience the richness of tradition and taste with <strong>Revathi Premium Rice</strong>. Carefully selected and expertly milled, this rice offers unmatched purity, aroma, and texture — perfect for daily meals or festive feasts.
                        </p>

                        <ul class="rice-features">
                          <li>Long, slender grains with a natural shine</li>
                          <li>Naturally aged for enhanced aroma and fluffiness</li>
                          <li>Ideal for biryanis, pulao, and traditional South Indian dishes</li>
                        </ul>

                        <div class="mt-4">
                          <a href="Products.php" class="read-btn">Explore Now <i class="bi bi-arrow-right-short"></i></a>
                        </div>
                      </div>

                    </div>
                    <div class="col-lg-6 text-center">
                      <div class="rice-right">
                        <img src="./assets/image/rice/img-1.png" class="img-fluid rounded" alt="White Ponni Kurunai">
                      </div>
                    </div>
                  </div>
                </div>
              </div>


              <div class="rice-card" data-type="rice2">
                <div class="rice-inner">
                  <div class="row align-items-center">
                    <div class="col-lg-6">
                      <div class="rice-left">
                        <h2 class="rice-title">Rajabogam Khichdi Ponni</h2>
                        <p class="rice-desc">
                          Specially curated for traditional Indian dishes, <strong>Rajabogam Khichdi Ponni Rice</strong> offers a soft texture, quick cooking time, and rich nutritional value — making it the perfect choice for khichdi, pongal, and everyday meals.
                        </p>

                        <ul class="rice-features">
                          <li>Medium-grain rice ideal for soft, creamy preparations</li>
                          <li>Cooks quickly and evenly for hassle-free cooking</li>
                          <li>Retains shape and absorbs flavors beautifully</li>
                          <li>Naturally processed with no added chemicals</li>
                        </ul>

                        <div class="mt-4">
                          <a href="Products.php" class="read-btn">Explore Now <i class="bi bi-arrow-right-short"></i></a>
                        </div>
                      </div>

                    </div>
                    <div class="col-lg-6 text-center">
                      <div class="rice-right">
                        <img src="./assets/image/rice/img-2.png" class="img-fluid rounded" alt="Rajabogam Khichdi Ponni">
                      </div>
                    </div>
                  </div>
                </div>
              </div>

              <div class="rice-card" data-type="rice3">
                <div class="rice-inner">
                  <div class="row align-items-center">
                    <div class="col-lg-6">
                      <div class="rice-left">
                        <h2 class="rice-title">Revathi Malligai</h2>
                        <p class="rice-desc">
                          Known for its delicate aroma and fluffy texture, <strong>Revathi Malligai Rice</strong> is the perfect choice for everyday meals. This short-grain variety cooks quickly and blends beautifully with South Indian dishes, delivering taste and comfort in every bite.
                        </p>

                        <ul class="rice-features">
                          <li>Soft and fluffy texture — ideal for daily cooking</li>
                          <li>Mild, jasmine-like aroma for a pleasant dining experience</li>
                          <li>Cooks evenly and absorbs flavors perfectly</li>
                        </ul>

                        <div class="mt-4">
                          <a href="Products.php" class="read-btn">Explore Now <i class="bi bi-arrow-right-short"></i></a>
                        </div>
                      </div>

                    </div>
                    <div class="col-lg-6 text-center">
                      <div class="rice-right">
                        <img src="./assets/image/rice/img-3.png" class="img-fluid rounded" alt="Malligai Ponni Kurunai">
                      </div>
                    </div>
                  </div>
                </div>
              </div>


              <div class="rice-card" data-type="rice4">
                <div class="rice-inner">
                  <div class="row align-items-center">
                    <div class="col-lg-6">
                      <div class="rice-left">
                        <h2 class="rice-title">Revathi Khichdi Kurunai</h2>
                        <p class="rice-desc">
                          Crafted for wholesome comfort, <strong>Revathi Khichdi Kurunai</strong> is a coarsely broken rice variety ideal for preparing soft, nourishing dishes. Its texture and quick cooking nature make it a favorite for pongal, khichdi, and baby food.
                        </p>

                        <ul class="rice-features">
                          <li>Coarse-grain rice perfect for soft-textured meals</li>
                          <li>Cooks quickly and easily — no soaking required</li>
                          <li>Rich in nutrients and easily digestible</li>
                          <li>Ideal for traditional South Indian dishes and light diets</li>
                        </ul>

                        <div class="mt-4">
                          <a href="Products.php" class="read-btn">Explore Now <i class="bi bi-arrow-right-short"></i></a>
                        </div>
                      </div>

                    </div>
                    <div class="col-lg-6 text-center">
                      <div class="rice-right">
                        <img src="./assets/image/rice/img-4.png" class="img-fluid rounded" alt="Revathi Khichdi Kurunai">
                      </div>
                    </div>
                  </div>
                </div>
              </div>

            </div>
          </div>
        </div>


        <div class="rive-overlay">
          <img src="./assets/image/icons/vector-2.png" class="img-fluid" alt="">
        </div>

        <div class="rive-overlay1">
          <img src="./assets/image/home/why-overlay.png" class="img-fluid" alt="">
        </div>
      </div>
    </section>

    <!-- way bridge -->
    <section class="way-bridge-section">
      <div class="container">
        <!-- Header Structure -->
        <div class="section-header">
          <div class="title-wrapper">
          </div>

        </div>


        <div class="row">
          <div class="col-lg-6 col-md-12 mt-4">
            <div class="left-bridge">
              <h2 class="about-content">The <span class="text-success succ1">Way Bridge</span></h2>
              <p>
                <i class="bi bi-arrow-right-short"></i>
                At <strong>Revathi Modern Rice Mill LLP</strong>, the <strong>Way Bridge</strong> is more than just infrastructure — it represents our round-the-clock commitment to precision, transparency, and efficiency in every grain. With a fully operational <strong>24/7 digital weighbridge</strong>, we ensure accurate measurements, real-time data tracking, and smooth logistics from farm to facility.
              </p>

              <ul class="bridge-points mt-3">
                <li>
                  <i class="bi bi-clock-history point-icon"></i>
                  <div class="point-text">24/7 fully automated weighbridge access</div>
                </li>
                <li>
                  <i class="bi bi-award point-icon"></i>
                  <div class="point-text">Consistent quality with zero compromise</div>
                </li>
                <li>
                  <i class="bi bi-cpu-fill point-icon"></i>
                  <div class="point-text">Advanced digital tracking & integration</div>
                </li>
                <li>
                  <i class="bi bi-shield-check point-icon"></i>
                  <div class="point-text">Comprehensive quality checks & standards</div>
                </li>
                <li>
                  <i class="bi bi-building-gear point-icon"></i>
                  <div class="point-text">Modern rice milling backed by smart logistics</div>
                </li>
              </ul>
            </div>

          </div>
          <div class="col-lg-6  col-md-12 mt-4">

            <div id="way-bridge" class="owl-carousel custom-dots">
              <div class="item active"><img src="./assets/image/home/img-1.png" alt="Slide 1"></div>
              <div class="item"><img src="./assets/image/home/img-1.png" alt="Slide 2"></div>
              <div class="item"><img src="./assets/image/home/img-1.png" alt="Slide 3"></div>
            </div>


          </div>
        </div>

      </div>

    </section>

    <!-- why choose section -->
    <section>
      <div class="inner-why-choose">

        <div class="container">
          <div class="row">
            <div class="col-lg-5 col-sm-12 order-sm-2 d-flex justify-content-center align-items-center">
              <img src="./assets/img/Group 85.png" class="img-fluid choose-img" alt="" style="max-width: 100%; height: auto;">
            </div>

            <div class="col-lg-7 col-sm-12 cc1 sm-order-1 md-order-2">
              <div class="why-choose-content">
                <h2 class="text-black Choose-content">Why <span class="text-success succ1">Choose us</span></h2>

                <div class="features-grid mt-4">

                  <div class="feature-card">

                    <div class="feature-text">
                      <h4> <i class="bi bi-award-fill"></i> Legacy of Quality & Trust</h4>
                      <p>Decades of experience in traditional rice processing with modern excellence.</p>
                    </div>
                  </div>

                  <div class="feature-card">

                    <div class="feature-text">
                      <h4> <i class="bi bi-cpu-fill"></i> Tradition Meets Technology</h4>
                      <p>Buhler Sortex German Technology preserves natural aroma and nutrition.</p>
                    </div>
                  </div>

                  <div class="feature-card">

                    <div class="feature-text">
                      <h4> <i class="bi bi-box2-heart"></i> Premium Raw Materials</h4>
                      <p>Finest paddy processed in hygienic environments for unmatched quality.</p>
                    </div>
                  </div>

                  <div class="feature-card">

                    <div class="feature-text">
                      <h4> <i class="bi bi-fire"></i> Easy Cooking, Rich Flavor</h4>
                      <p>Perfect for modern lifestyles without compromising traditional taste.</p>
                    </div>
                  </div>

                </div>

                <div class="mt-4">
                  <a href="about.php" class="read-btn">Know More <i class="bi bi-arrow-right-short"></i></a>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>


    </section>

    <!-- Gallery Section -->
    <section class="gallery-section">
      <div class="inner-gallery">

        <div class="container">

          <h2 class="text-black about-content">
            Revathi Mills <span class="text-success succ1" data-aos="fade-up" data-aos-delay="100">Gallery</span>
          </h2>

          <div class="row">
            <div class="col-12">

              <div class="filter-group d-flex flex-wrap gap-2 justify-content-center my-3">

                <a class="filter-btn read-btn active" onclick="filterGallery('all', event)">
                  <i class="bi bi-grid-fill me-1"></i> All
                </a>

                <a class="filter-btn read-btn" onclick="filterGallery('paddy-field', event)">
                  Paddy Field
                </a>

                <a class="filter-btn read-btn" onclick="filterGallery('rice', event)">
                  Rice
                </a>

                <a class="filter-btn read-btn" onclick="filterGallery('paddy', event)">
                  Paddy
                </a>

              </div>

            </div>

            <div class="col-lg-3 col-md-6 col-sm-12 mt-3 gallery-item paddy-field">
              <div class="gallery-card cursor-pointer" onclick="openModal(); currentSlide(1)">
                <img src="./assets/image/gallery/img-1.png" class="img-fluid" alt="" />
                <div class="gallery-overlay">

                </div>
              </div>
            </div>
            <div class="col-lg-3 col-md-6 col-sm-12 mt-3 gallery-item rice">
              <div class="gallery-card cursor-pointer" onclick="openModal(); currentSlide(5)">
                <img src="./assets/image/gallery/img-5.png" class="img-fluid" alt="Millets" />
                <div class="gallery-overlay">

                </div>
              </div>
            </div>


            <div class="col-lg-3 col-md-6 col-sm-12 mt-3 gallery-item paddy-field">
              <div class="gallery-card cursor-pointer" onclick="openModal(); currentSlide(3)">
                <img src="./assets/image/gallery/img-3.png" class="img-fluid" alt="Rice" />
                <div class="gallery-overlay">

                </div>
              </div>
            </div>

            <div class="col-lg-3 col-md-6 col-sm-12 mt-3 gallery-item paddy-field">
              <div class="gallery-card cursor-pointer" onclick="openModal(); currentSlide(4)">
                <img src="./assets/image/gallery/img-4.png" class="img-fluid" alt="Millets" />
                <div class="gallery-overlay">
                </div>
              </div>
            </div>

            <div class="col-lg-3 col-md-6 col-sm-12 mt-3 gallery-item rice">
              <div class="gallery-card cursor-pointer" onclick="openModal(); currentSlide(6)">
                <img src="./assets/image/gallery/img-6.png" class="img-fluid" alt="Millets" />
                <div class="gallery-overlay">

                </div>
              </div>
            </div>

            <div class="col-lg-3 col-md-6 col-sm-12 mt-3 gallery-item paddy">
              <div class="gallery-card cursor-pointer" onclick="openModal(); currentSlide(7)">
                <img src="./assets/image/gallery/img-7.png" class="img-fluid" alt="Millets" />
                <div class="gallery-overlay">
                </div>
              </div>
            </div>

            <div class="col-lg-3 col-md-6 col-sm-12 mt-3 gallery-item paddy">
              <div class="gallery-card cursor-pointer" onclick="openModal(); currentSlide(8)">
                <img src="./assets/image/gallery/img-8.png" class="img-fluid" alt="Millets" />
                <div class="gallery-overlay">

                </div>
              </div>
            </div>
            <div class="col-lg-3 col-md-6 col-sm-12 mt-3 gallery-item paddy-field">
              <div class="gallery-card cursor-pointer" onclick="openModal(); currentSlide(2)">
                <img src="./assets/image/gallery/img-2.png" class="img-fluid" alt="Rice" />
                <div class="gallery-overlay">

                </div>
              </div>
            </div>

            <div class="col-lg-3 col-md-6 col-sm-12 mt-3 gallery-item rice">
              <div class="gallery-card cursor-pointer" onclick="openModal(); currentSlide(9)">
                <img src="./assets/image/gallery/img-9.png" class="img-fluid" alt="Millets" />
                <div class="gallery-overlay">

                </div>
              </div>
            </div>

            <div class="col-lg-3 col-md-6 col-sm-12 mt-3 gallery-item paddy">
              <div class="gallery-card cursor-pointer" onclick="openModal(); currentSlide(10)">
                <img src="./assets/image/gallery/img-10.png" class="img-fluid" alt="Millets" />
                <div class="gallery-overlay">

                </div>
              </div>
            </div>

            <div class="col-lg-3 col-md-6 col-sm-12 mt-3 gallery-item rice">
              <div class="gallery-card cursor-pointer" onclick="openModal(); currentSlide(11)">
                <img src="./assets/image/gallery/img-11.png" class="img-fluid" alt="Millets" />
                <div class="gallery-overlay">

                </div>
              </div>
            </div>
            <div class="col-lg-3 col-md-6 col-sm-12 mt-3 gallery-item paddy">
              <div class="gallery-card cursor-pointer" onclick="openModal(); currentSlide(12)">
                <img src="./assets/image/gallery/img-12.png" class="img-fluid" alt="Millets" />
                <div class="gallery-overlay">

                </div>
              </div>
            </div>

          </div>
        </div>
      </div>
    </section>

    <!-- waybridge-section -->
    <script>
      $(document).ready(function() {
        $("#way-bridge").owlCarousel({
          items: 1,
          loop: true,
          dots: true,
          nav: false,
          autoplay: true,
          autoplayTimeout: 10000,
          autoplayHoverPause: true
        });
      });
    </script>

    <!-- product tab -->
    <script>
      const tabs = document.querySelectorAll('.tab-link');
      const contents1 = document.querySelectorAll('.product-content');

      tabs.forEach(tab => {
        tab.addEventListener('click', () => {
          tabs.forEach(el => el.classList.remove('active'));
          contents1.forEach(el => el.classList.remove('active'));

          tab.classList.add('active');
          document.getElementById(tab.getAttribute('data-target')).classList.add('active');
        });
      });
    </script>

    <!-- product carosel -->
    <script>
      $(document).ready(function() {
        var owl = $(".primium-product");
        owl.owlCarousel({
          loop: true,
          margin: 20,
          nav: false,
          dots: false,
          autoplay: false,
          autoplayTimeout: 3000,
          responsive: {
            0: {
              items: 1
            },
            768: {
              items: 2
            },
            1200: {
              items: 3
            }
          }
        });

        // Custom Nav
        $(".prev-btn").click(function() {
          owl.trigger("prev.owl.carousel");
        });
        $(".next-btn").click(function() {
          owl.trigger("next.owl.carousel");
        });
      });
    </script>

    <!-- product carousel -->
    <!-- <section>
      <div class="inner-product">
        <div class="container">
          <div class="product-head mb-4">
            <h2 class="about-content">Our<span class="text-success succ1"> Product </span></h2>
            <p>Finest Quality Rice, Straight From Our Mill</p>
          </div>

          <div class="owl-carousel owl-theme product-slider">
            
            <div class="item">
              <div class="product-card">
                <img src="assets/image/product/img-1.webp" class="img-fluid" alt="Product 1">
                <h5>White Ponni Kurunai</h5>
                <p>Finely broken white ponni rice, ideal for soft porridge and baby food.</p>
              </div>
            </div>
           
            <div class="item">
              <div class="product-card">
                <img src="assets/image/product/img-2.webp" class="img-fluid" alt="Product 1">
                <h5>Rajabogam Khichdi Ponni</h5>
                <p>Premium-quality ponni rice perfect for khichdi, soft-textured and easy to cook.</p>
              </div>
            </div>
            <div class="item">
              <div class="product-card">
                <img src="assets/image/product/img-3.webp" class="img-fluid" alt="Product 1">
                <h5>Malligai Ponni Kurunai</h5>
                <p>Fragrant broken malligai ponni rice, great for idli, dosa, or kanji.</p>
              </div>
            </div>
            <div class="item">
              <div class="product-card">
                <img src="assets/image/product/img-4.webp" class="img-fluid" alt="Product 1">
                <h5>Revathi Khichdi Kurunai</h5>
                <p>Light and soft Revathi variety, ideal for khichdi and traditional South Indian meals.</p>
              </div>
            </div>
            <div class="item">
              <div class="product-card">
                <img src="assets/image/product/img-5.png" class="img-fluid" alt="Product 1">
                <h5>Ponni Khichdi Samba</h5>
                <p>Medium-grain samba rice with ponni flavor, best suited for khichdi and pulao.</p>
              </div>
            </div>
            <div class="item">
              <div class="product-card">
                <img src="assets/image/product/img-6.png" class="img-fluid" alt="Product 1">
                <h5>Special White Ponni</h5>
                <p>High-quality white ponni rice, fluffy texture, perfect for daily South Indian meals.</p>
              </div>
            </div>
            <div class="item">
              <div class="product-card">
                <img src="assets/image/product/img-7.png" class="img-fluid" alt="Product 1">
                <h5>Rajabogam Malligai Ponni Rice</h5>
                <p>Aromatic blend of Rajabogam and Malligai Ponni, great for flavorful rice dishes.</p>
              </div>
            </div>
            <div class="item">
              <div class="product-card">
                <img src="assets/image/product/img-8.png" class="img-fluid" alt="Product 1">
                <h5>Rajabogam Ponni Rice</h5>
                <p>Premium-grade ponni rice known for its softness, taste, and excellent cooking quality.</p>
              </div>
            </div>

          </div>

       
          <div class="custom-nav">
            <button class="custom-prev"><i class="bi bi-chevron-left"></i></button>
            <button class="custom-next"><i class="bi bi-chevron-right"></i></button>
          </div>


        </div>


      </div>
    </section> -->



    <script>
      function filterGallery(category, event) {
        const items = document.querySelectorAll('.gallery-item');

        items.forEach(item => {
          if (category === 'all' || item.classList.contains(category)) {
            item.style.display = 'block';
          } else {
            item.style.display = 'none';
          }
        });

        // Update active state on filter buttons
        document.querySelectorAll('.filter-btn').forEach(btn => btn.classList.remove('active'));
        if (event) {
          event.currentTarget.classList.add('active');
        }
      }
    </script>

    <!-- Modal Popup -->
    <div id="myModal" class="modal">
      <span class="close" onclick="closeModal()">&times;</span>
      <div class="modal-content">
        <!-- Slides -->
        <div class="mySlides">
          <img src="./assets/img/gallery/img-1.png" alt="Gallery Image 1" />
        </div>
        <div class="mySlides">
          <img src="./assets/img/gallery/img-2.png" alt="Gallery Image 2" />
        </div>
        <!-- Slides -->
        <div class="mySlides">
          <img src="./assets/img/gallery/img-3.png" alt="Gallery Image 1" />
        </div>
        <div class="mySlides">
          <img src="./assets/img/gallery/img-4.png" alt="Gallery Image 2" />
        </div>
        <!-- Slides -->
        <div class="mySlides">
          <img src="./assets/img/gallery/img-5.png" alt="Gallery Image 1" />
        </div>
        <div class="mySlides">
          <img src="./assets/img/gallery/img-6.png" alt="Gallery Image 2" />
        </div>
        <!-- Slides -->
        <div class="mySlides">
          <img src="./assets/img/gallery/img-7.png" alt="Gallery Image 1" />
        </div>
        <div class="mySlides">
          <img src="./assets/img/gallery/img-8.png" alt="Gallery Image 2" />
        </div>
        <!-- <div class="mySlides">
          <img src="./assets/img/gallery/img-9.png" alt="Gallery Image 2" />
        </div> -->


        <!-- Navigation Buttons -->
        <a class="prev" onclick="plusSlides(-1)">&#10094;</a>
        <a class="next" onclick="plusSlides(1)">&#10095;</a>

        <!-- Image Count -->
        <div class="slide-number" id="slide-number">1 / 9</div>
      </div>
    </div>



    <!-- testimonial section -->
    <!-- <section class="testmonial-section">
      <div class="container-fluid">
        <div class="inner-testimonial">
          <div class="row">


            <div class="col-lg-7 col-md-12 mt-3">
              <div class="test-right d-flex flex-column justify-content-center h-100" data-aos="fade-up" data-aos-delay="100">
                <h2 class="text-black Choose-content" data-aos="fade-up" data-aos-delay="1500">Oru Client <span class="text-success succ1">Testimonials</span></h2>
                <p> Our clients trust Oru for quality, reliability, and service. Their feedback reflects our commitment to excellence in every project.</p>


                <div class="inner-carousel">
                  <div class="owl-carousel-wrapper">

                    <div class="owl-carousel custom-owl-carousel owl-theme" data-aos="fade-up" data-aos-delay="300">

                      <div class="item">
                        <div class="test-card">
                          <div class="star-rating">
                            <span class="star filled">&#9733;</span>
                            <span class="star filled">&#9733;</span>
                            <span class="star filled">&#9733;</span>
                            <span class="star">&#9733;</span>
                            <span class="star">&#9733;</span>
                          </div>
                          <div class="test-content">
                            <h4>Revathimills provided excellent service and quality products.
                              Their team is professional and always delivers on time.
                              Highly recommended!”</h4>
                            <p> <i class="bi bi-person-circle"></i> Anita Sharma</p>
                          </div>
                        </div>
                      </div>

                      <div class="item">
                        <div class="test-card">
                          <div class="star-rating">
                            <span class="star filled">&#9733;</span>
                            <span class="star filled">&#9733;</span>
                            <span class="star filled">&#9733;</span>
                            <span class="star">&#9733;</span>
                            <span class="star">&#9733;</span>
                          </div>
                          <div class="test-content">
                            <h4>Great experience working with Revathimills.
                              Their attention to detail and customer support is outstanding.
                              Truly a reliable partner.</h4>
                            <p> <i class="bi bi-person-circle"></i> Rajesh Kumar</p>
                          </div>
                        </div>
                      </div>

                      <div class="item">
                        <div class="test-card">
                          <div class="star-rating">
                            <span class="star filled">&#9733;</span>
                            <span class="star filled">&#9733;</span>
                            <span class="star filled">&#9733;</span>
                            <span class="star">&#9733;</span>
                            <span class="star">&#9733;</span>
                          </div>
                          <div class="test-content">
                            <h4>The product quality and timely delivery exceeded our expectations.
                              Revathimills is a trusted supplier we will continue working with</h4>
                            <p> <i class="bi bi-person-circle"></i> Vikram</p>
                          </div>
                        </div>
                      </div>

                      <div class="item">
                        <div class="test-card">
                          <div class="star-rating">
                            <span class="star filled">&#9733;</span>
                            <span class="star filled">&#9733;</span>
                            <span class="star filled">&#9733;</span>
                            <span class="star">&#9733;</span>
                            <span class="star">&#9733;</span>
                          </div>
                          <div class="test-content">
                            <h4>Excellent communication and top-notch quality.
                              Revathimills consistently meets our requirements
                              and supports us with great dedication.</h4>
                            <p> <i class="bi bi-person-circle"></i> Naveen</p>
                          </div>
                        </div>
                      </div>

                    </div>

                  </div>
                </div>


              </div>

            </div>

            <div class="col-lg-5 col-md-6 col-sm-12 mt-3 d-none d-lg-block" data-aos="fade-up" data-aos-delay="100">

              <div class="test-left d-flex justify-content-center align-items-center">
                <img src="./assets/img/gallery/testimonial.jpg" class="img-fluid" alt="">


              </div>

            </div>

          </div>

          <div class="test-overlay">
            <img src="./assets/img/gallery/test-overlay.png" class="img-fluid" alt="">
          </div>
        </div>

      </div>
      </div>
    </section> -->


    <!-- package carosle -->
    <script>
      let currentIndex = 0;
      let autoSlideInterval;

      const thumbnails = document.querySelectorAll('.thumbnail-item');
      const mainImage = document.getElementById('mainImage');
      const contents = document.querySelectorAll('.content-item');

      function changePackage(thumbnail) {
        const packagingType = thumbnail.getAttribute('data-packaging');
        const newImageSrc = thumbnail.getAttribute('data-image');


        thumbnails.forEach(item => item.classList.remove('active'));
        thumbnail.classList.add('active');

        contents.forEach(content => {
          content.classList.remove('active');
          if (content.getAttribute('data-packaging') === packagingType) {
            setTimeout(() => content.classList.add('active'), 10);
          }
        });

        mainImage.classList.remove('active');
        setTimeout(() => {
          mainImage.src = newImageSrc;
          mainImage.alt = thumbnail.querySelector('img').alt;
          mainImage.classList.add('active');
        }, 120);
      }

      function startAutoSlide() {
        autoSlideInterval = setInterval(() => {
          currentIndex = (currentIndex + 1) % thumbnails.length;
          changePackage(thumbnails[currentIndex]);
        }, 5000);
      }

      function stopAutoSlide() {
        clearInterval(autoSlideInterval);
      }

      thumbnails.forEach((thumb, index) => {
        thumb.addEventListener('click', () => {
          currentIndex = index;
          changePackage(thumb);
          stopAutoSlide();
          startAutoSlide();
        });
      });

      // Start auto slide on page load
      document.addEventListener('DOMContentLoaded', () => {
        changePackage(thumbnails[currentIndex]);
        startAutoSlide();
      });
    </script>



  </main>


  <!-- footer secction -->
  <?php include('footer.php'); ?>

  <!-- banner carousel -->
  <script>
    $(document).ready(function() {
      var totalSlides = $('.custom-owl .item').length;

      var owl = $(".custom-owl");
      owl.owlCarousel({
        items: 1,
        loop: true,
        autoplay: true,
        autoplayTimeout: 3000,
        autoplayHoverPause: true,
        dots: true,
        nav: false
      });

      owl.on('changed.owl.carousel', function(event) {
        var currentIndex = event.item.index - event.relatedTarget._clones.length / 2;
        if (currentIndex >= totalSlides) currentIndex = 0;
        if (currentIndex < 0) currentIndex = totalSlides - 1;

        $("#customPage").text((currentIndex + 1) + "/" + totalSlides);
      });

      // Initial set
      $("#customPage").text("1/" + totalSlides);
    });
  </script>


  <!-- product carousel -->
  <script>
    $(document).ready(function() {
      const owl = $(".product-slider");
      owl.owlCarousel({
        loop: true,
        margin: 20,
        autoplay: true,
        autoplayTimeout: 3000,
        nav: false,
        dots: false,
        responsive: {
          0: {
            items: 1
          },
          576: {
            items: 2
          },
          1200: {
            items: 3
          }
        }
      });

      // Custom Navigation Events
      $(".custom-next").click(function() {
        owl.trigger("next.owl.carousel");
      });
      $(".custom-prev").click(function() {
        owl.trigger("prev.owl.carousel");
      });
    });
  </script>

  <!-- rice js -->
  <script>
    document.addEventListener('DOMContentLoaded', () => {
      const section = document.getElementById('rice-category');
      const thumbnails = section.querySelectorAll('.rice-thumbnail');
      const riceCards = section.querySelectorAll('.rice-card');
      const prevBtn = document.getElementById('prevBtn');
      const nextBtn = document.getElementById('nextBtn');

      let currentIndex = 0;
      let autoSlide;

      function showCard(index) {
        thumbnails.forEach((thumb, i) => {
          thumb.classList.toggle('active', i === index);
        });

        riceCards.forEach(card => {
          const match = card.getAttribute('data-type') === thumbnails[index].getAttribute('data-year');
          card.style.display = match ? 'block' : 'none';
        });
      }

      function startAutoSlide() {
        autoSlide = setInterval(() => {
          currentIndex = (currentIndex + 1) % thumbnails.length;
          showCard(currentIndex);
        }, 16000);
      }

      function stopAutoSlide() {
        clearInterval(autoSlide);
      }

      thumbnails.forEach((thumb, index) => {
        thumb.addEventListener('click', () => {
          currentIndex = index;
          showCard(currentIndex);
          stopAutoSlide();
          startAutoSlide();
        });
      });

      if (prevBtn && nextBtn) {
        prevBtn.addEventListener('click', () => {
          currentIndex = (currentIndex - 1 + thumbnails.length) % thumbnails.length;
          showCard(currentIndex);
          stopAutoSlide();
          startAutoSlide();
        });

        nextBtn.addEventListener('click', () => {
          currentIndex = (currentIndex + 1) % thumbnails.length;
          showCard(currentIndex);
          // stopAutoSlide();
          // startAutoSlide();
        });
      }

      showCard(currentIndex);
      // startAutoSlide();  
    });
  </script>

  <script>
    document.addEventListener('DOMContentLoaded', () => {
      const section = document.getElementById('rice-category');
      const thumbnails = section.querySelectorAll('.rice-thumbnail');
      const riceCards = section.querySelectorAll('.rice-card');

      let currentIndex = 0;
      let autoSlide;

      function showCard(index) {
        thumbnails.forEach((thumb, i) => {
          thumb.classList.toggle('active', i === index);
        });

        riceCards.forEach(card => {
          const match = card.getAttribute('data-type') === thumbnails[index].getAttribute('data-year');
          card.style.display = match ? 'block' : 'none';
        });
      }

      function startAutoSlide() {
        autoSlide = setInterval(() => {
          currentIndex = (currentIndex + 1) % thumbnails.length;
          showCard(currentIndex);
        }, 16000);
      }

      function stopAutoSlide() {
        clearInterval(autoSlide);
      }

      thumbnails.forEach((thumb, index) => {
        thumb.addEventListener('click', () => {
          currentIndex = index;
          showCard(index);
          stopAutoSlide();
          startAutoSlide();
        });
      });

      showCard(currentIndex);
      // startAutoSlide(); 
    });
  </script>


  <!-- package carousel -->
  <script>
    $(document).ready(function() {
      $('.package-carousel').owlCarousel({
        loop: true,
        margin: 20,
        nav: false,
        dots: true,
        autoplay: true,
        autoplayTimeout: 3000,
        responsive: {
          0: {
            items: 1
          },
          768: {
            items: 1
          },
          992: {
            items: 1
          }
        }
      });
    });
  </script>

  <!-- custom-owl-carousel -->
  <script>
    $(document).ready(function() {
      $(".custom-owl-carousel").owlCarousel({
        loop: true,
        margin: 10,
        nav: false,
        dots: true,
        autoplay: true,
        autoplayTimeout: 4000,
        autoplayHoverPause: true,
        responsive: {
          0: {
            items: 1
          },
          768: {
            items: 2
          }
        }
      });
    });
  </script>

  <!-- slider -->
  <script>
    function openModal() {
      document.getElementById("myModal").style.display = "block";
    }

    function closeModal() {
      document.getElementById("myModal").style.display = "none";
    }

    let slideIndex = 1;
    showSlides(slideIndex);

    function plusSlides(n) {
      showSlides(slideIndex += n);
    }

    function currentSlide(n) {
      showSlides(slideIndex = n);
    }

    function showSlides(n) {
      const slides = document.getElementsByClassName("mySlides");
      const slideNumber = document.getElementById("slide-number");

      if (n > slides.length) {
        slideIndex = 1;
      }

      if (n < 1) {
        slideIndex = slides.length;
      }

      for (let i = 0; i < slides.length; i++) {
        slides[i].style.display = "none";
      }
      slides[slideIndex - 1].style.display = "block";

      slideNumber.textContent = `${slideIndex} / ${slides.length}`;
    }


    const modal = document.getElementById("myModal");
    modal.addEventListener("click", function(event) {
      if (event.target === modal) {
        closeModal();
      }
    });
  </script>

</body>