<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">

  <title>Revathi Mills</title>

  <style>
    .inner-product {
      background-image: none !important;
    }

    .about-content {
      color: #000 !important;
    }

    .product-head p {
      color: #000 !important;
    }
  </style>

</head>

<body>

  <!-- header -->
  <?php include('header.php'); ?>


  <main id="main">

    <section class="hero-banner">
      <div class="banner-container">
        <div class="banner-image">
          <img src="./assets/image/banner/sub-banner-4.png" alt="About Us" class="banner-img">
          <div class="gradient-overlay"></div>
        </div>

        <div class="banner-content">
          <h1 class="banner-title">Our Product</h1>
          <div class="animated-line"></div>
        </div>

        <div class="particle particle-1"></div>
        <div class="particle particle-2"></div>
        <div class="particle particle-3"></div>
      </div>
    </section>


    <section id="title-sec01" class="title-sec01">
      <div class="container" data-aos="fade-up">
        <div class="row gx-0">
          <div class="col-lg-12 d-flex flex-column justify-content-center" data-aos="fade-up" data-aos-delay="200">
            <div class="content">
              <h1 class="main-title01">Revathi Premium</h1>
            </div>
          </div>
        </div>
      </div>
    </section>

    <!-- product section -->
    <!-- product section -->
    <section>
      <div class="inner-home-product">
        <div class="container">

          <div class="product-section">

            <div class="row">

              <div class="col-lg-4 d-flex">

                <div class="product-head d-flex flex-column justify-content-center align-items-start">
                  <h2 class="about-content">Our<span class="text-success succ1"> Product </span></h2>
                  <p>Finest Quality Rice, Straight From Our Mill</p>
                </div>

              </div>

              <div class="col-lg-8">

                <div class="product-menu">

                  <div class="tab-link active" data-target="tab1">
                    <img src="./assets/image/icons/icon-3.png" alt="Egg And Cucumber">
                    <p>Premium Rice</p>
                  </div>

                  <div class="tab-link" data-target="tab2">
                    <img src="./assets/image/icons/icon-2.png" alt="Chicken Fried Rice">
                    <p>Broken Rice</p>
                  </div>

                  <div class="tab-link" data-target="tab3">
                    <img src="./assets/image/icons/icon-1.png" alt="Chicken Leg Piece">
                    <p>Other Collections</p>
                  </div>

                </div>
              </div>
            </div>


            <div class="product-content active" id="tab1">

              <div class="container position-relative">

                <div id="primium-product" class="primium-product owl-carousel owl-theme">

                  <div class="item">
                    <div class="product-card">
                      <div class="d-flex justify-content-center position-relative">
                        <img src="assets/image/product/img-5.png" class="img-fluid" alt="Product 1">
                        <div class="product-img-overlay">
                          <h3>Top Seller</h3>
                        </div>
                      </div>
                      <h5>Revathi Khichadi</h5>
                      <p>Soft, broken rice ideal for khichadi and light meals. Cooks quickly and tastes delicious.</p>

                      <a href="products.php">View Details <i class="bi bi-arrow-right-short"></i></a>
                    </div>
                  </div>

                  <div class="item">
                    <div class="product-card">
                      <div class="d-flex justify-content-center position-relative">
                        <img src="assets/image/product/img-6.png" class="img-fluid" alt="Product 1">
                        <div class="product-img-overlay">
                          <h3>Best Quality</h3>
                        </div>
                      </div>
                      <h5>Revathi Premium</h5>
                      <p>High-quality, long-grain rice perfect for daily use with excellent taste and aroma.</p>
                      <a href="products.php">View Details <i class="bi bi-arrow-right-short"></i></a>

                    </div>
                  </div>

                  <div class="item">
                    <div class="product-card">
                      <div class="d-flex justify-content-center">
                        <img src="assets/image/product/img-7.png" class="img-fluid" alt="Product 1">
                      </div>
                      <h5>Revathi Malligai</h5>
                      <p>Jasmine-scented rice with soft texture, ideal for traditional South Indian meals.</p>
                      <a href="products.php">View Details <i class="bi bi-arrow-right-short"></i></a>

                    </div>
                  </div>

                  <div class="item">
                    <div class="product-card">
                      <div class="d-flex justify-content-center">
                        <img src="assets/image/product/img-8.png" class="img-fluid" alt="Product 1">
                      </div>
                      <h5>Rajabhogam Ponni Rice</h5>
                      <p>Rich-textured Ponni rice, perfect for steaming and authentic South Indian dishes.</p>
                      <a href="products.php">View Details <i class="bi bi-arrow-right-short"></i></a>

                    </div>
                  </div>

                </div>



                <button class="primium-btn prev-btn position-absolute top-50 start-0 translate-middle-y">
                  <i class="bi bi-arrow-left-short"></i>
                </button>
                <button class="primium-btn next-btn position-absolute top-50 end-0 translate-middle-y">
                  <i class="bi bi-arrow-right-short"></i>
                </button>

              </div>

            </div>

            <div class="product-content" id="tab2">

              <div class="container position-relative">

                <div id="primium-product" class="primium-product owl-carousel owl-theme">

                  <div class="item">
                    <div class="product-card">
                      <div class="d-flex justify-content-center position-relative">
                        <img src="assets/image/product/img-1.webp" class="img-fluid" alt="Product 1">
                        <div class="product-img-overlay">
                          <h3>Top Seller</h3>
                        </div>
                      </div>
                      <h5>White Ponni Kurunai</h5>
                      <p>Finely broken white Ponni rice, ideal for porridge, tiffin items, and quick, soft meals.</p>
                      <a href="products.php">View Details <i class="bi bi-arrow-right-short"></i></a>

                    </div>
                  </div>

                  <div class="item">
                    <div class="product-card">
                      <div class="d-flex justify-content-center">
                        <img src="assets/image/product/img-2.webp" class="img-fluid" alt="Product 1">
                      </div>
                      <h5>Rajabogam Khicadi Ponni</h5>
                      <p>A premium-quality broken rice, perfect for soft khichadi and nutritious, easily digestible meals.</p>
                      <a href="products.php">View Details <i class="bi bi-arrow-right-short"></i></a>

                    </div>
                  </div>

                  <div class="item">
                    <div class="product-card">
                      <div class="d-flex justify-content-center position-relative">
                        <img src="assets/image/product/img-3.webp" class="img-fluid" alt="Product 1">
                        <div class="product-img-overlay">
                          <h3>Best Product</h3>
                        </div>
                      </div>
                      <h5>Malligai Ponni Kurunai</h5>
                      <p>Fragrant broken rice with a soft texture, great for light South Indian dishes and porridge.</p>
                      <a href="products.php">View Details <i class="bi bi-arrow-right-short"></i></a>

                    </div>
                  </div>

                  <div class="item">
                    <div class="product-card">
                      <div class="d-flex justify-content-center position-relative">
                        <img src="assets/image/product/img-4.webp" class="img-fluid" alt="Product 1">
                      </div>
                      <h5>Revathi Khichadi Kurunai</h5>
                      <p>Specially milled rice for khichadi, offering consistent softness and flavor in every meal.</p>
                      <a href="products.php">View Details <i class="bi bi-arrow-right-short"></i></a>

                    </div>
                  </div>

                </div>

                <!-- Navigation Buttons -->
                <button class="primium-btn prev-btn position-absolute top-50 start-0 translate-middle-y">
                  <i class="bi bi-arrow-left-short"></i>
                </button>
                <button class="primium-btn next-btn position-absolute top-50 end-0 translate-middle-y">
                  <i class="bi bi-arrow-right-short"></i>
                </button>

              </div>


            </div>

            <div class="product-content" id="tab3">

              <div class="container position-relative">

                <div id="primium-product" class="primium-product owl-carousel owl-theme">

                  <div class="item">
                    <div class="product-card">
                      <div class="d-flex justify-content-center">
                        <img src="assets/image/product/img-1.webp" class="img-fluid" alt="Rice Bran">
                      </div>
                      <h5>Rice Bran (தவுடி)</h5>
                      <p>Used for oil extraction and cattle feed, rich in nutrients.</p>
                      <a href="products.php">View Details <i class="bi bi-arrow-right-short"></i></a>

                    </div>
                  </div>

                  <div class="item">
                    <div class="product-card">
                      <div class="d-flex justify-content-center">
                        <img src="assets/image/product/img-2.webp" class="img-fluid" alt="Black Rice">
                      </div>
                      <h5>Black Rice (கருப்பு கவுனி)</h5>
                      <p>Healthy, fiber-rich rice known for its natural black color.</p>
                      <a href="products.php">View Details <i class="bi bi-arrow-right-short"></i></a>

                    </div>
                  </div>

                  <div class="item">
                    <div class="product-card">
                      <div class="d-flex justify-content-center">
                        <img src="assets/image/product/img-3.webp" class="img-fluid" alt="Broken Rice Seeds">
                      </div>
                      <h5>Broken Rice Seed (உடைந்த விதை)</h5>
                      <p>Ideal for poultry feed and flour making.</p>
                      <a href="products.php">View Details <i class="bi bi-arrow-right-short"></i></a>

                    </div>
                  </div>

                  <div class="item">
                    <div class="product-card">
                      <div class="d-flex justify-content-center">
                        <img src="assets/image/product/img-3.webp" class="img-fluid" alt="Immature Paddy">
                      </div>
                      <h5>Immature Paddy (கருக்காய்)</h5>
                      <p>Used in animal feed and rice flour processing.</p>
                      <a href="products.php">View Details <i class="bi bi-arrow-right-short"></i></a>

                    </div>
                  </div>

                  <div class="item">
                    <div class="product-card">
                      <div class="d-flex justify-content-center">
                        <img src="assets/image/product/img-3.webp" class="img-fluid" alt="Bran Broken Rice">
                      </div>
                      <h5>Bran Broken Rice (தவுடு குறுநை)</h5>
                      <p>Commonly used for cattle feed and industrial needs.</p>
                      <a href="products.php">View Details <i class="bi bi-arrow-right-short"></i></a>

                    </div>
                  </div>

                </div>


                <button class="primium-btn prev-btn position-absolute top-50 start-0 translate-middle-y">
                  <i class="bi bi-arrow-left-short"></i>
                </button>
                <button class="primium-btn next-btn position-absolute top-50 end-0 translate-middle-y">
                  <i class="bi bi-arrow-right-short"></i>
                </button>

              </div>


            </div>

          </div>

        </div>

        <div class="product-vector-overlay">
          <img src="./assets/image/icons/vector-1.png" class="img-fluid" alt="">
        </div>
      </div>
    </section>




  </main>


  <!-- footer -->
  <?php include('footer.php') ?>


</body>
<!-- product carosel -->
<script>
  $(document).ready(function() {
    var owl = $(".primium-product");
    owl.owlCarousel({
      loop: true,
      margin: 20,
      nav: false,
      dots: false,
      autoplay: false,
      autoplayTimeout: 3000,
      responsive: {
        0: {
          items: 1
        },
        768: {
          items: 2
        },
        1200: {
          items: 3
        }
      }
    });

    // Custom Nav
    $(".prev-btn").click(function() {
      owl.trigger("prev.owl.carousel");
    });
    $(".next-btn").click(function() {
      owl.trigger("next.owl.carousel");
    });
  });
</script>


<!-- product tab -->
<script>
  const tabs = document.querySelectorAll('.tab-link');
  const contents1 = document.querySelectorAll('.product-content');

  tabs.forEach(tab => {
    tab.addEventListener('click', () => {
      tabs.forEach(el => el.classList.remove('active'));
      contents1.forEach(el => el.classList.remove('active'));

      tab.classList.add('active');
      document.getElementById(tab.getAttribute('data-target')).classList.add('active');
    });
  });
</script>

</html>