  <!DOCTYPE html>
  <html lang="en">

  <head>
    <meta charset="utf-8">
    <meta content="width=device-width, initial-scale=1.0" name="viewport">


    <!-- meta tag -->
    <title>About Us | Leading Interior Designers in Coimbatore</title>
    <meta name="description" content="Learn about leading interior designers in Coimbatore delivering innovative home interiors, turnkey interior solutions, and sustainable architectural design">


    <!-- Open Graph Meta Tags -->
    <meta property="og:type" content="website" />
    <meta property="og:title" content="About Us | Leading Interior Designers in Coimbatore" />
    <meta property="og:image" content="https://thawdesigners.in/assets/img/Thaw-Designers.webp" />
    <meta property="og:image:width" content="446" />
    <meta property="og:image:height" content="336" />
    <meta property="og:description" content="Learn about leading interior designers in Coimbatore delivering innovative home interiors, turnkey interior solutions, and sustainable architectural design" />
    <meta property="og:url" content="https://www.thawdesigners.in/about-us.php" />
    <meta property="og:site_name" content="Thaw Designers" />
    <meta property="fb:admins" content="100047348516276" />
    <meta property="og:locale" content="en_IN" />
    <link rel="me" href="https://www.facebook.com/profile.php?id=100047348516276" />
    <link rel="me" href="https://www.instagram.com/thawdesigners/" />
    <link rel="me" href="https://www.youtube.com/@Thawdesigners" />
    <meta name="robots" content="index, follow" />
    <meta name="language" content="English" />
    <meta name="geo.placename" content="Coimbatore, Madurai, Chennai,Bangalore, Tamil Nadu, India" />
    <meta name="copyright" content="https://www.thawdesigners.in/" />
    <meta name="google-site-verification" content="sQBzNCJ9wUa26uRAJu9OtJVFbCQ2lE-YXyst3D9uoSs " />
    <meta name="twitter:card" content="summary_large_image" />
    <meta name="twitter:title" content="About Us | Leading Interior Designers in Coimbatore" />
    <meta name="twitter:description" content="Learn about leading interior designers in Coimbatore delivering innovative home interiors, turnkey interior solutions, and sustainable architectural design" />
    <meta name="twitter:image" content="https://thawdesigners.in/assets/img/Thaw-Designers.webp" />

    <!-- canonical tag -->
    <link rel="canonical" href="https://thawdesigners.in/about-us.php" />

    <!-- schema tag -->
    <script type='application/ld+json'>
      {
        "@context": "https://schema.org",
        "@type": "LocalBusiness",
        "name": "Thaw Designers",
        "image": "https://thawdesigners.in/assets/img/Thaw-Designers.webp",
        "@id": "https://www.thawdesigners.in/",
        "url": "https://www.thawdesigners.in/about-us.php",
        "telephone": "+91 90956 59705",
        "description": "Thaw Designers offers expert interior design and
        architecture services in Coimbatore and Bangalore,
        including
        residential,
        commercial,
        apartment,
        villa,
        office,
        school,
        and
        hospital design solutions.
        ",
        "address": {
          "@type": "PostalAddress",
          "streetAddress": "SF NO. 128/2, Chandra Garden, Road,
          behind Aalam Montessori school,
          Thriveni West ",
          "addressLocality": "Kalapatti, Coimbatore",
          "addressRegion": "Tamil Nadu",
          "postalCode": "641035",
          "addressCountry": "IN"
        },
        "geo": {
          "@type": "GeoCoordinates",
          "latitude": 11.084082987551191,
          "longitude": 77.0322872680657
        },
        "openingHoursSpecification": [{
          "@type": "OpeningHoursSpecification",
          "dayOfWeek": [
            "Monday",
            "Tuesday",
            "Wednesday",
            "Thursday",
            "Friday",
            "Saturday"
          ],
          "opens": "09:30",
          "closes": "19:00"
        }],
        "areaServed": [
          "Coimbatore",
          "Chennai",
          "Madurai",
          "Tamil Nadu",
          "Bangalore",
          "India",
        ],
        "sameAs": [
          "https://www.facebook.com/architectscoimbatore/",
          "https:https://www.instagram.com/thawdesigners/",
          "https:https://in.pinterest.com/thawseo2024/",
          "https:https://www.youtube.com/@Thawdesigners",
          "https:https://x.com/thaw_Designers"
        ]
      }
    </script>

    <!-- Google tag (gtag.js) -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=G-9WRLDDSSCM"></script>
    <script>
      window.dataLayer = window.dataLayer || [];

      function gtag() {
        dataLayer.push(arguments);
      }
      gtag('js', new Date());
      gtag('config', 'G-9WRLDDSSCM');
    </script>

    <!-- Google Tag Manager -->
    <script>
      (function(w, d, s, l, i) {
        w[l] = w[l] || [];
        w[l].push({
          'gtm.start': new Date().getTime(),
          event: 'gtm.js'
        });
        var f = d.getElementsByTagName(s)[0],
          j = d.createElement(s),
          dl = l != 'dataLayer' ? '&l=' + l : '';
        j.async = true;
        j.src =
          'https://www.googletagmanager.com/gtm.js?id=' + i + dl;
        f.parentNode.insertBe
        fore(j, f);
      })(window, document, 'script', 'dataLayer', 'GTM-5ZV73TVX');
    </script>
    <!-- End Google Tag Manager -->

    <!-- head -->
    <?php include("./includes/head.php"); ?>

  </head>

  <body>

    <!-- Google Tag Manager (noscript) -->
    <noscript><iframe
        src="https://www.googletagmanager.com/ns.html?id=GTM-5ZV73TVX"
        height="0" width="0"
        style="display:none;visibility:hidden"></iframe></noscript>
    <!-- End Google Tag Manager (noscript) -->


    <!-- header -->
    <?php include("./includes/header.php") ?>

    <!-- sub banner -->
    <div class="sub-banner">
      <div class="overlay"></div>
      <div class="sub-banner-content text-center">
        <h1 class="title">About Us</h1>
        <nav class="breadcrumb">
          <a href="index.php">Home</a> &nbsp; / &nbsp; <span>About Us</span>
        </nav>
      </div>
    </div>

    <main id="main">

      <!-- about us secetion -->
      <section class="about-us01">
        <div class="container">
          <div class="row">
            <div class="col-12 d-flex flex-column justify-content-center">
              <h1 class="wow animate__animated animate__fadeInUp">We are a team of dreamers <br> and builders</h1>
            </div>
            <div class="col-12">
              <p class="wow animate__animated animate__fadeInUp" data-wow-delay="0.3s">
                Welcome to **Thaw Designers**, a multidisciplinary architectural firm that began its journey in **2002**. We are a team of passionate architects and designers dedicated to transforming spaces and bringing your vision to life. Based in Bangalore, we've also expanded our expertise to Coimbatore.
              </p>
            </div>
          </div>
        </div>
        <br>
        <div class="container">
          <div class="row">
            <div class="col-lg-6 col-md-12 mb-4">
              <div class="our-story-box02">
                <img src="assets/img/about-us/luxury-residential-architects-in-Coimbatore.webp" loading="lazy" alt="luxury residential architects in Coimbatore" title=" luxury residential architects in Coimbatore" class="img-fluid wow animate__animated animate__fadeInLeft">
              </div>
            </div>
            <div class="col-lg-6 col-md-12">
              <div class="our-story-box01 wow animate__animated animate__fadeInRight">
                <h2>Our Story</h2>
                <p>
                  With more than a decade of experience, our founders, **Ar. Prasath Chandrasekaran and Ar. Tara Prasath**, have cultivated a deep concern for the built environment. Our tradition is to define and create dimensions for our clients' dreams with passion and dedication. We believe in providing complete solutions with innovation, technology, and excellence. We offer a comprehensive range of services, including architectural design, interior design, project management, and renovation. Our approach is unique, and we strive to make a mark on the globe, both nationally and internationally.
                  <br><br>
                  Collaboration lies at the heart of our process. We actively involve our clients every step of the way, ensuring that their input and preferences are vital in creating spaces that truly resonate with them. From concept to completion, we are committed to bringing your vision to life seamlessly.
                </p>
              </div>
            </div>
          </div>
        </div>
        <br>
        <div class="container">
          <div class="our-story-box01 wow animate__animated animate__fadeInRight">
            <h2>Meet Our Honourable Founder </h2>
            <p>Dedicated to excellence, vision, and values — the foundation of everything we do. </p>
          </div>
          <!-- Founder Section -->
          <div class="founder-container container py-5">
            <div class="row justify-content-center">
              <!-- Founder 1 -->
              <div class="col-md-6 col-lg-5 mb-4">
                <div class="founder-card text-center">
                  <div class="founder-image-wrapper">
                    <img src="assets/img/about-us/best-architects-in-tamilnadu.webp" alt="best architects in tamilnadu" title="best architects in tamilnadu" loading="lazy" class="founder-image img-fluid">
                  </div>
                  <h4 class="founder-name mt-3 mb-1">AR. Prasath Chandrasekaran</h4>
                  <p style="text-align: center !important;" class="founder-title text-center">Principal Architect</p>
                </div>
              </div>
              <!-- Founder 2 -->
              <div class="col-md-6 col-lg-5 mb-4">
                <div class="founder-card text-center">
                  <div class="founder-image-wrapper">
                    <img src="assets/img/about-us/best-architects-in-Coimbatore.webp" alt="best architects in Coimbatore" title="best architects in Coimbatore" loading="lazy" class="founder-image img-fluid">
                  </div>
                  <h4 class="founder-name mt-3 mb-1">AR. Tara Chandrasekaran</h4>
                  <p style="text-align: center !important;" class="founder-title text-center">Chief Architect</p>
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>

      <!-- Client badge -->
      <section class="brand-section-unique py-5">
        <div class="container">
          <div class="owl-carousel brand-carousel-unique owl-theme" id="brand-carousel-container"></div>
        </div>
      </section>

      <!-- how we work -->
      <section class="how-it-works-section section-padding text-light">
        <div class="container">
          <h2 class="text-center fw-bold mb-5 wow animate__animated animate__fadeInUp">HOW IT WORKS</h2>
          <div class="row align-items-center">
            <div class="col-md-5">
              <div class="row gy-4">
                <div class="col-12">
                  <div class="how-box d-flex flex-column align-items-md-end align-items-md-start wow animate__animated animate__fadeInLeft">
                    <div class="icon-box mb-4">
                      <i class="bi bi-people-fill fs-3"></i>
                    </div>
                    <h5 class="how-step">01</h5>
                    <h4 class="how-title">OUR FOUNDERS</h4>
                    <p class="how-text">
                      With more than a decade of experience, our founders, <strong>Ar. Prasath Chandrasekaran</strong> and <strong>Ar. Tara Prasath</strong>, have cultivated a deep concern for the built environment.
                    </p>
                  </div>
                </div>
                <div class="col-12">
                  <div class="how-box d-flex flex-column align-items-md-end align-items-md-start wow animate__animated animate__fadeInLeft" data-wow-delay="0.2s">
                    <div class="icon-box mb-4">
                      <i class="bi bi-bullseye fs-3"></i>
                    </div>
                    <h5 class="how-step">02</h5>
                    <h4 class="how-title">OUR MISSION</h4>
                    <p class="how-text">
                      Our tradition is to define and create dimensions for our clients' dreams with passion and dedication. We offer complete solutions with innovation, technology, and excellence.
                    </p>
                  </div>
                </div>
              </div>
            </div>

            <div class="col-md-2 d-none d-md-flex flex-column justify-content-center align-items-center position-relative">
              <div class="center-circle my-3 wow animate__animated animate__zoomIn">
                <i class="bi bi-globe2 fs-2"></i>
              </div>
            </div>

            <div class="col-md-5">
              <div class="row gy-4">
                <div class="col-12">
                  <div class="how-box wow animate__animated animate__fadeInRight">
                    <div class="icon-box mb-4">
                      <i class="bi bi-tools fs-3"></i>
                    </div>
                    <h5 class="how-step">03</h5>
                    <h4 class="how-title">OUR SERVICES</h4>
                    <p class="how-text">
                      We offer a comprehensive range of services including architectural design, interior design, project management, and renovation to deliver outstanding results.
                    </p>
                  </div>
                </div>
                <div class="col-12">
                  <div class="how-box wow animate__animated animate__fadeInRight" data-wow-delay="0.2s">
                    <div class="icon-box mb-4">
                      <i class="bi bi-diagram-3-fill fs-3"></i>
                    </div>
                    <h5 class="how-step">04</h5>
                    <h4 class="how-title">OUR APPROACH</h4>
                    <p class="how-text">
                      Collaboration is at the heart of our process. We involve clients at every stage—ensuring their preferences shape the spaces we create from concept to completion.
                    </p>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>

      <!-- vission and mission -->
      <section class="about-us03 section=padding">
        <div class="container">
          <div class="row">
            <div class="col-lg-6 col-md-6">
              <div class="how-we01">
                <img src="assets/img/about-us/school-interior-designers-in-Coimbatore.webp" title="school interior designers in Coimbatore" loading="lazy" alt="school interior designers in Coimbatore" class="img-fluid wow animate__animated animate__fadeInLeft">
              </div>
            </div>
            <div class="col-lg-6 col-md-6 d-flex flex-column justify-content-center">
              <div class="how-we02 wow animate__animated animate__fadeInRight">
                <h2>Vision</h2>
                <p>
                  Our vision is simple yet powerful: **"We dream along with you."** This philosophy allows us to produce impressive and satisfactory designs that consider nature and its interaction with the environment. We emphasize creating inspiring, technically innovative buildings with practical and elegant solutions. Our expertise in identifying the flaws and discomforts in human living has led us to evolve into a new venture, **AARAN INFRASTRUCTURES**, a project development company focused on delivering complaint-free architectural, interior, and construction projects in and around Coimbatore.
                  <br><br>
                  Our minds work around the clock to deliver the best of our knowledge and uniqueness to our clients in everything we do. We aim to take on more challenging projects like malls, hospitals, recreation centers, commercial complexes, and schools.
                </p>
              </div>
            </div>
          </div>
        </div>

        <div class="container">
          <div class="row">
            <div class="col-lg-6 col-md-6 order-1 order-md-1 order-lg-2">
              <div class="how-we01">
                <img src="assets/img/about-us/school-architects-in-coimbatore.webp" alt="school architects in coimbatore" loading="lazy" title="school architects in coimbatore" class="img-fluid wow animate__animated animate__fadeInRight">
              </div>
            </div>
            <div class="col-lg-6 col-md-6 d-flex flex-column justify-content-center order-2 order-md-2 order-lg-1">
              <div class="how-we02 wow animate__animated animate__fadeInLeft">
                <h2>Mission</h2>
                <p>
                  Our vision is simple yet powerful: <strong>"We dream along with you."</strong> This philosophy allows us to produce impressive and satisfactory designs that consider nature and its interaction with the environment. We emphasize creating inspiring, technically innovative buildings with practical and elegant solutions. Our expertise in identifying the flaws and discomforts in human living has led us to evolve into a new venture, <strong>AARAN INFRASTRUCTURES</strong>, a project development company focused on delivering complaint-free architectural, interior, and construction projects in and around Coimbatore.
                  <br><br>
                  Our minds work around the clock to deliver the best of our knowledge and uniqueness to our clients in everything we do. We aim to take on more challenging projects like malls, hospitals, recreation centers, commercial complexes, and schools.
                </p>
              </div>
            </div>
          </div>
        </div>
      </section>

      <!-- why choose us section -->
      <section class="section-padding features-bg">
        <div class="container-fluid">
          <div class="row justify-content-center mb-5">
            <div class="col-lg-10 text-center">
              <h2 class="mb-4 fw-bold text-white wow animate__animated animate__fadeInUp">Why Choose Us</h2>
              <p class="text-white wow animate__animated animate__fadeInUp" data-wow-delay="0.2s">
                Choosing the right builder is about more than just construction — it's about trust, responsibility, and long-term value.
                We understand that a home or building is often a person's lifetime investment, which is why we build on the foundation
                of trust, transparency, and ethical practices.
              </p>
              <p class="text-white wow animate__animated animate__fadeInUp" data-wow-delay="0.4s">
                From securing clear titles and statutory approvals to prioritizing the welfare of every worker on site, we take full
                ownership of our responsibilities. We don’t just deliver projects — we deliver peace of mind.
              </p>
              <p class="text-white wow animate__animated animate__fadeInUp" data-wow-delay="0.6s">
                At our core, we aim to uplift industry standards, impact lives positively, and leave behind a legacy of meaningful
                structures. For us, success isn’t just about profit — it's about purpose. That’s why we go beyond expectations and let
                excellence speak for itself.
              </p>
            </div>
          </div>

          <div class="row text-center justify-content-center">
            <div class="col-md-3 col-sm-6 col-12 design-service-box unique-box-1 wow animate__animated animate__fadeIn" data-wow-delay="0.2s">
              <div class="design-icon">
                <i class="bi bi-building" style="font-size: 48px;"></i>
              </div>
              <div class="design-title">Multidisciplinary Expertise</div>
              <div class="design-description">
                Offers a wide range of services including Architectural Design, Interior Design Consultancy, Project Management,
                Contract Works, Layout Planning, and Renovation.
              </div>
              <div class="design-underline">
                <div class="design-underline-line"></div>
                <div class="design-underline-dot"></div>
                <div class="design-underline-line"></div>
              </div>
            </div>

            <div class="col-md-3 col-sm-6 col-12 design-service-box unique-box-2 wow animate__animated animate__fadeIn" data-wow-delay="0.4s">
              <div class="design-icon">
                <i class="bi bi-geo-alt-fill" style="font-size: 48px;"></i>
              </div>
              <div class="design-title">Geographical Reach</div>
              <div class="design-description">
                Headquartered in Bangalore with operational branches in Coimbatore, serving clients across India and internationally.
              </div>
              <div class="design-underline">
                <div class="design-underline-line"></div>
                <div class="design-underline-dot"></div>
                <div class="design-underline-line"></div>
              </div>
            </div>

            <div class="col-md-3 col-sm-6 col-12 design-service-box unique-box-3 wow animate__animated animate__fadeIn" data-wow-delay="0.6s">
              <div class="design-icon">
                <i class="bi bi-person-heart" style="font-size: 48px;"></i>
              </div>
              <div class="design-title">Client-Centered Approach</div>
              <div class="design-description">
                Committed to transforming client visions into architectural realities with passion, precision, and professionalism.
              </div>
              <div class="design-underline">
                <div class="design-underline-line"></div>
                <div class="design-underline-dot"></div>
                <div class="design-underline-line"></div>
              </div>
            </div>
          </div>
        </div>
      </section>

    </main>
    <!-- footer -->
    <?php include("./includes/footer.php") ?>

    <!-- script -->
    <?php include("./includes/script.php") ?>



  </body>

  </html>