<!DOCTYPE html>
<html lang="en">


<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">


  <!-- meta tag -->
  <title>Top Architects in Coimbatore | Residential&Commercial Design</title>
  <meta name="description" content="Top architects in Coimbatore offering residential and commercial architecture design, custom villas, modern homes, and expert architectural solutions">

  <!-- Open Graph Meta Tags -->
  <meta property="og:type" content="website" />
  <meta property="og:title" content="Top Architects in Coimbatore | Residential&Commercial Design" />
  <meta property="og:image" content="https://thawdesigners.in/assets/img/Thaw-Designers.webp" />
  <meta property="og:image:width" content="446" />
  <meta property="og:image:height" content="336" />
  <meta property="og:description" content="Top architects in Coimbatore offering residential and commercial architecture design, custom villas, modern homes, and expert architectural solutions" />
  <meta property="og:url" content="https://www.thawdesigners.in/architecture.php" />
  <meta property="og:site_name" content="Thaw Designers" />
  <meta property="fb:admins" content="100047348516276" />
  <meta property="og:locale" content="en_IN" />
  <link rel="me" href="https://www.facebook.com/profile.php?id=100047348516276" />
  <link rel="me" href="https://www.instagram.com/thawdesigners/" />
  <link rel="me" href="https://www.youtube.com/@Thawdesigners" />
  <meta name="robots" content="index, follow" />
  <meta name="language" content="English" />
  <meta name="geo.placename" content="Coimbatore, Madurai, Chennai,Bangalore, Tamil Nadu, India" />
  <meta name="copyright" content="https://www.thawdesigners.in/" />
  <meta name="google-site-verification" content="sQBzNCJ9wUa26uRAJu9OtJVFbCQ2lE-YXyst3D9uoSs" />
  <meta name="twitter:card" content="summary_large_image" />
  <meta name="twitter:title" content="Top Architects in Coimbatore | Residential&Commercial Design" />
  <meta name="twitter:description" content="Top architects in Coimbatore offering residential and commercial architecture design, custom villas, modern homes, and expert architectural solutions" />
  <meta name="twitter:image" content="https://thawdesigners.in/assets/img/Thaw-Designers.webp" />

  <!-- canonical tag -->
  <link rel="canonical" href="https://thawdesigners.in/architecture.php" />

  <!-- schema tag -->
  <script type='application/ld+json'>
    {
      "@context": "https://schema.org",
      "@type": "LocalBusiness",
      "name": "Thaw Designers",
      "image": "https://thawdesigners.in/assets/img/Thaw-Designers.webp",
      "@id": "https://www.thawdesigners.in/",
      "url": "https://www.thawdesigners.in/architecture.php",
      "telephone": "+91 90956 59705",
      "description": "Thaw Designers offers expert interior design and
      architecture services in Coimbatore and Bangalore,
      including
      residential,
      commercial,
      apartment,
      villa,
      office,
      school,
      and
      hospital design solutions.
      ",
      "address": {
        "@type": "PostalAddress",
        "streetAddress": "SF NO. 128/2, Chandra Garden, Road,
        behind Aalam Montessori school,
        Thriveni West ",
        "addressLocality": "Kalapatti, Coimbatore",
        "addressRegion": "Tamil Nadu",
        "postalCode": "641035",
        "addressCountry": "IN"
      },
      "geo": {
        "@type": "GeoCoordinates",
        "latitude": 11.084082987551191,
        "longitude": 77.0322872680657
      },
      "openingHoursSpecification": [{
        "@type": "OpeningHoursSpecification",
        "dayOfWeek": [
          "Monday",
          "Tuesday",
          "Wednesday",
          "Thursday",
          "Friday",
          "Saturday"
        ],
        "opens": "09:30",
        "closes": "19:00"
      }],
      "areaServed": [
        "Coimbatore",
        "Chennai",
        "Madurai",
        "Tamil Nadu",
        "Bangalore",
        "India",
      ],
      "sameAs": [
        "https://www.facebook.com/architectscoimbatore/",
        "https:https://www.instagram.com/thawdesigners/",
        "https:https://in.pinterest.com/thawseo2024/",
        "https:https://www.youtube.com/@Thawdesigners",
        "https:https://x.com/thaw_Designers"
      ]
    }
  </script>

  <!-- Google tag (gtag.js) -->
  <script async src="https://www.googletagmanager.com/gtag/js?id=G-9WRLDDSSCM"></script>
  <script>
    window.dataLayer = window.dataLayer || [];

    function gtag() {
      dataLayer.push(arguments);
    }
    gtag('js', new Date());
    gtag('config', 'G-9WRLDDSSCM');
  </script>

  <!-- Google Tag Manager -->
  <script>
    (function(w, d, s, l, i) {
      w[l] = w[l] || [];
      w[l].push({
        'gtm.start': new Date().getTime(),
        event: 'gtm.js'
      });
      var f = d.getElementsByTagName(s)[0],
        j = d.createElement(s),
        dl = l != 'dataLayer' ? '&l=' + l : '';
      j.async = true;
      j.src =
        'https://www.googletagmanager.com/gtm.js?id=' + i + dl;
      f.parentNode.insertBe
      fore(j, f);
    })(window, document, 'script', 'dataLayer', 'GTM-5ZV73TVX');
  </script>
  <!-- End Google Tag Manager -->

  <!-- head -->
  <?php include("./includes/head.php"); ?>

</head>

<body>

  <!-- Google Tag Manager (noscript) -->
  <noscript><iframe
      src="https://www.googletagmanager.com/ns.html?id=GTM-5ZV73TVX"
      height="0" width="0"
      style="display:none;visibility:hidden"></iframe></noscript>
  <!-- End Google Tag Manager (noscript) -->

  <!-- header -->
  <?php include("./includes/header.php") ?>


  <div class="sub-banner">
    <div class="overlay"></div>
    <div class="sub-banner-content text-center">
      <h1 class="title">Architecture </h1>
      <nav class="breadcrumb">
        <a href="index.php">Home</a> &nbsp; / &nbsp; <span>Architecture </span>
      </nav>
    </div>
  </div>



  <main id="main">

    <section class="projects01 ">
      <div class="container">
        <h1>Architecture </h1>
        <!-- Tab Links -->
        <div class="row">
          <div class="col-12">
            <div>
              <ul class="project-filter list-inline text-center mb-4">
                <li class="list-inline-item active" data-filter="all">All</li>
                <li class="list-inline-item" data-filter="residence">Residence</li>
                <li class="list-inline-item" data-filter="apartment">Apartment</li>
                <li class="list-inline-item" data-filter="commercial">Commercial</li>
                <li class="list-inline-item" data-filter="school">School</li>
                <li class="list-inline-item" data-filter="hospital">Hospital</li>
              </ul>

            </div>
          </div>
        </div>

        <div class="row" id="dynamicGallery"></div>

      </div>
    </section>

  </main>

  <!-- footer  -->
  <?php include("./includes/footer.php") ?>

  <!-- script -->
  <?php include("./includes/script.php") ?>



</body>


<script>
  const imageData = [


    // residence
    {
      filename: "Expert-residence-architect-in-coimbatore",
      title: "Vivanth Residency",
      imgtitle: "Expert residence architect in coimbatore",
      alt: "Expert residence architect in coimbatore",
      para: "Vivanth Residency exemplifies modern lifestyle with smartly designed interiors, superior finishes, and a peaceful ambiance, set within the vibrant surroundings of Coimbatore.",
      category: "residence"
    },
    {
      filename: "Expert-residence-architect-in-bangalore",
      title: "Navarathna, R.S Puram",
      imgtitle: "Expert residence architect in bangalore",
      alt: "Expert residence architect in bangalore",
      para: "Navarathna, R.S. Puram reflects premium city living with elegant architecture, upscale finishes, and thoughtfully planned interiors, set in one of Coimbatore’s most prestigious and well-connected neighborhoods.",
      category: "residence"
    },
    {
      filename: "Expert-residence-architect-in-tamilnadu",
      title: "Mahanadi Residency",
      imgtitle: "Expert residence architect in tamilnadu",
      alt: "Expert residence architect in tamilnadu",
      para: "Mahanadi Residency combines functional design with contemporary aesthetics, offering well-planned homes, essential amenities, and a tranquil environment in the fast-growing Coimbatore locality.",
      category: "residence"
    }, {
      filename: "Best-residence-architect-in-coimbatore",
      title: "Dejoo Residence, Sundarapalayam",
      imgtitle: "Best residence architect in coimbatore",
      alt: "Best residence architect in coimbatore",
      para: "This residence blends contemporary styling with traditional warmth, offering elegant comfort and privacy in Sundarapalayam’s serene setting.",
      category: "residence"
    },
    {
      filename: "Best-residence-architect-in-bangalore",
      title: "Dr. Kaja Residence, Podanur",
      imgtitle: "Best residence architect in bangalore",
      alt: "Best residence architect in bangalore",
      para: "Designed for spacious living with elegant interiors, Dr. Kaja Residence blends modern comfort with thoughtful architecture in the peaceful locality of Podanur.",
      category: "residence"
    },
    {
      filename: "Best-residence-architect-in-tamilnadu",
      title: "Residence, Ganapathy",
      imgtitle: "Best residence architect in tamilnadu",
      alt: "Best residence architect in tamilnadu",
      para: "A stylish and compact home that combines everyday functionality with creative interior elements in the Ganapathy area.",
      category: "residence"
    },
    {
      filename: "Top-residence-architect-in-coimbatore",
      title: "Sabarish Residence",
      imgtitle: "Top residence architect in coimbatore",
      alt: "Top residence architect in coimbatore",
      para: "Sabarish Residence is a bespoke home that blends modern aesthetics with personal comfort, featuring elegant interiors and a serene atmosphere in the heart of Kalapatti’s residential enclave.",
      category: "residence"
    },

    // apartment

    {
      filename: "Expert-apartment-architect-company-in-coimbatore",
      title: "Aashrutha Project",
      imgtitle: "Expert apartment architect company in coimbatore",
      alt: "Expert apartment architect company in coimbatore",
      para: "Aashrutha Project offers thoughtfully crafted living spaces with a focus on comfort, simplicity, and everyday convenience, located in a peaceful and well-connected part of coimbatore.",
      category: "apartment"
    },
    {
      filename: "Expert-apartment-architect-company-in-bangalore",
      title: "Navarathana Apartments",
      imgtitle: "Expert apartment architect company in bangalore",
      alt: "Expert apartment architect company in bangalore",
      para: "Navarathana Apartments blends contemporary design with comfort, offering sophisticated living spaces, top-tier amenities, and thoughtful layouts in the heart of Kalapatti’s thriving residential zone.",
      category: "apartment"
    },
    {
      filename: "Best-apartment-architect-company-in-bangalore",
      title: "Royal Orchid Apartment",
      imgtitle: "Best apartment architect company in bangalore",
      alt: "Best apartment architect company in bangalore",
      para: "Royal Orchid Apartment offers refined urban living with elegant architecture, quality craftsmanship, and modern comforts, nestled in a serene and well-connected Kalapatti neighborhood.",
      category: "apartment"
    },
    {
      filename: "best-apartment-architect-company-in-coimbatore",
      title: "Everest Elegance",
      imgtitle: "best apartment architect company in coimbatore",
      alt: "best apartment architect company in coimbatore",
      para: "Everest Elegance showcases luxury living with bold architecture, premium finishes, and carefully planned interiors in a high-end Kalapatti community.",
      category: "apartment"
    },
    {
      filename: "top-apartment-architect-company-in-coimbatore",
      title: "Aasrutha Apartments, Saravanampatty",
      imgtitle: "top apartment architect company in coimbatore ",
      alt: "top apartment architect company in coimbatore ",
      para: "Aasrutha Apartments in Saravanampatty is a modern residential project offering elegant design, comfort, and excellent connectivity in Coimbatore’s growing IT hub.",
      category: "apartment"
    },

    {
      filename: "Top-apartment-architect-company-in-bangalore",
      title: "Dr. Krishna Colony, Apartment",
      imgtitle: "Top apartment architect company in bangalore",
      alt: "Top apartment architect company in bangalore",
      para: "A modern apartment design that maximizes light, space, and urban comfort in the heart of Dr. Krishna Colony, Coimbatore.",
      category: "apartment"
    },

    // commercial

    {
      filename: "Best-commercial-architect-in-coimbatore",
      title: "Visrutha, Gandhipuram",
      imgtitle: "Best commercial architect in coimbatore",
      alt: "Best commercial architect in coimbatore",
      para: "Located in Gandhipuram, Visrutha is a multi-functional space featuring refined commercial architecture with sleek lines and modern visual balance.",
      category: "commercial"
    },


    {
      filename: "Top-commercial-architect-in-tamilnadu",
      title: "Commercial Complex, Davangere",
      imgtitle: "Top commercial architect in tamilnadu",
      alt: "Top commercial architect in tamilnadu",
      para: "A multi-utility commercial complex designed for functionality, retail flow, and aesthetic appeal in the bustling city of Davangere.",
      category: "commercial"
    },

    // school
    {
      filename: "Expert-school-architect-in-coimbatore",
      title: "CMC School, Auditorium",
      imgtitle: "Expert school architect in coimbatore",
      alt: "Expert school architect in coimbatore",
      para: "Designed for functional acoustics and elegant aesthetics, the CMC School Auditorium creates a vibrant space for student gatherings and performances",
      category: "school"
    },

    {
      filename: "Best-school-architect-in-tamilnadu",
      title: "Entrance Arch, KG, Kovilpalayam",
      imgtitle: "Best school architect in tamilnadu",
      alt: "Best school architect in tamilnadu",
      para: "A grand and welcoming archway at KG School, Kovilpalayam, combining traditional form with modern construction techniques.",
      category: "school"
    },

    {
      filename: "Top-school-architect-in-bangalore",
      title: "Subbaiah School",
      imgtitle: "Top school architect in bangalore",
      alt: "Top school architect in bangalore",
      para: "An institutionally planned school layout with a focus on open learning environments and strong architectural identity.",
      category: "school"
    },

    // hospital

    {
      filename: "Best-hospital-architect-in-coimbatore",
      title: "Fathima Hospital, Podanur",
      imgtitle: "Best hospital architect in coimbatore",
      alt: "Best hospital architect in coimbatore",
      category: "hospital",
      para: "A well-planned hospital space with a patient-centric design, Fathima Hospital offers modern medical facilities in a clean, efficient, and healing-focused environment.",
    },
    {
      filename: "Expert-hospital-architect-in-tamilnadu",
      title: "Muthu Hospital, Trichy Road",
      imgtitle: "Expert hospital architect in tamilnadu",
      alt: "Expert-hospital-architect-in-tamilnadu",
      para: "Muthu Hospital features a clean, modern façade with efficient layout planning, designed to support both outpatient and emergency services with architectural clarity.",
      category: "hospital"
    },

    {
      filename: "Top-hospital-architect-in-bangalore",
      title: "Ambalavanan, Saravanampatty",
      imgtitle: "Top hospital architect in bangalore",
      alt: "Top hospital architect in bangalore",
      para: "A thoughtfully designed clinical space combining functional planning and patient comfort in the vibrant community of Saravanampatty.",
      category: "hospital"
    }

  ];


  const container = document.getElementById("dynamicGallery");

  imageData.forEach(({
    filename,
    title,
    alt,
    category,
    imgtitle,
    para
  }) => {
    const colDiv = document.createElement("div");
    colDiv.className = `col-lg-4 col-md-6 mb-4 gallery-item ${category}`;

    colDiv.innerHTML = `
    <div class="image-box position-relative overflow-hidden">
      <a href="./assets/img/architecture/${filename}.webp" class="glightbox" data-gallery="gallery1" data-title="${title}">
        <img class="img-fluid" src="./assets/img/architecture/${filename}.webp" alt="${alt}" loaading="lazy" alt="${imgtitle}" loading="lazy">
        <div class="overlay-icon">
          <i class="bi bi-eye"></i>
        </div>
      </a>
      <p class="image-caption-h2 text-center mt-2">${title}</p>
      <p class="image-caption text-center mt-2">${para}</p>
    </div>
  `;

    container.appendChild(colDiv);
  });

  const lightbox = GLightbox({
    selector: '.glightbox',
    touchNavigation: true,
    loop: true,
    zoomable: false
  });
</script>

<script>
  const filterButtons = document.querySelectorAll('.project-filter li');

  filterButtons.forEach(btn => {
    btn.addEventListener('click', () => {
      const filter = btn.getAttribute('data-filter');

      // Update active class
      filterButtons.forEach(b => b.classList.remove('active'));
      btn.classList.add('active');

      // Filter images
      document.querySelectorAll('.gallery-item').forEach(item => {
        if (filter === 'all' || item.classList.contains(filter)) {
          item.style.display = "block";
        } else {
          item.style.display = "none";
        }
      });
    });
  });
</script>

</html>