<!DOCTYPE html>
<html lang="en">


<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">

  <!-- meta tag -->
  <title>Contact Interior Designers & Architects in Coimbatore</title>
  <meta name="description" content="Get in touch with expert interior designers and architects in Coimbatore for residential, commercial, and turnkey design solutions. Contact us today">

  <!-- Open Graph Meta Tags -->
  <meta property="og:type" content="website" />
  <meta property="og:title" content="Contact Interior Designers & Architects in Coimbatore" />
  <meta property="og:image" content="https://thawdesigners.in/assets/img/Thaw-Designers.webp" />
  <meta property="og:image:width" content="446" />
  <meta property="og:image:height" content="336" />
  <meta property="og:description" content="Get in touch with expert interior designers and architects in Coimbatore for residential, commercial, and turnkey design solutions. Contact us today" />
  <meta property="og:url" content="https://www.thawdesigners.in/contact-us.php" />
  <meta property="og:site_name" content="Thaw Designers" />
  <meta property="fb:admins" content="100047348516276" />
  <meta property="og:locale" content="en_IN" />
  <link rel="me" href="https://www.facebook.com/profile.php?id=100047348516276" />
  <link rel="me" href="https://www.instagram.com/thawdesigners/" />
  <link rel="me" href="https://www.youtube.com/@Thawdesigners" />
  <meta name="robots" content="index, follow" />
  <meta name="language" content="English" />
  <meta name="geo.placename" content="Coimbatore, Madurai, Chennai,Bangalore, Tamil Nadu, India" />
  <meta name="copyright" content="https://www.thawdesigners.in/" />
  <meta name="google-site-verification" content="sQBzNCJ9wUa26uRAJu9OtJVFbCQ2lE-YXyst3D9uoSs" />
  <meta name="twitter:card" content="summary_large_image" />
  <meta name="twitter:title" content="Contact Interior Designers & Architects in Coimbatore" />
  <meta name="twitter:description" content="Get in touch with expert interior designers and architects in Coimbatore for residential, commercial, and turnkey design solutions. Contact us today" />
  <meta name="twitter:image" content="https://thawdesigners.in/assets/img/Thaw-Designers.webp" />

  <!-- canonical tag -->
  <link rel="canonical" href="https://thawdesigners.in/contact-us.php" />

  <!-- schema tag -->
  <script type='application/ld+json'>
    {
      "@context": "https://schema.org",
      "@type": "LocalBusiness",
      "name": "Thaw Designers",
      "image": "https://thawdesigners.in/assets/img/Thaw-Designers.webp",
      "@id": "https://www.thawdesigners.in/",
      "url": "https://www.thawdesigners.in/contact-us.php",
      "telephone": "+91 90956 59705",
      "description": "Thaw Designers offers expert interior design and
      architecture services in Coimbatore and Bangalore,
      including
      residential,
      commercial,
      apartment,
      villa,
      office,
      school,
      and
      hospital design solutions.
      ",
      "address": {
        "@type": "PostalAddress",
        "streetAddress": "SF NO. 128/2, Chandra Garden, Road,
        behind Aalam Montessori school,
        Thriveni West ",
        "addressLocality": "Kalapatti, Coimbatore",
        "addressRegion": "Tamil Nadu",
        "postalCode": "641035",
        "addressCountry": "IN"
      },
      "geo": {
        "@type": "GeoCoordinates",
        "latitude": 11.084082987551191,
        "longitude": 77.0322872680657
      },
      "openingHoursSpecification": [{
        "@type": "OpeningHoursSpecification",
        "dayOfWeek": [
          "Monday",
          "Tuesday",
          "Wednesday",
          "Thursday",
          "Friday",
          "Saturday"
        ],
        "opens": "09:30",
        "closes": "19:00"
      }],
      "areaServed": [
        "Coimbatore",
        "Chennai",
        "Madurai",
        "Tamil Nadu",
        "Bangalore",
        "India",
      ],
      "sameAs": [
        "https://www.facebook.com/architectscoimbatore/",
        "https:https://www.instagram.com/thawdesigners/",
        "https:https://in.pinterest.com/thawseo2024/",
        "https:https://www.youtube.com/@Thawdesigners",
        "https:https://x.com/thaw_Designers"
      ]
    }
  </script>

  <!-- Google tag (gtag.js) -->
  <script async src="https://www.googletagmanager.com/gtag/js?id=G-9WRLDDSSCM"></script>
  <script>
    window.dataLayer = window.dataLayer || [];

    function gtag() {
      dataLayer.push(arguments);
    }
    gtag('js', new Date());
    gtag('config', 'G-9WRLDDSSCM');
  </script>


  <!-- Google Tag Manager -->
  <script>
    (function(w, d, s, l, i) {
      w[l] = w[l] || [];
      w[l].push({
        'gtm.start': new Date().getTime(),
        event: 'gtm.js'
      });
      var f = d.getElementsByTagName(s)[0],
        j = d.createElement(s),
        dl = l != 'dataLayer' ? '&l=' + l : '';
      j.async = true;
      j.src =
        'https://www.googletagmanager.com/gtm.js?id=' + i + dl;
      f.parentNode.insertBe
      fore(j, f);
    })(window, document, 'script', 'dataLayer', 'GTM-5ZV73TVX');
  </script>
  <!-- End Google Tag Manager -->

  <!-- head -->
  <?php include("./includes/head.php"); ?>

</head>

<body>

  <!-- Google Tag Manager (noscript) -->
  <noscript><iframe
      src="https://www.googletagmanager.com/ns.html?id=GTM-5ZV73TVX"
      height="0" width="0"
      style="display:none;visibility:hidden"></iframe></noscript>
  <!-- End Google Tag Manager (noscript) -->

  <!-- header -->
  <?php include("./includes/header.php") ?>

  <div class="sub-banner">
    <div class="overlay"></div>
    <div class="sub-banner-content text-center">
      <h1 class="title">Contact Us</h1>
      <nav class="breadcrumb">
        <a href="index.php">Home</a> &nbsp; / &nbsp; <span>Contact Us</span>
      </nav>
    </div>
  </div>

  <main id="main">
    <section class="contact-us01 section-padding">
      <div class="container">
        <div class="row mb-5 justify-content-center">

          <div class="col-md-6 col-lg-4">
            <div class="cont-cont d-flex flex-column align-items-center">
              <h4 class="d-flex flex-column align-items-center"> <i class="bi bi-geo-alt-fill"></i> reach us</h4>
              <p>
                <a href="https://maps.app.goo.gl/sfeJaYK2Q1X3JoWq5" title="https://maps.app.goo.gl/sfeJaYK2Q1X3JoWq5">
                  Thaw Designer - SF NO. 128/2, <br>
                  Ground Floor, Chandra Garden Road, <br>
                  behind Aalam Montessori school,<br>
                  Thriveni West Road, Kalapatti,<br>
                  Coimbatore, Tamil Nadu 641035.
                </a>
              </p>
            </div>
          </div>
          <div class="col-md-6 col-lg-4">
            <div class="cont-cont d-flex flex-column align-items-center">
              <h4 class="d-flex flex-column align-items-center"> <i class="bi bi-telephone-fill"></i> call us</h4>
              <p>

                <a href="tel:+9190956 59705"><i class="bi bi-telephone-fill"></i> +91 90956 59705 </a>
              </p>
              <p>

                <a href="tel:+919384998646"><i class="bi bi-telephone-fill"></i> +91 93849 98646 </a>
              </p>
              </p>
            </div>
          </div>
          <div class="col-md-6 col-lg-4">
            <div class="cont-cont d-flex flex-column align-items-center">
              <h4 class="d-flex flex-column align-items-center"> <i class="bi bi-envelope-fill"></i> email support</h4>
              <p>
                <a href="mailto:enquiry@thawdesigners.in"><i class="bi bi-envelope-fill"></i> enquiry@thawdesigners.in </a>
              </p>
            </div>
          </div>

        </div>
        <!-- 2 -->
        <div class="row">
          <div class="col-lg-6 col-md-6 mb-5">
            <div class="con-form" id="enquire-now">
              <h4>enquire now</h4>
              <form action="contact.php" method="POST" id="contact-main">
                <div class="row">
                  <div class="col-md-6">
                    <label>Name<span class="required">*</span></label>
                    <input type="text" class="form-control" placeholder="Name *" name="name" id="name">
                    <div class="error-msg text-danger" id="name-error"></div>
                  </div>

                  <div class="col-md-6">
                    <label>Email Id<span class="required">*</span></label>
                    <input type="email" class="form-control" placeholder="Email Id *" name="email" id="email">
                    <div class="error-msg text-danger" id="email-error"></div>
                  </div>

                  <div class="col-md-6">
                    <label>Mobile Number<span class="required">*</span></label>
                    <input type="text" class="form-control" placeholder="Mobile Number *" name="mobile" id="mobile">
                    <div class="error-msg text-danger" id="mobile-error"></div>
                  </div>

                  <div class="col-md-6">
                    <label>Subject</label>
                    <input type="text" class="form-control" placeholder="Subject *" name="subject" id="subject">
                    <div class="error-msg text-danger" id="subject-error"></div>
                  </div>

                  <div class="col-md-12">
                    <label>Message<span class="required">*</span></label>
                    <textarea class="form-control" placeholder="Message *" name="message" rows="5" id="message"></textarea>
                    <div class="error-msg text-danger" id="message-error"></div>
                  </div>
                </div>

                <div class="row">
                  <div class="col-lg-12 col-md-12">
                    <div class="text-center mt-3">
                      <button class="btn btn-primary" type="submit"><i class="bi bi-envelope-fill"></i> Submit</button>
                    </div>
                  </div>
                </div>
              </form>

            </div>
          </div>
          <div class="col-lg-6 col-md-6 mb-5">
            <div class="map-sec">
                <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d4644.430628385612!2d77.0322857!3d11.0840842!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x3ba8f977ad684c51%3A0x60b9bf70d701fc83!2sThaw%20Designers%20%7CBest%20Architect%20in%20Coimbatore%20%7C%20House%20Interior%20Designer%20in%20Coimbatore%20%7C%20Best%20Interior%20Designer%20in%20Coimbatore!5e1!3m2!1sen!2sin!4v1756711702039!5m2!1sen!2sin" width="100%" height="450" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
            </div>
          </div>
        </div>
      </div>
    </section>

  </main>
  <!-- footer -->
  <?php include("./includes/footer.php") ?>
  <!-- script -->
  <?php include("./includes/script.php") ?>

  <script>
    document.getElementById('contact-main').addEventListener('submit', function(event) {
      event.preventDefault();
      document.querySelectorAll('.error-message').forEach(element => {
        element.textContent = '';
      });

      let isValid = true;
      const name = document.getElementById('name').value.trim();
      const email = document.getElementById('email').value.trim();
      const phone = document.getElementById('mobile').value.trim();
      const message = document.getElementById('message').value.trim();

      if (name === '') {
        document.getElementById('name-error').textContent = 'Name is required';
        isValid = false;
      }
      if (email === '') {
        document.getElementById('email-error').textContent = 'Email is required';
        isValid = false;
      } else if (!validateEmail(email)) {
        document.getElementById('email-error').textContent = 'Invalid email format';
        isValid = false;
      }
      if (mobile === '') {
        document.getElementById('mobile-error').textContent = 'Phone number is required';
        isValid = false;
      }
      if (message === '') {
        document.getElementById('message-error').textContent = 'Message is required';
        isValid = false;
      }

      console.log(isValid);
      if (isValid) {
        const formData = new FormData(document.getElementById('contact-main'));
        fetch('contact.php', {
            method: 'POST',
            body: formData,
          })
          .then(response => response.json())
          .then(data => {
            Toastify({
              text: data.message,
              duration: 3000,
              close: true,
              gravity: 'top',
              position: 'right',
              backgroundColor: data.status === 'success' ? 'green' : 'red',
            }).showToast();
            console.log(data);

            document.getElementById('contact-main').reset();

          })
          .catch(() => {
            Toastify({
              text: 'An error occurred while submitting the form. Please try again later.',
              duration: 3000,
              close: true,
              gravity: 'top',
              position: 'right',
              backgroundColor: 'red',
            }).showToast();
          });
      }
    });

    function validateEmail(email) {
      const re = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
      return re.test(email.toLowerCase());
    }



    document.getElementById('mobile').addEventListener('input', function() {
      this.value = this.value.replace(/[^0-9]/g, '');
    });
  </script>

</body>

</html>