<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">

  <!-- meta tag -->
  <title>Top Interior Designers in Coimbatore | Interior Designers</title>
  <meta name="description" content="Discover top interior designers in Coimbatore offering modern home interiors, turnkey interior solutions, and expert residential interior designers Coimbatore">

  <!-- Open Graph Meta Tags -->
  <meta property="og:type" content="website" />
  <meta property="og:title" content="Top Interior Designers in Coimbatore | Interior Designers" />
  <meta property="og:image" content="https://thawdesigners.in/assets/img/Thaw-Designers.webp" />
  <meta property="og:image:width" content="446" />
  <meta property="og:image:height" content="336" />
  <meta property="og:description" content="Discover top interior designers in Coimbatore offering modern home interiors, turnkey interior solutions, and expert residential interior designers Coimbatore" />
  <meta property="og:url" content="https://www.thawdesigners.in/" />
  <meta property="og:site_name" content="Thaw Designers" />
  <meta property="fb:admins" content="100047348516276" />
  <meta property="og:locale" content="en_IN" />
  <link rel="me" href="https://www.facebook.com/profile.php?id=100047348516276" />
  <link rel="me" href="https://www.instagram.com/thawdesigners/" />
  <link rel="me" href="https://www.youtube.com/@Thawdesigners" />
  <meta name="robots" content="index, follow" />
  <meta name="language" content="English" />
  <meta name="geo.placename" content="Coimbatore, Madurai, Chennai,Bangalore, Tamil Nadu, India" />
  <meta name="copyright" content="https://www.thawdesigners.in/" />
  <meta name="google-site-verification" content="sQBzNCJ9wUa26uRAJu9OtJVFbCQ2lE-YXyst3D9uoSs" />
  <meta name="twitter:card" content="summary_large_image" />
  <meta name="twitter:title" content="Top Interior Designers in Coimbatore | Interior Designers" />
  <meta name="twitter:description" content="Discover top interior designers in Coimbatore offering modern home interiors, turnkey interior solutions, and expert residential interior designers Coimbatore" />
  <meta name="twitter:image" content="https://thawdesigners.in/assets/img/Thaw-Designers.webp" />

  <!-- canonical tag -->
  <link rel="canonical" href="https://thawdesigners.in/" />

  <!-- schema tag -->
  <script type='application/ld+json'>
    {
      "@context": "https://schema.org",
      "@type": "LocalBusiness",
      "name": "Thaw Designers",
      "image": "https://thawdesigners.in/assets/img/Thaw-Designers.webp",
      "@id": "https://www.thawdesigners.in/",
      "url": "https://www.thawdesigners.in/index.php",
      "telephone": "+91 90956 59705",
      "description": "Thaw Designers offers expert interior design and
      architecture services in Coimbatore and Bangalore,
      including
      residential,
      commercial,
      apartment,
      villa,
      office,
      school,
      and
      hospital design solutions.
      ",
      "address": {
        "@type": "PostalAddress",
        "streetAddress": "SF NO. 128/2, Chandra Garden, Road,
        behind Aalam Montessori school,
        Thriveni West ",
        "addressLocality": "Kalapatti, Coimbatore",
        "addressRegion": "Tamil Nadu",
        "postalCode": "641035",
        "addressCountry": "IN"
      },
      "geo": {
        "@type": "GeoCoordinates",
        "latitude": 11.084082987551191,
        "longitude": 77.0322872680657
      },
      "openingHoursSpecification": [{
        "@type": "OpeningHoursSpecification",
        "dayOfWeek": [
          "Monday",
          "Tuesday",
          "Wednesday",
          "Thursday",
          "Friday",
          "Saturday"
        ],
        "opens": "09:30",
        "closes": "19:00"
      }],
      "areaServed": [
        "Coimbatore",
        "Chennai",
        "Madurai",
        "Tamil Nadu",
        "Bangalore",
        "India",
      ],
      "sameAs": [
        "https://www.facebook.com/architectscoimbatore/",
        "https:https://www.instagram.com/thawdesigners/",
        "https:https://in.pinterest.com/thawseo2024/",
        "https:https://www.youtube.com/@Thawdesigners",
        "https:https://x.com/thaw_Designers"
      ]
    }
  </script>

  <!-- Google tag (gtag.js) -->
  <script async src="https://www.googletagmanager.com/gtag/js?id=G-9WRLDDSSCM"></script>
  <script>
    window.dataLayer = window.dataLayer || [];

    function gtag() {
      dataLayer.push(arguments);
    }
    gtag('js', new Date());
    gtag('config', 'G-9WRLDDSSCM');
  </script>

  <!-- Google Tag Manager -->
  <script>
    (function(w, d, s, l, i) {
      w[l] = w[l] || [];
      w[l].push({
        'gtm.start': new Date().getTime(),
        event: 'gtm.js'
      });
      var f = d.getElementsByTagName(s)[0],
        j = d.createElement(s),
        dl = l != 'dataLayer' ? '&l=' + l : '';
      j.async = true;
      j.src =
        'https://www.googletagmanager.com/gtm.js?id=' + i + dl;
      f.parentNode.insertBe
      fore(j, f);
    })(window, document, 'script', 'dataLayer', 'GTM-5ZV73TVX');
  </script>
  <!-- End Google Tag Manager -->

  <!-- head -->
  <?php include("./includes/head.php"); ?>

</head>

<body>

  <!-- Google Tag Manager (noscript) -->
  <noscript><iframe
      src="https://www.googletagmanager.com/ns.html?id=GTM-5ZV73TVX"
      height="0" width="0"
      style="display:none;visibility:hidden"></iframe></noscript>
  <!-- End Google Tag Manager (noscript) -->

  <!-- header -->
  <?php include("./includes/header.php") ?>

  <main id="main">

    <!-- banner section -->
    <div class="home-main-slider-master">
      <header>
        <div id="slidermaster" class="owl-carousel owl-theme">
        </div>
      </header>
    </div>

    <!-- Features -->
    <section class="section-padding features-bg">
      <div class="container-fluid">
        <div class="row text-center justify-content-center">

          <div class="col-md-3 col-sm-6 col-12 design-service-box unique-box-1 wow animate__animated animate__fadeInUp">
            <div class="design-icon">
              <i class="bi bi-building" style="font-size: 48px;"></i>
            </div>
            <div class="design-title">Multidisciplinary Expertise</div>
            <div class="design-description">Offers a wide range of services including Architectural Design, Interior Design Consultancy, Project Management, Contract Works, Layout Planning, and Renovation.</div>
            <div class="design-underline">
              <div class="design-underline-line"></div>
              <div class="design-underline-dot"></div>
              <div class="design-underline-line"></div>
            </div>
          </div>

          <div class="col-md-3 col-sm-6 col-12 design-service-box unique-box-2 wow animate__animated animate__fadeInUp" data-wow-delay="0.3s">
            <div class="design-icon">
              <i class="bi bi-geo-alt-fill" style="font-size: 48px;"></i>
            </div>
            <div class="design-title">Geographical Reach</div>
            <div class="design-description">Headquartered in Bangalore with operational branches in Coimbatore, serving clients across India and internationally.</div>
            <div class="design-underline">
              <div class="design-underline-line"></div>
              <div class="design-underline-dot"></div>
              <div class="design-underline-line"></div>
            </div>
          </div>

          <div class="col-md-3 col-sm-6 col-12 design-service-box unique-box-3 wow animate__animated animate__fadeInUp" data-wow-delay="0.6s">
            <div class="design-icon">
              <i class="bi bi-person-heart" style="font-size: 48px;"></i>
            </div>
            <div class="design-title">Client-Centered Approach</div>
            <div class="design-description">Committed to transforming client visions into architectural realities with passion, precision, and professionalism.</div>
            <div class="design-underline">
              <div class="design-underline-line"></div>
              <div class="design-underline-dot"></div>
              <div class="design-underline-line"></div>
            </div>
          </div>

        </div>
      </div>
    </section>

    <!-- about us section -->
    <section class="home01 section-padding">
      <div class="float-img01">
        <img src="assets/img/shapes/Top-interior-designers-in-Coimbatore.webp" class="img-fluid" alt="Top interior designers in Coimbatore" title="Top interior designers in Coimbatore" loading="lazy">
      </div>
      <div class="float-img02">
        <img src="assets/img/shapes/expert-interior-designers-in-Coimbatore.webp" class="img-fluid" alt="expert interior designers in Coimbatore" title="expert interior designers in Coimbatore" loading="lazy">
      </div>
      <div class="float-glow">
        <img class="img-fluid" src="./assets/img/shapes/commercial-interior-designer-in-tamilnadu.webp" alt="commercial interior designer in tamilnadu" title="commercial interior designer in tamilnadu" loading="lazy">
      </div>

      <div class="container">

        <div class="row">

          <div class="col-lg-6 col-lg-6">
            <div class="hom-img">
              <img src="assets/img/home/Best-Interior-Designers-in-Coimbatore.webp" class="img-fluid" alt="Best Interior Designers in Coimbatore" title="Best Interior Designers in Coimbatore" loading="lazy">
            </div>
          </div>

          <div class="col-lg-6 col-lg-6 d-flex flex-column justify-content-center">
            <div class="hom-cont">
              <h1> <span>a</span>bout <span>u</span>s</h1>
              <p>
                THAW Designers, established in 2002, is a multidisciplinary architectural firm offering services in architectural and interior design consultancy, project management, layout planning, and renovation. With branches in Bangalore and Coimbatore, THAW is driven by a passionate team committed to transforming client dreams into reality through innovation, quality, and excellence.
              </p>
              <p>At THAW Designers, we don't just build spaces — we shape experiences. With over two decades of expertise, our multidisciplinary team blends creativity, precision, and functionality to deliver designs that inspire. Whether it's architectural planning, interior innovation, or full-scale project management, our solutions are tailored to elevate every environment.</p>
              <div class="progress-container">
                <div class="d-flex justify-content-between">
                  <div class="progress-title">ARCHITECTURE</div>
                  <div class="progress-value" id="arch-percent">0%</div>
                </div>
                <div class="progress">
                  <div class="progress-bar" role="progressbar" id="arch-bar" style="width: 0%"></div>
                </div>
              </div>

              <div class="progress-container">
                <div class="d-flex justify-content-between">
                  <div class="progress-title">INTERIOR DESIGN</div>
                  <div class="progress-value" id="interior-percent">0%</div>
                </div>
                <div class="progress">
                  <div class="progress-bar" role="progressbar" id="interior-bar" style="width: 0%"></div>
                </div>
              </div>
              <br>
              <div>
                <a href="about-us.php" class="custom-btn hvr-sweep-to-right">
                  About Us <i class="bi bi-arrow-right"></i>
                </a>
              </div>

            </div>
          </div>
        </div>
      </div>
    </section>

    <!-- our project -->
    <section class="home03 section-padding">
      <div class="container">
        <h2 class="clr-head"> <span class="bold-span">o</span>ur <span class="color-span"><span class="bold-span">p</span>rojects</span> </h2>
        <p class="para-ser text-justify">
          Thaw Designers is a leading multidisciplinary firm in South India, offering exceptional architectural and interior design services across Coimbatore, Bangalore, and beyond. With a strong focus on client relationships, innovation, and quality, we specialize in residential, commercial, healthcare, spiritual, and public space projects — from villas and resorts to stadiums and churches.
        </p>
        <div class="row">
          <div class="col-lg-4 col-md-12">
            <!-- button -->
            <div>
              <button class="tab-category active" onclick="toggleTabGroup('architectureTab', this)">Architecture</button>
              /
              <button class="tab-category" onclick="toggleTabGroup('interiorTab', this)">Interior</button>
            </div>

            <!-- Architecture -->
            <div class="tab" id="architectureTab">

              <button class="tablinks" id="defaultOpen" onclick="opentab(event, 'tabone')">
                <i class="bi bi-house-door-fill"></i> Residence
              </button>

              <button class="tablinks" onclick="opentab(event, 'tabtwo')">
                <i class="bi bi-building"></i> Apartment
              </button>

              <button class="tablinks" onclick="opentab(event, 'tabthree')">
                <i class="bi bi-shop"></i> Commercial
              </button>

              <button class="tablinks" onclick="opentab(event, 'tabfour')">
                <i class="bi bi-mortarboard"></i> School
              </button>

              <button class="tablinks" onclick="opentab(event, 'tabfive')">
                <i class="bi bi-hospital"></i> Hospital
              </button>

            </div>

            <div class="tab" id="interiorTab" style="display: none;">
              <button class="tablinks" onclick="opentab(event, 'tabone-int')">
                <i class="bi bi-house-door-fill"></i> Residence
              </button>

              <button class="tablinks" onclick="opentab(event, 'tabtwo-int')">
                <i class="bi bi-shop"></i> Commercial
              </button>

              <button class="tablinks" onclick="opentab(event, 'tabthree-int')">
                <i class="bi bi-building"></i> Apartment
              </button>

              <button class="tablinks" onclick="opentab(event, 'tabfour-int')">
                <i class="bi bi-mortarboard"></i> School
              </button>
            </div>
          </div>

          <div class="col-lg-8 col-md-12 mt-5">

            <!-- architecture -->
            <div id="tabone" class="tabcontent">
              <img src="assets/img/home/architecture/Residence-architecture-in-coimbatore.webp" class="img-fluid" alt="Residence architecture in coimbatore" title="Residence architecture in coimbatore" loading="lazy">
              <div class="tab-para">
                <p> At Thaw Designers, we specialize in residential architecture design that reflects the lifestyle, values, and aspirations of our clients. As leading residential architects in Coimbatore, we understand that your home is more than just a structure — it’s a space where comfort meets creativity. From concept to completion, our team works closely with homeowners to design personalized spaces that are both aesthetically pleasing and functionally sound. </p>
              </div>
            </div>

            <div id="tabtwo" class="tabcontent">
              <img src="assets/img/home/architecture/Apartment-architecture-in-coimbatore.webp" class="img-fluid" alt="Apartment architecture in coimbatore" title="Apartment architecture in coimbatore" loading="lazy">
              <div class="tab-para">
                <p>At Thaw Designers, we are leading apartment architects in Coimbatore, known for delivering efficient, elegant, and budget-friendly apartment projects. Our team focuses on modern apartment architecture design that optimizes space, enhances natural lighting, and blends functionality with style. As one of the best residential apartment architects, we ensure every design is tailored to urban lifestyles, safety norms, and long-term durability — making us the preferred choice for apartment construction planning.</p>
              </div>
            </div>

            <div id="tabthree" class="tabcontent">
              <img src="assets/img/home/architecture/Commercial-architecture-in-coimbatore.webp" class="img-fluid" alt="Commercial architecture in coimbatore" title="Commercial architecture in coimbatore" loading="lazy">
              <div class="tab-para">
                <p> Thaw Designers stands among the top architects for office in Coimbatore, delivering innovative and functional office design solutions that suit modern work environments. We specialize in corporate office architecture, blending space efficiency, aesthetics, and brand identity. Our office projects across Coimbatore and other parts of India reflect smart planning, employee comfort, and future-ready workspace solutions tailored to your business goals.</p>
              </div>
            </div>

            <div id="tabfour" class="tabcontent">
              <img src="assets/img/home/architecture/School-architecture-in-coimbatore.webp" class="img-fluid" alt="School architecture in coimbatore" title="School architecture in coimbatore" loading="lazy">
              <div class="tab-para">
                <p> Thaw Designers specializes in school architecture design that promotes learning, safety, and sustainability. As one of the top commercial architects in Coimbatore, we create smart layouts for educational institutions across India, focusing on natural light, ventilation, and future-ready infrastructure. Our goal is to deliver inspiring, functional school environments that support academic growth and community engagement.</p>
              </div>
            </div>

            <div id="tabfive" class="tabcontent">
              <img src="assets/img/home/architecture/Hospital-architecture-in-coimbatore.webp" class="img-fluid" alt="Hospital architecture in coimbatore">
              <div class="tab-para">
                <p> Thaw Designers is one of the most trusted hospital architects in Coimbatore, offering smart, sustainable, and patient-focused architectural solutions for healthcare facilities. We understand the importance of efficient layouts, hygienic flow, and future-ready designs in hospitals and clinics. As a leading commercial building architect in India, we specialize in planning hospitals that improve patient experience and staff workflow. Our expert team ensures compliance, safety, and operational efficiency in every design.</p>
              </div>
            </div>

            <!-- Interior Tab Contents -->
            <div id="tabone-int" class="tabcontent">
              <img src="assets/img/home/architecture/Residence-interior-in-coimbatore.webp" class="img-fluid" title="Residence interior in coimbatore" loading="lazy" alt="Residence interior in coimbatore">
              <div class="tab-para">
                <p> Transform your living spaces with Thaw Designers, one of the most trusted residential interior designers in Coimbatore. We specialize in crafting personalized home interiors that combine style and comfort. Whether you're looking for modern home interiors or timeless traditional themes, our design team ensures every detail reflects your personality. With projects across India, our focus on quality and creativity makes us a preferred choice for residential interiors in Coimbatore.</p>
              </div>
            </div>

            <div id="tabtwo-int" class="tabcontent">
              <img src="assets/img/home/architecture/Commercial-interior-in-coimbatore.webp" class="img-fluid" alt="Commercial interior in coimbatore" title="Commercial interior in coimbatore" loading="lazy">
              <div class="tab-para">
                <p> At Thaw Designers, we specialize in commercial interior design in Coimbatore, creating stylish and functional spaces that reflect your brand identity. From corporate offices to retail showrooms, we deliver smart, space-saving designs tailored to your business needs. As one of the best office interior designers in Coimbatore, we ensure every detail enhances productivity and professionalism. Trust our expertise to transform your workspace into a modern, client-friendly environment.</p>
              </div>
            </div>

            <div id="tabthree-int" class="tabcontent">
              <img src="assets/img/home/architecture/Apartment-interior-in-coimbatore.webp" class="img-fluid" alt="Apartment interior in coimbatore" title="Apartment interior in coimbatore" loading="lazy">
              <div class="tab-para">
                <p> Thaw Designers offers custom apartment interior design services tailored to meet the needs of urban living across India. Our team of skilled designers works closely with clients to create well-balanced layouts, smart storage, and cohesive design themes. From modular kitchens to stylish living rooms, we deliver complete solutions for apartment interior decoration. Based in Coimbatore, we serve clients nationwide with designs that combine practicality, luxury, and visual appeal.</p>
              </div>
            </div>

            <div id="tabfour-int" class="tabcontent">
              <img src="assets/img/home/architecture/School-interior-in-coimbatore.webp" class="img-fluid" alt="School interior in coimbatore" title="School interior in coimbatore" loading="lazy">
              <div class="tab-para">
                <p> At Thaw Designers, we specialize in school interior design in Coimbatore, delivering spaces that inspire learning and creativity. Our expert team designs classrooms, libraries, staff rooms, and common areas with ergonomics, functionality, and aesthetics in mind. As one of the top providers of school furniture design and educational interiors, we aim to create child-friendly environments that promote focus and productivity across schools in Tamil Nadu and all over India.</p>
              </div>
            </div>

          </div>
        </div>

        <!-- image overlay -->
        <div class="float-img03">
          <img src="assets/img/shapes/interior-design-services-in-Coimbatore.webp" class="img-fluid" alt="interior design services in Coimbatore" title="interior design services in Coimbatore" loading="lazy">
        </div>

        <div class="float-img04">
          <img src="assets/img/shapes/interior-design-services-in-Coimbatore.webp" class="img-fluid" alt="interior design services in Coimbatore" title="interior design services in Coimbatore" loading="lazy">
        </div>

      </div>
    </section>

    <!-- Why Choose Us -->
    <section class="why-choose-us section-padding">
      <div class="why-choose-us-main d-block d-lg-none wow animate__animated animate__fadeInUp">
        <img class="img-fluid" src="./assets/img/bg/Trusted-interior-designers-in-coimbatore" alt="Trusted interior designers in coimbatore" title="Trusted interior designers in coimbatore" loading="lazy" />
      </div>
      <div class="why-choose-us-main-right d-none d-lg-block wow animate__animated animate__fadeInUp">
        <img class="img-fluid" src="./assets/img/bg/leading-Home-Interior-Designers-in-Coimbatore.webp" alt="leading Home Interior Designers in Coimbatore" title="leading Home Interior Designers in Coimbatore" loading="lazy" />
      </div>
      <div class="why-container">
        <div class="container">
          <div class="mb-5 wow animate__animated animate__fadeInUp" data-wow-delay="0.3s">
            <h2 class="why-title">
              <span class="bold-span">w</span>hy
              <span class="color-span"><span class="bold-span">c</span>hoose us</span>
            </h2>
            <p>
              Your satisfaction drives us. From concept to completion, we prioritize
              collaboration, transparency, and attention to detail — ensuring every
              project reflects your unique vision and exceeds expectations.
            </p>
          </div>
        </div>

        <div class="why-grid">

          <div
            class="why-box wow animate__animated animate__fadeInLeft"
            data-wow-delay="0.5s">
            <img src="assets/img/icons/Showroom-Interior-Designers-in-coimbatore.webp" alt="Showroom Interior Designers in coimbatore" title="Showroom Interior Designers in coimbatore" loading="lazy" />
            <h3>50+</h3>
            <h4>Realized projects</h4>
          </div>

          <div
            class="why-box wow animate__animated animate__fadeInUp"
            data-wow-delay="0.7s">
            <img src="assets/img/icons/villa-architects-in-Coimbatore.webp" alt="villa architects in Coimbatore" title="villa architects in Coimbatore" loading="lazy" />
            <h3>10+</h3>
            <h4>Years of experience</h4>
          </div>

          <div
            class="why-box wow animate__animated animate__fadeInRight"
            data-wow-delay="0.9s">
            <img src="assets/img/icons/Trusted-architects-in-coimbatore.webp" alt="Trusted architects in coimbatore" title="Trusted architects in coimbatore" loading="lazy" />
            <h3>25+</h3>
            <h4>Team members</h4>

          </div>

        </div>
      </div>
    </section>

    <!-- Testimonials -->
    <section class="home05 testimonials-section section-padding">
      <div class="container">
        <div class="mb-5 text-center wow animate__animated animate__fadeInUp">
          <h2 class="clr-head"><span class="bold-span">T</span>estimonials</h2>
          <p class="text-white">
            Working with their team was seamless and inspiring. They delivered
            exceptional quality on time and with great attention to detail
          </p>
        </div>
        <div
          class="owl-carousel owl-theme wow animate__animated animate__fadeInUp"
          id="home-testimonials"
          data-wow-delay="0.3s">
          <div class="testimonial-card item">
            <div class="profile">
              <div class="quote-icon">”</div>
            </div>
            <div class="content">
              <p>
                Best Architect service. Their projects are having unique design. Delivery projects at time. Very good quality. Very big design team they have in their office to deliver drawings at time
              </p>

              <div class="stars"> <img class="img-fluid review-icon" src="./assets/img/icons/Commercial-architecture-in-coimbatore.webp" alt="Commercial architecture in coimbatore" title="Commercial architecture in coimbatore" loading="lazy"> ★★★★★</div>
              <h5>Build tech solutions</h5>

            </div>
          </div>

          <div class="testimonial-card item">
            <div class="profile">
              <div class="quote-icon">”</div>
            </div>
            <div class="content">
              <p>
                Thanks to Thaw Designers for designing my dream home and helping me in selection of every things. Excellent work done by them. The final outcome of my home is great and fab. Completely satisfied and happy with their work.
              </p>
              <div class="stars"> <img class="img-fluid review-icon" src="./assets/img/icons/Commercial-architecture-in-coimbatore.webp" alt="Commercial architecture in coimbatore" title="Commercial architecture in coimbatore" loading="lazy"> ★★★★★</div>
              <h5>Nithya Rasumani</h5>

            </div>
          </div>
          <div class="testimonial-card item">
            <div class="profile">
              <div class="quote-icon">”</div>
            </div>
            <div class="content">
              <p>
                Experienced architects and designers with a clear vision and exceptional execution. The project was meticulously planned and delivered right on schedule.
              </p>
              <div class="stars"> <img class="img-fluid review-icon" src="./assets/img/icons/Commercial-architecture-in-coimbatore.webp" alt="Commercial architecture in coimbatore" title="Commercial architecture in coimbatore" loading="lazy"> ★★★★★</div>
              <h5>Sangeeth Prabhakaran</h5>
            </div>
          </div>
          <div class="testimonial-card item">
            <div class="profile">
              <div class="quote-icon">”</div>
            </div>
            <div class="content">
              <p> They really listened to our needs and designed something that works perfectly for us. Truly impressive. </p>
              <div class="stars"> <img class="img-fluid review-icon" src="./assets/img/icons/Commercial-architecture-in-coimbatore.webp" alt="Commercial architecture in coimbatore" title="Commercial architecture in coimbatore" loading="lazy"> ★★★★★</div>
              <h5>Nisha karthiga</h5>
            </div>
          </div>

          <div class="testimonial-card item">
            <div class="profile">
              <div class="quote-icon">”</div>
            </div>
            <div class="content">
              <p> Your consistently meet projects deadlines. And deliver high quality designs.. Highly recommended!!</p>
              <div class="stars"> <img class="img-fluid review-icon" src="./assets/img/icons/Commercial-architecture-in-coimbatore.webp" alt="Commercial architecture in coimbatore" title="Commercial architecture in coimbatore" loading="lazy"> ★★★★★</div>
              <h5>Indra Murugesh</h5>
            </div>
          </div>
        </div>
      </div>
    </section>

    <!-- Call to action section-->
    <section class="cta-section section-padding">
      <div class="cta-content wow animate__animated animate__fadeInUp">
        <h2>Let's Build Something Great Together</h2>
        <p>Contact us today to start your dream project with our expert team.</p>
        <a
          href="contact.php"
          class="cta-btn wow animate__animated animate__pulse"
          data-wow-delay="0.5s"
          data-wow-iteration="infinite">
          Get in Touch
        </a>
      </div>
    </section>

  </main>

  <!-- footer secction -->
  <?php include("./includes/footer.php") ?>

  <!-- script section -->
  <?php include("./includes/script.php") ?>

</body>

</html>