<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">

  <!-- meta tag -->
  <title>Top Interior Designers in Coimbatore | Residential & Commercial</title>
  <meta name="description" content="Top interior designers in Coimbatore delivering modern residential and commercial interiors, modular kitchens, and custom home interior solutions">

  <!-- Open Graph Meta Tags -->
  <meta property="og:type" content="website" />
  <meta property="og:title" content="Top Interior Designers in Coimbatore | Residential & Commercial" />
  <meta property="og:image" content="https://thawdesigners.in/assets/img/Thaw-Designers.webp" />
  <meta property="og:image:width" content="446" />
  <meta property="og:image:height" content="336" />
  <meta property="og:description" content="Top interior designers in Coimbatore delivering modern residential and commercial interiors, modular kitchens, and custom home interior solutions" />
  <meta property="og:url" content="https://www.thawdesigners.in/interiors.php" />
  <meta property="og:site_name" content="Thaw Designers" />
  <meta property="fb:admins" content="100047348516276" />
  <meta property="og:locale" content="en_IN" />
  <link rel="me" href="https://www.facebook.com/profile.php?id=100047348516276" />
  <link rel="me" href="https://www.instagram.com/thawdesigners/" />
  <link rel="me" href="https://www.youtube.com/@Thawdesigners" />
  <meta name="robots" content="index, follow" />
  <meta name="language" content="English" />
  <meta name="geo.placename" content="Coimbatore, Madurai, Chennai,Bangalore, Tamil Nadu, India" />
  <meta name="copyright" content="https://www.thawdesigners.in/" />
  <meta name="google-site-verification" content="sQBzNCJ9wUa26uRAJu9OtJVFbCQ2lE-YXyst3D9uoSs" />
  <meta name="twitter:card" content="summary_large_image" />
  <meta name="twitter:title" content="Top Interior Designers in Coimbatore | Residential & Commercial" />
  <meta name="twitter:description" content="Top interior designers in Coimbatore delivering modern residential and commercial interiors, modular kitchens, and custom home interior solutions" />
  <meta name="twitter:image" content="https://thawdesigners.in/assets/img/Thaw-Designers.webp" />

  <!-- canonical tag -->
  <link rel=" canonical" href="https://thawdesigners.in/interiors.php" />

  <!-- schema tag -->
  <script type='application/ld+json'>
    {
      "@context": "https://schema.org",
      "@type": "LocalBusiness",
      "name": "Thaw Designers",
      "image": "https://thawdesigners.in/assets/img/Thaw-Designers.webp",
      "@id": "https://www.thawdesigners.in/",
      "url": "https://www.thawdesigners.in/interiors.php",
      "telephone": "+91 90956 59705",
      "description": "Thaw Designers offers expert interior design and
      architecture services in Coimbatore and Bangalore,
      including
      residential,
      commercial,
      apartment,
      villa,
      office,
      school,
      and
      hospital design solutions.
      ",
      "address": {
        "@type": "PostalAddress",
        "streetAddress": "SF NO. 128/2, Chandra Garden, Road,
        behind Aalam Montessori school,
        Thriveni West ",
        "addressLocality": "Kalapatti, Coimbatore",
        "addressRegion": "Tamil Nadu",
        "postalCode": "641035",
        "addressCountry": "IN"
      },
      "geo": {
        "@type": "GeoCoordinates",
        "latitude": 11.084082987551191,
        "longitude": 77.0322872680657
      },
      "openingHoursSpecification": [{
        "@type": "OpeningHoursSpecification",
        "dayOfWeek": [
          "Monday",
          "Tuesday",
          "Wednesday",
          "Thursday",
          "Friday",
          "Saturday"
        ],
        "opens": "09:30",
        "closes": "19:00"
      }],
      "areaServed": [
        "Coimbatore",
        "Chennai",
        "Madurai",
        "Tamil Nadu",
        "Bangalore",
        "India",
      ],
      "sameAs": [
        "https://www.facebook.com/architectscoimbatore/",
        "https:https://www.instagram.com/thawdesigners/",
        "https:https://in.pinterest.com/thawseo2024/",
        "https:https://www.youtube.com/@Thawdesigners",
        "https:https://x.com/thaw_Designers"
      ]
    }
  </script>

  <!-- Google tag (gtag.js) -->
  <script async src="https://www.googletagmanager.com/gtag/js?id=G-9WRLDDSSCM"></script>
  <script>
    window.dataLayer = window.dataLayer || [];

    function gtag() {
      dataLayer.push(arguments);
    }
    gtag('js', new Date());
    gtag('config', 'G-9WRLDDSSCM');
  </script>

  <!-- Google Tag Manager -->
  <script>
    (function(w, d, s, l, i) {
      w[l] = w[l] || [];
      w[l].push({
        'gtm.start': new Date().getTime(),
        event: 'gtm.js'
      });
      var f = d.getElementsByTagName(s)[0],
        j = d.createElement(s),
        dl = l != 'dataLayer' ? '&l=' + l : '';
      j.async = true;
      j.src =
        'https://www.googletagmanager.com/gtm.js?id=' + i + dl;
      f.parentNode.insertBe
      fore(j, f);
    })(window, document, 'script', 'dataLayer', 'GTM-5ZV73TVX');
  </script>
  <!-- End Google Tag Manager -->

  <!-- head -->
  <?php include("./includes/head.php"); ?>


</head>

<body>

  <!-- Google Tag Manager (noscript) -->
  <noscript><iframe
      src="https://www.googletagmanager.com/ns.html?id=GTM-5ZV73TVX"
      height="0" width="0"
      style="display:none;visibility:hidden"></iframe></noscript>
  <!-- End Google Tag Manager (noscript) -->

  <!-- header -->
  <?php include("./includes/header.php") ?>

  <!-- Sub Banner Section -->
  <div class="sub-banner">
    <div class="overlay"></div>
    <div class="sub-banner-content text-center">
      <h1 class="title">Interior</h1>
      <nav class="breadcrumb">
        <a href="index.php">Home</a> &nbsp; / &nbsp; <span>Interior</span>
      </nav>
    </div>
  </div>

  <main id="main">

    <section class="projects01 ">
      <div class="container">
        <h1>Interior</h1>
        <div class="row">
          <div class="col-12">
            <div>
              <ul class="project-filter list-inline text-center mb-4">
                <li class="list-inline-item active" data-filter="all">All</li>
                <li class="list-inline-item" data-filter="residence">Residence</li>
                <li class="list-inline-item" data-filter="apartment">Apartment</li>
                <li class="list-inline-item" data-filter="commercial">Commercial</li>
                <li class="list-inline-item" data-filter="school">School</li>
              </ul>
            </div>
          </div>
        </div>
        <div class="row" id="dynamicGallery"></div>
      </div>
    </section>

  </main>
  <!-- footer -->
  <?php include("./includes/footer.php") ?>
  <!-- script -->
  <?php include("./includes/script.php") ?>



</body>
<script>
  const imageData = [{
      filename: "Interior-Designers.webp",
      title: "Proposed interiors at Periyanaickem Palayam",
      alt: "top interior designers in Coimbatore",
      imgtitle: "top interior designers in Coimbatore",
      para: "Mani’s Residency Proposed Interiors...",
      category: "residence",

      folder: "residence/proposed",
      multiimages: [
        "Interior-Designers.webp",
        "Best-interior-designers.webp",
        "top-interior-designers-in-Coimbatore.webp",
        "best-interior-design-company.webp",
        "Interior-design-Company-in-Coimbatore.webp",
        "Top-interior-designers.webp",
        "Residence-interior-designers-in-Coimbatore.webp",
        "Residency-interior-designers.webp"
      ]
    }, {
      filename: "Best-interior-designers-in-Chennai.webp",
      title: "Taisha Park - Chennai",
      alt: "Best interior designers in Chennai",
      imgtitle:"Best interior designers in Chennai",
      para: "HIG Project offers luxury apartment interior design with elegant and functional layouts, spacious living areas, premium finishes, and modern amenities for upscale urban living",
      category: "residence",
      folder: "apartment/taisha park",
      multiimages: [
        "interior-Design-Company.webp",
        "Top-10-Interior-design-Company.webp",
        "apartment-interior-design-company.webp",
        "Apartment-interior-designers-in-Coimbatore.webp",
        "best-apartment-interior-designers-in-coimbatore.webp",
        "Apartment-interior-designers.webp",
        "expert-interior-design-company.webp",
        "Apartment-interior-designers-in-Bangalore.webp"      ]
    },

    {
      filename: "Interior-designers-in-Coimbatore.webp",
      title: "Icon City Velankuruchi",
      alt: "Best interior designers",
      imgtitle:"Best interior designers",
      para: "Icon City Velankuruchi blends contemporary residential interiors with lush surroundings, spacious homes, premium amenities, and a vibrant community for elegant urban living.",
      category: "apartment",
      folder: "apartment/icon-city",
      multiimages: [
        "Best-interior-designers.webp",
        "Dining-hall-interior-designers-in-Coimbatore.webp",
        "Home-interior-designers-in-Coimbatore.webp",
        "Kitchen-interior-designers-in-Coimbatore.webp",
        "Modular-kitchen-interior-designers-in-Coimbatore.webp",
        "Hall-interior-design-company.webp",
        "Bedroom-interior-designers-in-Coimbatore.webp",
        "Poja-room-interior-designers.webp",
        "Poja-room-interior-designers-in-Coimbatore.webp"      ]
    },

    {
      filename: "Office-Interior-designers-in-Coimbatore.webp",
      title: "IMR Office, Salem",
      alt: "Office Interior designers in Coimbatore",
      imgtitle:"Office Interior designers in Coimbatore",
      para: "IMR Office in Salem features premium office interior design concepts, offering contemporary workspace layouts designed to enhance productivity with elegant and functional interiors.",
      category: "commercial",
      folder: "commercial/IMR office",
      multiimages: [
        "Top-office-interior-Designers.webp",
        "Best-interior-designers-in-Coimbatore.webp",
        "Commercial-interior-designers-in-Coimbatore.webp",
        "Top-interior-design-company.webp",
        "Top-office-interior-designers-company-in-Coimbatore.webp",
        "Office-interior-designers.webp",
        "Best-designers-for-office-ion-Coimbatore.webp",
        "Interior-designing-company-in-Coimbatore.webp",
        "Coimbatore-interior-designers.webp",
        "Best-interior-designers-company.webp",
        "Office-interior-design-company.webp"      ]
    },
    {
      filename: "Habitat-interior-designers-in-Coimbatore.webp",
      title: "Shells, Customised Habitat",
      alt: "Habitat interior designers in Coimbatore",
       imgtitle:"Habitat interior designers in Coimbatore",
      para: "Shells, Customised Habitat showcases innovative residential interior design in Coimbatore with personalized spaces, modern aesthetics, and sustainable layouts tailored for elegant and comfortable living",
      category: "residence",
      folder: "residence/shells",
      multiimages: [
        "Habitat-interior-designers-in-Coimbatore.webp",
        "interior-designers-near-me.webp",
        "interior-design-company-near-me.webp",
        "Best-habitat-interior-design-company.webp",
        "Habitat-interior-design-company-in-Coimbatore.webp",
        "Commercial-interior-designers-near-me.webp",
        "interior-designers-near-me-Coimbatore.webp"

      ]
    },
    {
      filename: "Show-room-interior-designers-in-Coimbatore.webp",
      title: "TAS it all (showroom)",
      alt: "Show room interior designers in Coimbatore",
       imgtitle:"Show room interior designers in Coimbatore",
      para: "TAS IT All showroom interiors reflect a bold retail interior design concept with premium displays, vibrant lighting, and a strategic layout that enhances customer experience and strengthens brand presence.",
      category: "commercial",
      folder: "commercial/TAS it all",
      multiimages: [
        "Showroom-interior-design-company-in-Coimbatore.webp",
        "Showroom-interior-design-company-near-me.webp",
        "Show-room-interior-design-company-near-me.webp",
        "showroom-interior-designers.webp"      ]
    },


    {
      filename: "Laboratory-interior-designers-in-Coimbatore.webp",
      title: "Ticel Bio Park, Dlux Tech, Coimbatore",
      alt: "Laboratory interior designers in Coimbatore",
      imgtitle:"Laboratory interior designers in Coimbatore",
      para: "Ticel Bio Park interiors in Coimbatore blend advanced laboratory interior design with functional workspaces, creating a modern environment ideal for research, innovation, and productivity",
      category: "commercial",
      folder: "commercial/Ticel biopark",
      multiimages: [
        "Laboratory-interior-designers-in-Coimbatore.webp",
        "Office-interior-designers-near-me.webp",

      ]
    },
    {
      filename: "School-interior-designers-in-Coimbatore.webp",
      title: "VMJ School",
      alt: "School interior designers in Coimbatore",
      imgtitle:"School interior designers in Coimbatore",
      para: "VMJ School interiors are thoughtfully designed to inspire learning with vibrant classrooms, interactive spaces, and child-friendly layouts, making it a standout in school interior design in India.",
      category: "school",
      folder: "school/VMJ school",
      multiimages: [
        "School-interior-designers-in-Coimbatore.webp",
        "interior-designers-for-school.webp",
        "School-interior-designers-near-me.webp",
      ]
    },

    {
      filename: "Interior-designers-in-Coimbatore.webp",
      title: "Mr.Vijay Residency, Madurai",
      alt: "Interior designers in Coimbatore",
       imgtitle:"Interior designers in Coimbatore",
      para: "Vijay Residency in Madurai presents elegant luxury residential interiors with high-end finishes, spacious layouts, and a perfect blend of comfort, sophistication, and modern living.",
      category: "residence",
      folder: "residence/vijay",
      multiimages: [
        "Interior-designers-in-Coimbatore.webp",
        "Home-interior-designers-near-me.webp",
        "Home-interior-design-company-near-me.webp",
        "Bedroom-interior-designers.webp",
        "Kitchen-interior-designers-near-me.webp",
        "Home-interior-designers.webp",
        "Interior-designers-in-Madurai.webp",
        "Top-interior-designers.webp",
        "Best-designers-for-home-interior.webp",
        "budget-friendly-interior-designers.webp",
        "interior-designers.webp",
        "Home-interior-designer.webp",
        "commercial-interior-designers.webp"
      ]
    },
    {
      filename: "Home-interior-designers-in-Coimbatore.webp",
      title: "MR. Wanstinman RES, Goundampalayam",
      alt: "MR. Wanstinman RES, Goundampalayam",
       imgtitle:"Home interior designers in Coimbatore",
      para: "Proposed Interiors MR. Wanstinman RES Residence in Goundampalayam showcases personalized residential interior design in Coimbatore, featuring modern design elements, cozy spaces, and elegant finishes tailored for contemporary living.",
      category: "residence",
      folder: "residence/wanstinman",
      multiimages: [
        "Home-interior-designers-in-Coimbatore.webp",
        "Commercial-interior-designers-in-Coimbatore.webp",
        "Best-interior-designers-for-home-in-Coimbatore.webp",
      ]
    },

  ];

  const container = document.getElementById("dynamicGallery");

  imageData.forEach(({
    filename,
    title,
    alt,
    category,
    imgtitle,
    para,
    multiimages,
    folder
  }) => {
    const colDiv = document.createElement("div");
    colDiv.className = `col-lg-4 col-md-6 mb-4 gallery-item ${category}`;

    // Base folder path
    const basePath = `./assets/img/projects/interiors/${folder}/`;

    // Main image link
    let lightboxLinks = `
    <a href="${basePath}${multiimages[0]}" class="glightbox" data-gallery="${title}" data-title="${title}">
      <img class="img-fluid" src="${basePath}${filename}" alt="${alt}" title="${imgtitle}" loading="lazy">
      <div class="overlay-icon">
        <i class="bi bi-eye"></i>
      </div>
      <p class="image-caption-h2 text-center mt-2">${title}</p>
      <p class="image-caption text-center mt-2">${para}</p>
    </a>
  `;

    for (let i = 1; i < multiimages.length; i++) {
      lightboxLinks += `
      <a href="${basePath}${multiimages[i]}" class="glightbox d-none" data-gallery="${title}" data-title="${title}"></a>
    `;
    }

    colDiv.innerHTML = `
    <div class="image-box position-relative overflow-hidden">
      ${lightboxLinks}
    </div>
  `;

    container.appendChild(colDiv);
  });

  const lightbox = GLightbox({
    selector: '.glightbox',
    touchNavigation: true,
    loop: true,
    zoomable: false
  });
</script>


<script>
  const filterButtons = document.querySelectorAll('.project-filter li');
  filterButtons.forEach(btn => {
    btn.addEventListener('click', () => {
      const filter = btn.getAttribute('data-filter');
      filterButtons.forEach(b => b.classList.remove('active'));
      btn.classList.add('active');
      document.querySelectorAll('.gallery-item').forEach(item => {
        if (filter === 'all' || item.classList.contains(filter)) {
          item.style.display = "block";
        } else {
          item.style.display = "none";
        }
      });
    });
  });
</script>

</html>