<!DOCTYPE html>
<html lang="en">


<head>
     <meta charset="utf-8">
     <meta content="width=device-width, initial-scale=1.0" name="viewport">


     <!-- meta tag -->
     <title>Top Architects in Coimbatore | Residential&Commercial Design</title>
     <meta name="description" content="Top architects in Coimbatore offering residential and commercial architecture design, custom villas, modern homes, and expert architectural solutions">

     <!-- Open Graph Meta Tags -->
     <meta property="og:type" content="website" />
     <meta property="og:title" content="Top Architects in Coimbatore | Residential&Commercial Design" />
     <meta property="og:image" content="https://thawdesigners.in/assets/img/Thaw-Designers.webp" />
     <meta property="og:image:width" content="446" />
     <meta property="og:image:height" content="336" />
     <meta property="og:description" content="Top architects in Coimbatore offering residential and commercial architecture design, custom villas, modern homes, and expert architectural solutions" />
     <meta property="og:url" content="https://www.thawdesigners.in/jobwork.php" />
     <meta property="og:site_name" content="Thaw Designers" />
     <meta property="fb:admins" content="100047348516276" />
     <meta property="og:locale" content="en_IN" />
     <link rel="me" href="https://www.facebook.com/profile.php?id=100047348516276" />
     <link rel="me" href="https://www.instagram.com/thawdesigners/" />
     <link rel="me" href="https://www.youtube.com/@Thawdesigners" />
     <meta name="robots" content="index, follow" />
     <meta name="language" content="English" />
     <meta name="geo.placename" content="Coimbatore, Madurai, Chennai,Bangalore, Tamil Nadu, India" />
     <meta name="copyright" content="https://www.thawdesigners.in/" />
     <meta name="google-site-verification" content="sQBzNCJ9wUa26uRAJu9OtJVFbCQ2lE-YXyst3D9uoSs" />
     <meta name="twitter:card" content="summary_large_image" />
     <meta name="twitter:title" content="Top Architects in Coimbatore | Residential&Commercial Design" />
     <meta name="twitter:description" content="Top architects in Coimbatore offering residential and commercial architecture design, custom villas, modern homes, and expert architectural solutions" />
     <meta name="twitter:image" content="https://thawdesigners.in/assets/img/Thaw-Designers.webp" />

     <!-- canonical tag -->
     <link rel="canonical" href="https://thawdesigners.in/jobwork.php" />

     <!-- schema tag -->
     <script type='application/ld+json'>
          {
               "@context": "https://schema.org",
               "@type": "LocalBusiness",
               "name": "Thaw Designers",
               "image": "https://thawdesigners.in/assets/img/Thaw-Designers.webp",
               "@id": "https://www.thawdesigners.in/",
               "url": "https://www.thawdesigners.in/jobwork.php",
               "telephone": "+91 90956 59705",
               "description": "Thaw Designers offers expert interior design and
               architecture services in Coimbatore and Bangalore,
               including
               residential,
               commercial,
               apartment,
               villa,
               office,
               school,
               and
               hospital design solutions.
               ",
               "address": {
                    "@type": "PostalAddress",
                    "streetAddress": "SF NO. 128/2, Chandra Garden, Road,
                    behind Aalam Montessori school,
                    Thriveni West ",
                    "addressLocality": "Kalapatti, Coimbatore",
                    "addressRegion": "Tamil Nadu",
                    "postalCode": "641035",
                    "addressCountry": "IN"
               },
               "geo": {
                    "@type": "GeoCoordinates",
                    "latitude": 11.084082987551191,
                    "longitude": 77.0322872680657
               },
               "openingHoursSpecification": [{
                    "@type": "OpeningHoursSpecification",
                    "dayOfWeek": [
                         "Monday",
                         "Tuesday",
                         "Wednesday",
                         "Thursday",
                         "Friday",
                         "Saturday"
                    ],
                    "opens": "09:30",
                    "closes": "19:00"
               }],
               "areaServed": [
                    "Coimbatore",
                    "Chennai",
                    "Madurai",
                    "Tamil Nadu",
                    "Bangalore",
                    "India",
               ],
               "sameAs": [
                    "https://www.facebook.com/architectscoimbatore/",
                    "https:https://www.instagram.com/thawdesigners/",
                    "https:https://in.pinterest.com/thawseo2024/",
                    "https:https://www.youtube.com/@Thawdesigners",
                    "https:https://x.com/thaw_Designers"
               ]
          }
     </script>

     <!-- Google tag (gtag.js) -->
     <script async src="https://www.googletagmanager.com/gtag/js?id=G-9WRLDDSSCM"></script>
     <script>
          window.dataLayer = window.dataLayer || [];

          function gtag() {
               dataLayer.push(arguments);
          }
          gtag('js', new Date());
          gtag('config', 'G-9WRLDDSSCM');
     </script>


     <!-- Google Tag Manager -->
     <script>
          (function(w, d, s, l, i) {
               w[l] = w[l] || [];
               w[l].push({
                    'gtm.start': new Date().getTime(),
                    event: 'gtm.js'
               });
               var f = d.getElementsByTagName(s)[0],
                    j = d.createElement(s),
                    dl = l != 'dataLayer' ? '&l=' + l : '';
               j.async = true;
               j.src =
                    'https://www.googletagmanager.com/gtm.js?id=' + i + dl;
               f.parentNode.insertBe
               fore(j, f);
          })(window, document, 'script', 'dataLayer', 'GTM-5ZV73TVX');
     </script>
     <!-- End Google Tag Manager -->

     <!-- head -->
     <?php include("./includes/head.php"); ?>

</head>

<body>


     <!-- Google Tag Manager (noscript) -->
     <noscript><iframe
               src="https://www.googletagmanager.com/ns.html?id=GTM-5ZV73TVX"
               height="0" width="0"
               style="display:none;visibility:hidden"></iframe></noscript>
     <!-- End Google Tag Manager (noscript) -->

     <!-- header -->
     <?php include("./includes/header.php") ?>

     <div class="sub-banner">
          <div class="overlay"></div>
          <div class="sub-banner-content text-center">
               <h1 class="title">Job Work</h1>
               <nav class="breadcrumb">
                    <a href="index.php">Home</a> &nbsp; / &nbsp; <span>Job Work</span>
               </nav>
          </div>
     </div>
     <main id="main">

          <!-- Architecture L Kitchen -->
          <section class="kitchen-island-section">
               <div class="container">
                    <!-- 1 -->
                    <div class="row">

                         <!-- Text Content -->
                         <div class="col-lg-6 order-2 order-lg-1">
                              <div class="kitchen-island-text pe-lg-4">
                                   <h3 class="fw-bold text-uppercase" style="background-color: #c8b16f; color: #fff; display: inline-block; padding: 5px 10px;">Four Walls Interiors and Beyond</h3>
                                   <p class="mt-3">
                                        At Four Walls Interiors and Beyond, we believe great interiors are not just built, they are crafted with care, precision, and passion. We are your trusted partner for complete interior job work solutions – from cutting board, mica pressing, and edge banding to the finest detailing that brings your design vision to life.
                                   </p>
                                   <p class="mt-3">
                                        With a focus on end-to-end execution, our expertise ensures every project runs smoothly, efficiently, and with uncompromising quality. Whether you are a designer, contractor, or homeowner, we provide the technical backbone that transforms concepts into stunning, ready-to-use interiors.
                                   </p>
                                   <p class="mt-3">
                                        Our end-to-end job work services ensure smooth execution, timely delivery, and top-notch quality. Whether for designers, contractors, or homeowners, we are the trusted backbone behind interiors that are functional, stylish, and built to last.

                                   <div class="progress-container">
                                        <div class="d-flex justify-content-between">
                                             <div class="progress-title">Board Cutting</div>
                                             <div class="progress-value" id="arch-percent">0%</div>
                                        </div>
                                        <div class="progress">
                                             <div class="progress-bar" role="progressbar" id="arch-bar" style="width: 0%"></div>
                                        </div>
                                   </div>

                                   <div class="progress-container">
                                        <div class="d-flex justify-content-between">
                                             <div class="progress-title">Mica Pressing </div>
                                             <div class="progress-value" id="interior-percent">0%</div>
                                        </div>
                                        <div class="progress">
                                             <div class="progress-bar" role="progressbar" id="interior-bar" style="width: 0%"></div>
                                        </div>
                                   </div>
                                   <div class="progress-container">
                                        <div class="d-flex justify-content-between">
                                             <div class="progress-title">Edge Branding </div>
                                             <div class="progress-value" id="interior-percents">0%</div>
                                        </div>
                                        <div class="progress">
                                             <div class="progress-bar" role="progressbars" id="interior-bars" style="width: 0%"></div>
                                        </div>
                                   </div>
                                   <br>
                                   <div>
                                        <a href="contact-us.php" class="custom-btn hvr-sweep-to-right">
                                             Enquiry Now <i class="bi bi-arrow-right"></i>
                                        </a>
                                   </div>

                              </div>
                         </div>

                         <!-- Image Content -->
                         <div class="col-lg-6 order-1 order-lg-2  mb-lg-0">
                              <div class="row  mb-5">
                                   <div class="col-12">
                                        <div>
                                             <img class="img-fluid job-work-img" src="./assets/img/home/banner/Affordable-architect-in-tamilnadu.webp" title="Affordable architect in tamilnadu" loading="lazy" alt="Affordable architect in tamilnadu" >
                                        </div>
                                   </div>
                              </div>
                         </div>

                    </div>
               </div>
          </section>
          <section class="section-padding features-bg">
               <div class="container-fluid">
                    <div class="text-center jobwork-sec mb-5">
                         <h2 class="clr-head"> <span class="bold-span">o</span>ur <span class="color-span"><span class="bold-span">j</span>ob Work</span> </h2>

                         <p class="para-ser text-center">
                              Complete interior job work solutions crafted with care, precision, and passion.
                         </p>
                    </div>
                    <div class="row text-center justify-content-center">
                         <div class="col-lg-3  col-md-6 col-sm-6 col-12 design-service-box unique-box-1 wow animate__animated animate__fadeInUp" data-wow-delay="0.3s">
                              <div class="design-icon">
                                   <i class="bi bi-scissors" style="font-size: 48px;"></i>
                              </div>
                              <div class="design-title">Cutting Board with Precision</div>
                              <div class="design-description">
                                   Clean, accurate cuts for flawless finishes that bring out the best in your interiors.
                              </div>
                              <div class="design-underline">
                                   <div class="design-underline-line"></div>
                                   <div class="design-underline-dot"></div>
                                   <div class="design-underline-line"></div>
                              </div>
                         </div>

                         <div class="col-lg-3 col-md-6 col-sm-6 col-12 design-service-box unique-box-1 wow animate__animated animate__fadeInUp" data-wow-delay="0.3s">
                              <div class="design-icon">
                                   <i class="bi bi-layers-fill" style="font-size: 48px;"></i>
                              </div>
                              <div class="design-title">Mica Pressing</div>
                              <div class="design-description">
                                   Seamless mica pressing for durability, strength, and a perfect look every time.
                              </div>
                              <div class="design-underline">
                                   <div class="design-underline-line"></div>
                                   <div class="design-underline-dot"></div>
                                   <div class="design-underline-line"></div>
                              </div>
                         </div>
                         <div class="col-lg-3 col-md-6 col-sm-6 col-12 design-service-box unique-box-1 wow animate__animated animate__fadeInUp" data-wow-delay="0.3s">
                              <div class="design-icon">
                                   <i class="bi bi-border-style" style="font-size: 48px;"></i>
                              </div>
                              <div class="design-title">Edge Banding</div>
                              <div class="design-description">
                                   Smooth, professional edges that elevate the overall appeal of your furniture and interiors.
                              </div>
                              <div class="design-underline">
                                   <div class="design-underline-line"></div>
                                   <div class="design-underline-dot"></div>
                                   <div class="design-underline-line"></div>
                              </div>
                         </div>
                         <div class="col-lg-3 col-md-6 col-sm-6 col-12 design-service-box unique-box-1 wow animate__animated animate__fadeInUp" data-wow-delay="0.3s">
                              <div class="design-icon">
                                   <i class="bi bi-house-heart-fill" style="font-size: 48px;"></i>
                              </div>
                              <div class="design-title">Custom Interior Job Work</div>
                              <div class="design-description">
                                   Tailored interior solutions designed to match your unique style and requirements.
                              </div>
                              <div class="design-underline">
                                   <div class="design-underline-line"></div>
                                   <div class="design-underline-dot"></div>
                                   <div class="design-underline-line"></div>
                              </div>
                         </div>
                    </div>
               </div>
          </section>

     </main>

     <!-- footer -->
     <?php include("./includes/footer.php") ?>

     <!-- script -->
     <?php include("./includes/script.php") ?>

     <script>
          function animateProgressBar(id, percentId, target) {
               let i = 0;
               const bar = document.getElementById(id);
               const percentText = document.getElementById(percentId);
               const interval = setInterval(() => {
                    if (i >= target) clearInterval(interval);
                    else {
                         i++;
                         bar.style.width = i + '%';
                         percentText.textContent = i + '%';
                    }
               }, 20);
          }

          window.onload = () => {
               animateProgressBar('arch-bar', 'arch-percent', 95);
               animateProgressBar('interior-bar', 'interior-percent', 90);
               animateProgressBar('interior-bars', 'interior-percents', 90);
          };
     </script>

</body>

</html>