<!DOCTYPE html>
<html lang="en">

<body>
    <?php include("./includes/header.php") ?>
  
    <div class="sub-banner">
        <div class="overlay"></div>
        <div class="sub-banner-content text-center">
            <h1 class="title">Apartment Architecture-Services</h1>
            <nav class="breadcrumb">
                <a href="index.php">Home</a> &nbsp; / &nbsp; <span>Architecture-Services</span>
            </nav>
        </div>
    </div>
    <main id="main">

        <!-- Architecture L Kitchen -->
        <section class="kitchen-island-section py-5">
            <div class="container">
                <!-- 1 -->
                <div class="row  mb-5">

                    <!-- Text Content -->
                    <div class="col-lg-5 order-2 order-lg-1">
                        <div class="kitchen-island-text pe-lg-4">
                            <h3 class="fw-bold text-uppercase" style="background-color: #c8b16f; color: #fff; display: inline-block; padding: 5px 10px;">Expert Apartment Architects in Coimbatore</h3>
                            <p class="mt-3">
                                At Thaw Designers, we are leading apartment architects in Coimbatore, known for delivering efficient, elegant, and budget-friendly apartment projects. Our team focuses on modern apartment architecture design that optimizes space, enhances natural lighting, and blends functionality with style. As one of the best residential apartment architects, we ensure every design is tailored to urban lifestyles, safety norms, and long-term durability — making us the preferred choice for apartment construction planning.
                            </p>

                        </div>
                    </div>

                    <!-- Image Content -->
                    <div class="col-lg-7 order-1 order-lg-2 mb-4 mb-lg-0">
                        <div>
                            <div id="archApartmentCarousel1" class="carousel slide" data-bs-ride="carousel">

                                <div class="carousel-indicators">
                                    <button type="button" data-bs-target="#archApartmentCarousel1" data-bs-slide-to="0" class="active" aria-current="true" aria-label="Slide 1"></button>
                                    <button type="button" data-bs-target="#archApartmentCarousel1" data-bs-slide-to="1" aria-label="Slide 2"></button>
                                </div>

                                <div class="carousel-inner">
                                    <div class="carousel-item active">
                                        <img src="./assets/img/services/architecture/apartment/apartment-services1.png" class="d-block w-100 rounded shadow" alt="Island Kitchen 1">
                                    </div>
                                    <div class="carousel-item">
                                        <img src="./assets/img/services/architecture/apartment/apartment-services2.png" class="d-block w-100 rounded shadow" alt="Island Kitchen 2">
                                    </div>
                                </div>

                                <button class="carousel-control-prev" type="button" data-bs-target="#archApartmentCarousel1" data-bs-slide="prev">
                                    <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                                    <span class="visually-hidden">Previous</span>
                                </button>
                                <button class="carousel-control-next" type="button" data-bs-target="#archApartmentCarousel1" data-bs-slide="next">
                                    <span class="carousel-control-next-icon" aria-hidden="true"></span>
                                    <span class="visually-hidden">Next</span>
                                </button>
                            </div>
                        </div>
                    </div>

                </div>
                <!-- 2 -->
                <div class="row  mb-5">


                    <!-- Image Content -->
                    <div class="col-lg-7 order-1 order-lg-1 mb-4 mb-lg-0">
                        <div>
                            <div id="archApartmentCarousel2" class="carousel slide" data-bs-ride="carousel">

                                <div class="carousel-indicators">
                                    <button type="button" data-bs-target="#archApartmentCarousel2" data-bs-slide-to="0" class="active" aria-current="true" aria-label="Slide 1"></button>
                                    <button type="button" data-bs-target="#archApartmentCarousel2" data-bs-slide-to="1" aria-label="Slide 2"></button>
                                </div>

                                <div class="carousel-inner">
                                    <div class="carousel-item active">
                                        <img src="./assets/img/services/architecture/apartment/apartment-services3.png" class="d-block w-100 rounded shadow" alt="Island Kitchen 1">
                                    </div>
                                    <div class="carousel-item">
                                        <img src="./assets/img/services/architecture/apartment/apartment-services4.png" class="d-block w-100 rounded shadow" alt="Island Kitchen 2">
                                    </div>
                                </div>

                                <button class="carousel-control-prev" type="button" data-bs-target="#archApartmentCarousel2" data-bs-slide="prev">
                                    <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                                    <span class="visually-hidden">Previous</span>
                                </button>
                                <button class="carousel-control-next" type="button" data-bs-target="#archApartmentCarousel2" data-bs-slide="next">
                                    <span class="carousel-control-next-icon" aria-hidden="true"></span>
                                    <span class="visually-hidden">Next</span>
                                </button>
                            </div>
                        </div>
                    </div>
                    <!-- Text Content -->
                    <div class="col-lg-5 order-2 order-lg-2">
                        <div class="kitchen-island-text text-right pe-lg-4">
                            <h3 class="fw-bold text-uppercase" style="background-color: #c8b16f; color: #fff; display: inline-block; padding: 5px 10px;">Customized Apartment Architectural Design Services</h3>
                            <p class="mt-3">
                                We provide specialized apartment architectural design services for developers, individuals, and builders seeking smart, scalable apartment layouts. Our experienced team works on everything from concept planning and 3D modeling to construction-ready blueprints. As a trusted name for multi-family housing design and urban apartment planning, Thaw Designers delivers personalized apartment solutions that meet functionality, cost-efficiency, and visual appeal — ensuring every square foot is thoughtfully utilized.

                        </div>
                    </div>


                </div>
                <!-- 3 -->
                <div class="row  mb-5">

                    <!-- Text Content -->
                    <div class="col-lg-5 order-2 order-lg-1">
                        <div class="kitchen-island-text pe-lg-4">
                            <h3 class="fw-bold text-uppercase" style="background-color: #c8b16f; color: #fff; display: inline-block; padding: 5px 10px;">Best Apartment Architects for Residential Projects</h3>
                            <p class="mt-3">
                                Thaw Designers is recognized as one of the best apartment architects in Coimbatore, offering end-to-end services for small to large-scale apartment projects. Whether you're developing a luxury apartment block or a budget-friendly housing unit, our team provides expert support in apartment floor plan design, elevation concepts, and project execution. With successful apartment projects across Coimbatore, Chennai, and Bangalore, we blend creative design with practical expertise to deliver lasting value.
                            </p>

                        </div>
                    </div>

                    <!-- Image Content -->
                    <div class="col-lg-7 order-1 order-lg-2 mb-4 mb-lg-0">
                        <div>
                            <div id="archApartmentCarousel3" class="carousel slide" data-bs-ride="carousel">

                                <div class="carousel-indicators">
                                    <button type="button" data-bs-target="#archApartmentCarousel3" data-bs-slide-to="0" class="active" aria-current="true" aria-label="Slide 1"></button>
                                    <button type="button" data-bs-target="#archApartmentCarousel3" data-bs-slide-to="1" aria-label="Slide 2"></button>
                                </div>

                                <div class="carousel-inner">
                                    <div class="carousel-item active">
                                        <img src="./assets/img/services/architecture/apartment/apartment-services4.png" class="d-block w-100 rounded shadow" alt="Island Kitchen 1">
                                    </div>
                                    <div class="carousel-item">
                                        <img src="./assets/img/services/architecture/apartment/apartment-services2.png" class="d-block w-100 rounded shadow" alt="Island Kitchen 2">
                                    </div>
                                </div>

                                <button class="carousel-control-prev" type="button" data-bs-target="#archApartmentCarousel3" data-bs-slide="prev">
                                    <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                                    <span class="visually-hidden">Previous</span>
                                </button>
                                <button class="carousel-control-next" type="button" data-bs-target="#archApartmentCarousel3" data-bs-slide="next">
                                    <span class="carousel-control-next-icon" aria-hidden="true"></span>
                                    <span class="visually-hidden">Next</span>
                                </button>
                            </div>
                        </div>
                    </div>

                </div>


            </div>
        </section>

        <!-- End Architecture L Kitchen -->
    </main>

    <?php include("./includes/footer.php") ?>
    <?php include("./includes/script.php") ?>



</body>

</html>